/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class WindowSnapping {
    static SnapListener sharedSnap = new SnapListener();

    public static void snap(Window snap, int position) {
        WindowSnapping.sharedSnap.snaps.addElement(new Snap(snap, position));
    }

    public static void snap(Window snap, int position, Window target) {
        SnapListener l = new SnapListener();
        l.snaps.addElement(new Snap(snap, position));
        target.addWindowListener(l);
    }

    public static void registerSnapping(Window target) {
        if (target != null) {
            target.addWindowListener(sharedSnap);
        }
    }

    public static void unregisterSnapping(Window target) {
        if (target != null) {
            target.removeWindowListener(sharedSnap);
        }
    }

    private static class SnapListener
    extends WindowAdapter
    implements ComponentListener {
        Vector snaps = new Vector();
        Window lastActivate = null;
        boolean ignoreEvents = false;

        public void windowActivated(WindowEvent e) {
            if (this.ignoreEvents) {
                this.ignoreEvents = false;
                return;
            }
            if (this.lastActivate != null) {
                this.lastActivate.removeComponentListener(this);
            }
            this.attachSnapTo(e.getWindow());
            this.lastActivate = e.getWindow();
            this.lastActivate.addComponentListener(this);
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
            this.attachSnapTo(this.lastActivate);
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void attachSnapTo(Window target) {
            Vector vector = this.snaps;
            synchronized (vector) {
                this.ignoreEvents = true;
                int i = 0;
                int c = this.snaps.size();
                while (i < c) {
                    ((Snap)this.snaps.elementAt(i)).attachTo(target);
                    ++i;
                }
                target.requestFocus();
                target.toFront();
            }
        }

        SnapListener() {
        }
    }

    private static class Snap {
        Window snap;
        int position;

        public void attachTo(Window target) {
            int y;
            int x;
            Rectangle targetBounds = target.getBounds();
            switch (this.position) {
                default: {
                    x = targetBounds.x;
                    y = targetBounds.y - this.snap.getSize().height;
                    break;
                }
                case 2: {
                    x = targetBounds.x + targetBounds.width - this.snap.getSize().width;
                    y = targetBounds.y - this.snap.getSize().height;
                    break;
                }
                case 6: {
                    x = targetBounds.x;
                    y = targetBounds.y + targetBounds.height;
                    break;
                }
                case 4: {
                    x = targetBounds.x + targetBounds.width - this.snap.getSize().width;
                    y = targetBounds.y + targetBounds.height;
                    break;
                }
                case 7: {
                    x = targetBounds.x - this.snap.getSize().width;
                    y = targetBounds.y;
                    break;
                }
                case 3: {
                    x = targetBounds.x + targetBounds.width;
                    y = targetBounds.y;
                    break;
                }
            }
            ((Component)this.snap).setLocation(x, y);
        }

        public Snap(Window snap, int position) {
            this.snap = snap;
            this.position = position;
        }
    }
}

