/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

final class CRCInputStream
extends FilterInputStream {
    private CRC32 crc = new CRC32();
    private int byteCount = 0;
    private byte[] byteArray = new byte[0];

    public long getValue() {
        return this.crc.getValue();
    }

    public void reset() {
        this.byteCount = 0;
        this.crc.reset();
    }

    public int count() {
        return this.byteCount;
    }

    public int read() throws IOException {
        int n = this.in.read();
        this.crc.update(n);
        ++this.byteCount;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        this.crc.update(byArray, n, n3);
        this.byteCount += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        if ((long)this.byteArray.length < l) {
            this.byteArray = new byte[(int)l];
        }
        return this.read(this.byteArray, 0, (int)l);
    }

    public CRCInputStream(InputStream inputStream) {
        super(inputStream);
    }
}

