package com.gotdns.jimula.EatHealthy;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;

/**
 * <em>ActivityHelp</em> is an object which show the short description
 * of activity level.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 */
public class ActivityHelp extends JDialog implements ActionListener {

  JPanel panel1 = new JPanel();
  JPanel insetsPanel1 = new JPanel();
  JButton butt_close = new JButton();//close dialog
  BorderLayout borderLayout1 = new BorderLayout();
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextArea txtArea_help = new JTextArea();

  /**
   * Construsts a new ActivityHelp object.
   */
  public ActivityHelp() {

    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception  {

    this.setTitle("Daily Activity Level");
    panel1.setLayout(borderLayout1);
    butt_close.setText("Ok");
    butt_close.addActionListener(this);
    txtArea_help.setBorder(null);
    jScrollPane1.setBorder(null);
    this.getContentPane().add(panel1, null);
    insetsPanel1.add(butt_close, null);
    panel1.add(jScrollPane1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(txtArea_help, null);
    panel1.add(insetsPanel1, BorderLayout.SOUTH);
    setResizable(true);
    readFile();
  }


// read the activity level description file
 private void readFile(){
  try{
    BufferedReader br=
     new BufferedReader(new FileReader("files/help"));
    String line;
    while((line=br.readLine())!=null){
      txtArea_help.append(line+"\n");
    }
    br.close();
  }catch(Exception e){
        System.out.println(e);
  }
}

/**
 * Overridden so we can exit when window is closed
 */
  protected void processWindowEvent(WindowEvent e) {
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      cancel();
    }
    super.processWindowEvent(e);
  }

  /**
   * close the dialog
   */
  void cancel() {
    dispose();
  }


  /**
   * Close the dialog on a button event
   */
  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == butt_close) {
      cancel();
    }
  }
}