package com.gotdns.jimula.EatHealthy;

/**
 * <em>CalculateServing</em> is an object which calculates food
 * serving depend on personal nutrient need. It is evoked by ServingPanel.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 * @see com.gotdns.jimula.EatHealthy.ServingPanel
 */
public class CalculateServing {

  //starch, meat, and oil serving
  private int starches_serving;
  private int meat_serving;
  private int oil_serving;

  //nutrient contents of milk, vegetable, fruit, starch, and meat
  private int milk_carb;
  private int milk_protein;
  private int milk_fat;
  private int vegetable_carb;
  private int vegetable_protein;
  private int fruit_carb;
  private int starches_protein;
  private int meat_fat;

  /**
   * Constructs a new CalculateServing object and calculate food serving.
   *
   * @param milk_serving serving of milk
   * @param milk_quantity fat contents of milk
   * @param vegetable_serving serving of vegetable
   * @param fruit_serving serving of fruit
   * @param meat_quantity fat contents of meat
   * @param protein contents of protein
   * @param fat contents of fat
   * @param carb contents of carbohydrate
   */
  public CalculateServing(int milk_serving,String milk_quantity,int vegetable_serving,
                           int fruit_serving,String meat_quantity,
                           float protein,float fat,float carb){

    //construsts new instance of vegatable, milk, starches, and meat
    Vegetable v=new Vegetable();
    Fruit f=new Fruit();
    Milk m=new Milk(milk_quantity);
    Starches star=new Starches();
    Meat mt=new Meat(meat_quantity);

    //calculate milk, vegetable, and fruit nutrient contents of actual serving
    this.milk_carb=m.carb*milk_serving;
    this.vegetable_carb=v.carb*vegetable_serving;
    this.fruit_carb=f.CARB*fruit_serving;
    this.milk_protein=m.protein*milk_serving;
    this.vegetable_protein=v.protein*vegetable_serving;
    this.milk_fat=m.fat*milk_serving;

    //calculate starches serving
    this.starches_serving=calculate_starches_serving(carb);
    //calculate starches protein contents of actual serving
    this.starches_protein=star.PROTEIN*starches_serving;

    //calculate meat serving
    this.meat_serving=calculate_meat_serving(protein);
    //calculate meat protein contents of actual serving
    this.meat_fat=mt.fat*meat_serving;

    //calculate oil serving
    this.oil_serving=calculate_oil_serving(fat);

  }


//Calculate starches serving
  private int calculate_starches_serving(float carb){

   //formula
    return Math.round((carb-(this.milk_carb+this.vegetable_carb+
                                 this.fruit_carb))/15);
  }

//Calculate meat serving
  private int calculate_meat_serving(float protein){

   //formula
    return Math.round((protein-(this.milk_protein+this.vegetable_protein+
                                this.starches_protein))/7);
  }


//Calculate oil serving
  private int calculate_oil_serving(float fat){
  //formula
     return Math.round((fat-(this.milk_fat+this.meat_fat))/5);
   }

 /**
  * Get starches serving
  * @return a integer with starches serving
  */
  public int getStarchesServing(){
   return this.starches_serving;
 }

 /**
  * Get meat serving
  * @return a integer with meat serving
  */
 public int getMeatServing(){
   return this.meat_serving;
 }

 /**
  * Get oil serving
  * @return a integer with oil serving
  */
 public int getOilServing(){
   return this.oil_serving;
 }
 /**
  * Get milk protein
  * @return a integer with milk serving
  */
 public int getMilkProtein(){
   return this.milk_protein;
 }

 /**
  * Get milk fat contents of actual serving
  * @return a integer with fat contents
  */
 public int getMilkFat(){
   return this.milk_fat;
 }

 /**
  * Get milk carbohydrate contents of actual serving
  * @return a integer with carbohydrate contents
  */
 public int getMilkCarb(){
   return this.milk_carb;
 }

 /**
  * Get vegetable protein contents of actual serving
  * @return a integer with protein contents
  */
 public int getVegetableProtein(){
   return this.vegetable_protein;
 }

 /**
  * Get vegetable carbohydrate contents of actual serving
  * @return a integer with carbohydrate contents
  */
 public int getVegetableCarb(){
   return this.vegetable_carb;
 }

 /**
  * Get fruit carbohydrate contents of actual serving
  * @return a integer with carbohydrate contents
  */
 public int getFruitCarb(){
   return this.fruit_carb;
 }





}