package com.gotdns.jimula.EatHealthy;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * <em>NutrientPanel</em> is a module that can calculate personal nutrient need.
 * Tt has a method {@link #addPanel() addPanel()}which return this panel to MainFrame.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 * @see com.gotdns.jimula.EatHealthy.MainFrame
 */
public class NutrientPanel {

  MainFrame frame;
  private String str_sex;
  private String str_level;
  private float float_level;

  private float protein;
  private float fat;
  private float carb;
  private float calories;

  private float height;

  ButtonGroup bg=new ButtonGroup();
  ButtonGroup bg_sex=new ButtonGroup();
  ButtonGroup bg_unit=new ButtonGroup();


  BorderLayout bl_contentPane = new BorderLayout();
  JPanel panel_nutrient = new JPanel();
  FlowLayout fl_panel_heigh = new FlowLayout();
  JPanel panel_heigh = new JPanel();
  TitledBorder tb_personal_info;
  JLabel lbl_unit = new JLabel();

  FlowLayout fl_panel_sex = new FlowLayout();
  JPanel panel_sex = new JPanel();
  JRadioButton rb_girl = new JRadioButton();
  JRadioButton rb_boy = new JRadioButton();
  JButton butt_level_help = new JButton();
  JRadioButton rb_level1 = new JRadioButton();
  JRadioButton rb_level3 = new JRadioButton();
  FlowLayout fl_panel_activity = new FlowLayout();
  JPanel panel_activity = new JPanel();
  JRadioButton rb_level5 = new JRadioButton();
  JRadioButton rb_level2 = new JRadioButton();
  JRadioButton rb_level4 = new JRadioButton();
  JPanel panel_personal_info = new JPanel();
  JButton butt_calculate = new JButton();
  JLabel lbl_calorie_show = new JLabel();
  JLabel lbl_portien = new JLabel();
  JPanel panel_info = new JPanel();
  JLabel lbl_carb = new JLabel();
  JLabel lbl_IBW = new JLabel();
  JLabel lbl_calorie = new JLabel();
  GridLayout gl_panel_info = new GridLayout();
  JLabel lbl_carb_show = new JLabel();
  JLabel lbl_portien_show = new JLabel();
  JLabel lbl_fat_show = new JLabel();
  JLabel lbl_IBW_show = new JLabel();
  JLabel lbl_fat = new JLabel();
  JLabel lbl_inch=new JLabel();
  TitledBorder tb_nutrient_need;
  JButton butt_design_menu = new JButton();
  JRadioButton rb_metric = new JRadioButton();
  JRadioButton rb_english = new JRadioButton();
  Border border1;
  TitledBorder titledBorder1;
  Float value = new Float(0F);
  Float min = new Float(0F);
  Float max = new Float(500F);
  Float step = new Float(0.1F);
  SpinnerNumberModel model1 = new SpinnerNumberModel(value, min, max, step);
  SpinnerNumberModel model2 = new SpinnerNumberModel(value, min, max, step);
  JSpinner spin_height = new JSpinner(model1);
  JSpinner spin_inch=new JSpinner(model2);
  Border border2;
  Border border3;
  TitledBorder titledBorder2;
  JPanel panel_sleepingTime = new JPanel();
  Border border4;
  TitledBorder titledBorder3;
  JLabel lbl_sleepingTime = new JLabel();
  JComboBox cb_sleepingTime = new JComboBox(initList());
  JLabel lbl_hours = new JLabel();
  Border border5;
  TitledBorder titledBorder4;



  /**
   * Construsts a new NutrientPanel instance
   * @param frame parent frame(MainFrame)
   * @see com.gotdns.jimula.EatHealthy.MainFrame
   */
  public NutrientPanel(MainFrame frame) {

    try {
      jbInit(frame);
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit(MainFrame frame) throws Exception  {


    this.frame=frame;

    tb_personal_info = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(172, 173, 174)),"Please Input Your Personal Info");
    tb_nutrient_need = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(172, 173, 174)),"Your nutrient need");
    border1 = BorderFactory.createEtchedBorder(Color.white,new Color(172, 173, 174));
    titledBorder1 = new TitledBorder(border1,"Height");
    border2 = BorderFactory.createEtchedBorder(Color.white,new Color(172, 173, 174));

    border3 = new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(172, 173, 174));
    titledBorder2 = new TitledBorder(new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(172, 173, 174)),"Gender");
    border4 = new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(172, 173, 174));
    titledBorder3 = new TitledBorder(border4,"Sleeping Hour");
    border5 = BorderFactory.createEtchedBorder(Color.white,new Color(172, 173, 174));
    titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(172, 173, 174)),"Activity Level");
    panel_nutrient.setLayout(null);
    panel_nutrient.setBorder(BorderFactory.createLoweredBevelBorder());
    fl_panel_heigh.setAlignment(FlowLayout.LEFT);
    panel_heigh.setBorder(titledBorder1);
    panel_heigh.setToolTipText("input your height");
    panel_heigh.setBounds(new Rectangle(20, 92, 176, 95));
    panel_heigh.setLayout(fl_panel_heigh);
    lbl_unit.setText("cm");
    fl_panel_sex.setAlignment(FlowLayout.LEFT);
    fl_panel_sex.setHgap(2);
    fl_panel_sex.setVgap(2);
    panel_sex.setBorder(titledBorder2);
    panel_sex.setToolTipText("choose your gender");
    panel_sex.setBounds(new Rectangle(21, 31, 126, 54));
    panel_sex.setLayout(fl_panel_sex);
    rb_girl.setText("Female");
    rb_girl.addItemListener(new rb_sex_itemAdapter(this));
    rb_boy.setText("Male");
    rb_boy.addItemListener(new rb_sex_itemAdapter(this));
    butt_level_help.setBorder(BorderFactory.createLineBorder(Color.black));
    butt_level_help.setPreferredSize(new Dimension(57, 20));
    butt_level_help.setText("help");
    butt_level_help.addActionListener(new NutrientPanel_butt_level_help_actionAdapter(this));
    rb_level1.setAlignmentX((float) 0.0);
    rb_level1.setText("Very light workload");
    rb_level1.addItemListener(new NutrientPanel_rb_level_itemAdapter(this));
    rb_level3.setText("Middle workload");
    rb_level3.addItemListener(new NutrientPanel_rb_level_itemAdapter(this));
    fl_panel_activity.setAlignment(FlowLayout.LEFT);
    fl_panel_activity.setHgap(1);
    fl_panel_activity.setVgap(1);
    panel_activity.setLayout(fl_panel_activity);
    panel_activity.setBorder(titledBorder4);
    panel_activity.setToolTipText("select your activity level");
    panel_activity.setBounds(new Rectangle(205, 33, 145, 214));
    rb_level5.setText("Very heavy workload");
    rb_level5.addItemListener(new NutrientPanel_rb_level_itemAdapter(this));
    rb_level2.setText("Light workload");
    rb_level2.addItemListener(new NutrientPanel_rb_level_itemAdapter(this));
    rb_level4.addItemListener(new NutrientPanel_rb_level_itemAdapter(this));
    rb_level4.setText("Heavy workload");
    panel_personal_info.setBorder(tb_personal_info);
    panel_personal_info.setBounds(new Rectangle(30, 24, 366, 333));
    panel_personal_info.setLayout(null);
    butt_calculate.setBounds(new Rectangle(55, 286, 87, 22));
    butt_calculate.setText("Calculate");
    butt_calculate.setToolTipText("calculate your nutrient need");
    butt_calculate.addActionListener(new NutrientPanel_butt_calculate_actionAdapter(this));
    lbl_calorie_show.setText("Calorie");
    lbl_calorie_show.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_calorie_show.setBackground(new Color(246, 248, 249));
    lbl_calorie_show.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_calorie_show.setForeground(new Color(210, 130, 0));
    lbl_calorie_show.setBorder(BorderFactory.createEtchedBorder());
    lbl_calorie_show.setDebugGraphicsOptions(0);
    lbl_calorie_show.setPreferredSize(new Dimension(12, 15));
    lbl_portien.setText("Portien (g) :");
    lbl_portien.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_portien.setVerifyInputWhenFocusTarget(true);
    panel_info.setLayout(gl_panel_info);
    panel_info.setBorder(tb_nutrient_need);
    panel_info.setBounds(new Rectangle(399, 24, 285, 246));
    lbl_carb.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_carb.setText("Carbohydrate (g) :");
    lbl_IBW.setBorder(null);
    lbl_IBW.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_IBW.setHorizontalTextPosition(SwingConstants.TRAILING);
    lbl_IBW.setText("Ideal Body Weight (kg) :");
    lbl_calorie.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_calorie.setHorizontalTextPosition(SwingConstants.TRAILING);
    lbl_calorie.setText("Calorie (kcal) :");
    gl_panel_info.setColumns(1);
    gl_panel_info.setHgap(2);
    gl_panel_info.setRows(5);
    gl_panel_info.setVgap(25);
    lbl_carb_show.setDebugGraphicsOptions(0);
    lbl_carb_show.setPreferredSize(new Dimension(12, 15));
    lbl_carb_show.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_carb_show.setForeground(new Color(0, 151, 0));
    lbl_carb_show.setBorder(BorderFactory.createEtchedBorder());
    lbl_carb_show.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_carb_show.setText("Carbohydrate");
    lbl_portien_show.setDebugGraphicsOptions(0);
    lbl_portien_show.setPreferredSize(new Dimension(12, 15));
    lbl_portien_show.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_portien_show.setForeground(new Color(255, 0, 171));
    lbl_portien_show.setBorder(BorderFactory.createEtchedBorder());
    lbl_portien_show.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_portien_show.setText("portein");
    lbl_fat_show.setDebugGraphicsOptions(0);
    lbl_fat_show.setPreferredSize(new Dimension(12, 15));
    lbl_fat_show.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_fat_show.setForeground(new Color(203, 159, 131));
    lbl_fat_show.setBorder(BorderFactory.createEtchedBorder());
    lbl_fat_show.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_fat_show.setText("fat");
    lbl_IBW_show.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_IBW_show.setForeground(Color.blue);
    lbl_IBW_show.setBorder(BorderFactory.createEtchedBorder());
    lbl_IBW_show.setPreferredSize(new Dimension(12, 15));
    lbl_IBW_show.setHorizontalAlignment(SwingConstants.CENTER);
    lbl_IBW_show.setText("IBW");
    lbl_fat.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_fat.setText("Fat (g) :");
    butt_design_menu.setBounds(new Rectangle(200, 286, 87, 22));
    butt_design_menu.setText("NEXT");
    butt_design_menu.addActionListener(new NutrientPanel_butt_design_menu_actionAdapter(this));
    rb_metric.setText("METRIC");
    rb_metric.addActionListener(new NutrientPanel_rb_metric_actionAdapter(this));
    rb_metric.setSelected(true);
    rb_english.setText("ENGLISH");
    rb_english.addActionListener(new NutrientPanel_rb_english_actionAdapter(this));
    spin_height.setMinimumSize(new Dimension(31, 26));
    spin_height.setPreferredSize(new Dimension(60, 26));
    spin_inch.setMinimumSize(new Dimension(31, 26));
    spin_inch.setPreferredSize(new Dimension(60, 26));
    panel_sleepingTime.setBorder(titledBorder3);
    panel_sleepingTime.setDebugGraphicsOptions(0);
    panel_sleepingTime.setToolTipText("choose your sleeping hours");
    panel_sleepingTime.setBounds(new Rectangle(19, 198, 173, 64));
    lbl_sleepingTime.setText("I sleep :");
    cb_sleepingTime.setMinimumSize(new Dimension(28, 20));
    cb_sleepingTime.setPreferredSize(new Dimension(38, 20));
    cb_sleepingTime.setLightWeightPopupEnabled(true);
    cb_sleepingTime.setMaximumRowCount(24);
    lbl_hours.setHorizontalAlignment(SwingConstants.LEFT);
    lbl_hours.setText("hours a day");
    panel_heigh.add(rb_metric, null);
    panel_heigh.add(rb_english, null);
    panel_heigh.add(spin_height, null);
    panel_heigh.add(lbl_unit, null);
    panel_personal_info.add(butt_calculate, null);
    panel_personal_info.add(panel_sex, null);
    panel_personal_info.add(panel_sleepingTime, null);
    panel_sleepingTime.add(lbl_sleepingTime, null);
    panel_sleepingTime.add(cb_sleepingTime, null);
    panel_sleepingTime.add(lbl_hours, null);
   //panel_personal_info.add(butt_design_menu, null);
    panel_nutrient.add(panel_info, null);

    panel_sex.add(rb_boy, null);
    panel_sex.add(rb_girl, null);
    panel_personal_info.add(panel_activity, null);
    panel_info.add(lbl_IBW, null);
    panel_info.add(lbl_IBW_show, null);
    panel_info.add(lbl_calorie, null);
    panel_info.add(lbl_calorie_show, null);
    panel_info.add(lbl_portien, null);
    panel_info.add(lbl_portien_show, null);
    panel_info.add(lbl_fat, null);
    panel_info.add(lbl_fat_show, null);
    panel_info.add(lbl_carb, null);
    panel_info.add(lbl_carb_show, null);

    panel_nutrient.add(panel_personal_info, null);

    panel_activity.add(rb_level1, null);
    panel_activity.add(rb_level2, null);
    panel_activity.add(rb_level3, null);
    panel_activity.add(rb_level4, null);
    panel_activity.add(rb_level5, null);
    panel_activity.add(butt_level_help, null);
    panel_personal_info.add(panel_heigh, null);


    bg.add(rb_level1);
    bg.add(rb_level2);
    bg.add(rb_level3);
    bg.add(rb_level4);
    bg.add(rb_level5);
    bg_sex.add(rb_boy);
    bg_sex.add(rb_girl);
    bg_unit.add(rb_metric);
    bg_unit.add(rb_english);
  }

//initiate JComboBox(cb_sleepingTime) list
  private String[] initList(){
   String list[]=new String[12];
   for (int i=0;i<12;i++){
     list[i]=String.valueOf((i+1));
   }
   return list;
 }

//Convert height unit from English to Metric
 private float convert(float feet,float inch){
   float height;
   height=(feet*0.3048F*100)+(inch*2.54F);
   height=(float)(Math.round(height*10))/10;
   return height;
 }

//Start to calculate personal need
 void butt_calculate_actionPerformed(ActionEvent e) {
   String unit=lbl_unit.getText();

 //Determine height unit
   if(unit.equals("ft")){
     float feet;
     float inch;
     feet=Float.parseFloat(String.valueOf(spin_height.getValue()));
     inch=Float.parseFloat(String.valueOf(spin_inch.getValue()));
     this.height=convert(feet,inch);
   }else if(unit.equals("cm")){
    this.height=Float.parseFloat(String.valueOf(spin_height.getValue()));
   }

   String str_sleepingTime=String.valueOf(cb_sleepingTime.getSelectedItem());
   int sleepingTime=Integer.parseInt(str_sleepingTime);

   CalculateNutrient cn=new CalculateNutrient(this.height,sleepingTime,str_sex,float_level);

   this.protein=cn.protein;
   this.fat=cn.fat;
   this.carb=cn.carb;
   this.calories=cn.Calorie;

   lbl_IBW_show.setText(String.valueOf(cn.IBW));
   lbl_calorie_show.setText(String.valueOf(calories));
   lbl_portien_show.setText(String.valueOf(protein));
   lbl_carb_show.setText(String.valueOf(carb));
   lbl_fat_show.setText(String.valueOf(fat));

   panel_personal_info.add(butt_design_menu);
   panel_personal_info.updateUI();

 }

 //Select the activity level
  void rb_level_itemStateChanged(ItemEvent e) {
      this.str_level=
      ((JRadioButton)e.getItemSelectable()).getText();

      if (str_level.equals("Very light workload")){
         this.float_level=0.6F;
      }else if (str_level.equals("Light workload")){
         this.float_level=0.8F;
      }else if (str_level.equals("Middle workload")){
         this.float_level=1.1F;
      }else if (str_level.equals("heavy workload")){
         this.float_level=1.7F;
      }else{
         this.float_level=2.5F;
      }

    }

   //select the personal gender
    void rb_sex_actionPerformed(ItemEvent e){

        this.str_sex=
            ((JRadioButton)e.getItemSelectable()).getText();
      }

      /**
       * Which is evoked by MainFrame
       * @return panel_nutrient a JPanel with panel_nutrient
       */
    public JPanel addPanel(){

      return panel_nutrient;
    }

  //Add ServingPanel, and pass parameter about personal nutrient need
  void butt_design_menu_actionPerformed(ActionEvent e) {
    ServingPanel ap=new ServingPanel(this.frame,protein,fat,carb,calories);
    this.frame.ap=ap;
    this.frame.contentPane.add(this.frame.ap.addPanel(),BorderLayout.CENTER);
    this.frame.contentPane.remove(this.addPanel());

    this.frame.contentPane.updateUI();

  }

//Change height unit from English to Metric
  void rb_metric_actionPerformed(ActionEvent e) {
    lbl_unit.setText("cm");
    panel_heigh.remove(spin_inch);
    panel_heigh.remove(lbl_inch);
    panel_heigh.updateUI();
  }

//Change height unit from Metric to English
  void rb_english_actionPerformed(ActionEvent e) {
    lbl_unit.setText("ft");
    lbl_inch.setText("in");
    panel_heigh.add(spin_inch,null);
    panel_heigh.add(lbl_inch,null);
    panel_heigh.updateUI();
  }

 //show activity help file, evoke object ActivityHelp
  void butt_level_help_actionPerformed(ActionEvent e) {
    ActivityHelp dlg = new ActivityHelp();
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = this.frame.getSize();
    Point loc = this.frame.getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.pack();
    dlg.show();
  }

 }




class rb_sex_itemAdapter implements ItemListener{
     NutrientPanel adaptee;

     rb_sex_itemAdapter(NutrientPanel adaptee){
     this.adaptee=adaptee;
      }
    public void itemStateChanged(ItemEvent e){
      adaptee.rb_sex_actionPerformed(e);
      }
    }

    class NutrientPanel_butt_calculate_actionAdapter implements java.awt.event.ActionListener {
      NutrientPanel adaptee;

      NutrientPanel_butt_calculate_actionAdapter(NutrientPanel adaptee) {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
      adaptee.butt_calculate_actionPerformed(e);
    }
  }


class NutrientPanel_rb_level_itemAdapter implements java.awt.event.ItemListener {
  NutrientPanel adaptee;

  NutrientPanel_rb_level_itemAdapter(NutrientPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void itemStateChanged(ItemEvent e) {
    adaptee.rb_level_itemStateChanged(e);
  }
}

class NutrientPanel_butt_design_menu_actionAdapter implements java.awt.event.ActionListener {
  NutrientPanel adaptee;

  NutrientPanel_butt_design_menu_actionAdapter(NutrientPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.butt_design_menu_actionPerformed(e);
  }
}

class NutrientPanel_rb_metric_actionAdapter implements java.awt.event.ActionListener {
  NutrientPanel adaptee;

  NutrientPanel_rb_metric_actionAdapter(NutrientPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.rb_metric_actionPerformed(e);
  }
}

class NutrientPanel_rb_english_actionAdapter implements java.awt.event.ActionListener {
  NutrientPanel adaptee;

  NutrientPanel_rb_english_actionAdapter(NutrientPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.rb_english_actionPerformed(e);
  }
}

class NutrientPanel_butt_level_help_actionAdapter implements java.awt.event.ActionListener {
  NutrientPanel adaptee;

  NutrientPanel_butt_level_help_actionAdapter(NutrientPanel adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.butt_level_help_actionPerformed(e);
  }
}


