
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "mgui.h"

#define CR      '\015'
#define LF      '\012'
//#define SPACE   '\040'

// the definition below was modified by Gordon Jacobs to remove
// the validity of a comma in a Signed Numeric quantity. The
// definition below is more accurate and the comma is now removed
// after reading the digit in getval()/
#define SIGNED_NUMERIC  (ungetc(( ch = getc(stream)),stream) != EOF ) &&\
		(((ch>='0') && (ch<='9')) || (ch=='-') || (ch=='+')\
		|| (ch==' ') || (ch == '.'))

// The debug stuff was added to trace what is going on during the conversion
// process to PostScript.
#ifdef DEBUG
#define debugp(x) {fprintf x; (void) fflush(stderr);}
#else
#define debugp(x)
#endif

#ifdef NOTIMP
#define notimp(x) {fprintf x; fprintf(stderr, "\n"); (void) fflush(stderr);}
#else
#define notimp(x)
#endif

#define 	ARCA 27                 /* HPGL Absolute Arc */
#define 	ARCR 28                 /* HPGL Relative Arc */

#define 	TEXT    31
#define 	MARK    32

#define 	LINETYPE        41
#define 	LINESCALE       42
#define 	LINE_TYPE_SCALE 43

#define 	XTICK 0
#define 	YTICK 1

// Files to open if any
FILE    	*stream;
FILE    	*fopen();

// Definition of "ch" used in SIGNED_NUMERIC
char    	ch;
char    	temp[25];
char    	filename[250];
int 		textsize;
float 	xoffset,
		yoffset;

long 	tempintx,
		tempinty;  							//was int

//microstepping with SMC800/SNC1500 Conrad card
//const unsigned char motor_array[16] = {0x27,0x2E,0x2D,0x35,0x1C,0x15,0x0D,0x0E,0x03,0x0A,0x09,0x11,0x38,0x31,0x29,0x2A};
//normalstepping with SMC800/SMC1500 Conrad card
//const unsigned char motor_array[8] = {0x27,0x2D,0x1C,0x0D,0x03,0x09,0x38,0x29};
//normal sequence like in conrad smcmot.c example

char 	rotate; 								//hplib

// Define the function getval() which returns a real number.
float   	getval();

// Scaling parameters used for translation from DXY and RD-GL
// coordinate sytem to the PostScript coordinate system which
// has been defined in millimeters. (See above)
int 		pencolor;
int 		red, blue, gray, purple, yellow, orange;

float 	productx, producty, productwidth, productheight;

float   	SCALE;
float   	XSCALE;
float   	YSCALE;

float 	screenscale, plotscale;

float   	xmin, ymin, zmin;
float   	xmax, ymax, zmax;
float   	psxmax,psymax;  /* max postscript dimensions */
float   	tlp,tln;        /* HP-GL tick length parameters */
float   	FONT_H_MULT;    /* fudge factor for font height */
float   	FONT_W_MULT;    /* fudge factor for font width */

// End of line terminator (RD-GL / HP-GL)
char    	EOL;

// zaxis
float 	penupval, pendown1val, pendown2val;

long 	oldx, oldy;  							//was int
float   	absX, absY, absZ;
float   	relX, relY, relY;
float   	newX, newY, newZ;
float   	oldX, oldY, oldZ;
float   	offsetx, offsety;
long 	zz;
int 		stepdelay, 
		startdelay, 
		enddelay, 
		keydelay;
int  	penupstartdelay, 
		penupenddelay;
int  	pendownstartdelay, 
		pendownenddelay;
int 		zdelay, 
		zaxis_startdelay,
		zaxis_enddelay, 
		zaxis_drilldelay;
float   	offX, offY;   							// used for Scale command 
float   	xval, yval;
float   	xStep, yStep, zStep;
long     	maxx, maxy;    						// was int // Width and height of drawarea
float   	smallX, smallY, smallZ,
		bigX, bigY, bigZ,
		tableresX, tableresY, tableresZ,  		// smallest move of table
		newreadX, newreadY,
		hardwarelimitx, hardwarelimity;

long		outxval, outyval;  						//was int

char    	step_output;

int     	MpointerX, MpointerY, MpointerZ;			// pointer for output array

long    	x1, 
		y1, 
		x2, 
		y2, 
		z1, 
		z2;			         	//line3d
long    	x,  
		y,  
		z;                      //line3d
long 	sx, 
		sy, 
		sz;  				//was int
long 	xdirection, 
		ydirection,
		xstep,  
		ystep;    			//was int

float   	point3doldX, point3doldY;       //line3d

int     	output_type;  			// 0=SMC800/1500 control card www.conrad.de
							// 1=phase control like uln2803 example
							// 2=pulse and direction control
int    xdirval, ydirval,zdirval,
	xstepval, ystepval,zstepval;	


float   	char_angle;
float   	char_height;
float   	char_width;
float   	char_space;
float   	char_slant;

char    	font[40];
char    	symbol;

int     	dcount;

// Degree radian conversion parameter ie: deg_rad = asin(1) / 90.0;
//( Defined in dxy2ps.c or rdgl2ps.c )
float   	deg_rad;

// Line / pen size parameter (max 9 sizes)
float   	pen_size[9];
int     	pen_number;

// Paper size (ie A3 or A4) and Mode (HPGL or DXY)
char    	*PaperSize;
char    	*Mode;

// Flags
int 		penuplines;
int     	LANDSCAPE;
int     	DRAW_FLAG;
int     	PLOTABS;
int  	PLOTARC;
int  	PENDOWN;
int 		actualpenstate;
int  	SETDOT;         /* HP-GL commands only */
int  	SYMBOL;         /* HP-GL commands only */

void outputtomotors();
void movestepper(void);
float getval(void);
void hpglcom(char op1);
void dumpit(long x);  //was int
void dumpcomma(void);
void plot(void);
void initgraphic(void);
float theMagnitude(float x, float y);
float theAngle(float x, float y);
line3d(long x1, long y1, long x2 , long y2, long z1, long z2);
point3d(long x, long y, long z);
read_settings_from_file();