/*
 * Code generated by MGUI Designer
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mgui.h"

/*
 * External User Defined Callbacks
 */
void file_open_cb(MENU_ITEM, MVALUE, void *);
/*
 * Global Variables
 */
MOBJECT Motion_Controlled_Main_Window;
MOBJECT File;
MOBJECT help;
MOBJECT about;
MOBJECT openfile_button;
MOBJECT tableset_button;
MOBJECT port_button;
MOBJECT speed_button;
MOBJECT zaxis_button;
MOBJECT offsetxy_button;
MOBJECT mirroxy_button;
MOBJECT key_control_button;
MOBJECT homebutton;
MOBJECT toggle_output_onoff;
MOBJECT popup_toggle_button;
MOBJECT toggle_rotate;
MOBJECT ttftext_button;
MOBJECT flat_table_button;
MOBJECT drawarea;
MOBJECT smallxinput;
MOBJECT smallyinput;
MOBJECT smallzinput;
MOBJECT bigxinput;
MOBJECT bigyinput;
MOBJECT bigzinput;
MOBJECT plotscale_label;
MOBJECT plotscaleinput;
MOBJECT screenscale_label;
MOBJECT screenscaleinput;
MOBJECT toggle_penup_lines_onoff;
MOBJECT start_button;
MOBJECT clearscreen_button;
MOBJECT label1;
MOBJECT label2;
MOBJECT label3;
MOBJECT fileinput;
/*
 * User Code
 */
// NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE
// ***************************************
// DO NOT EDIT THIS FILE OUTSIDE DESIGNER
// ***************************************
// NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE 



// Luberth Dijkman Bangert 23 1619GJ Andijk Netherlands Europe
// E-Mail Luberth@geocities.com
//
// This file is made with designer
// All text/code is edited with mgui designer
// And the code is generated bij mgui designer
//
// I used borlandC BCversion 3.1 on a 80-486DX2 66Mhz 8Mb Mem 420Mb harddisk
// Set compiler memory to LARGE
// Include /LIB/ Bormgui.lib and Bgimgui.lib
// Set directories **********;c:\mgui\include

#include "hpglcom.c"
#include "defn.h"
#include "sounds.c"
#include "options.c"   // the options window 
#include "tableset.c"  // the table settings window 
#include "zaxis.c"     // the zaxis settings window 
#include "speed.c"     // the speed settings window 
#include "settings.c"  // read/write settings.ini
#include "offsetxy.c"  // offset xy settings window
#include "about.c"     // menu file about window
#include "keycontr.c"  //keycontrol window
#include "ttftext.c"
#include "home.c"/*
 * END of User Code
 */

/*
 * Shell creation prototypes
 */
MOBJECT MDCreateMotion_Controlled_Main_Window(void);

/*
 * Project Defined Callbacks
 */
void file_open_cb(MENU_ITEM it, MVALUE status, void *ud)
{
	char fname[25], dirname[25];
     	
	if(MFileSelection("File Open", "*.plt", fname, dirname, True))
	{
		strcat(dirname, fname);
		MObjectSetText(fileinput, dirname);
		//if(fname[0])
		//MSFileSetFile(sfile, dirname);
	}
}


void menu_file_exit_cb(MENU_ITEM it, MVALUE status, void *ud)
{
	if(MMessageDialog("Menu file exit","Exit Program","Yes","No",NULL))
		return;
	MShellUnrealize(Motion_Controlled_Main_Window);
	MShellDestroy(Motion_Controlled_Main_Window);
	MGUITerm();
	exit(0);
}

void menu_help_cb(MENU_ITEM it, MVALUE status, void *ud)
{
	// just pressed menu help help
	// next code wil create help window with help.txt

	MOBJECT shell;

	shell = MCreateShell("Help Text", NULL);
	MCreateSFile(shell, "help.txt", FIXED_MEDIUM, 20, 68);

	MShellRealize(shell);
}
void menu_about_cb(MENU_ITEM it, MVALUE status, void *ud)
{
	Make_Good_Sound();
	MDCreateHello_World();
	MShellRealize(Hello_World);
	
}


void fileopenimagebuttonclick_cb(MOBJECT p, void *od, void *ad)
{
	char fname[25], dirname[25];
     	
	if(MFileSelection("File Open", "*.plt", fname, dirname, True))
	{
		strcat(dirname, fname);
		MObjectSetText(fileinput, dirname);
		//if(fname[0])
		//MSFileSetFile(sfile, dirname);
	}
}

void tableset_button_click_cb(MOBJECT p, void *od, void *ad)
{
	Make_Good_Sound();
	MDCreateTableSettingsWindow();
	MShellRealize(TableSettingsWindow);
}

void portbutton_click_cb(MOBJECT p, void *od, void *ad)
{
	Make_Good_Sound();
	MDCreateOptionsWindow();
	MShellRealize(OptionsWindow);
}
void speed_button_click_cb(MOBJECT p, void *od, void *ad)
{
	Make_Good_Sound();
	MDCreatespeedSettingsWindow();
	MShellRealize(speedSettingsWindow);
}
void zaxis_button_click_cb(MOBJECT p, void *od, void *ad)
{
        Make_Good_Sound();
	MDCreatezaxisSettingsWindow();
	MShellRealize(zaxisSettingsWindow);
}

void offsetxy_button_cb(MOBJECT p, void *od, void *ad)
{
	Make_Good_Sound();
	
	MDCreateoffsetxysettingswindow();
	MShellRealize(offsetxysettingswindow);

}

void keycontrol_cb(MOBJECT p, void *od, void *ad)
{
	
	
	MDCreatekeycontrolWindow();
	MShellRealize(keycontrolWindow);
Make_Good_Sound();
}

void home_button_cb(MOBJECT p, void *od, void *ad)
{
  	extern unsigned int _LPT;

	MDCreatehome();       // create the home window
	MShellRealize(home);  // realize the home window

if(output_type==0){   // = SMC800/SMC1500

  	
	// microstepping with SMC800/SNC1500 Conrad card
	const unsigned char motor_array[16] = {0x27,0x2E,0x2D,0x35,0x1C,0x15,0x0D,0x0E,0x03,0x0A,0x09,0x11,0x38,0x31,0x29,0x2A};
	// normalstepping with SMC800/SMC1500 Conrad card
	//const unsigned char motor_array[8] = {0x27,0x2D,0x1C,0x0D,0x03,0x09,0x38,0x29};
	// normal sequence like in conrad smcmot.c example

  	
	int ii=0;

	while((inp(_LPT +1) & 0x80) == 0){
		//if switches are closed move away from switches in all axis to open switch ;Vecout(xStep, yStep, zStep);
		
		MObjectSetText(label1,"Moving Away"); 
		MObjectSetText(label2,"From switches");

		MpointerX=MpointerX+1;   		
		if (MpointerX > 15)MpointerX = 0;
		MpointerY=MpointerY+1;   		
		if (MpointerY > 15)MpointerY = 0;	
		MpointerZ=MpointerZ-1;   		
		if (MpointerZ < 0)MpointerZ = 15;
	
		outp(_LPT,motor_array[MpointerX]);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform			
	
		outp(_LPT,motor_array[MpointerY]+64);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform
	
		outp(_LPT,motor_array[MpointerZ]+128);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform

		Wait_Time(5000);  
	
		ii++;
		if(ii>=1000){
			MObjectSetText(home_label1, "Takes to much steps \nto move away From switches "); 
			delay(2000);
			MShellUnrealize(home);  // Unrealize the home window
			break;   		// exit while switch is closed lus 
		}	
} 
  
   	
	
	MObjectSetText(home_label1, "Moving Zaxis towards switch \nEscape key exits "); 
    	
	while ((inp(_LPT +1) & 0x80) != 0)            
    	{
		if((inp(0x64)&32)==0){   	 	// check if it is a keyboard or mouse scancode ps2mouse error
			if((inp(0x60))==1){
				            Make_Good_Sound(); 		// Keyboard scancode check;
					    break;
							
			}
		}
		//move towards Z axis switch until its closed
      		       	
		MpointerZ=MpointerZ+1;   		
		if (MpointerZ > 15)MpointerZ = 0;      	
				
		outp(_LPT,motor_array[MpointerZ]+128);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform
		Wait_Time(5000);
	}
	
	for(ii=1; ii<=99;++ii){
		//move 100 steps away from switch in z axis to open switch
		MObjectSetText(home_label1, "Move 100 steps away from switch \nin Z axis to open switch "); 
		MpointerZ=MpointerZ-1;   		
		if (MpointerZ< 0)MpointerZ = 15;
		
		outp(_LPT,motor_array[MpointerZ]+128);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform
		Wait_Time(5000);
	}






    	Wait_Time(656324);       		/* Zeit:  656324 = 550 msec. */
	Make_Good_Sound();

	
	MObjectSetText(home_label1, "Moving Xaxis towards switch \nEscape key exits "); 

	while ((inp(_LPT +1) & 0x80) != 0)       
    	{		
		if((inp(0x64)&32)==0){   	 	// check if it is a keyboard or mouse scancode ps2mouse error
			if((inp(0x60))==1){
				            Make_Good_Sound(); 		// Keyboard scancode check;
					    break;
							
			}
		}
		//move towards X axis switch until its closed
      		       
		MpointerX=MpointerX-1;   		
		if (MpointerX < 0)MpointerX = 15;

		
		outp(_LPT,motor_array[MpointerX]);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform
		Wait_Time(5000);
    }
	for(ii=1; ii<=99;++ii){
		//move 100 steps away from switch in x axis to open switch
		MObjectSetText(home_label1, "Move 100 steps away from switch \nin X axis to open switch "); 
		MpointerX=MpointerX+1;
		if (MpointerX > 15)MpointerX = 0;
		
		outp(_LPT,motor_array[MpointerX]);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform
		Wait_Time(5000);
	}

    	Wait_Time(656324);       		/* Zeit:  656324 = 550 msec. */
	Make_Good_Sound();

	
    	MObjectSetText(home_label1, "Moving Yaxis towards switch \nEscape key exits "); 

	while ((inp(_LPT +1) & 0x80) != 0)  
    	{
		if((inp(0x64)&32)==0){   	 	// check if it is a keyboard or mouse scancode ps2mouse error
			if((inp(0x60))==1){
				Make_Good_Sound(); 		// Keyboard scancode check;
				break;
							
			}
		}
		//move towards Y axis switch until its closed
       
		MpointerY=MpointerY-1;   			
		if (MpointerY < 0)MpointerY = 15;

		outp(_LPT,motor_array[MpointerY]+64);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform
		Wait_Time(5000);
    	}

	for(ii=1; ii<=99;++ii){
		//move 100 steps away from switch in y axis to open switch
		MObjectSetText(home_label1, "Move 100 steps away from switch \nin Y axis to open switch "); 
		MpointerY=MpointerY+1;   	
		if (MpointerY > 15)MpointerY = 0;
		
		outp(_LPT,motor_array[MpointerY]+64);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform
		Wait_Time(5000);
	}

    	Wait_Time(656324);       		/* Zeit:  656324 = 550 msec. */
	Make_Good_Sound();
	
	
	MObjectSetText(home_label1, "Thank you \nDone Homing "); 	
	delay(2500);
	MShellUnrealize(home);	//close the home window
	
 oldX=0;
 oldY=0;
x=0; 
y=0; 


	
}

//if(output_type==1){ DO THAT } 
//if(output_type==2){ DO THAT } 

}


void toggle_output_onoff_cb(MOBJECT p, MVALUE od, void *ad)
{
	if(MTButtonGetActivationStatus(toggle_output_onoff)==0){
		step_output=0;         //0=no output 1=yes output
		MObjectSetPopupHelp(toggle_output_onoff,"Output is OFF",1,1);
	}
	if(MTButtonGetActivationStatus(toggle_output_onoff)==1){
		step_output=1;

		MObjectSetPopupHelp(toggle_output_onoff,"Output is ON",1,1);
	}	

	Make_Good_Sound();
}

void popup_toggle_button_cb(MOBJECT p, MVALUE od, void *ad)
{
	Make_Good_Sound();

if(MTButtonGetActivationStatus(popup_toggle_button)){
	MObjectSetPopupHelp(openfile_button,"Opens a HPGL file",1,1);
	MObjectSetPopupHelp(tableset_button,"Table settings resolution/productsize",1,1);
	MObjectSetPopupHelp(port_button,"LPT port setting en output type",1,1);
	MObjectSetPopupHelp(speed_button,"Speed settings",1,1);
	MObjectSetPopupHelp(zaxis_button,"Z axis settings",1,1);
	MObjectSetPopupHelp(offsetxy_button,"Drawing offset xy",1,1);

	MObjectSetPopupHelp(start_button,"Press this button to start drawing",1,1);
	MObjectSetPopupHelp(screenscaleinput,"Size for screendrawing Has no effect on engraving size",1,1);
	MObjectSetPopupHelp(plotscaleinput,"Size of your engraving",1,1);
	MObjectSetPopupHelp(drawarea,"Button 1 sets offset and draws again\nButton 2 draws drawing size\nButton 3 draws lines",1,1);	
}
if(!MTButtonGetActivationStatus(popup_toggle_button)){
	
	MObjectSetPopupHelp(openfile_button,"Opens a HPGL file",5000,10);
	MObjectSetPopupHelp(tableset_button,"Table settings resolution/productsize",5000,10);
	MObjectSetPopupHelp(port_button,"LPT port setting en output type",5000,10);
	MObjectSetPopupHelp(speed_button,"Speed settings",5000,10);
	MObjectSetPopupHelp(zaxis_button,"Z axis settings",5000,10);
	MObjectSetPopupHelp(offsetxy_button,"Drawing offset xy",5000,10);	

	MObjectSetPopupHelp(start_button,"Press this button to start drawing",5000,10);
	MObjectSetPopupHelp(screenscaleinput,"Size for screendrawing Has no effect on engraving size",5000,10);
	MObjectSetPopupHelp(plotscaleinput,"Size of your engraving",5000,10);
		MObjectSetPopupHelp(drawarea,"Button 1 sets offset and draws again\nButton 2 draws drawing size\nButton 3 draws lines",5000,10);	
}
}

void toggle_rotate_cb(MOBJECT p, MVALUE od, void *ad)
{
	if(MTButtonGetActivationStatus(toggle_rotate)==0)rotate=0;
	if(MTButtonGetActivationStatus(toggle_rotate)==1)rotate=1;
}

void ttftext_button_cb(MOBJECT p, void *od, void *ad)
{
	MDCreatettftextWindow();
	MShellRealize(ttftextWindow);
	Make_Good_Sound();
}

void drawareainputcb(MOBJECT p, MEvent *od, void *ad)
{

	

	//set the mouse position in mm to bottom off screen
	gcvt((od->mouse.x / screenscale),8,temp);          	// float 2 string
	MObjectSetText(label1,temp);     			// type values to window
	gcvt(((maxy-od->mouse.y) / screenscale),8,temp);        // float 2 string
	MObjectSetText(label2,temp);     			// type values to window
	
	//next sets the offsetx offsety with a mousepress
	if(od->mouse.button==1 && od->type == E_BUTTON_RELEASE){ //mouse button 1 is pressed and released in drawarea
					
		//draw a drawing size box and a cirkel for drawing origin
		MDrawCircle(drawarea,od->mouse.x,od->mouse.y,2,MAllocColor(0xff,0x00,0x00)/*red*/);	
		MDrawBox(drawarea,od->mouse.x, od->mouse.y, bigX*tableresX-(offsetx*tableresX), -(bigY*tableresY-(offsety*tableresY)),MAllocColor(0xff,0x00,0x00)/*red*/);
	
		
		//mouse press sets the offsetx and offsety
		offsetx=(od->mouse.x/screenscale)/tableresX;
		offsety=((maxy-od->mouse.y)/screenscale)/tableresY;
	
		//draw the drawing after mouseclick  a bit weird call of start_button_cb
		MRButtonActivate(start_button);
	}

	if (od->mouse.button==2 && od->type == E_BUTTON_RELEASE){
		MDrawBox(drawarea,od->mouse.x, od->mouse.y, bigX*tableresX-(offsetx*tableresX), -(bigY*tableresY-(offsety*tableresY)),MAllocColor(0xff,0xff,0x00));
	}

	if (od->mouse.button==3 && od->type == E_BUTTON_PRESS){
		tempintx=od->mouse.x;
		tempinty=od->mouse.y;
	}
	if(od->mouse.button==3 && od->type == E_BUTTON_RELEASE){
		MDrawXorLine(drawarea, tempintx, tempinty, od->mouse.x,  od->mouse.y);	
	}

	if(od->type == E_MOTION){
		
		
		//draw a drawing size box when the mouse is moved and erase it after delay(10)
		MDrawXorBox(drawarea,od->mouse.x, od->mouse.y, bigX*tableresX-(offsetx*tableresX), -(bigY*tableresY-(offsety*tableresY)));
        	
		delay(10);
		MDrawXorBox(drawarea,od->mouse.x, od->mouse.y, bigX*tableresX-(offsetx*tableresX), -(bigY*tableresY-(offsety*tableresY)));
		
	}

}

void toggle_penup_lines_onoff_cb(MOBJECT p, MVALUE od, void *ad)
{
	if(MTButtonGetActivationStatus(toggle_penup_lines_onoff)==0){
		MObjectSetPopupHelp(toggle_penup_lines_onoff,"Penup line drawing is OFF",1,1);
	}
	if(MTButtonGetActivationStatus(toggle_penup_lines_onoff)==1){
		MObjectSetPopupHelp(toggle_penup_lines_onoff,"Penup line drawing is ON",1,1);
	}	
}

void start_button_cb(MOBJECT p, void *od, void *ad)
{

	 int     op;                                 /* GWKMOD */


	if (MTButtonGetActivationStatus(toggle_penup_lines_onoff)==1){
		penuplines=1;
	}
	else{
		penuplines=0;
	}


	 MObjectGetText(plotscaleinput,temp);	// get string plotscale
	 plotscale = atof(temp);		// string plotscale to float
	 
	 MObjectGetText(screenscaleinput,temp); // get string screenscale
	 screenscale = atof(temp);		// string screenscale to float
			 
	 plotscale=plotscale/100;          	// input was percentage
	 screenscale=screenscale/100; 		// input was percentage

	 
	smallX=smallY=smallZ=0; 
	bigX=bigY=bigZ=0;
	
	Init_Timer();                 		//smcmot.c timer init smc_mot

	maxy = MObjectGetHeight(drawarea); 	//height of drawarea

	MObjectGetText(fileinput,filename);	// get fileinput filename
	stream=fopen(filename,"r");		//

	MDrawBox(drawarea,smallX,maxy-smallY,hardwarelimitx*screenscale,-(hardwarelimity*screenscale),MAllocColor(0xff,0x00,0x00)/*red*/);
	//above draw a harware limit box to screen mdrawbox(drawarea,x,y,width,height,color)
	
	MDrawBox(drawarea,(productx)*screenscale,maxy-(producty)*screenscale,((productwidth)*screenscale),-((productheight)*screenscale),MAllocColor(0xc1,0xc1,0xc1));
	//above draw a product limit box to screen mdrawbox(drawarea,x,y,width,height,color)
	
	MDrawCircle(drawarea,offsetx*screenscale,maxy-offsety*screenscale,2,MAllocColor(0xff,0x00,0x00)/*red*/);	
	//above draw a circle on 0,0
	if(step_output==1){
		MObjectSetText(label3,"Coils ON");
	}

	PLOTABS=1;

	while ((op = getc(stream)) != EOF)      // file read/parse
	 if (isalpha(op) > 0){
		hpglcom(op);
	 }
 	fclose(stream);  			// close HPGL input file
						// not sure about this
						// problems with file open 
line3d(oldX, oldY, 0,0,0,0);
oldX=x;
oldY=y;
Make_Attention_Sound();
	
	
//done drawing so turn motors off
if(output_type==0){//SMC800/SMC1500
			outp(_LPT,27);
			Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
							// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
			outp(_LPT+2, 1);  		// strobe data ubername/perform
			outp(_LPT+2, 0);  		// strobe data ubername/perform
			outp(_LPT,27+64);
			Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
							// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
			outp(_LPT+2, 1);  		// strobe data ubername/perform
			outp(_LPT+2, 0); 

			outp(_LPT,27+128);
			Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
							// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
			outp(_LPT+2, 1);  		// strobe data ubername/perform
			outp(_LPT+2, 0); 
			MObjectSetText(label3,"Coils OFF");
}

//turn motors off prevent them to get to hot
if(output_type==1){//PHASE CONTROL
			outp(_LPT,0);
			outp(_LPT+2, 0^11);  		// ^=xor 11 some bits are inverted on this adres
			MObjectSetText(label3,"Coils OFF");
}
			 	

	
	
	gcvt(smallX*tableresX,8,temp);          // float 2 string
	MObjectSetText(smallxinput,temp);     	// type values to window
	gcvt(smallY*tableresY,8,temp);	      	// *tableres to get milimeters
	MObjectSetText(smallyinput,temp);
	gcvt(smallZ*tableresZ,8,temp);	      	
	MObjectSetText(smallzinput,temp);

	gcvt(bigX*tableresX,8,temp);	
	MObjectSetText(bigxinput,temp);
	gcvt(bigY*tableresY,8,temp);
	MObjectSetText(bigyinput,temp);
	gcvt(bigZ*tableresZ,8,temp);
	MObjectSetText(bigzinput,temp);


}

void clearscreen_button_cb(MOBJECT p, void *od, void *ad)
{
	MObjectRedraw(drawarea); 
}


/*
 * Shell creation functions
 */

MOBJECT MDCreateMotion_Controlled_Main_Window(void)
{
	MOBJECT _menu000;
	MOBJECT _colform000;
	MOBJECT _tbutton000;
	MOBJECT _colform001;
	MOBJECT _rowform000;
	MOBJECT _colform002;

	Motion_Controlled_Main_Window = MCreateShell("Motion Controlled (Steppermotor Driver Connected to Parallel Port)", 0);
	MFormSetSpacing(Motion_Controlled_Main_Window, 0);
	MObjectSetCompositeWidth(Motion_Controlled_Main_Window, 640);
	MObjectSetCompositeHeight(Motion_Controlled_Main_Window, 480);
read_settings_from_file();
screenscale=100;
plotscale=100;



	{
	  MOBJECT	pd;
	  MENU_ITEM	item;

	  _menu000 = MCreateMenuBar(Motion_Controlled_Main_Window, FIXED_SMALL);
	  MMenuBarSetAcc(_menu000, F10);
	  File = MCreateMenu(_menu000, "File");
	  item = MMenuAddItem(File, "Open", file_open_cb, NULL);
	  MMenuAddSeparator(File);
	  item = MMenuAddItem(File, "Exit", menu_file_exit_cb, NULL);
	  help = MCreateMenu(_menu000, "Help");
	  item = MMenuAddItem(help, "info", menu_help_cb, NULL);
	  about = MCreateMenu(_menu000, "About");
	  item = MMenuAddItem(about, "about", menu_about_cb, NULL);
	}
	MTopAttach(_menu000, F_ATT_FORM, 1, NULL);
	MLeftAttach(_menu000, F_ATT_FORM, 1, NULL);
	MObjectAlign(_menu000, LEFT_ALIGN, TOP_ALIGN);
	MObjectSetShadow(_menu000, WS_NONE, 0, 0);

	_colform000 = MCreateColForm(Motion_Controlled_Main_Window);
	MFormSetSpacing(_colform000, 1);
	MTopAttach(_colform000, F_ATT_OBJ, 1, _menu000);
	MLeftAttach(_colform000, F_ATT_FORM, 1, NULL);
	MObjectAlign(_colform000, LEFT_ALIGN, TOP_ALIGN);
	MObjectSetResize(_colform000, False, False);

	openfile_button = MCreateImagePButtonExt(_colform000, "bmopen.bmp", "", "", "", "", "");
	MPButtonSetCallback(openfile_button, fileopenimagebuttonclick_cb, NULL);
	MObjectSetShadow(openfile_button, WS_ETCHED_IN, 1, 1);

	tableset_button = MCreatePButton(_colform000, "Table", TIMES_SMALL);
	MPButtonSetCallback(tableset_button, tableset_button_click_cb, NULL);
	MObjectSetShadow(tableset_button, WS_ETCHED_IN, 1, 1);

	port_button = MCreatePButton(_colform000, "Port", TIMES_SMALL);
	MPButtonSetCallback(port_button, portbutton_click_cb, NULL);
	MObjectSetShadow(port_button, WS_ETCHED_IN, 1, 1);

	speed_button = MCreatePButton(_colform000, "Speed", TIMES_SMALL);
	MPButtonSetCallback(speed_button, speed_button_click_cb, NULL);
	MObjectSetShadow(speed_button, WS_ETCHED_IN, 1, 1);

	zaxis_button = MCreatePButton(_colform000, "Z-Axis", TIMES_SMALL);
	MPButtonSetCallback(zaxis_button, zaxis_button_click_cb, NULL);
	MObjectSetShadow(zaxis_button, WS_ETCHED_IN, 1, 1);

	offsetxy_button = MCreatePButton(_colform000, "OffSet XY", TIMES_SMALL);
	MPButtonSetCallback(offsetxy_button, offsetxy_button_cb, NULL);
	MObjectSetShadow(offsetxy_button, WS_ETCHED_IN, 1, 1);

	mirroxy_button = MCreatePButton(_colform000, "Mirror", TIMES_SMALL);
	MObjectSetShadow(mirroxy_button, WS_ETCHED_IN, 1, 1);

	key_control_button = MCreatePButton(_colform000, "Key Control", TIMES_SMALL);
	MPButtonSetCallback(key_control_button, keycontrol_cb, NULL);
	MObjectSetShadow(key_control_button, WS_ETCHED_IN, 1, 1);
MObjectSetPopupHelp(key_control_button,"Only for SMC800/SMC1500 at the moment",1,1);
	homebutton = MCreatePButton(_colform000, "Home", TIMES_SMALL);
	MPButtonSetCallback(homebutton, home_button_cb, NULL);
	MObjectSetShadow(homebutton, WS_ETCHED_IN, 1, 1);
MObjectSetPopupHelp(homebutton,"Only for SMC800/SMC1500 at the moment",1,1);
	toggle_output_onoff = MCreateImageTextTButtonExt(_colform000, "Output", TIMES_SMALL, "red.bmp", "green.bmp", "", "", "", "");
	MButtonSetTextVsImageAlignment(toggle_output_onoff, 1);
	MTButtonSetCallback(toggle_output_onoff, toggle_output_onoff_cb, NULL);
MObjectSetPopupHelp(toggle_output_onoff,"Turn output to steppers ON or OFF",1,1);
	_tbutton000 = MCreateImageTextTButtonExt(_colform000, "Coolant", TIMES_SMALL, "red.bmp", "green.bmp", "", "", "", "");
	MButtonSetTextVsImageAlignment(_tbutton000, 1);

	popup_toggle_button = MCreateImageTextTButtonExt(_colform000, "PopUp", TIMES_SMALL, "red.bmp", "green.bmp", "", "", "", "");
	MButtonSetTextVsImageAlignment(popup_toggle_button, 1);
	MTButtonSetCallback(popup_toggle_button, popup_toggle_button_cb, NULL);
MObjectSetPopupHelp(popup_toggle_button,"on = fast popuphelp off = slow popuphelp",1,1);	
	toggle_rotate = MCreateImageTextTButtonExt(_colform000, "Rotate", TIMES_SMALL, "red.bmp", "green.bmp", "", "", "", "");
	MButtonSetTextVsImageAlignment(toggle_rotate, 1);
	MTButtonSetCallback(toggle_rotate, toggle_rotate_cb, NULL);

	ttftext_button = MCreatePButton(_colform000, "TTF Text", TIMES_SMALL);
	MPButtonSetCallback(ttftext_button, ttftext_button_cb, NULL);
	MObjectSetShadow(ttftext_button, WS_ETCHED_IN, 1, 1);

	flat_table_button = MCreatePButton(_colform000, "Flat", TIMES_SMALL);
	MObjectSetShadow(flat_table_button, WS_ETCHED_IN, 1, 1);

	_colform001 = MCreateColForm(Motion_Controlled_Main_Window);
	MTopAttach(_colform001, F_ATT_OBJ, 1, _colform000);

	drawarea = MCreateDrawArea(_colform001, 507, 375);
	MDrawAreaSetInputCallback(drawarea, drawareainputcb, NULL);
	MObjectSetForegroundRGB(drawarea, 255, 255, 0);
	MObjectSetBackgroundRGB(drawarea, 212, 215, 212);
	MObjectSetResize(drawarea, True, True);
MObjectSetCursor(drawarea, MC_CROSSHAIR);
maxy = MObjectGetHeight(drawarea); 	//height of drawarea
	_rowform000 = MCreateRowForm(_colform001);
	MObjectSetResize(_rowform000, False, True);
	MObjectSetCompositeWidth(_rowform000, 120);

	smallxinput = MCreateLabel(_rowform000, "smallx", HELV_MEDIUM);
	MObjectSetShadow(smallxinput, WS_ETCHED_IN, 1, 1);

	smallyinput = MCreateLabel(_rowform000, "smally", HELV_MEDIUM);
	MObjectSetShadow(smallyinput, WS_ETCHED_IN, 1, 1);

	smallzinput = MCreateLabel(_rowform000, "smallz", HELV_MEDIUM);
	MObjectSetShadow(smallzinput, WS_ETCHED_IN, 1, 1);

	bigxinput = MCreateLabel(_rowform000, "bigx", HELV_MEDIUM);
	MObjectSetShadow(bigxinput, WS_ETCHED_IN, 1, 1);

	bigyinput = MCreateLabel(_rowform000, "bigy", HELV_MEDIUM);
	MObjectSetShadow(bigyinput, WS_ETCHED_IN, 1, 1);

	bigzinput = MCreateLabel(_rowform000, "bigz", HELV_MEDIUM);
	MObjectSetShadow(bigzinput, WS_ETCHED_IN, 1, 1);

	plotscale_label = MCreateLabel(_rowform000, "Plotscale", HELV_MEDIUM);
	MObjectSetShadow(plotscale_label, WS_ETCHED_IN, 1, 1);

	plotscaleinput = MCreateEdit(_rowform000, "100", 10, FIXED_MEDIUM);

	screenscale_label = MCreateLabel(_rowform000, "Screenscale", HELV_MEDIUM);

	screenscaleinput = MCreateEdit(_rowform000, "100", 10, FIXED_MEDIUM);

	toggle_penup_lines_onoff = MCreateImageTextTButtonExt(_rowform000, "PenUp Lines", HELV_MEDIUM, "red.bmp", "green.bmp", "", "", "", "");
	MButtonSetTextVsImageAlignment(toggle_penup_lines_onoff, 1);
	MTButtonSetCallback(toggle_penup_lines_onoff, toggle_penup_lines_onoff_cb, NULL);

	start_button = MCreatePButton(_rowform000, "Start", TIMES_MEDIUM);
	MPButtonSetCallback(start_button, start_button_cb, NULL);

	clearscreen_button = MCreatePButton(_rowform000, "Clear", TIMES_MEDIUM);
	MPButtonSetCallback(clearscreen_button, clearscreen_button_cb, NULL);

	_colform002 = MCreateColForm(Motion_Controlled_Main_Window);
	MObjectSetResize(_colform002, True, False);

	label1 = MCreateLabel(_colform002, "Mouse Xmm", HELV_MEDIUM);
	MObjectSetShadow(label1, WS_ETCHED_IN, 1, 1);
MObjectSetPopupHelp(label1,"X in milimeters",1,1);
	label2 = MCreateLabel(_colform002, "Mouse Ymm", HELV_MEDIUM);
	MObjectSetShadow(label2, WS_ETCHED_IN, 1, 1);
MObjectSetPopupHelp(label2,"Y in milimeters",1,1);
	label3 = MCreateLabel(_colform002, "", HELV_MEDIUM);
	MObjectSetShadow(label3, WS_ETCHED_IN, 1, 1);

	fileinput = MCreateClippedEdit(_colform002, "dir-hpgl.plt", 100, 30, FIXED_MEDIUM);


	return Motion_Controlled_Main_Window;
}

void MDQuitCB(MOBJECT shell, void *od, void *ad)
{
	if (MMessageDialog("", "Do you really want to quit ?", "Yes", "No", NULL))
		return;
	MShellUnrealize(shell);
	MShellDestroy(shell);
	MGUITerm();
	exit(0);
}

void MGUIMain(int argc, char **argv)
{
	MOBJECT shell;

	shell = MDCreateMotion_Controlled_Main_Window();
	MShellRealize(shell);

	MShellSetWMCloseCallback(shell, MDQuitCB, 0L);
	MMainLoop();
}
