/*
 * Decompiled with CFR 0.152.
 */
package jfr.html;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import jfr.html.parser.AuthorizationErr;
import jfr.html.parser.HostNotFoundException;
import jfr.html.parser.Keyword;
import jfr.html.parser.PageNotFoundException;
import jfr.html.parser.Problem;
import jfr.html.parser.StringKeyword;
import jfr.list.GenericLink;
import jfr.pagesucker.Constants;
import jfr.util.Aborter;
import jfr.util.Alphabet;
import jfr.util.AlphabetException;
import jfr.util.FileAccessor;
import jfr.util.FileSet;
import jfr.util.ModifiableInteger;
import jfr.util.StackInputStream;
import jfr.util.StringUtils;
import jfr.util.UserAbortException;

public abstract class Parser
extends GenericLink {
    public static final byte FILE_HTML = 1;
    public static final byte FILE_RAM = 2;
    public static final byte FILE_M3U = 3;
    public static final byte FILE_DATA = 4;
    public static final byte FILE_JAVASCRIPT_INCLUDE = 5;
    protected StackInputStream in_stream;
    protected DataOutputStream out_stream;
    protected URL page_url;
    protected URL base_url;
    protected String referencing_url_string;
    protected String[] page_default_names;
    protected String save_base_dir_string;
    protected File save_file;
    protected FileSet m_files_in_use;
    protected Aborter aborter;
    protected int input_buffer_size = 20480;
    protected int output_buffer_size = 20480;
    protected int m_recursion_level;
    protected byte file_kind;
    protected boolean save_page;
    protected boolean parse_page;
    protected boolean use_absolute_paths_in_ram_files;
    protected boolean use_absolute_paths_in_m3u_files;
    protected boolean dont_allow_gt_in_strings;
    protected boolean accept_single_line_comments;
    protected int thread_index;
    public static Alphabet alphabet_whitespace;
    public static Alphabet alphabet_keyword;
    public static Alphabet alphabet_not_keyword;
    public static Alphabet alphabet_string;
    public static Alphabet alphabet_string_wo_gt;
    public static Alphabet alphabet_not_tag_start;
    public static Alphabet alphabet_not_tag_end;
    public static Alphabet alphabet_not_tag_end_or_quotes;
    public static Alphabet alphabet_not_tag_end_or_whitespace;
    public static Alphabet alphabet_not_dash;
    public static Alphabet alphabet_control_characters;
    public static Alphabet alphabet_control_or_space;
    public static Alphabet alphabet_not_control_or_space;
    public static Alphabet alphabet_not_eol;
    public static Alphabet alphabet_separator;
    public static Alphabet alphabet_valid_scheme_chars;
    public static FileAccessor file_accessor;

    public Parser(URL url, String ref_url_string, String[] default_names, String save_dir, byte in_file_kind, boolean in_use_absolute_paths_in_ram_files, boolean in_use_absolute_paths_in_m3u_files, ModifiableInteger existing_file_strategy, FileSet files_in_use, Aborter the_aborter, int in_recursion_level, boolean in_dont_allow_gt_in_strings, boolean in_accept_single_line_comments) throws IOException, Problem {
        this.base_url = this.page_url = url;
        this.referencing_url_string = ref_url_string != null ? ref_url_string : "<none>";
        this.page_default_names = default_names;
        this.save_base_dir_string = save_dir;
        this.parse_page = in_file_kind == 1 || in_file_kind == 2 || in_file_kind == 3;
        this.file_kind = in_file_kind;
        this.use_absolute_paths_in_ram_files = in_use_absolute_paths_in_ram_files;
        this.use_absolute_paths_in_m3u_files = in_use_absolute_paths_in_m3u_files;
        this.aborter = the_aborter;
        this.m_files_in_use = files_in_use;
        this.m_recursion_level = in_recursion_level;
        this.dont_allow_gt_in_strings = in_dont_allow_gt_in_strings;
        this.accept_single_line_comments = in_accept_single_line_comments;
        this.thread_index = -1;
        if (this.save_base_dir_string != null) {
            String filename = Parser.getURLString(this.getPageURL(), false, true, false, false);
            String hostname = this.getPageURL().getHost();
            int port = this.getPageURL().getPort();
            if (hostname == null || hostname.length() == 0) {
                if (filename.charAt(0) == '/' && filename.length() > 1) {
                    filename = filename.substring(1);
                }
            } else {
                if (port != -1) {
                    hostname = String.valueOf(hostname) + '_';
                    hostname = String.valueOf(hostname) + String.valueOf(port);
                }
                filename = filename.charAt(0) != '/' ? String.valueOf(hostname) + '/' + filename : String.valueOf(hostname) + filename;
            }
            if (filename.endsWith("/")) {
                filename = String.valueOf(filename) + "index.html";
            }
            if (File.separatorChar != '/') {
                filename = alphabet_separator.clean(filename, 'x');
            }
            filename = filename.replace('/', File.separatorChar);
            File file = file_accessor.adaptFileSpecToLocalSystem(new File(filename));
            this.save_file = file_accessor.createFile(new File(this.save_base_dir_string, file.getPath()), existing_file_strategy, files_in_use);
            this.save_page = existing_file_strategy.value == 1;
        } else {
            this.save_file = null;
            existing_file_strategy.value = 2;
            this.save_page = false;
        }
    }

    public void setThreadIndex(int index) {
        this.thread_index = index;
    }

    public File getSaveFile() {
        return this.save_file;
    }

    public boolean getSavePageFlag() {
        return this.save_page;
    }

    public boolean getParsePageFlag() {
        return this.parse_page;
    }

    public byte getFileKind() {
        return this.file_kind;
    }

    public URL getPageURL() {
        return this.page_url;
    }

    public URL getBaseURL() {
        return this.base_url;
    }

    public String getReferencingURLString() {
        return this.referencing_url_string;
    }

    public int getRecursionLevel() {
        return this.m_recursion_level;
    }

    protected abstract void tagAction(Keyword var1) throws IOException, UserAbortException;

    protected abstract void handleLink(String var1, boolean var2) throws IOException;

    protected void displayStatus(String description, char status) {
    }

    protected void setConnectionRequestProperties(URL url, URLConnection connection) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseDoc() throws HostNotFoundException, PageNotFoundException, AuthorizationErr, Problem, IOException, UserAbortException {
        block29: {
            InputStream page_stream;
            block28: {
                String errstr_output_stream_open = "Could not open the output disk file";
                page_stream = null;
                URLConnection page_connection = null;
                FileOutputStream fos = null;
                BufferedOutputStream bos = null;
                int page_content_length = -1;
                try {
                    String url_path = this.getPageURL().getFile();
                    try {
                        page_connection = this.openURLConnection(this.getPageURL());
                        page_stream = page_connection.getInputStream();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new HostNotFoundException(this.getPageURL().toString());
                    }
                    if (page_stream == null) {
                        if (this.page_default_names == null) throw new PageNotFoundException(this.getPageURL().toString());
                        int used_default_name_index = -1;
                        int i = 0;
                        while (i < this.page_default_names.length) {
                            if (url_path.endsWith("/" + this.page_default_names[i])) {
                                used_default_name_index = i;
                                break;
                            }
                            ++i;
                        }
                        if (used_default_name_index == -1) throw new PageNotFoundException(this.getPageURL().toString());
                        url_path = url_path.substring(0, url_path.length() - this.page_default_names[used_default_name_index].length());
                        this.page_url = this.base_url = new URL(this.getPageURL(), url_path);
                        try {
                            page_connection = this.openURLConnection(this.getPageURL());
                            page_stream = page_connection.getInputStream();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new PageNotFoundException(this.getPageURL().toString());
                        }
                    }
                    page_content_length = page_connection.getContentLength();
                    if (this.save_page) {
                        fos = new FileOutputStream(this.save_file);
                        bos = new BufferedOutputStream(fos, this.output_buffer_size);
                        this.out_stream = new DataOutputStream(bos);
                    } else {
                        this.out_stream = null;
                    }
                    if (!this.parse_page) {
                        if (this.out_stream != null) {
                            int size;
                            byte[] buffer = new byte[this.input_buffer_size];
                            int bytes_read = 0;
                            String url_string = this.getPageURL().toString();
                            while ((size = page_stream.read(buffer)) != -1) {
                                this.out_stream.write(buffer, 0, size);
                                if (bytes_read < page_content_length) {
                                    int percentage = (bytes_read += size) * 100 / page_content_length;
                                    this.displayStatus("Downloading \"" + url_string + "\" (" + String.valueOf(percentage) + "%)", 'D');
                                }
                                if (this.aborter == null || !this.aborter.abortRequested()) continue;
                                throw new UserAbortException();
                            }
                        }
                    } else {
                        this.in_stream = new StackInputStream(new BufferedInputStream(page_stream, this.input_buffer_size));
                        if (this.file_kind == 2 || this.file_kind == 3) {
                            String url_string = null;
                            boolean not_finished = true;
                            while (not_finished && alphabet_control_or_space.skip(this.in_stream, this.out_stream) != -1) {
                                if (this.in_stream.peek() == 59) {
                                    if (alphabet_not_eol.skip(this.in_stream, this.out_stream) != -1) continue;
                                    not_finished = false;
                                    continue;
                                }
                                url_string = alphabet_not_control_or_space.span(this.in_stream);
                                this.handleLink(url_string, false);
                            }
                        } else {
                            while (alphabet_not_tag_start.skip(this.in_stream, this.out_stream) != -1 && this.in_stream.read() != -1) {
                                this.parseTag();
                                if (this.aborter == null || !this.aborter.abortRequested()) continue;
                                throw new UserAbortException();
                            }
                        }
                    }
                    Object var9_17 = null;
                    if (this.in_stream == null) break block28;
                }
                catch (Throwable throwable) {
                    Object var9_18 = null;
                    if (this.in_stream != null) {
                        this.in_stream.close();
                        this.in_stream = null;
                        page_stream = null;
                    } else if (page_stream != null) {
                        page_stream.close();
                        page_stream = null;
                    }
                    if (this.out_stream != null) {
                        this.out_stream.flush();
                        this.out_stream.close();
                        this.out_stream = null;
                    }
                    if (!this.save_page) throw throwable;
                    this.m_files_in_use.remove(this.save_file);
                    throw throwable;
                }
                this.in_stream.close();
                this.in_stream = null;
                page_stream = null;
                break block29;
            }
            if (page_stream != null) {
                page_stream.close();
                page_stream = null;
            }
        }
        if (this.out_stream != null) {
            this.out_stream.flush();
            this.out_stream.close();
            this.out_stream = null;
        }
        if (!this.save_page) return;
        this.m_files_in_use.remove(this.save_file);
    }

    protected void parseTag() throws IOException, UserAbortException {
        if (this.parseCommentTag()) {
            return;
        }
        Keyword kw = this.getKeyword(false);
        switch (kw.getKind()) {
            case 70: {
                if (this.out_stream == null) break;
                this.out_stream.writeByte(60);
                break;
            }
            case 62: {
                if (this.out_stream == null) break;
                this.out_stream.writeBytes("<>");
                break;
            }
            default: {
                if (this.out_stream != null) {
                    this.out_stream.writeBytes(String.valueOf('<') + kw.toString());
                }
                this.tagAction(kw);
            }
        }
    }

    private boolean parseCommentTag() throws IOException, UserAbortException {
        if ((char)this.in_stream.peek() != '!') {
            return false;
        }
        if (this.in_stream.read() == -1) {
            return false;
        }
        int c1 = this.in_stream.read();
        int c2 = this.in_stream.read();
        if (c1 != 45 || c2 != 45) {
            this.in_stream.pushBack(c2);
            this.in_stream.pushBack(c1);
            this.in_stream.pushBack(33);
            return false;
        }
        if (this.out_stream != null) {
            this.out_stream.writeBytes("<!--");
        }
        StringBuffer comment_buffer = new StringBuffer();
        while (true) {
            if ((c1 = this.in_stream.read()) != 45) {
                if (c1 == -1) {
                    int first_line_length;
                    if (!this.accept_single_line_comments) {
                        if (this.out_stream != null) {
                            this.out_stream.writeBytes(comment_buffer.toString());
                        }
                        return true;
                    }
                    String comment = comment_buffer.toString();
                    String first_line = Constants.alphabet_not_CR_or_LF.span(comment);
                    if (this.out_stream != null) {
                        this.out_stream.writeBytes(first_line);
                        this.out_stream.writeBytes("-->");
                    }
                    if ((first_line_length = first_line.length()) < comment.length()) {
                        this.in_stream.pushBack(comment.substring(first_line_length));
                    }
                    return true;
                }
                comment_buffer.append((char)c1);
                if (this.aborter == null || !this.aborter.abortRequested()) continue;
                throw new UserAbortException();
            }
            c2 = this.in_stream.read();
            int c3 = this.in_stream.read();
            if (c1 == 45 && c2 == 45 && c3 == 62) break;
            comment_buffer.append((char)c1);
            this.in_stream.pushBack(c3);
            this.in_stream.pushBack(c2);
        }
        if (this.out_stream != null) {
            this.out_stream.writeBytes(comment_buffer.toString());
            this.out_stream.writeBytes("-->");
        }
        return true;
    }

    protected void skipToEndOfTag(boolean write_to_output) throws IOException {
        char c;
        DataOutputStream local_out_stream;
        DataOutputStream dataOutputStream = local_out_stream = write_to_output ? this.out_stream : null;
        do {
            Alphabet alpha;
            if (alphabet_not_tag_end_or_quotes.skip(this.in_stream, local_out_stream) == -1) {
                return;
            }
            if (this.in_stream.peek() == 62) {
                this.in_stream.read();
                if (local_out_stream != null) {
                    local_out_stream.write(62);
                }
                return;
            }
            this.in_stream.read();
            if (local_out_stream != null) {
                local_out_stream.write(34);
            }
            Alphabet alphabet = alpha = this.dont_allow_gt_in_strings ? alphabet_string_wo_gt : alphabet_string;
            if (alpha.skip(this.in_stream, local_out_stream) == -1) {
                return;
            }
            c = (char)this.in_stream.read();
            if (local_out_stream == null) continue;
            local_out_stream.writeByte(c);
        } while (c != '>');
    }

    protected Keyword getKeyword(boolean write_to_output) throws IOException {
        return this.getKeyword(write_to_output, true);
    }

    protected Keyword getKeyword(boolean write_to_output, boolean also_output_keywords) throws IOException {
        String keyword_string;
        DataOutputStream out_stream_kw;
        DataOutputStream out_stream_garbage = write_to_output ? this.out_stream : null;
        DataOutputStream dataOutputStream = out_stream_kw = also_output_keywords ? out_stream_garbage : null;
        if (alphabet_whitespace.skip(this.in_stream, out_stream_garbage) == -1) {
            return new Keyword(70);
        }
        char c = (char)this.in_stream.peek();
        switch (c) {
            case '>': {
                this.in_stream.read();
                if (out_stream_kw != null) {
                    out_stream_kw.write(62);
                }
                return new Keyword(62);
            }
            case '=': {
                this.in_stream.read();
                if (out_stream_kw != null) {
                    out_stream_kw.write(61);
                }
                return new Keyword(60);
            }
            case '#': {
                this.in_stream.read();
                if (out_stream_kw != null) {
                    out_stream_kw.write(35);
                }
                return new Keyword(61);
            }
            case '\"': {
                this.in_stream.read();
                StringKeyword kw = new StringKeyword(alphabet_string.span(this.in_stream, null));
                this.in_stream.read();
                if (out_stream_kw != null) {
                    out_stream_kw.writeBytes(((Keyword)kw).toString());
                }
                return kw;
            }
        }
        if (!alphabet_keyword.contains(c)) {
            c = (char)alphabet_not_keyword.skip(this.in_stream, out_stream_garbage);
        }
        if ((keyword_string = alphabet_keyword.span(this.in_stream, out_stream_kw).toUpperCase()).equals("A")) {
            return new Keyword(1);
        }
        if (keyword_string.equals("HREF")) {
            return new Keyword(2);
        }
        if (keyword_string.equals("NAME")) {
            return new Keyword(3);
        }
        if (keyword_string.equals("IMG")) {
            return new Keyword(4);
        }
        if (keyword_string.equals("SRC")) {
            return new Keyword(5);
        }
        if (keyword_string.equals("AREA")) {
            return new Keyword(6);
        }
        if (keyword_string.equals("BODY")) {
            return new Keyword(7);
        }
        if (keyword_string.equals("BACKGROUND")) {
            return new Keyword(8);
        }
        if (keyword_string.equals("FRAME")) {
            return new Keyword(9);
        }
        if (keyword_string.equals("BASE")) {
            return new Keyword(10);
        }
        if (keyword_string.equals("SCRIPT")) {
            return new Keyword(11);
        }
        if (keyword_string.equals("LANGUAGE")) {
            return new Keyword(12);
        }
        if (keyword_string.equals("ONMOUSEOUT")) {
            return new Keyword(13);
        }
        if (keyword_string.equals("ONMOUSEOVER")) {
            return new Keyword(14);
        }
        if (keyword_string.equals("ONCLICK")) {
            return new Keyword(15);
        }
        if (keyword_string.equals("ONCHANGE")) {
            return new Keyword(16);
        }
        if (keyword_string.equals("INPUT")) {
            return new Keyword(17);
        }
        if (keyword_string.equals("SELECT")) {
            return new Keyword(18);
        }
        if (keyword_string.equals("OPTION")) {
            return new Keyword(19);
        }
        if (keyword_string.equals("VALUE")) {
            return new Keyword(20);
        }
        return new Keyword(0, keyword_string);
    }

    protected int findKeywordPairsInTag(boolean write_to_output, int kw1_first, int kw1_second) throws IOException {
        return this.findKeywordPairsInTag(write_to_output, kw1_first, kw1_second, true);
    }

    protected int findKeywordPairsInTag(boolean write_to_output, int kw1_first, int kw1_second, boolean also_output_found_kw) throws IOException {
        int[] keywords = new int[]{kw1_first, kw1_second};
        return this.findKeywordPairsInTag(write_to_output, keywords, also_output_found_kw);
    }

    protected int findKeywordPairsInTag(boolean write_to_output, int[] keywords) throws IOException {
        return this.findKeywordPairsInTag(write_to_output, keywords, true);
    }

    protected int findKeywordPairsInTag(boolean write_to_output, int[] keywords, boolean also_output_found_kw) throws IOException {
        boolean output_undesired_kw;
        int kw_pairs = keywords.length / 2;
        boolean bl = output_undesired_kw = write_to_output && !also_output_found_kw && this.out_stream != null;
        if (kw_pairs == 0) {
            return -1;
        }
        Keyword first_kw = this.getKeyword(write_to_output, also_output_found_kw);
        byte first_kw_kind = first_kw.getKind();
        if (first_kw_kind == 70 || first_kw_kind == 62) {
            if (output_undesired_kw) {
                this.out_stream.writeBytes(first_kw.toString());
            }
            return -1;
        }
        while (true) {
            Keyword second_kw;
            byte second_kw_kind;
            if ((second_kw_kind = (second_kw = this.getKeyword(write_to_output, also_output_found_kw)).getKind()) == 70 || second_kw_kind == 62) {
                if (output_undesired_kw) {
                    this.out_stream.writeBytes(first_kw.toString());
                    this.out_stream.writeBytes(second_kw.toString());
                }
                return -1;
            }
            int i = 0;
            while (i < kw_pairs) {
                if (first_kw_kind == keywords[i * 2] && second_kw_kind == keywords[i * 2 + 1]) {
                    return first_kw_kind;
                }
                ++i;
            }
            if (output_undesired_kw) {
                this.out_stream.writeBytes(first_kw.toString());
            }
            first_kw = second_kw;
            first_kw_kind = second_kw_kind;
        }
    }

    protected String getString() throws IOException {
        alphabet_whitespace.skip(this.in_stream, this.out_stream);
        if ((char)this.in_stream.peek() == '\"') {
            Alphabet alpha = this.dont_allow_gt_in_strings ? alphabet_string_wo_gt : alphabet_string;
            this.in_stream.read();
            alphabet_whitespace.skip(this.in_stream, this.out_stream);
            String result = alpha.span(this.in_stream, null);
            if (this.in_stream.peek() == 34) {
                this.in_stream.read();
            }
            result = alphabet_whitespace.trimRight(result);
            return result;
        }
        return alphabet_not_tag_end_or_whitespace.span(this.in_stream, null);
    }

    public void writeLocalURL(File file, String reference, char quote_char) throws IOException {
        if (this.out_stream != null) {
            if (this.file_kind == 1) {
                this.out_stream.writeByte(quote_char);
            }
            if (this.file_kind == 2 && this.use_absolute_paths_in_ram_files || this.file_kind == 3 && this.use_absolute_paths_in_m3u_files) {
                String path = file.getAbsolutePath().replace(File.separatorChar, '/');
                this.out_stream.writeBytes("file://" + StringUtils.encodeURLCharacters(path));
            } else {
                String path = Parser.getRelativeFilePath(file, this.save_file);
                this.out_stream.writeBytes(StringUtils.encodeURLCharacters(path));
            }
            if (this.file_kind == 1) {
                if (reference != null) {
                    this.out_stream.writeBytes("#" + reference);
                }
                this.out_stream.writeByte(quote_char);
            }
        }
    }

    public void writeURL(String url_string, char quote_char, boolean close_string) throws IOException {
        if (this.out_stream != null) {
            if (this.file_kind == 1) {
                this.out_stream.writeByte(quote_char);
            }
            this.out_stream.writeBytes(url_string);
            if (close_string && this.file_kind == 1) {
                this.out_stream.writeByte(quote_char);
            }
        }
    }

    public void writeURL(String url_string) throws IOException {
        this.writeURL(url_string, '\"', true);
    }

    public String getLowerURLProtocol(String url_string) {
        int colon_index = url_string.indexOf(58);
        int question_index = url_string.indexOf(63);
        int sharp_index = url_string.indexOf(35);
        if (colon_index <= 0) {
            return null;
        }
        if (question_index >= 0 && question_index < colon_index) {
            return null;
        }
        if (sharp_index >= 0 && sharp_index < colon_index) {
            return null;
        }
        return url_string.substring(0, colon_index).toLowerCase();
    }

    public static URL buildNormalizedURL(URL in_base_url, String url_string, boolean accept_untyped_files) throws MalformedURLException {
        String fragment = null;
        String scheme = null;
        String netloc = null;
        String query = null;
        String params = null;
        String path = null;
        boolean removed_final_slash = false;
        boolean has_file_scheme = false;
        StringBuffer buffer = new StringBuffer(100);
        int index = url_string.indexOf(35);
        if (index >= 0) {
            fragment = index < url_string.length() - 1 ? url_string.substring(index + 1) : null;
            url_string = url_string.substring(0, index);
        }
        if ((index = url_string.indexOf(58)) >= 1) {
            scheme = url_string.substring(0, index);
            if (alphabet_valid_scheme_chars.contains(scheme)) {
                url_string = index < url_string.length() - 1 ? url_string.substring(index + 1) : "";
            } else {
                scheme = null;
            }
        }
        boolean bl = has_file_scheme = scheme != null && scheme.toLowerCase().equals("file");
        if (url_string.startsWith("//")) {
            index = url_string.indexOf(47, 2);
            if (index >= 0) {
                netloc = index <= 2 ? null : url_string.substring(2, index);
                url_string = url_string.substring(index);
            } else {
                netloc = url_string.length() <= 2 ? null : url_string.substring(2);
                url_string = "";
            }
        }
        if ((index = url_string.indexOf(63)) >= 0) {
            query = index < url_string.length() - 1 ? url_string.substring(index + 1) : null;
            url_string = url_string.substring(0, index);
        }
        if ((index = url_string.indexOf(59)) >= 0) {
            params = index < url_string.length() - 1 ? url_string.substring(index + 1) : null;
            url_string = url_string.substring(0, index);
        }
        path = url_string;
        if (scheme == null || netloc == null && !has_file_scheme) {
            String base_path;
            if (in_base_url == null) {
                throw new MalformedURLException();
            }
            scheme = in_base_url.getProtocol();
            netloc = in_base_url.getHost();
            int base_port = in_base_url.getPort();
            if (base_port != -1) {
                netloc = String.valueOf(netloc) + ':';
                netloc = String.valueOf(netloc) + String.valueOf(base_port);
            }
            if (!path.startsWith("/") && (index = (base_path = in_base_url.getFile()).lastIndexOf(47)) >= 0) {
                path = String.valueOf(base_path.substring(0, index + 1)) + path;
            }
        }
        if (path.startsWith("/")) {
            path = path.length() > 1 ? path.substring(1) : "";
        }
        buffer.setLength(0);
        buffer.append(path);
        int path_length = buffer.length();
        while (path_length > 0 && buffer.charAt(path_length - 1) == '/') {
            buffer.setLength(--path_length);
            removed_final_slash = true;
        }
        path = buffer.toString();
        while ((index = path.indexOf("//")) >= 0) {
            path = String.valueOf(path.substring(0, index)) + path.substring(index + 1);
        }
        index = path.lastIndexOf(47);
        String file_string = index >= 0 ? path.substring(index + 1) : path;
        if (!path.endsWith("/") && (removed_final_slash || file_string.equals("..") || file_string.indexOf(46) < 0 && !accept_untyped_files)) {
            path = String.valueOf(path) + '/';
        }
        buffer.setLength(0);
        buffer.append(scheme);
        buffer.append(':');
        if (has_file_scheme) {
            buffer.append("//");
            if (netloc != null) {
                buffer.append('/');
                buffer.append(netloc);
            }
        } else if (netloc != null) {
            buffer.append("//");
            buffer.append(netloc);
        }
        if (!path.startsWith("/")) {
            buffer.append('/');
        }
        buffer.append(path);
        if (params != null) {
            buffer.append(';');
            buffer.append(params);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append('#');
            buffer.append(fragment);
        }
        return new URL(buffer.toString());
    }

    public static URL addDefaultNameToURL(URL url, String[] default_names) throws MalformedURLException {
        if (default_names == null) {
            return url;
        }
        String path_string = url.getFile();
        if (!path_string.endsWith("/")) {
            return url;
        }
        String ref_string = url.getRef();
        String query_string = null;
        int question_mark_index = path_string.indexOf(63);
        if (question_mark_index >= 0) {
            query_string = path_string.substring(question_mark_index);
            if (ref_string != null) {
                query_string = String.valueOf(query_string) + ref_string;
                ref_string = null;
            }
            path_string = question_mark_index == 0 ? "" : path_string.substring(0, question_mark_index);
        }
        InputStream in_stream = null;
        String new_path_string = null;
        int i = 0;
        while (in_stream == null && i < default_names.length) {
            new_path_string = String.valueOf(path_string) + default_names[i];
            URL new_url = new URL(url, new_path_string);
            try {
                in_stream = new_url.openStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        if (in_stream != null) {
            path_string = new_path_string;
            try {
                in_stream.close();
            }
            catch (IOException iOException) {}
        } else {
            return url;
        }
        if (ref_string != null) {
            path_string = String.valueOf(path_string) + '#' + ref_string;
        } else if (query_string != null) {
            path_string = String.valueOf(path_string) + query_string;
        }
        return new URL(url, path_string);
    }

    public static String getURLString(URL u, boolean include_host, boolean include_filename, boolean include_reference, boolean include_query_string) {
        String protocol = String.valueOf(u.getProtocol()) + ":";
        String host = u.getHost();
        int port = u.getPort();
        String complete_path = u.getFile();
        String reference = u.getRef();
        String query_string = null;
        int question_mark_index = complete_path.indexOf(63);
        StringBuffer result = new StringBuffer();
        if (question_mark_index >= 0) {
            query_string = complete_path.substring(question_mark_index);
            if (reference != null) {
                query_string = String.valueOf(query_string) + '#' + reference;
                reference = null;
            }
            String string = complete_path = question_mark_index == 0 ? "" : complete_path.substring(0, question_mark_index);
        }
        if (include_host) {
            if (protocol.toLowerCase().equals("file:")) {
                result.append(protocol);
                result.append("//");
            } else if (host != null && host.length() > 0) {
                result.append(protocol);
                result.append("//");
                result.append(host);
                if (port != -1) {
                    result.append(':');
                    result.append(String.valueOf(port));
                }
            }
        }
        if (include_filename) {
            result.append(complete_path);
        } else {
            int slash_index = complete_path.lastIndexOf(47);
            if (slash_index >= 0) {
                result.append(complete_path.substring(0, slash_index + 1));
            } else {
                result.append('/');
            }
        }
        if (include_reference && reference != null) {
            result.append('#');
            result.append(reference);
        }
        if (include_query_string && query_string != null) {
            result.append(query_string);
        }
        return result.toString();
    }

    public static String getRelativeFilePath(File file, File base) {
        int i;
        String file_parent = file.getParent();
        String base_parent = base.getParent();
        int common_part_length = 0;
        StringBuffer relative_path = new StringBuffer();
        String[] file_dirs = null;
        String[] base_dirs = null;
        if (file_parent != null) {
            file_dirs = StringUtils.tokenizeString(file_parent, File.separatorChar);
        }
        if (base_parent != null) {
            base_dirs = StringUtils.tokenizeString(base_parent, File.separatorChar);
        }
        if (file_parent != null && base_parent != null) {
            int min_dirs_length = Math.min(file_dirs.length, base_dirs.length);
            i = 0;
            while (i < min_dirs_length) {
                if (!file_dirs[i].equals(base_dirs[i])) break;
                ++common_part_length;
                ++i;
            }
        }
        if (file_dirs != null) {
            i = common_part_length;
            while (i < file_dirs.length) {
                relative_path.append(file_dirs[i]);
                relative_path.append('/');
                ++i;
            }
        }
        if (base_dirs != null) {
            i = common_part_length;
            while (i < base_dirs.length) {
                relative_path.insert(0, "../");
                ++i;
            }
        }
        relative_path.append(file.getName());
        return relative_path.toString();
    }

    public static String getFirstURLInListFile(URL in_list_url) throws PageNotFoundException, AuthorizationErr, HostNotFoundException, IOException {
        StackInputStream stream;
        String result = null;
        try {
            stream = new StackInputStream(in_list_url.openStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PageNotFoundException(in_list_url.toString());
        }
        catch (UnknownHostException unknownHostException) {
            throw new HostNotFoundException(in_list_url.toString());
        }
        do {
            if (alphabet_control_or_space.skip(stream) != -1) {
                if (stream.peek() == 59) {
                    if (alphabet_not_eol.skip(stream) != -1) continue;
                    result = "";
                    continue;
                }
                result = alphabet_not_control_or_space.span(stream);
                continue;
            }
            result = "";
        } while (result == null);
        stream.close();
        return result;
    }

    public URLConnection openURLConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        this.setConnectionRequestProperties(url, connection);
        String protocol = url.getProtocol().toLowerCase();
        if (protocol.equals("file")) {
            return connection;
        }
        String status_line = connection.getHeaderField(0);
        if (status_line == null) {
            throw new IOException("No connection request header.");
        }
        int space_pos = status_line.indexOf(32);
        if (space_pos < 0) {
            throw new IOException("Non standard connection request header.");
        }
        String return_code = status_line.substring(space_pos + 1, space_pos + 4);
        if (return_code.equals("404")) {
            throw new FileNotFoundException();
        }
        if (!return_code.equals("200")) {
            throw new IOException("Connection failed due to error code " + return_code + ".");
        }
        return connection;
    }

    static {
        file_accessor = new FileAccessor();
        try {
            alphabet_whitespace = new Alphabet(" \t\r\n");
            alphabet_keyword = new Alphabet('A', 'Z');
            alphabet_keyword.add(new Alphabet('a', 'z'));
            alphabet_keyword.add("!/#0123456789");
            alphabet_not_keyword = new Alphabet(alphabet_keyword);
            alphabet_not_keyword.invert();
            alphabet_string = new Alphabet('\"');
            alphabet_string.invert();
            alphabet_string_wo_gt = new Alphabet(alphabet_string);
            alphabet_string_wo_gt.sub('>');
            alphabet_not_tag_start = new Alphabet('<');
            alphabet_not_tag_start.invert();
            alphabet_not_tag_end = new Alphabet('>');
            alphabet_not_tag_end.invert();
            alphabet_not_tag_end_or_quotes = new Alphabet(alphabet_not_tag_end);
            alphabet_not_tag_end_or_quotes.sub('\"');
            alphabet_not_tag_end_or_whitespace = new Alphabet(alphabet_not_tag_end);
            alphabet_not_tag_end_or_whitespace.sub(alphabet_whitespace);
            alphabet_not_dash = new Alphabet('-');
            alphabet_not_dash.invert();
            alphabet_control_characters = new Alphabet('\u0000', '\u001f');
            alphabet_control_characters.add('\u007f');
            alphabet_control_or_space = new Alphabet(alphabet_control_characters);
            alphabet_control_or_space.add(' ');
            alphabet_not_control_or_space = new Alphabet(alphabet_control_or_space);
            alphabet_not_control_or_space.invert();
            alphabet_not_eol = new Alphabet("\n\r");
            alphabet_not_eol.invert();
            alphabet_separator = new Alphabet(File.separatorChar);
            alphabet_valid_scheme_chars = new Alphabet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.");
        }
        catch (AlphabetException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

