/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jfr.awt.FixedSizeList;
import jfr.awt.FixedSizePanel;
import jfr.awt.MessageDialog;
import jfr.pagesucker.Constants;
import jfr.pagesucker.Settings;
import jfr.pagesucker.SuckerFrame;
import jfr.pagesucker.SuckerFrameOwner;
import jfr.util.StringUtils;

public class AuthenticationFrame
extends SuckerFrame
implements ActionListener,
ItemListener {
    private final int LIST_ROW_COUNT = 10;
    private final int DOMAIN_TEXTFIELD_SIZE = 20;
    private final int USERNAME_TEXTFIELD_SIZE = 20;
    private final int PASSWORD_TEXTFIELD_SIZE = 20;
    FixedSizeList list_domains;
    Button button_add_domain;
    Button button_remove_domain;
    Button button_edit_domain;
    TextField textfield_dialog_domain;
    TextField textfield_dialog_username;
    TextField textfield_dialog_password;

    public AuthenticationFrame(SuckerFrameOwner in_owner) {
        super(in_owner, "Settings: Authentication");
    }

    protected void setup(Point in_frame_location, Dimension in_frame_size) {
        super.setup(in_frame_location, in_frame_size);
        this.fillDomainList();
    }

    protected void setUpFrameContents() {
        int row = 0;
        Label label = new Label("Domains Requiring a Login:");
        this.addToGridBag(label, row, 1, 17);
        this.list_domains = new FixedSizeList(10, true, 300, -1);
        this.list_domains.addItemListener(this);
        this.list_domains.addActionListener(this);
        this.addToGridBag(this.list_domains, ++row, 1, 17);
        this.button_add_domain = new Button("Add");
        this.button_add_domain.setBackground(Color.white);
        this.button_add_domain.addActionListener(this);
        this.button_edit_domain = new Button("Edit");
        this.button_edit_domain.setBackground(Color.white);
        this.button_edit_domain.setEnabled(false);
        this.button_edit_domain.addActionListener(this);
        this.button_remove_domain = new Button("Remove");
        this.button_remove_domain.setBackground(Color.white);
        this.button_remove_domain.setEnabled(false);
        this.button_remove_domain.addActionListener(this);
        FixedSizePanel panel = new FixedSizePanel(-1, -1, false, 5, 0, 0);
        panel.setLayout(new GridLayout(3, 1, 0, 2));
        panel.add(this.button_add_domain);
        panel.add(this.button_edit_domain);
        panel.add(this.button_remove_domain);
        this.addToGridBag(panel, row, 0, 10);
        ++row;
    }

    public boolean saveContentsValues() {
        return true;
    }

    public void updateFromEditingSettings() {
        this.fillDomainList();
    }

    public void fillDomainList() {
        String[] authentications = Main.sucker.editing_settings.authentications;
        int width = this.list_domains.getSize().width;
        this.list_domains.removeAll();
        if (authentications == null || authentications.length == 0) {
            return;
        }
        int i = 0;
        while (i < authentications.length) {
            String domain = Settings.getAuthenticationHost(authentications[i]);
            this.list_domains.addItem(StringUtils.compressString(domain, this.list_domains, 15));
            ++i;
        }
        this.updateDomainListButtonState();
    }

    public void addDomain() {
        String password;
        String username;
        String domain;
        Panel panel_domain_items = this.assembleDomainPanel(null, null, null);
        while (true) {
            MessageDialog dialog;
            String button_pressed;
            if ((button_pressed = (dialog = new MessageDialog((Frame)this, 0, MessageDialog.array_ok_cancel_buttons, panel_domain_items)).handle()) == null || button_pressed.equals("Cancel")) {
                return;
            }
            domain = this.textfield_dialog_domain.getText();
            username = this.textfield_dialog_username.getText();
            password = this.textfield_dialog_password.getText();
            if (domain.length() != 0 && !Constants.alphabet_whitespace.contains(domain)) break;
            new MessageDialog((Frame)this, "Invalid domain name.", 0).handle();
        }
        Main.sucker.editing_settings.addAuthentication(domain, username, password);
        this.list_domains.addItem(StringUtils.compressString(domain, this.list_domains, 15));
    }

    public void removeSelectedDomains() {
        int[] indexes = this.list_domains.getSelectedIndexes();
        if (indexes.length == 0) {
            return;
        }
        Main.sucker.editing_settings.removeAuthentications(indexes);
        int i = indexes.length - 1;
        while (i >= 0) {
            this.list_domains.remove(indexes[i]);
            --i;
        }
    }

    public void editSelectedDomain() {
        int[] indexes = this.list_domains.getSelectedIndexes();
        if (indexes.length != 1) {
            return;
        }
        String auth = Main.sucker.editing_settings.authentications[indexes[0]];
        String domain = Settings.getAuthenticationHost(auth);
        String username = Settings.getAuthenticationUsername(auth);
        String password = Settings.getAuthenticationPassword(auth);
        Panel panel_domain_items = this.assembleDomainPanel(domain, username, password);
        while (true) {
            MessageDialog dialog;
            String button_pressed;
            if ((button_pressed = (dialog = new MessageDialog((Frame)this, 0, MessageDialog.array_ok_cancel_buttons, panel_domain_items)).handle()) == null || button_pressed.equals("Cancel")) {
                return;
            }
            domain = this.textfield_dialog_domain.getText();
            username = this.textfield_dialog_username.getText();
            password = this.textfield_dialog_password.getText();
            if (domain.length() != 0 && !Constants.alphabet_whitespace.contains(domain)) break;
            new MessageDialog((Frame)this, "Invalid domain name.", 0).handle();
        }
        Main.sucker.editing_settings.authentications[indexes[0]] = auth = Settings.buildAuthenticationString(domain, String.valueOf(username) + ':' + password);
        this.list_domains.replaceItem(StringUtils.compressString(domain, this.list_domains, 15), indexes[0]);
    }

    public Panel assembleDomainPanel(String domain, String username, String password) {
        int row = 0;
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Label label = new Label("Domain:");
        this.addToGridBag(panel, label, row, 1, 17);
        this.textfield_dialog_domain = new TextField(domain == null ? "" : domain, 20);
        this.textfield_dialog_domain.setEditable(true);
        ((Component)this.textfield_dialog_domain).setBackground(Color.white);
        this.addToGridBag(panel, this.textfield_dialog_domain, row, 0, 17);
        this.addToGridBag(panel, new Label(), ++row, 1, 17);
        label = new Label("(e.g. \"www.example.com:80\")");
        this.addToGridBag(panel, label, row, 0, 17);
        label = new Label("Username:");
        this.addToGridBag(panel, label, ++row, 1, 17);
        this.textfield_dialog_username = new TextField(username == null ? "" : username, 20);
        this.textfield_dialog_username.setEditable(true);
        ((Component)this.textfield_dialog_username).setBackground(Color.white);
        this.addToGridBag(panel, this.textfield_dialog_username, row, 0, 17);
        label = new Label("Password:");
        this.addToGridBag(panel, label, ++row, 1, 17);
        this.textfield_dialog_password = new TextField(password == null ? "" : password, 20);
        this.textfield_dialog_password.setEditable(true);
        this.textfield_dialog_password.setEchoChar('*');
        ((Component)this.textfield_dialog_password).setBackground(Color.white);
        this.addToGridBag(panel, this.textfield_dialog_password, row, 0, 17);
        this.addToGridBag(panel, new Label(), ++row, 0, 17);
        ++row;
        return panel;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.list_domains) {
            int[] selected_indexes = this.list_domains.getSelectedIndexes();
            if (selected_indexes.length == 1) {
                this.editSelectedDomain();
                this.updateDomainListButtonState();
            }
        } else if (source == this.button_add_domain) {
            this.addDomain();
            this.updateDomainListButtonState();
        } else if (source == this.button_remove_domain) {
            this.removeSelectedDomains();
            this.updateDomainListButtonState();
        } else if (source == this.button_edit_domain) {
            this.editSelectedDomain();
            this.updateDomainListButtonState();
        } else {
            super.actionPerformed(evt);
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.list_domains) {
            this.updateDomainListButtonState();
        } else {
            super.itemStateChanged(evt);
        }
    }

    protected void updateDomainListButtonState() {
        int[] selected_indexes = this.list_domains.getSelectedIndexes();
        if (selected_indexes.length == 0) {
            this.button_remove_domain.setEnabled(false);
            this.button_edit_domain.setEnabled(false);
        } else if (selected_indexes.length == 1) {
            this.button_remove_domain.setEnabled(true);
            this.button_edit_domain.setEnabled(true);
        } else {
            this.button_remove_domain.setEnabled(true);
            this.button_edit_domain.setEnabled(false);
        }
    }
}

