package wdpro;

use CGI::Carp qw(fatalsToBrowser);
use strict;
use DBI;
use CGI qw/:cgi/;
my $query=new CGI;
use File::Path;

my ($dbdriver,$dbname,$dbusername,$dbpassword,$debug,$cgilocation)=($::dbdriver,$::dbname,$::dbusername,$::dbpassword,$::debug,$::cgiScriptURL);
my ($adminpass,$sqlEntry,$uploadsdir,$uploadsURL)=($::adminpass,$::sqlEntry,$::uploadsdir,$::uploadsURL);
my (%user_data,@value,%fields,%globals,%member,%lang,%layout,@allTables);
&readparse; # get name=value pairs into %user_data
&blankForm unless $user_data{_cgifunction};
&checkDrivers(); #Check that the driver exists
my $dbh=&connect($dbdriver,$dbname,$dbusername,$dbpassword); #log into the database and create handle
&loadGlobals; #Read preferences from database and load fields array. Load globals prior to login.
&login; #check passwords and set cookie and userID
&moreGlobals; #Globals that have to be set after login.
&printHeader; #print header for html output
&dumpValues if $debug;
&cgifunction; #Call the correct subroutine
$dbh->disconnect(); #Destroy the database handler
#END OF SCRIPT


sub printHeader {
  #eventually it will be necessary to return other header types.
  if ((exists($user_data{_cgifunction})) and 
      ($user_data{_cgifunction}=~/^printTables$|^Export Records$|^Download Orders$|^Backup Database$/i)) {
    print "Content-type: text/plain\n\n";
  } else {
    if ($user_data{_nocache}) {print "Expires: 0\n"};
    print "Content-type: text/html\n\n";
  }
}

sub validate {
  my ($username,$password)=@_;
  if (($username eq "admin") and ($password eq crypt($adminpass,77))) {
    return 1;
  } 
  my $statement="SELECT password FROM _members WHERE email=".$dbh->quote($username);
  my ($p)=&getSingleArray($statement);
  unless ($p) {return 0};
  if ($password eq crypt($p,77)) {return 1} else {return 0};
}

sub login {
  if ((exists($user_data{_cgifunction})) and ($user_data{_cgifunction} eq "Mail Password")) {
    &mailpass;
    exit;
  }
  unless ((grep /^_preferences$/, @allTables)and(grep /^_members$/, @allTables)) {$globals{firstTimeLogin}=1};
  my $username=&getCookie("$globals{cgilocation}_username");
  my $password=&getCookie("$globals{cgilocation}_password");
  if ((exists($user_data{username}) and (exists($user_data{password})))) {
    $username=$user_data{username};
    $password=crypt($user_data{password},77);
  }
  if (($username)and($password)) {
    if (&validate($username,$password)) {
      unless ((&getCookie("$globals{cgilocation}_username") eq $username) and
              (&getCookie("$globals{cgilocation}_password") eq $password)) {
				print qq(Set-cookie: $globals{cgilocation}_username=$username\n);
				print qq(Set-cookie: $globals{cgilocation}_password=$password\n);
      }
      $globals{userID}=$username;
      if ($globals{userID} ne "admin") {
        %member=&getHash("_members","email",$globals{userID},1);
        if ($member{groupname}=~/\S+/) {
       	  my %groupMember=&getHash("_members","email",$member{groupname},1);
		  foreach (qw(default_url searchLayout searchPage header footer profileTemplate canadd canmodify candelete canimport canexport limitto1 manageall templates)) {
          $member{$_}=$groupMember{$_};
	    }
      }
    }
    return;
    } else {
      print qq(Set-cookie: $globals{cgilocation}_username=\n);
      print qq(Set-cookie: $globals{cgilocation}_password=\n);
      print qq(Content-type: text/html\n\n
	     <SCRIPT>
	     alert('Invalid Login');
	     history.go(-1);
	     </SCRIPT>
	     <NOSCRIPT>Invalid Login</NOSCRIPT>
     );
      $globals{userID}=0;     
    }
  }
  
  
  # if username is a membername and password is correct
  # set cookie for username and password
  # and userID is the username
  # return;
  
  # if we are here it means the user is neither admin nor member
  # so we set the cookies to nothing, and userID=0
  $globals{userID}=0;
  return;
}

sub mailpass {
  print "Content-type: text/html\n\n";
  my $email=$user_data{username};
  my $statement="SELECT password FROM _members WHERE email =".$dbh->quote($email);
  my $password=(&getSingleArray($statement))[0];
  if ($password) {
    my $body=qq(
Thank you for using the $globals{cgilocation} database.
Your password is $password\.
    );
    &mail($email,$globals{admin_email_address},"Your Password for $globals{cgilocation}",$body);
    print qq(
<SCRIPT>alert('Your password has been mailed to you.');history.go(-1)</SCRIPT>
    );
    exit;
  } else {
    print qq(<SCRIPT>alert('We were unable to find a password for $user_data{username}');history.go(-1)</SCRIPT>);
    exit;
  }
}

sub cgifunction {
  $_= ($user_data{_cgifunction}) ? $user_data{_cgifunction} : "";

  if (/^admin$/i) {&admin}
  elsif (/^Manage Table Configurations$/i) {&manageTables}
  elsif (/^Modify Table$/i) {&modifyTable}
  elsif (/^Insert Field$/i) {&insertField}
  elsif (/^Delete Field$/i) {&deleteField}
  elsif (/^Redefine Field$/i) {&redefineField}
  elsif (/^Refresh Fields$/i) {&refreshFields}
  elsif (/^Relationships$/i) {&relationships}
  elsif (/^Save Table Relationships$/i) {&saveRelationships}
  elsif (/^Add New Table$/i) {&addTable}
  elsif (/^Drop Table$/i) {&dropTable}
  elsif (/^Manage Members$/i) {&manageMembers}
  elsif (/^Add Member$/i) {&memberForm}
  elsif (/^Delete Member$/i) {&deleteMember}
  elsif (/^Edit Member$/i) {&memberForm}
  elsif (/^Save Member Data$/i) {&saveMemberData}
  elsif (/^Save Instant Member Data$/i) {&saveMemberData}
  elsif (/^Manage Preferences$/i) {&managePreferences}
  elsif (/^Save Preferences$/i) {&savePreferences}
  elsif (/^Manage Layouts$/i) {&manageLayouts}
  elsif (/^Edit Selected Layout$/i) {&layoutForm}
  elsif (/^Add Layout$/i) {&layoutForm}
  elsif (/^Duplicate Layout$/i) {&layoutForm}
  elsif (/^Save Layout$/i) {&saveLayout}
  elsif (/^Delete Selected Layout$/i) {&deleteLayout}
  elsif (/^Manage Records$/i) {&manageRecords}
  elsif (/^(Go to Selected Table)|(Manage ?Data)$/i) {&manageRecords2}
  elsif (/^Submit Registration$/i) {&register}
  elsif (/^Add$/i) {&addRecord}
  elsif (/^Search\/modify$/i) {&searchModify}
  elsif (/^Modify Record$/i) {&modifyRecord}
  elsif (/^Delete All Found Records$/i) {&deleteAllFound}
  elsif (/^Delete Only Selected Records$/i) {&deleteOnlySelected}
  elsif (/^(Next Page)|(Previous Page)|(Refresh Page)$/i) {&nextPrev}
  elsif (/^Modify$/i) {&modify}
  elsif (/^user$/i) {&user}
  elsif (/^search$/i) {&search}
  elsif (/^form$/i) {&form}
  elsif (/^printTables$/i) {&printTables}
  elsif (/^Memberpage$/i) {&memberpage}
  elsif (/^Login Page$/i) {&loginPage}
  elsif (/^Import Records$/i) {&importRecords}
  elsif (/^import2$/i) {&import2}
  elsif (/^SQL Entry$/i) {&sqlEntry}
  elsif (/^Export Records$/i) {&exportRecords}
  elsif (/^Add Index$/i) {&addIndex}
  elsif (/^Drop Index$/i) {&dropIndex}
  elsif (/^Upload New Table$/i) {&uploadTable}
  elsif (/^getDoc$/i) {&getDoc}
  elsif (/^Template Field Assistant$/i) {&templateFieldAssistant}
  elsif (/^instant ?member$/i) {&memberForm}
  elsif (/^Show Member$/i) {&showMember}
  elsif (/^Upgrade From Webdata 2\.x$/i) {&upgradeFromWebdata2}
  elsif (/^Send Batch Mail$/i) {&mailBatch}
  elsif (/^Configure Shopping Cart$/i) {&configureCart}
  elsif (/^Save Cart Settings$/i) {&saveCartSettings}
  elsif (/^Add to cart$/i) {&addToCart}
  elsif (/^View Cart$/i) {&viewCart}
  elsif (/^Refresh Cart$/i) {&refreshCart}
  elsif (/^Check Out$/i) {&checkOut}
  elsif (/^checkout2$/i) {&checkOut2}
  elsif (/^Process Order$/i) {&processOrder}
  elsif (/^Empty Cart$/i) {&emptyCart}
  elsif (/^Shopping Cart$/i) {&shoppingCart}
  elsif (/^Finish Order$/i) {&finishOrder}
  elsif (/^Fill Order$/i) {&fillOrder}
  elsif (/^Unfill Order$/i) {&fillOrder}
  elsif (/^Delete Order$/i) {&deleteOrder}
  elsif (/^Download Orders$/i) {&downloadOrders}
  elsif (/^Backup Page$/i) {&backupPage}
  elsif (/^Backup Database$/i) {&backupDatabase}
  elsif (/^Restore Database$/i) {&restoreDatabase}
  elsif (/^Replace Values$/i) {&replaceValues}
  elsif (/^do nothing$/i) {}
  else {
    if (!$_) {
    } else {
    print qq(<BODY BGCOLOR=WHITE><H1>Error: Incorrect value for _cgifunction</H1>
Webdata uses the parameter: "_cgifunction" to call the correct subroutine.<P>\n\n);
      print qq(No recognized value was supplied for _cgifunction. Check that the form has an input box or );
      print qq(button named '_cgifunction', or if you used );
      print qq(a direct link, the URL should contain "_cgifunction=somevalue."\n\n);
      print qq(The value supplied for _cgifunction was "$_", which does not equate to any function call in Webdata.\n\n);
    }
  }
}

sub blankForm {
      print "Content-type: text/html\n\n";
      print <<EOF; 
<HTML><HEAD><TITLE>Database Login page</TITLE>
<SCRIPT>
function forgot(f) {
  val=f.username.value;
  atsign=val.indexOf('\@');
  dot=val.indexOf('.',atsign);
  if ((atsign==-1)||(dot==-1)) {alert('Please enter an e-mail address in the first box');return};
  f._cgifunction.value="Mail Password";
  f.submit();
}
</SCRIPT>
</HEAD>
<BODY BGCOLOR=WHITE> <FORM NAME="form1" ACTION="$cgilocation" METHOD=POST> 
<B>E-mail</B> <INPUT TYPE=TEXT
NAME="username" VALUE="admin" onFocus="this.select()"><BR> 
<B>Password</B> <INPUT TYPE=PASSWORD NAME="password"> 
<A HREF="javascript:forgot(document.form1)">Mail me my password</A><BR>
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Login Page"> 
<INPUT TYPE=SUBMIT VALUE="Enter"></FORM>
</BODY></HTML>
EOF
exit;
}

sub replaceValues {
  &adminCheck;
  my $statement="UPDATE $user_data{_tableName} SET $user_data{replaceField}=$user_data{replaceValue}";
  $statement.=" WHERE ".&unescape($user_data{where}) if $user_data{where};
  &do($statement);
  &manageRecords2;
}

sub backupPage {
  &adminCheck;
  &graphicsHeader('Manage Records');
  print <<EOF;
<h1>Back-up the entire database</h1>
<FORM NAME="form1" ACTION="$globals{cgilocation}" METHOD=POST ENCTYPE="multipart/form-data">
<B>To back-up the database</B>, click "Backup Database", and then choose SAVE-AS from the FILE menu in your browser.<BR>
Replace the default filename with your choice of name and a .txt extension.<BR><BR>


<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Backup Database">
Include "Include DROP TABLE"? <INPUT TYPE=CHECKBOX NAME="drop" VALUE="1" CHECKED> 
<INPUT TYPE=SUBMIT VALUE="Backup Database"><BR><BR><HR><BR>
<B>To restore the database</B>, use the browse button to select the file and click "Restore Database".<BR><BR>

<INPUT TYPE="file" NAME="file"><BR>
<INPUT TYPE=BUTTON VALUE="Restore Database" onClick="restoreDatabase(form)">
</FORM>
<SCRIPT>
function restoreDatabase(f) {
  message='This will execute the uploaded SQL script. If that script contains "DROP TABLE"\\n'+
  'commands, it will wipe out your entire database before rebuilding it. Are you sure\\n'+
  'that you want to do this?';
  if (confirm(message)) {
    f._cgifunction.value="Restore Database";
    f.submit();
  }
}
</SCRIPT>

EOF
  &graphicsFooter('Manage Records');
}

sub backupDatabase {
  &adminCheck;
  foreach my $table (@allTables) {
    print qq(\#\n\# Table structure for table '$table'\n\#\n\n);
    if ($user_data{drop}) {print qq(DROP TABLE IF EXISTS $table\;\n)};
    my @fieldList;
    foreach my $field (&getFields($table)) {
      my %f=&extractField($table,$field);
      $f{null}=($f{null})?"":" not null";
      $f{extra}=($f{extra})?" $f{extra}":"";
      if (($f{type}=~/text/i)or($f{extra}=~/auto/i)or($f{null}=~/not null/i)) {
	$f{default}="";
      } elsif (length($f{default})) {
	$f{default}=" default ".$dbh->quote($f{default});
      } else {
	$f{default}=" default NULL";
      }
      push(@fieldList,"$field $f{type}$f{null}$f{extra}$f{default}");
    }
    push(@fieldList,"PRIMARY KEY (".&getKey($table).")") if &getKey($table);
    my $statement="CREATE TABLE $table (\n  ".join(",\n  ",@fieldList)."\n)";
    print "$statement\;\n";
    print qq(\n\#\n\# Dumping data for table '$table'\n\#\n\n);
    $statement=qq(SELECT * FROM $table);
    my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
    $sth->execute or &sqlerror($statement,$DBI::errstr,$!);
    while (my @data=$sth->fetchrow_array) {
      foreach (@data) {$_=$dbh->quote($_)};
      $statement="INSERT INTO $table VALUES (".join(',',@data).")";
      print "$statement\;\n";
    }
    $sth->finish();
    print "\n";
  }
}

sub restoreDatabase {
  &adminCheck;
  my $file;
  my $uploadsize=0;
  unless ($user_data{file}) {
    &error("No file was selected")
  }
  while (my $bytesread=read($query->param("file"),my $buffer,1024)) {
    $uploadsize+=length($buffer);
    $file.=$buffer;
  }
  my @lines=split(/[\r\n]+/,$file);
  undef $file;
  while($lines[0]!~/^\s*\#/) {shift(@lines)};
  foreach (@lines) {$file.="$_\n" unless /^\s*\#/};
  @lines=split(/\;\n+/,$file);
  my $count=1;
  foreach (@lines) {
    $_=~s/[\r\n]+//g;
    print "$count. $_<BR>\n";
    $dbh->do($_);
  } continue {$count++}
  my $goback=($debug)?"":"history.go(-1)";
  print <<EOF;
<SCRIPT>
alert('Database Restore Complete');
$goback
</SCRIPT>
EOF
}

sub fillOrder {
  my $statement=qq(SELECT customer_ID FROM _checkout WHERE customer_ID=$user_data{orderNum});
  my @tmp=&getSingleArray($statement);
  if ($tmp[0]) {
    my $filled=($user_data{_cgifunction} eq "Fill Order")?1:"NULL";
    $statement=qq(UPDATE _checkout SET filled=$filled,date_time=date_time WHERE customer_ID=$user_data{orderNum});
    &do($statement);
  } else {
    my @result;
    foreach (&getFields("_checkout")) {
      my $val;
      if (/^customer_ID$/) {
	$val=$dbh->quote($user_data{orderNum});
      } elsif (/^filled$/) {
	$val=$dbh->quote("1");
      } else {
	$val='NULL';
      }
      push (@result,$val)
    }
    $statement="INSERT INTO _checkout VALUES (".join(',',@result).")";
    &do($statement);
  }
  &shoppingCart;
}

sub deleteOrder {
  my $statement=qq(DELETE FROM _orders WHERE cart_ID=$user_data{orderNum});
  &do($statement);
  print <<EOF;
<SCRIPT>alert('The order has been deleted')</SCRIPT>
EOF
&shoppingCart;
}

sub downloadOrders {
  my $password=crypt($adminpass,77);
  my $cartURL=&getSecureShoppingCartURL;
  unless (($ENV{HTTP_REFERER}=~/^($cartURL)|($globals{cgilocation})\??/) and ($user_data{pw} eq $password)) {
    &error("Please access the shopping cart by clicking the link on the 
            administration page at $globals{cgilocation}");
  }
  $globals{userID}="admin";
  if ($user_data{download}) {$user_data{showAll}=1};
  my $statement=qq(SELECT * FROM _orders LEFT OUTER JOIN _checkout 
		   ON _orders.cart_ID=_checkout.customer_ID 
		   ORDER BY _orders.cart_ID DESC);
  print "$statement<HR>\n" if $debug;
  my @fields=(&getFields("_checkout"),&getFields("_orders"));
  my @labels=@fields;
  foreach (@labels) {
    $_=~s/\"/\"\"/g;
    $_=qq("$_");
  }
  print (join(',',@labels)."\n");
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute or &sqlerror($statement,$DBI::errstr,$!);
  while (my $row=$sth->fetchrow_hashref) {
    my %data=%$row;
    my @result;
    foreach (@fields) {
      if (/^creditcard$/) {
	my $statement="SELECT DECODE(".$dbh->quote($data{$_}).",".$dbh->quote($adminpass).")";
	$data{$_}=(&getSingleArray($statement))[0];
      }
      $data{$_}=~s/\"/\"\"/g;
      $data{$_}=~s/[\r\n]+/<BR>/g;
      $data{$_}=qq("$data{$_}");
      push(@result,$data{$_});
    }
    print (join(',',@result)."\n");
  }
  $sth->finish();
}

sub shoppingCart {
  my $password=crypt($adminpass,77);
  my $cartURL=&getSecureShoppingCartURL;
  unless (($ENV{HTTP_REFERER}=~/^($cartURL)|($globals{cgilocation})\??/) and ($user_data{pw} eq $password)) {
    &error("Please access the shopping cart by clicking the link on the 
            administration page at $globals{cgilocation}");
  }
  $globals{userID}="admin";
  if ($user_data{download}) {$user_data{showAll}=1};
  my $where;
  unless ($user_data{showAll}) {$where="WHERE _checkout.filled IS NULL"};
  my $statement=qq(SELECT * FROM _orders LEFT OUTER JOIN _checkout 
		   ON _orders.cart_ID=_checkout.customer_ID 
		   $where
		   ORDER BY _orders.cart_ID DESC);
  print "$statement<HR>\n" if $debug;
  &graphicsHeader;
  print <<EOF;
<SCRIPT>
function fillOrder(num) {
  document.form1.orderNum.value=num;
  document.form1.submit();
}
function unfillOrder(num) {
  document.form1.orderNum.value=num;
  document.form1._cgifunction.value="Unfill Order";
  document.form1.submit();
}
function deleteOrder(num) {
  if (!confirm("Are you sure you want to delete order #"+num)) {return}
  document.form1.orderNum.value=num;
  document.form1._cgifunction.value="Delete Order";
  document.form1.submit();
}
</SCRIPT>
<FORM NAME="form1" METHOD=POST>
<!-- action left out to default to current URL -->
<INPUT TYPE=HIDDEN NAME="orderNum" VALUE="">
<INPUT TYPE=HIDDEN NAME="pw" VALUE="$user_data{pw}">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Fill Order">
</FORM>

EOF
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute or &sqlerror($statement,$DBI::errstr,$!);
  my $lastID="AA";
  print "<FORM><BLOCKQUOTE><PRE>";
  while (my $row=$sth->fetchrow_hashref) {
    my %data=%$row;
    if ($data{customer_ID} ne $lastID) {
      $statement=qq(SELECT DECODE(creditcard,"$adminpass") FROM _checkout WHERE checkout_ID="$data{checkout_ID}");
      $data{creditcard}=(&getSingleArray($statement))[0];
      my $fillStatus=($data{filled})?"Order has been filled":"<font color=red>Not Filled</font>";
      print <<EOF;
      </PRE></BLOCKQUOTE>
<B>ORDER \#$data{cart_ID}</B> ($fillStatus\)
EOF
unless ($data{filled}) {
  print qq(<BR><A HREF="javascript:fillOrder($data{cart_ID})">Mark order as filled</A>);
} else {
  print qq(<BR><A HREF="javascript:unfillOrder($data{cart_ID})">Mark order as unfilled</A>);  
} 
print qq( &nbsp;&nbsp;&nbsp;<A HREF="javaScript:deleteOrder($data{cart_ID})">Delete order</A>);

if ($data{ship_firstname}) {
  print <<EOF;
<BR><B>SHIP TO:</B>
$data{ship_firstname} $data{ship_lastname}, $data{ship_company}<BR>$data{ship_address1} $data{ship_address2}, $data{ship_city}, $data{ship_state} $data{ship_zip} $data{ship_country}<BR>TEL: $data{ship_telephone} FAX: $data{ship_fax} EMAIL: $data{ship_email}<BR>CARD\#: $data{creditcard}  exp:$data{expiration}
EOF
}
if ($data{bill_firstname}) {print <<EOF;
<B>BILL TO:</B>
$data{bill_firstname} $data{bill_lastname}, $data{bill_company}<BR> $data{bill_address1} $data{bill_address2}, $data{bill_city}, $data{bill_state} $data{bill_zip} $data{bill_country}<BR>TEL: $data{bill_telephone}<BR>
EOF
}

      print "<BLOCKQUOTE><PRE>";
      $lastID=$data{customer_ID};
      printf("%5s %15s %20s\n","QUANTITY","PRODUCT ID","PRODUCT NAME");
    }
    printf("%5s %15s %20s\n",$data{quantity},$data{product_ID},$data{product_Name});
    print "<HR>";
  }
  $sth->finish();
  print "</PRE></BLOCKQUOTE></FORM>";
  print qq(<A HREF=\"$cartURL\?_cgifunction=Shopping+Cart&pw=$user_data{pw});
  if ($user_data{showAll}) {
    print qq(\">Show Unfilled Orders Only</A>);
  } else {
    print qq(&showAll=1\">Show All Orders</A>);
  }
print qq(&nbsp;&nbsp;);
print qq(<A HREF="$cartURL\?_cgifunction=Download+Orders&pw=$user_data{pw}">);
print qq(Download Orders</A>);
  &graphicsFooter;
}

sub loadCart {
  my $layout=$_[0];
  my @cartFields = &getFields("_shoppingcart"); #load preferences
  my $statement="SELECT * FROM _shoppingcart WHERE cart_layout=".$dbh->quote($layout);
  my @cartData=&getSingleArray($statement);
  for (my $i=0;$i<=$#cartFields;$i++) {
    $globals{$cartFields[$i]}=$cartData[$i];
  }
}

sub emptyCart {
  my $statement="DELETE FROM _orders WHERE cart_ID=".$dbh->quote($globals{cartID});
  &do($statement);
  print <<EOF;
<SCRIPT>
alert('Your cart is now empty');
history.go(-1);
</SCRIPT>
EOF
}

sub getOrders {
  #IN: cartID
  #OUT: An array of tab delimited lines with the entire cart
  my $statement="SELECT * FROM _orders WHERE cart_ID=".$dbh->quote($_[0]);
  my $sth=$dbh->prepare("$statement") or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  my @result;
  while (my @data=$sth->fetchrow_array) {
    foreach(@data) {s/\t/    /g;}
    push(@result,join("\t",@data));
  }
  $sth->finish();
  return (@result);
}

sub refreshCart {
  my @lines=&getOrders($globals{cartID});
  my $count=0;
  my $statement="DELETE FROM _orders WHERE cart_ID=".$dbh->quote($globals{cartID});
  &do($statement);
  my $i;
  for ($i=0;$i<=$#lines;$i++) {
    my @data=split("\t",$lines[$i]);
    my $key="qty_$i";
    if ($user_data{$key}>0) {
      shift(@data);shift(@data);shift(@data);
      foreach (@data) {$_=$dbh->quote($_)};
      my $statement="INSERT INTO _orders VALUES(NULL,".$dbh->quote($globals{cartID}).",";
      $statement.=$dbh->quote($user_data{$key}).",".join(",",@data).")";
      &do($statement);
    }
  }
  &viewCart;
}

sub round {
  unless ($#_==1) {&::error('ERROR with round. USAGE: \&round(value,places) ex. \&round(6.544553,2)')}
  my ($val,$place)=@_;
  $val=$val*(10**$place);
  $val++ if $val-int($val)>=0.5;
  $val=int($val)/(10**$place);
  return $val;
}

sub isTaxableDestination {
	if ($globals{cart_homeState} eq $globals{state}) {return 1};
	if ($globals{cart_homeState}=~/^EU$/i) {
		my @eec=('Austria','Belgium','Denmark','Finland','France',
		'Germany','Greece','Ireland','Italy','Luxembourg','Netherlands',
		'Portugal','Spain','Sweden','United Kingdom');
		if (grep /^$user_data{cart_country}$/, @eec) {
			return 1;
		}
	}
}

sub checkOut2 {
  my $cartID=$user_data{cartID};
  &loadCart($user_data{_layout});
  print qq(<BODY BGCOLOR=WHITE>$globals{cart_header});
#CHECK FOR REQUIRED STATE AND ZIP
  my $errormsg="";
  if ($user_data{zipcode}!~/[a-zA-Z0-9]/) {
    $errormsg.="A Postal Code is required.<BR>";
  }
  $globals{state}=&getState;
  
  if (length($errormsg)) {
    print qq(The checkout script cannot continue for the following reasons:<P>);
    print qq($errormsg\n);
    print qq(<A HREF="javascript:history.back()">Return to previous page</A>);
    exit;
  }
#DISPLAY CART
  my @lines=&getOrders;

print qq(<BODY BGCOLOR=WHITE>
<CENTER><H2>CHECKOUT SCREEN</H2>
<B><I>Please confirm your order</I></B><P>
<TABLE BORDER=4 CELLPADDING=0><TR><TD>
<TABLE BORDER=0 CELLPADDING=5><TR><TD BGCOLOR=#008000 ALIGN=CENTER><FONT COLOR=WHITE FACE=ARIAL><B>ORDER CONFIRMATION</B></FONT>
</TD></TR><TR><TD ALIGN=CENTER>);
  (my ($ordertotal,$taxabletotal,$weighttotal),@lines)=&displayCart($cartID,$user_data{_layout}); #both print&displayCart($cartID);
  $globals{ordertotal}=$ordertotal;
print qq(</TD></TR></TABLE></TD></TR></TABLE>);
  $taxabletotal=$taxabletotal*($globals{cart_salesTax}/100);
  $taxabletotal=&round($taxabletotal,2);
  $taxabletotal=$taxabletotal*&isTaxableDestination;
  my $shipping=getShipping($weighttotal);
  $shipping=&round($shipping,2);
  my $grandtotal=$ordertotal+$taxabletotal+$shipping;
  my $taxLabel=($globals{cart_homeState}=~/^EU$/i)?"VAT":"Tax";
  print "<BLOCKQUOTE><PRE>\n";
  printf("%-40s%8.2f\n","<B>Order Subtotal</B>",$ordertotal);
  printf("%-40s%8.2f\n","<B>$taxLabel</B>",$taxabletotal);
  printf("%-40s%8.2f\n","<B>Shipping</B>",$shipping);
  printf("%-39s<B>$globals{cart_currency}%8.2f</B>\n","<B>GRAND TOTAL</B>",$grandtotal);
  print "</PRE></BLOCKQUOTE>\n";
  $globals{ordertotal}=$ordertotal;
  $globals{taxabletotal}=$taxabletotal;
  $globals{shipping}=$shipping;
  $globals{grandtotal}=$grandtotal;


  &payment;

 print qq(<TABLE BORDER=0 CELLSPACING=5 CELLPADDING=2>
<TD BGCOLOR="$globals{cart_color}"><A
HREF="javascript:history.back()"><FONT COLOR=WHITE
FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
&lt;--&nbsp;MAKE&nbsp;CHANGES </B></A></TD></TR></TABLE>
	);
print qq(</CENTER> $globals{cart_footer}); 
  print qq(
	   <SCRIPT>
	   function setCookie(name, value, expire) {
	     document.cookie = name + "=" + escape(value)
	       + ((expire == null) ? "" : ("; expires=" + expire.toGMTString()))
	     }
	   now=new Date();
	   expires=new Date();
	   expires.setTime(now.getTime() + 1000*60*60*24*365); //cookie expires in 1 year
		function serviceForm(f) {
		  nw=window.open('','','width=250,height=100');
		  nw.document.write('<BODY BGCOLOR=WHITE onLoad="document.form1.submit()">');
		  nw.document.write('<B>Connecting to Server. Please wait...</B>');
		  formstring='<FORM NAME="form1" ACTION="$globals{cgilocation}" METHOD=POST>'+
		  '<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Finish Order">'+
		  '<INPUT TYPE=HIDDEN NAME="_layout" VALUE="$user_data{_layout}">'+
		  '<INPUT TYPE=HIDDEN NAME="_thankyou" VALUE="No">'+
		  '<INPUT TYPE=HIDDEN NAME="ordertotal" VALUE="$ordertotal">'+
		  '<INPUT TYPE=HIDDEN NAME="taxabletotal" VALUE="$taxabletotal">'+
		  '<INPUT TYPE=HIDDEN NAME="shipping" VALUE="$shipping">'+
		  '<INPUT TYPE=HIDDEN NAME="grandtotal" VALUE="$grandtotal">'+
		  '<INPUT TYPE=HIDDEN NAME="ship_type" VALUE="$weighttotal lbs, $user_data{ship_type}">'+
		  '<INPUT TYPE=HIDDEN NAME="cartID" VALUE="$cartID">'+
		  '</FORM>';
		  nw.document.write(formstring);
		  nw.document.close();
		  nw.location='$globals{cgilocation}?_cgifunction=process+order&cartID=$cartID'
		  f.submit();
		}
	   </SCRIPT>
	  );
}

sub storage {
  my $addressinfo=&getCookie("cart_addressinfo");
  my @addr=split('\|',$addressinfo);
  my $acount=0;
  my %address;
  foreach (qw(ship_firstname ship_lastname ship_company ship_address1 ship_address2 ship_city ship_state ship_zip ship_telephone ship_fax ship_email billing_firstname billing_lastname billing_company billing_address1 billing_address2 billing_city billing_state billing_zipcode billing_country billing_telephone)) {
    $address{$_}=$addr[$acount];
    $acount++;
}

  if (($user_data{zipcode})and($user_data{zipcode} ne $address{ship_zip})) {
    %address=();
  }
  my $state=$address{ship_state} unless $globals{state};
  my $COD="";
  if ($globals{cart_cardTypes}=~/C\.O\.D\./) {
	$COD=qq(<SMALL> Check here for C.O.D.</SMALL><INPUT TYPE=CHECKBOX NAME="COD">);
  }
 print qq(<FORM NAME="cartform" METHOD="POST">
<P>$globals{cart_specialInst}
<TABLE BORDER=0>
<TR><TD COLSPAN=2>&nbsp;</TD></TR>
<TR><TD ALIGN-LEFT COLSPAN=2><B><FONT SIZE=+1><U>Shipping Information</U></FONT></B></TD></TR>
<TR><TD>First Name</TD><TD><INPUT TYPE=TEXT NAME="ship_firstname" SIZE=40 VALUE="$address{ship_firstname}"></TD></TR>
<TR><TD>Last Name</TD><TD><INPUT TYPE=TEXT NAME="ship_lastname" SIZE=40 VALUE="$address{ship_lastname}"></TD></TR>
<TR><TD>Company</TD><TD><INPUT TYPE=TEXT NAME="ship_company" SIZE=20 VALUE="$address{ship_company}"></TD></TR>
<TR><TD>Address1</TD><TD><INPUT TYPE=TEXT NAME="ship_address1" SIZE=25 VALUE="$address{ship_address1}"></TD></TR>
<TR><TD>Address2</TD><TD><INPUT TYPE=TEXT NAME="ship_address2" SIZE=25 VALUE="$address{ship_address2}"></TD></TR>
<TR><TD>City</TD><TD><INPUT TYPE=TEXT NAME= "ship_city" SIZE=20 VALUE="$address{ship_city}"></TR>
<TR><TD>State/Province</TD><TD><INPUT TYPE=TEXT NAME="ship_state" VALUE="$globals{state}"></TD></TR>
<TR><TD>Postal Code</TD><TD><INPUT TYPE=HIDDEN NAME="ship_zip" VALUE="$user_data{zipcode}">$user_data{zipcode}</TD></TR>
<TR><TD>Country</TD><TD><INPUT TYPE=HIDDEN NAME="ship_country" VALUE="$user_data{cart_country}">$user_data{cart_country}</TD></TR>
<TR><TD>Telephone</TD><TD><INPUT TYPE=TEXT NAME="ship_telephone" SIZE=20 VALUE="$address{ship_telephone}"></TD></TR>
<TR><TD>Fax</TD><TD><INPUT TYPE=TEXT NAME="ship_fax" SIZE=20 VALUE="$address{ship_fax}"></TD></TR>
<TR><TD>E-mail</TD><TD><INPUT TYPE=TEXT NAME="ship_email" SIZE=35 VALUE="$address{ship_email}"></TD></TR>
<TR><TD>Credit Card Number<BR><I>$globals{cart_cardTypes}</I>
</TD><TD><INPUT TYPE=TEXT NAME="creditcard" SIZE=16>$COD</TD></TR>
<TR><TD>Expiration Date (mmyy)</TD><TD><INPUT TYPE=TEXT NAME="expiration" SIZE=4></TD></TR>

<TR><TD COLSPAN=2>&nbsp;</TD></TR>
<TR><TD ALIGN-LEFT COLSPAN=2><B><FONT SIZE=+1><U>Billing Information</U></FONT></B> <I>If Different from above</I></TD></TR>
<TR><TD>First Name</TD><TD><INPUT TYPE=TEXT NAME="bill_firstname" SIZE=40 VALUE="$address{billing_firstname}"></TD></TR>
<TR><TD>Last Name</TD><TD><INPUT TYPE=TEXT NAME="bill_lastname" SIZE=40 VALUE="$address{billing_lastname}"></TD></TR>
<TR><TD>Company</TD><TD><INPUT TYPE=TEXT NAME="bill_company" SIZE=20 VALUE="$address{billing_company}"></TD></TR>
<TR><TD>Address1</TD><TD><INPUT TYPE=TEXT NAME="bill_address1" SIZE=25 VALUE="$address{billing_address1}"></TD></TR>
<TR><TD>Address2</TD><TD><INPUT TYPE=TEXT NAME="bill_address2" SIZE=25 VALUE="$address{billing_address2}"></TD></TR>
<TR><TD>City</TD><TD><INPUT TYPE=TEXT NAME= "bill_city" SIZE=20 VALUE="$address{billing_city}"></TR>
<TR><TD>State/Province</TD><TD><INPUT TYPE=TEXT NAME="bill_state" VALUE="$address{billing_state}"></TD></TR>
<TR><TD>Postal Code</TD><TD><INPUT TYPE=TEXT NAME="bill_zipcode" VALUE="$address{billing_zipcode}"></TD></TR>
<TR><TD>Country</TD><TD><INPUT TYPE=TEXT NAME="bill_country" VALUE="$address{billing_country}"></TD></TR>
<TR><TD>Telephone</TD><TD><INPUT TYPE=TEXT NAME="bill_telephone" SIZE=20 VALUE="$address{billing_tel}"></TD></TR>
</TABLE>

<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="process order">
<INPUT TYPE=HIDDEN NAME="_layout" VALUE="$user_data{_layout}">
<INPUT TYPE=HIDDEN NAME="ordertotal" VALUE="$globals{ordertotal}">
<INPUT TYPE=HIDDEN NAME="taxabletotal" VALUE="$globals{taxabletotal}">
<INPUT TYPE=HIDDEN NAME="shipping" VALUE="$globals{shipping}">
<INPUT TYPE=HIDDEN NAME="grandtotal" VALUE="$globals{grandtotal}">
<INPUT TYPE=HIDDEN NAME="ship_type" VALUE="$globals{weighttotal} lbs, $user_data{ship_type}">
<INPUT TYPE=HIDDEN NAME="cartID" VALUE="$user_data{cartID}">
<INPUT TYPE=SUBMIT VALUE="Complete my purchase">
</FORM>
 );
}

sub validateCard {
#Based on the Business::CreditCard module by Jon Orwant
  my ($number) = @_;
  my ($i, $sum, $weight);
  if (($globals{cart_cardTypes}=~/C\.O\.D\./)and(!length($number))) {
    return 1;
  }
  
  return 0 if $number =~ /[^\d\s]/;
  
  $number =~ s/\D//g;
  
  return 0 unless length($number) >= 13 && 0+$number;
  
  for ($i = 0; $i < length($number) - 1; $i++) {
    $weight = substr($number, -1 * ($i + 2), 1) * (2 - ($i % 2));
    $sum += (($weight < 10) ? $weight : ($weight - 9));
  }
  
  return 1 if substr($number, -1) == (10 - $sum % 10) % 10;
  return 0;
} 

sub cardtype {
#Based on the Business::CreditCard module by Jon Orwant
    my ($number) = @_;
 
    return "Not a credit card" if $number =~ /[^\d\s]/;
 
    $number =~ s/\D//g;
 
    return "Not a credit card" unless length($number) >= 13 && 0+$number;
 
    return "VISA card" if substr($number,0,1) == "4";
    return "MasterCard" if substr($number,0,1) == "5";
    return "Discover card" if substr($number,0,1) == "6";
    return "American Express card" if substr($number,0,2) == "37";
    return "Diners Club, Transmedia, or other dining/entertainment card" if substr($number,0,1) == "3";
    return "Unknown";
}                                                                                                          

sub processOrder {
  $user_data{card_type}=&cardtype($user_data{creditcard});
  $globals{cartID}=$user_data{cartID};
  my $ct=substr($user_data{card_type},0,4);
  $ct=~s/Amer/Amex/i;
  $ct=~s/Dine/Othe/i;
	print qq(
	   <SCRIPT>
	   function setCookie(name, value, expire) {
	     document.cookie = name + "=" + escape(value)
	       + ((expire == null) ? "" : ("; expires=" + expire.toGMTString()))
	     }
	   
	   now=new Date();
	   expires=new Date();
	   expires.setTime(now.getTime() + 1000*60*60*24*365); //cookie expires in 1 year
	   </SCRIPT>
	    );
if ($globals{cart_payment} eq "storage") {
  my $requiredFieldsMessage="";
  foreach (qw(ship_firstname ship_lastname ship_address1 ship_city ship_state ship_telephone ship_email creditcard expiration)) {
    if ($globals{cart_cardTypes}=~/C\.O\.D\./) {
      next if /creditcard|expiration/;
    }
    unless ($user_data{$_}) {
      $requiredFieldsMessage.="$_ is a required field<BR>\n";
    }
  }
  if (length($requiredFieldsMessage)) {
	print qq(<h2>Error: requied fields</h2>\n
	Your transaction could not be completed for the following reason(s)<P>$requiredFieldsMessage<P>
	Please click the BACK button on your browser and complete the form.);
	exit;
  }
  if (length($user_data{billing_address1})) {
	  $requiredFieldsMessage="";
	  foreach (qw(billing_address1 billing_city billing_state billing_zipcode billing_tel)) {
		unless ($user_data{$_}) {
			$requiredFieldsMessage.="$_ is a required field if shipping is not the same as billing.<BR>\n";
		}
	  }
	  if (length($requiredFieldsMessage)) {
		print qq(<h2>Error: requied fields</h2>\n
		Your transaction could not be completed for the following reason(s)<P>$requiredFieldsMessage<P>
		Please click the BACK button on your browser and complete the form.);
		exit;
	  }
  }
  if (!&validateCard($user_data{creditcard})) {&error('Invalid Credit Card Number')};
  if ($globals{cart_cardTypes}!~/$ct|C\.O\.D\./i) {
    print qq(
<SCRIPT>
alert('Invalid Card Type.\\nYou entered a card of type: $user_data{card_type}.\\nWe accept: $globals{cart_cardTypes}');
history.back();
</SCRIPT>
	);
	exit;
  }
}
  my @tmp;
  foreach (qw(ship_firstname ship_lastname ship_company ship_address1 ship_address2 ship_city ship_state ship_zip ship_telephone ship_fax ship_email billing_firstname billing_lastname billing_company billing_address1 billing_address2 billing_city billing_state billing_zipcode billing_country billing_tel)) {
    push(@tmp,$user_data{$_});
  }
  my $cart_addressinfo=join('|',@tmp);
  print qq(<SCRIPT>setCookie('cart_addressinfo','$cart_addressinfo',expires)</SCRIPT>);

  if ($globals{cart_payment} eq "storage") {
    $globals{cart_returnURL}="$globals{cgilocation}?_cgifunction=user&_layout=".&escape($user_data{_layout}) unless $globals{cart_returnURL};
    print qq(
<SCRIPT>
    var loc="$globals{cgilocation}?_cgifunction=Finish+Order&_layout="+escape("$user_data{_layout}")+
            "&cartID=$globals{cartID}";
    nw=window.open('','','width=250,height=125,resizable=1');
    nw.document.write("<B>Connecting to server...</B>");
    nw.document.close();
    nw.focus();
    nw.location=loc;
    location.replace("$globals{cart_returnURL}");
</SCRIPT>
	    );
  } else {
	  print "<SCRIPT>self.close()</SCRIPT>";
  }

##########################################
  my @fields=&getFields("_checkout");
  my @data=();
  $user_data{customer_ID}=$globals{cartID} unless (exists $user_data{customer_ID});
  my @now=localtime(time);
  $now[5]+=1900;
  $now[4]++;
  for (my $i=0;$i<=4;$i++) {
    if ($now[$i]<10) {$now[$i]="0".$now[$i]};
  }
  $user_data{date_time}="$now[5]$now[4]$now[3]$now[2]$now[1]$now[0]";
  $user_data{IP_address}=$ENV{REMOTE_ADDR};
  foreach (@fields) {
    if (/creditcard/) {
      push(@data,"ENCODE(".$dbh->quote($user_data{$_}).",".$dbh->quote($adminpass).")");
    } else {
      push(@data,$dbh->quote($user_data{$_}))
    };      
  }
  my $statement="INSERT INTO _checkout VALUES (".join(",",@data).")";
  my $num=&do($statement);
  if ($num) {
    print <<EOF;
<SCRIPT>
    var loc="$globals{cgilocation}?_cgifunction=Finish+Order&_layout="+escape("$user_data{_layout}")+
            "&cartID=$globals{cartID}";
    nw=window.open('','','width=250,height=125,resizable=1');
    nw.document.write("<B>Connecting to server...</B>");
    nw.document.close();
    nw.focus();
    nw.location=loc;
    location.replace("$globals{cart_returnURL}");
</SCRIPT>
EOF
    my $body="CART #: $globals{cartID}\n";
    $body.="DATE: ".localtime(time)."\nIP: $ENV{REMOTE_ADDR}\n\n";
    my $bodyFields='quantity,product_ID,product_Name,product_Desc,product_Price';
    my $statement="SELECT $bodyFields FROM _orders WHERE cart_ID=".$dbh->quote($globals{cartID});
    my $sth=$dbh->prepare("$statement") or &sqlerror($statement,$DBI::errstr,$!);
    $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
    $body.=qq(QTY\tPROD_ID\tPRODUCT\tDESCRIPTION\tPRICE\n);
    while (my @row=$sth->fetchrow_array) {
      $body.=join("\t",@row)."\n";
      &reduceInventory($user_data{_layout},$row[1],$row[0]);
    }

    $body.="SUBTOTAL: $user_data{ordertotal}\n";
    $body.="TAX:      $user_data{taxabletotal}\n";
    $body.="SHIPPING: $user_data{shipping}\n";
    $body.="TOTAL:   $globals{cart_currency}$user_data{grandtotal}\n";
    &mail($globals{cart_email},$globals{admin_email_address},"Shopping Cart Order: $globals{cartID}",$body);
    $body="$globals{cart_email_header}\n$body\n$globals{cart_email_footer}";
    &mail($user_data{ship_email},$globals{cart_email},"Shopping Cart Order: $globals{cartID}",$body);
  }
}

sub reduceInventory {
  my ($layout,$prodID,$qty)=@_;
  my $statement=qq(SELECT cart_prodID,cart_prodInventory FROM _shoppingcart WHERE cart_layout=).$dbh->quote($layout);
  my ($prodField,$invField)=&getSingleArray($statement);
  return if $invField =~ /-- None --/;
  my ($table,$field)=split('\.',$prodField);
  $statement=qq(UPDATE $table SET $invField=$invField - $qty WHERE $prodField=).$dbh->quote($prodID);
  &do($statement);
  $statement=qq(SELECT $invField FROM $table WHERE $prodField=).$dbh->quote($prodID);
  my $newInv=(&getSingleArray($statement))[0];
  if ($newInv<=1) {
    my $body=qq(
Warning, product ID=$prodID in the $table table has an inventory 
of $newInv after the most recent order has shipped.
);
    &mail($globals{admin_email_address},$globals{admin_email_address},"Inventory getting low",$body);
  }
}

sub finishOrder {
  print qq(<SCRIPT>document.cookie="$layout{layout_name}_cartID="</SCRIPT>);
  unless ($user_data{_thankyou} eq "No") {
    print qq(<BODY BGCOLOR=WHITE><center><h3>Your order has been received.<BR>Thank You.</h3>
	     <FORM><INPUT TYPE=BUTTON VALUE=" OK " onClick="self.close()"></FORM></CENTER></BODY>);
  } else {
    my @fields=&getFields("_checkout");
    my %vals;
    foreach (@fields) {
      $vals{$_}=$dbh->quote("");
    }
    $vals{customer_ID}=$dbh->quote($user_data{cartID});
    my @now=localtime(time);
    $now[5]+=1900;
    $now[4]++;
    for (my $i=0;$i<=4;$i++) {
      if ($now[$i]<10) {$now[$i]="0".$now[$i]};
      $vals{date_time}=$dbh->quote("$now[5]$now[4]$now[3]$now[2]$now[1]$now[0]");
    }
    $vals{IP_address}=$dbh->quote($ENV{REMOTE_ADDR});
    $vals{filled}="NULL";
    my @setlist;
    foreach (@fields) {push(@setlist,$vals{$_})};
    my $statement="INSERT INTO _checkout VALUES (".join(',',@setlist).")";
    &do($statement);
    print qq(<SCRIPT>self.close()</SCRIPT>);
  }
}


sub authorizenet {
  my $grandtotal=$globals{grandtotal};
  print qq(<FORM METHOD=POST ACTION="$globals{cart_secureURL}">
<input type="hidden" name="x_Login" value="$globals{cart_serviceID}">
<input type="hidden" name="x_Description" value="Shopping Cart Order #$globals{cartID}" SIZE=80><P>
<input type="hidden" name="x_Amount" value=");
printf ("%.2f",$grandtotal);
print qq(">
<input type="hidden" name="x_Cust_ID" value="Shopping Cart Customer">
<input type="hidden" name="x_zip" value="$user_data{zipcode}">
<input type="hidden" name="x_Version" value="3.0">
<input type="hidden" name="x_Show_Form" value="PAYMENT_FORM">
<input type="button" value="Click Here for Secure Payment Form" onClick="serviceForm(form)">
</FORM>
);
}

sub processingnet {
  print qq(
<FORM METHOD=POST ACTION="$globals{cart_secureURL}">
<INPUT TYPE=HIDDEN NAME="vendor" VALUE="$globals{cart_serviceID}">
<input type="hidden" name="price" value="$globals{grandtotal}">
<input type="hidden" name="orderid" value="$globals{cartID}">
<input type="button" value="Click Here for Secure Payment Form" onClick="serviceForm(form)">
</FORM>
);
}

sub paypal {
print qq(
<!-- Begin PayPal Logo -->
<FORM METHOD=POST ACTION="$globals{cart_secureURL}">
<INPUT TYPE="hidden" NAME="cmd" VALUE="_xclick">
<INPUT TYPE="hidden" NAME="business" VALUE="$globals{cart_serviceID}"><INPUT 
TYPE="hidden" NAME="return" VALUE="$globals{cart_returnURL}">
<INPUT TYPE="hidden" NAME="item_name" VALUE="Shopping Cart Order# $globals{cartID}"><INPUT 
TYPE="hidden" NAME="item_number" VALUE="Cart# $globals{cartID}"><INPUT 
TYPE="hidden" NAME="amount" VALUE="$globals{grandtotal}"><INPUT 
TYPE="hidden" NAME="no_intl" VALUE="1"><INPUT TYPE="image" 
SRC="http://images.paypal.com/images/x-click-but2.gif" NAME="submit" 
ALT="Make payments with PayPal - it's fast, free and secure!">
</FORM>
<!-- End PayPal Logo -->
);
}

sub worldpay {
#####################################################
######### ENTER WORLDPAY 3 LETTER CURRENCY CODE #####
my $currency="GBP";
if ($globals{cart_currency} eq "\$") {$currency="USD"};
#####################################################
#####################################################
print qq(
<form action="$globals{cart_secureURL}" method="post">              
<input type="hidden" name="store" value="$globals{cart_serviceID}">
<input type="hidden" name="cname" value="$currency">
);
my @lines=&getOrders;
my $i;
for ($i=1;$i<=$#lines+1;$i++) {
	my @data=split("\t",$lines[$i-1]);
	foreach (@data) {s/\"//g};
	if (!$data[1]) {$data[1]=$data[2]};
	$data[3]=~s/ - [\d\.]+//g;
	print qq(<input type="hidden" name="desc$i" value="$data[2]">
<input type="hidden" name="code$i" value="$data[1]">
<input type="hidden" name="cur$i" value="$currency">
<input type="hidden" name="qty$i" value="$data[0]">
<input type="hidden" name="cost$i" value="$data[4]">\n);
}
$i++;
print qq(<input type="hidden" name="desc$i" value="Tax">
<input type="hidden" name="code$i" value="Tax">
<input type="hidden" name="cur$i" value="$currency">
<input type="hidden" name="qty$i" value="1">
<input type="hidden" name="cost$i" value="$globals{taxabletotal}">\n);
$i++;
print qq(<input type="hidden" name="desc$i" value="Shipping">
<input type="hidden" name="code$i" value="Shipping">
<input type="hidden" name="cur$i" value="$currency">
<input type="hidden" name="qty$i" value="1">
<input type="hidden" name="cost$i" value="$globals{shipping}">

<input type="button" value="Click Here for Secure Payment Form" onClick="serviceForm(form)">
</form>
);
}

sub cardservice {
  print qq(
<FORM METHOD=POST ACTION="$globals{cart_secureURL}">
<INPUT TYPE=HIDDEN NAME="mode" VALUE="fullpay">
<INPUT TYPE=HIDDEN NAME="chargetotal" VALUE="$globals{grandtotal}">
<INPUT TYPE=HIDDEN NAME="storename" VALUE="$globals{cart_serviceID}">
<input type="button" value="Click Here for Secure Payment Form" onClick="serviceForm(form)">
</FORM>
);
}

sub anacom {
  print qq(
<FORM METHOD=POST ACTION="$globals{cart_secureURL}">
<input type="hidden" name="returnlink" value="$globals{cart_returnURL}">
<input type="hidden" name="fulltotal" value="$globals{grandtotal}">
<input type="hidden" name="ordernumber" value="$globals{cartID}">
<input type="hidden" name="bzip" value="$user_data{zipcode}">
<input type="button" value="Click Here for Secure Payment Form" onClick="serviceForm(form)">
</FORM>
);
}

sub signio {
  #default link: https://payflowlink.signio.com/paylinks.dll
  print qq(
<form method="POST" action="$globals{cart_secureURL}"> 
<input type="hidden" name="MFCIsapiCommand" value="Orders"> 
<input type="hidden" name="LOGIN" value="$globals{cart_serviceID}"> 
<input type="hidden" name="AMOUNT" value="$globals{grandtotal}"> 
<input type="hidden" name="TYPE" value="S"> 
<input type="submit" value="Click here to Purchase"> 
</form>
);
}



sub getShipping {
  my $weight=$_[0];
  my $zipcode=$user_data{zipcode};
  my $ship_type=$user_data{ship_type};
  my $slash;
  my $result;
  if ($uploadsdir=~/([\\\/])/) {$slash=$1};

  if ($globals{cart_shipCalc} eq "ups") { 
  unless ($weight) {return 0};
  #CALCULATE UPS RATE
  my $upsdir="${uploadsdir}${slash}ups$slash";

  open(FILE1,"<${upsdir}homezip.csv") or &::error("could not open ${upsdir}homezip.csv");
  my @homezip=<FILE1>;
  close FILE1;
  chomp(@homezip);

  my $ratefile;
  my $upscol;
  if ($ship_type eq "Next Day") {$ratefile="1da.csv";$upscol=6}
  elsif ($ship_type eq "2 Day") {$ratefile="2da.csv";$upscol=3}
  else {$ratefile="gndres.csv";$upscol=1};

  open(FILE2, "<${upsdir}$ratefile") or &::error("could not open ${upsdir}$ratefile");
  my @rates=<FILE2>;
  close FILE2;
  chomp(@rates);

  $zipcode=substr($zipcode,0,3);
  my $zone;
  foreach (@homezip) {
    next if $_!~/^\d/;
    my @data=split(',');
    my $i=$data[0];
    if (($i!~/-/)&&($zipcode eq $i)) {
      my $zone=$data[$upscol];
      if ($zone eq "-") {
	print qq(UPS $ship_type service is not available. Please click the back button and select another service.);
	exit;
      }
      last;
    }
    if ($i=~/-/) {
      my ($min,$max)=split(/-/,$i);
      if (($min<=$zipcode)&&($max>=$zipcode)) {
	$zone=$data[$upscol];
	if ($zone eq "-") {
	  print qq(UPS $ship_type service is not available. Please click the back button and select another service.);
	  exit;
      }
	last;
      }
    }
  }
  my $zonecol;
  foreach (@rates) {
    if (/^Weight/i) {
      my @titles=split(',');
      my $count=0;
      foreach (@titles) {
	my $titlenum;
	if (/(\d+)/) {$titlenum=$1};
	if ($titlenum==$zone) {$zonecol=$count};
	$count++;
      }
    }
    if (/^\d/) {
      $_=~s/ //g;
      my @data=split(',');
      next if $data[0]<$weight;
      $result=$data[$zonecol];
      last;
    }
  }
  return $result;
}

if ($globals{cart_shipCalc} eq "fedex") { 
  unless ($weight) {return 0};
  #CALCULATE FEDEX RATE
  my $fedexdir="${uploadsdir}${slash}fedex$slash";
  my %rates=();
  my $zone;
  my $nextline=0;
  my $key=0;
  open(FILE1,"<${fedexdir}homezip.txt") or &::error("could not open ${fedexdir}homezip.txt");
  while (<FILE1>) {
    chomp(my ($range,$express,$ground)=split(','));
    next unless $express;
    $range=~s/\"//g;
    my ($min,$max)=split('-',$range);
    my $longMin;
    if ($min<1000) {$min=$min*100} else {$longMin=1};
    if (!$max) {
      if ($longMin) {$max=$min} else {$max=$min+99};
    } else {
      if ($max<1000) {$max=$max*100};      
    }
    if (($zipcode>=$min)and($zipcode<=$max)) {
      if ($ship_type=~/Day/) {$zone=$express} else {$zone=$ground};
      $zone=~s/\"//g;
      last;
    }
  }
  close FILE1;
  #open correct shipping file
  my ($ratefile,$upscol);
  if ($ship_type eq "Next Day") {$ratefile="serv-po.txt";$upscol=6}
  elsif ($ship_type eq "2 Day") {$ratefile="serv-e2.txt";$upscol=3}
  else {$ratefile="serv-exp.txt";$upscol=1};
  open(FILE2, "<${fedexdir}$ratefile") or &::error("could not open ${fedexdir}$ratefile");
  my @rates=<FILE2>;
  close FILE2;
  
  #lookup region and weight
  until ($rates[0]=~/\d  +\d/) {shift(@rates)};
  my @titles=split(/ +/,$rates[0]);
  chomp(@titles);
  shift(@titles);
  my $count=0;
  my $zonecol;
  foreach (@titles) {
    my $titlenum;
    if (/([\d-]+)/) {$titlenum=$1};
    if ($titlenum==$zone) {$zonecol=$count;last};
    if ($titlenum=~/-/) {
      my ($min,$max)=split('-',$titlenum);
      if (($zone>=$min)&&($zone<=$max)) {
	$zonecol=$count;
	last;
      }
    }
    $count++;
  }
  shift(@rates);
  until ($rates[0]=~/\$\d+\.\d+  +\$\d+\.\d+/) {shift(@rates)};
  if ($weight<1) {
    my @prices=split(/ +/,$rates[0]);
    chomp(@prices);
    shift(@prices);
    return $prices[$zonecol];
  }
  shift(@rates);
  until ($rates[0]=~/\$\d+\.\d+  +\$\d+\.\d+/) {shift(@rates)};
  foreach (@rates) {
    last if /^ *$/;
    $_=~s/\$//g;
    $_=~s/lbs?\.//g;
    my @prices=split(/ +/,$_);
    shift(@prices);
    my $lineWeight;
    if ($prices[0]=~/(\d+)/) {$lineWeight=$1};
    shift(@prices);
    if ($weight >= $lineWeight) {$result=$prices[$zonecol]} else {last};
  }

  return $result;

}

if ($globals{cart_shipCalc} eq "percentage") {
  $result=($globals{cart_shipPercent}/100)*$globals{ordertotal};
  return $result;
} 

if ($globals{cart_shipCalc} eq "pricerange") { 
  my ($country,$amountcode,$allOthersAmt);
  my @prlines=split(/\n/,$globals{cart_shipPriceRange});
  chomp(@prlines);
  if ($prlines[0]=~/^[a-zA-Z]/) {
    #calculate by country
    foreach (@prlines) {
      if (/(\s+\d)/) {
	    my $tmp=$1;
  	    ($country,$amountcode)=split($tmp);
		$tmp=~s/^\s+//;
		$amountcode=$tmp.$amountcode;
		$amountcode=~s/\s+$//g;
	  }
	  if ($country eq $user_data{cart_country}) {last}
	  if ($country=~/All Others/i) {$allOthersAmt=$amountcode};
	}
	if ($country ne $user_data{cart_country}) {$amountcode=$allOthersAmt};
    if ($amountcode=~/\%$/) {
		$amountcode=~s/\/\%$//;
		if ($amountcode>0) {
			return ($globals{ordertotal}*($amountcode/100));
		} else {
			return 0;
		}
	} elsif ($amountcode=~/(lb|kg)$/i) {
		$amountcode=~s/\/(lb|kg)$//i;
		if ($amountcode>0) {
			return $weight*$amountcode;
		} else {
			return 0;
		}
	} else {
		if ($amountcode>0) {
			return $amountcode;
		} else {
			return 0;
		}
	 }
  } else {
    #calculate by price range
    foreach (@prlines) {
      my ($range,$total)=split(/\s+/);
      my ($min,$max)=split('-',$range);
      if (($globals{ordertotal}>=$min)&&($globals{ordertotal}<=$max)) {
        return $total;
      }
    }
  }
}


}

sub getState {
  my %zipState=qw(
002 NH 003 VA 005 NY 006 PR 007 PR 008 VI 009 PR 010 MA 011 MA 012 MA 
013 MA 014 MA 015 MA 016 MA 017 MA 018 MA 019 MA 020 MA 021 MA 022 MA 
023 MA 024 MA 025 MA 026 MA 027 MA 028 RI 029 RI 030 NH 031 NH 032 NH 
033 NH 034 NH 035 NH 036 NH 037 NH 038 NH 039 ME 040 ME 041 ME 042 ME 
043 ME 044 ME 045 ME 046 ME 047 ME 048 ME 049 ME 050 VT 051 VT 052 VT 
053 VT 054 VT 055 MA 056 VT 057 VT 058 VT 059 VT 060 CT 061 CT 062 CT 
063 CT 064 CT 065 CT 066 CT 067 CT 068 CT 069 CT 070 NJ 071 NJ 072 NJ 
073 NJ 074 NJ 075 NJ 076 NJ 077 NJ 078 NJ 079 NJ 080 NJ 081 NJ 082 NJ 
083 NJ 084 NJ 085 NJ 086 NJ 087 NJ 088 NJ 089 NJ 090 AE 091 AE 092 AE 
093 AE 094 AE 095 AE 096 AE 097 AE 098 AE 100 NY 101 NY 102 NY 103 NY 
104 NY 105 NY 106 NY 107 NY 108 NY 109 NY 110 NY 111 NY 112 NY 113 NY 
114 NY 115 NY 116 NY 117 NY 118 NY 119 NY 120 NY 121 NY 122 NY 123 NY 
124 NY 125 NY 126 NY 127 NY 128 NY 129 NY 130 NY 131 NY 132 NY 133 NY 
134 NY 135 NY 136 NY 137 NY 138 NY 139 NY 140 NY 141 NY 142 NY 143 NY 
144 NY 145 NY 146 NY 147 NY 148 NY 149 NY 150 PA 151 PA 152 PA 153 PA 
154 PA 155 PA 156 PA 157 PA 158 PA 159 PA 160 PA 161 PA 162 PA 163 PA 
164 PA 165 PA 166 PA 167 PA 168 PA 169 PA 170 PA 171 PA 172 PA 173 PA 
174 PA 175 PA 176 PA 177 PA 178 PA 179 PA 180 PA 181 PA 182 PA 183 PA 
184 PA 185 PA 186 PA 187 PA 188 PA 189 PA 190 PA 191 PA 192 PA 193 PA 
194 PA 195 PA 196 PA 197 DE 198 DE 199 DE 200 DC 201 VA 202 DC 203 DC 
204 DC 205 DC 206 MD 207 MD 208 MD 209 MD 210 MD 211 MD 212 MD 214 MD 
215 MD 216 MD 217 MD 218 MD 219 MD 220 VA 221 VA 222 VA 223 VA 224 VA 
225 VA 226 VA 227 VA 228 VA 229 VA 230 VA 231 VA 232 VA 233 VA 234 VA 
235 VA 236 VA 237 VA 238 VA 239 VA 240 VA 241 VA 242 VA 243 VA 244 VA 
245 VA 246 VA 247 WV 248 WV 249 WV 250 WV 251 WV 252 WV 253 WV 254 WV 
255 WV 256 WV 257 WV 258 WV 259 WV 260 WV 261 WV 262 WV 263 WV 264 WV 
265 WV 266 WV 267 WV 268 WV 270 NC 271 NC 272 NC 273 NC 274 NC 275 NC 
276 NC 277 NC 278 NC 279 NC 280 NC 281 NC 282 NC 283 NC 284 NC 285 NC 
286 NC 287 NC 288 NC 289 NC 290 SC 291 SC 292 SC 293 SC 294 SC 295 SC 
296 SC 297 SC 298 SC 299 SC 300 GA 301 GA 302 GA 303 GA 304 GA 305 GA 
306 GA 307 GA 308 GA 309 GA 310 GA 311 GA 312 GA 313 GA 314 GA 315 GA 
316 GA 317 GA 318 GA 319 GA 320 FL 321 FL 322 FL 323 FL 324 FL 325 FL 
326 FL 327 FL 328 FL 329 FL 330 FL 331 FL 332 FL 333 FL 334 FL 335 FL 
336 FL 337 FL 338 FL 339 FL 340 AA 341 FL 342 FL 344 FL 346 FL 347 FL 
349 FL 350 AL 351 AL 352 AL 354 AL 355 AL 356 AL 357 AL 358 AL 359 AL 
360 AL 361 AL 362 AL 363 AL 364 AL 365 AL 366 AL 367 AL 368 AL 369 AL 
370 TN 371 TN 372 TN 373 TN 374 TN 375 TN 376 TN 377 TN 378 TN 379 TN 
380 TN 381 TN 382 TN 383 TN 384 TN 385 TN 386 MS 387 MS 388 MS 389 MS 
390 MS 391 MS 392 MS 393 MS 394 MS 395 MS 396 MS 397 MS 399 GA 400 KY 
401 KY 402 KY 403 KY 404 KY 405 KY 406 KY 407 KY 408 KY 409 KY 410 KY 
411 KY 412 KY 413 KY 414 KY 415 KY 416 KY 417 KY 418 KY 420 KY 421 KY 
422 KY 423 KY 424 KY 425 KY 426 KY 427 KY 430 OH 431 OH 432 OH 433 OH 
434 OH 435 OH 436 OH 437 OH 438 OH 439 OH 440 OH 441 OH 442 OH 443 OH 
444 OH 445 OH 446 OH 447 OH 448 OH 449 OH 450 OH 451 OH 452 OH 453 OH 
454 OH 455 OH 456 OH 457 OH 458 OH 459 OH 460 IN 461 IN 462 IN 463 IN 
464 IN 465 IN 466 IN 467 IN 468 IN 469 IN 470 IN 471 IN 472 IN 473 IN 
474 IN 475 IN 476 IN 477 IN 478 IN 479 IN 480 MI 481 MI 482 MI 483 MI 
484 MI 485 MI 486 MI 487 MI 488 MI 489 MI 490 MI 491 MI 492 MI 493 MI 
494 MI 495 MI 496 MI 497 MI 498 MI 499 MI 500 IA 501 IA 502 IA 503 IA 
504 IA 505 IA 506 IA 507 IA 508 IA 509 IA 510 IA 511 IA 512 IA 513 IA 
514 IA 515 IA 516 IA 520 IA 521 IA 522 IA 523 IA 524 IA 525 IA 526 IA 
527 IA 528 IA 530 WI 531 WI 532 WI 534 WI 535 WI 537 WI 538 WI 539 WI 
540 WI 541 WI 542 WI 543 WI 544 WI 545 WI 546 WI 547 WI 548 WI 549 WI 
550 MN 551 MN 553 MN 554 MN 555 MN 556 MN 557 MN 558 MN 559 MN 560 MN 
561 MN 562 MN 563 MN 564 MN 565 MN 566 MN 567 MN 570 SD 571 SD 572 SD 
573 SD 574 SD 575 SD 576 SD 577 SD 580 ND 581 ND 582 ND 583 ND 584 ND 
585 ND 586 ND 587 ND 588 ND 590 MT 591 MT 592 MT 593 MT 594 MT 595 MT 
596 MT 597 MT 598 MT 599 MT 600 IL 601 IL 602 IL 603 IL 604 IL 605 IL 
606 IL 607 IL 608 IL 609 IL 610 IL 611 IL 612 IL 613 IL 614 IL 615 IL 
616 IL 617 IL 618 IL 619 IL 620 IL 622 IL 623 IL 624 IL 625 IL 626 IL 
627 IL 628 IL 629 IL 630 MO 631 MO 633 MO 634 MO 635 MO 636 MO 637 MO 
638 MO 639 MO 640 MO 641 MO 644 MO 645 MO 646 MO 647 MO 648 MO 649 MO 
650 MO 651 MO 652 MO 653 MO 654 MO 655 MO 656 MO 657 MO 658 MO 660 KS 
661 KS 662 KS 664 KS 665 KS 666 KS 667 KS 668 KS 669 KS 670 KS 671 KS 
672 KS 673 KS 674 KS 675 KS 676 KS 677 KS 678 KS 679 KS 680 NE 681 NE 
683 NE 684 NE 685 NE 686 NE 687 NE 688 NE 689 NE 690 NE 691 NE 692 NE 
693 NE 700 LA 701 LA 703 LA 704 LA 705 LA 706 LA 707 LA 708 LA 710 LA 
711 LA 712 LA 713 LA 714 LA 716 AR 717 AR 718 AR 719 AR 720 AR 721 AR 
722 AR 723 AR 724 AR 725 AR 726 AR 727 AR 728 AR 729 AR 730 OK 731 OK 
733 TX 734 OK 735 OK 736 OK 737 OK 738 OK 739 OK 740 OK 741 OK 743 OK 
744 OK 745 OK 746 OK 747 OK 748 OK 749 OK 750 TX 751 TX 752 TX 753 TX 
754 TX 755 TX 756 TX 757 TX 758 TX 759 TX 760 TX 761 TX 762 TX 763 TX 
764 TX 765 TX 766 TX 767 TX 768 TX 769 TX 770 TX 772 TX 773 TX 774 TX 
775 TX 776 TX 777 TX 778 TX 779 TX 780 TX 781 TX 782 TX 783 TX 784 TX 
785 TX 786 TX 787 TX 788 TX 789 TX 790 TX 791 TX 792 TX 793 TX 794 TX 
795 TX 796 TX 797 TX 798 TX 799 TX 800 CO 801 CO 802 CO 803 CO 804 CO 
805 CO 806 CO 807 CO 808 CO 809 CO 810 CO 811 CO 812 CO 813 CO 814 CO 
815 CO 816 CO 820 WY 821 WY 822 WY 823 WY 824 WY 825 WY 826 WY 827 WY 
828 WY 829 WY 830 WY 831 WY 832 ID 833 ID 834 ID 835 ID 836 ID 837 ID 
838 ID 840 UT 841 UT 842 UT 843 UT 844 UT 845 UT 846 UT 847 UT 850 AZ 
852 AZ 853 AZ 855 AZ 856 AZ 857 AZ 859 AZ 860 AZ 863 AZ 864 AZ 865 AZ 
870 NM 871 NM 872 NM 873 NM 874 NM 875 NM 877 NM 878 NM 879 NM 880 NM 
881 NM 882 NM 883 NM 884 NM 885 TX 889 NV 890 NV 891 NV 893 NV 894 NV 
895 NV 897 NV 898 NV 900 CA 901 CA 902 CA 903 CA 904 CA 905 CA 906 CA 
907 CA 908 CA 910 CA 911 CA 912 CA 913 CA 914 CA 915 CA 916 CA 917 CA 
918 CA 919 CA 920 CA 921 CA 922 CA 923 CA 924 CA 925 CA 926 CA 927 CA 
928 CA 930 CA 931 CA 932 CA 933 CA 934 CA 935 CA 936 CA 937 CA 938 CA 
939 CA 940 CA 941 CA 942 CA 943 CA 944 CA 945 CA 946 CA 947 CA 948 CA 
949 CA 950 CA 951 CA 952 CA 953 CA 954 CA 955 CA 956 CA 957 CA 958 CA 
959 CA 960 CA 961 CA 962 AP 963 AP 964 AP 965 AP 966 AP 967 HI 968 HI 
969 GU 970 OR 971 OR 972 OR 973 OR 974 OR 975 OR 976 OR 977 OR 978 OR 
979 OR 980 WA 981 WA 982 WA 983 WA 984 WA 985 WA 986 WA 988 WA 989 WA 
990 WA 991 WA 992 WA 993 WA 994 WA 995 AK 996 AK 997 AK 998 AK 999 AK 
  );
my %zipExceptions=qw(
83422 WY 96799 AS 96940 PW 96940 PW 96940 PW 96941 FM 96941 FM 96942 FM
96942 FM 96943 FM 96943 FM 96944 FM 96944 FM 96950 MP 96950 MP 96951 MP
96951 MP 96952 MP 96952 MP 96960 MH 96960 MH 96970 MH 96970 MH 06390 NY
);

  my $zipPrefix=substr($user_data{zipcode},0,3);
  my $state;
  if ($user_data{cart_country} eq "United States") {
    if (exists($zipExceptions{substr($user_data{zipcode},0,5)})) {
      $state=$zipExceptions{substr($user_data{zipcode},0,5)};
      if (substr($user_data{zipcode},0,5)==83422) {
	if ($user_data{zipcode}=~/ID/) {
	  $state="ID";
	} else {
	  $state="WY";
	}
	$user_data{zipcode}=substr($user_data{zipcode},0,5);
      }
    } else {
      $state=$zipState{$zipPrefix};
    }
  }

  return $state;
}

sub payment {
  &storage if $globals{cart_payment} eq "storage";
  &authorizenet if $globals{cart_payment} eq "Authorize Net";
  &processingnet if $globals{cart_payment} eq "Processing.Net";
  &cardservice if $globals{cart_payment} eq "CardService";
  &anacom if $globals{cart_payment} eq "Anacom";
  &signio if $globals{cart_payment} eq "Signio";
  &paypal if $globals{cart_payment} eq "PayPal";	
  &worldpay if $globals{cart_payment} eq "WorldPay";	
}

sub viewCart {
  &loadCart($user_data{_layout});
  print qq(
<HEAD><TITLE>View Shopping Cart Page</TITLE>
<SCRIPT>
function checkout() {
  document.cartform._cgifunction.value="Check Out";
  document.cartform.submit();
}
</SCRIPT>
<BODY BGCOLOR=WHITE>
$globals{cart_header}
The contents of your shopping cart is listed below.  You may change the quantity of items for any item by changing the number in the quanity box and clicking "REFRESH".  To remove an item from your order, change the quantity to zero (0) and click "REFRESH". 
<FORM NAME="cartform" ACTION="$globals{cgilocation}" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Refresh Cart">
<INPUT TYPE=HIDDEN NAME="_layout" VALUE="$user_data{_layout}">
<INPUT TYPE=HIDDEN NAME="query" VALUE="">
<CENTER>
<TABLE BORDER=4 CELLPADDING=0><TR><TD>
<TABLE BORDER=0 CELLPADDING=5><TR><TD BGCOLOR="$globals{cart_color}" ALIGN=CENTER><FONT COLOR=WHITE FACE=ARIAL><B>ORDER CONFIRMATION: CART\# $globals{cartID}</B></FONT>
</TD></TR><TR><TD ALIGN=CENTER>);

  my @lines=&getOrders($globals{cartID});
  my $ordertotal=0;
  
  unless ($#lines>-1) {
    print "<font color=red><B>The shopping cart is empty</B></font>"
  } else {
    print qq(
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
<TH>Quantity</TH>
<TH>Product ID</TH>
<TH>Name</TH>
<TH>Description</TH>
<TH>Price</TH>
<TH>Item Total</TH>
</TR>
	    );
    
    my $count=0;
    foreach (@lines) {
      my @data=split("\t");
      shift(@data);shift(@data);
      foreach (@data) {$_=~s/^$/\&nbsp\;/};
      my $linetotal=$data[0]*$data[4];
      $ordertotal+=$linetotal;
      $data[3]=~s/ - [\d\.]+//g;
      if ($count%2) {print qq(<TR BGCOLOR=WHITE>)} else {print qq(<TR BGCOLOR="#FFFFEF">)};
      print qq(
<TD><INPUT TYPE=TEXT NAME="qty_$count" SIZE=4 VALUE="$data[0]"></TD>
<TD ALIGN=CENTER>$data[1]</TD>
<TD ALIGN=LEFT>$data[2]</TD>
<TD ALIGN=LEFT>$data[3]</TD>);
      printf ("<TD ALIGN=RIGHT>%.2f</TD><TD ALIGN=RIGHT>%.2f</TD></TR>",$data[4],$linetotal);
      $count++; 
    }
    print qq(</TABLE>);
  } 
  print qq(</TD></TR></TABLE></TD></TR></TABLE></CENTER></FORM>);
  printf ("<CENTER>Order Total: <B>$globals{cart_currency}%.2f</B></CENTER>",$ordertotal);
  print qq(
<P><CENTER><TABLE BORDER=0 CELLSPACING=5 CELLPADDING=2>
<TR><TD BGCOLOR=$globals{cart_color}><A HREF="$globals{cgilocation}?_cgifunction=user&_layout=$user_data{_layout}"><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
&lt;--&nbsp;BACK&nbsp;TO&nbsp;SHOPPING</B></A></TD>);
  
  
  print qq(<TD BGCOLOR="$globals{cart_color}"><A HREF="javascript:document.cartform.submit()"><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
REFRESH</B></A></TD><TD BGCOLOR="$globals{cart_color}">
<A HREF="javascript:checkout()"><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
CHECK&nbsp;OUT&nbsp;--&gt;</B></TD>);
  
  print qq(</TR></TABLE></CENTER>$globals{cart_footer});
  
}

sub displayCart {
  my ($cartID,$layout)=@_;
  $cartID=$globals{cartID} if (!$cartID);
  my @lines=&getOrders($cartID);
  if ($#lines<0) {print qq(<font color=red size=+2>The Shopping Cart is Empty</font>);return};
  my ($ordertotal,$taxabletotal,$weighttotal,$linetotal);
  print qq(<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
<TH>Qty</TH>
<TH>Prod ID</TH>
<TH>Name</TH>
<TH>Description</TH>
<TH>Price</TH>
<TH>Item Total</TH></TR>
);
  my $i;
  for ($i=0;$i<=$#lines;$i++) {
    my @data=split("\t",$lines[$i]);
    shift(@data);shift(@data);
    $data[3]=~s/ - [\d\.]+//g;
    print qq(<TR>
<TD ALIGN=RIGHT><TT>$data[0]</TT></TD>
<TD><TT>$data[1]</TT></TD>
<TD><TT>$data[2]</TT></TD>
<TD><TT>$data[3]</TT></TD>
<TD ALIGN=RIGHT><TT>);
    $linetotal=$data[0]*$data[4];
    printf("%.2f</TT></TD><TD ALIGN=RIGHT><TT>%.2f",$data[4],$linetotal);
    
    $ordertotal+=$linetotal;
    $taxabletotal+=$linetotal if $data[6];
    unless ($data[5]) {$data[5]=0};
    $weighttotal+=$data[0]*$data[5];


    print qq(</TT></TD></TR>);
    
  }
  print qq(</TABLE>);
  return ($ordertotal,$taxabletotal,$weighttotal,@lines);
}

sub countryList {
my $val=$_[0];
my $result;
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Afghanistan";
$result.= ">Afghanistan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Albania";
$result.= ">Albania</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Algeria";
$result.= ">Algeria</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Andorra";
$result.= ">Andorra</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Angola";
$result.= ">Angola</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Antigua and Barbuda";
$result.= ">Antigua and Barbuda</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Argentina";
$result.= ">Argentina</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Armenia";
$result.= ">Armenia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Australia";
$result.= ">Australia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Austria";
$result.= ">Austria</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Azerbaijan";
$result.= ">Azerbaijan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Bahamas";
$result.= ">Bahamas</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Bahrain";
$result.= ">Bahrain</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Bangladesh";
$result.= ">Bangladesh</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Barbados";
$result.= ">Barbados</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Belarus";
$result.= ">Belarus</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Belgium";
$result.= ">Belgium</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Belize";
$result.= ">Belize</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Benin";
$result.= ">Benin</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Bhutan";
$result.= ">Bhutan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Bolivia";
$result.= ">Bolivia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Bosnia and Herzegovina";
$result.= ">Bosnia and Herzegovina</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Botswana";
$result.= ">Botswana</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Brazil";
$result.= ">Brazil</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Brunei";
$result.= ">Brunei</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Bulgaria";
$result.= ">Bulgaria</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Burkina Faso";
$result.= ">Burkina Faso</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Burundi";
$result.= ">Burundi</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Cambodia";
$result.= ">Cambodia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Cameroon";
$result.= ">Cameroon</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Canada";
$result.= ">Canada</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Cape Verde";
$result.= ">Cape Verde</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Central African Republic";
$result.= ">Central African Republic</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Chad";
$result.= ">Chad</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Chile";
$result.= ">Chile</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "China";
$result.= ">China</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Colombia";
$result.= ">Colombia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Comoros";
$result.= ">Comoros</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Congo";
$result.= ">Congo</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Congo, Democratic Republic of";
$result.= ">Congo</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Costa Rica";
$result.= ">Costa Rica</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Croatia";
$result.= ">Croatia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Cuba";
$result.= ">Cuba</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Cyprus";
$result.= ">Cyprus</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Czech Republic";
$result.= ">Czech Republic</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Cte d'Ivoire";
$result.= ">Cte d'Ivoire</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Denmark";
$result.= ">Denmark</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Djibouti";
$result.= ">Djibouti</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Dominica";
$result.= ">Dominica</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Dominican Republic";
$result.= ">Dominican Republic</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Ecuador";
$result.= ">Ecuador</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Egypt";
$result.= ">Egypt</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "El Salvador";
$result.= ">El Salvador</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Equatorial Guinea";
$result.= ">Equatorial Guinea</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Eritrea";
$result.= ">Eritrea</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Estonia";
$result.= ">Estonia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Ethiopia";
$result.= ">Ethiopia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Fiji";
$result.= ">Fiji</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Finland";
$result.= ">Finland</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "France";
$result.= ">France</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Gabon";
$result.= ">Gabon</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Gambia";
$result.= ">Gambia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Georgia";
$result.= ">Georgia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Germany";
$result.= ">Germany</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Ghana";
$result.= ">Ghana</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Greece";
$result.= ">Greece</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Grenada";
$result.= ">Grenada</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Guatemala";
$result.= ">Guatemala</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Guinea";
$result.= ">Guinea</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Guinea-Bissau";
$result.= ">Guinea-Bissau</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Guyana";
$result.= ">Guyana</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Haiti";
$result.= ">Haiti</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Honduras";
$result.= ">Honduras</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Hungary";
$result.= ">Hungary</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Iceland";
$result.= ">Iceland</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "India";
$result.= ">India</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Indonesia";
$result.= ">Indonesia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Iran";
$result.= ">Iran</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Iraq";
$result.= ">Iraq</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Ireland";
$result.= ">Ireland</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Israel";
$result.= ">Israel</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Italy";
$result.= ">Italy</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Jamaica";
$result.= ">Jamaica</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Japan";
$result.= ">Japan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Jordan";
$result.= ">Jordan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Kazakhstan";
$result.= ">Kazakhstan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Kenya";
$result.= ">Kenya</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Kiribati";
$result.= ">Kiribati</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Korea, North";
$result.= ">Korea, North</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Korea, South";
$result.= ">Korea, South</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Kuwait";
$result.= ">Kuwait</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Kyrgyzstan";
$result.= ">Kyrgyzstan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Laos";
$result.= ">Laos</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Latvia";
$result.= ">Latvia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Lebanon";
$result.= ">Lebanon</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Lesotho";
$result.= ">Lesotho</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Liberia";
$result.= ">Liberia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Libya";
$result.= ">Libya</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Liechtenstein";
$result.= ">Liechtenstein</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Lithuania";
$result.= ">Lithuania</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Luxembourg";
$result.= ">Luxembourg</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Macedonia, Former Yugoslav Republic";
$result.= ">Macedonia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "of";
$result.= ">of</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Madagascar";
$result.= ">Madagascar</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Malawi";
$result.= ">Malawi</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Malaysia";
$result.= ">Malaysia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Maldives";
$result.= ">Maldives</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Mali";
$result.= ">Mali</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Malta";
$result.= ">Malta</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Marshall Islands";
$result.= ">Marshall Islands</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Mauritania";
$result.= ">Mauritania</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Mauritius";
$result.= ">Mauritius</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Mexico";
$result.= ">Mexico</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Micronesia, Federated States of";
$result.= ">Micronesia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Moldova";
$result.= ">Moldova</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Monaco";
$result.= ">Monaco</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Mongolia";
$result.= ">Mongolia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Morocco";
$result.= ">Morocco</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Mozambique";
$result.= ">Mozambique</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Myanmar";
$result.= ">Myanmar</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Namibia";
$result.= ">Namibia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Nauru";
$result.= ">Nauru</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Nepal";
$result.= ">Nepal</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Netherlands";
$result.= ">Netherlands</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "New Zealand";
$result.= ">New Zealand</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Nicaragua";
$result.= ">Nicaragua</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Niger";
$result.= ">Niger</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Nigeria";
$result.= ">Nigeria</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Norway";
$result.= ">Norway</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Oman";
$result.= ">Oman</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Pakistan";
$result.= ">Pakistan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Palau";
$result.= ">Palau</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Panama";
$result.= ">Panama</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Papua New Guinea";
$result.= ">Papua New Guinea</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Paraguay";
$result.= ">Paraguay</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Peru";
$result.= ">Peru</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Philippines";
$result.= ">Philippines</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Poland";
$result.= ">Poland</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Portugal";
$result.= ">Portugal</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Qatar";
$result.= ">Qatar</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Romania";
$result.= ">Romania</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Russia";
$result.= ">Russia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Rwanda";
$result.= ">Rwanda</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Saint Kitts and Nevis";
$result.= ">Saint Kitts and Nevis</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Saint Lucia";
$result.= ">Saint Lucia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Saint Vincent and The Grenadines";
$result.= ">Saint Vincent/Grenadines</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Samoa";
$result.= ">Samoa</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "San Marino";
$result.= ">San Marino</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Sao Tome and Principe";
$result.= ">Sao Tome and Principe</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Saudi Arabia";
$result.= ">Saudi Arabia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Senegal";
$result.= ">Senegal</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Seychelles";
$result.= ">Seychelles</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Sierra Leone";
$result.= ">Sierra Leone</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Singapore";
$result.= ">Singapore</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Slovakia";
$result.= ">Slovakia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Slovenia";
$result.= ">Slovenia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Solomon Islands";
$result.= ">Solomon Islands</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Somalia";
$result.= ">Somalia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "South Africa";
$result.= ">South Africa</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Spain";
$result.= ">Spain</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Sri Lanka";
$result.= ">Sri Lanka</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Sudan";
$result.= ">Sudan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Suriname";
$result.= ">Suriname</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Swaziland";
$result.= ">Swaziland</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Sweden";
$result.= ">Sweden</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Switzerland";
$result.= ">Switzerland</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Syria";
$result.= ">Syria</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Taiwan";
$result.= ">Taiwan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Tajikistan";
$result.= ">Tajikistan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Tanzania";
$result.= ">Tanzania</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Thailand";
$result.= ">Thailand</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Togo";
$result.= ">Togo</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Tonga";
$result.= ">Tonga</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Trinidad and Tobago";
$result.= ">Trinidad and Tobago</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Tunisia";
$result.= ">Tunisia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Turkey";
$result.= ">Turkey</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Turkmenistan";
$result.= ">Turkmenistan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Tuvalu";
$result.= ">Tuvalu</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Uganda";
$result.= ">Uganda</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Ukraine";
$result.= ">Ukraine</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "United Arab Emirates";
$result.= ">United Arab Emirates</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "United Kingdom";
$result.= ">United Kingdom</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "United States";
$result.= ">United States</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Uruguay";
$result.= ">Uruguay</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Uzbekistan";
$result.= ">Uzbekistan</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Vanuatu";
$result.= ">Vanuatu</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Vatican City";
$result.= ">Vatican City</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Venezuela";
$result.= ">Venezuela</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Vietnam";
$result.= ">Vietnam</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Western Sahara";
$result.= ">Western Sahara</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Yemen";
$result.= ">Yemen</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Yugoslavia";
$result.= ">Yugoslavia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Zambia";
$result.= ">Zambia</OPTION>\n";
$result.= "<OPTION";
$result.= " SELECTED" if $val eq "Zimbabwe";
$result.= ">Zimbabwe</OPTION>\n";
return $result;
}

sub checkOut {
  &loadCart($user_data{_layout});
  my $cart_zip=&getCookie('cart_zipcode');
  my $cart_country=&getCookie('cart_country');
  unless ($cart_country) {$cart_country="United States"};
  print qq(
<BODY BGCOLOR=WHITE>
$globals{cart_header}
<CENTER><H2>CHECKOUT SCREEN</H2>
<B><I>Please confirm your order</I></B><P>
<TABLE BORDER=4 CELLPADDING=0><TR><TD>
<TABLE BORDER=0 CELLPADDING=5 WIDTH=100\%><TR><TD BGCOLOR="$globals{cart_color}" ALIGN=CENTER><FONT COLOR=WHITE FACE=ARIAL><B>ORDER CONFIRMATION CART \#$globals{cartID}</B></FONT>
</TD></TR><TR><TD ALIGN=CENTER>);
my ($ordertotal,$taxabletotal,$weighttotal,@lines)=&displayCart($globals{cartID},$user_data{_layout}); #both print the cart and return $ordertotal,@lines
print qq(</TD></TR></TABLE>);

if ($#lines>=0) {
	print qq(
<!--<hr NOSHADE HEIGHT=4>-->

<TABLE BORDER=1 CELLPADDING=5 WIDTH=100% BGCOLOR="#FFFFEF">
<TR><TD>
<FORM NAME="cartform" ACTION=\");
	if ($globals{cart_payment} eq "storage") {
	  unless ($globals{cart_secureURL}) {$globals{cart_secureURL}=$globals{cgilocation}};
	  print "$globals{cart_secureURL}"; 
	} else {
	  print "$globals{cgilocation}"
	}

	print qq(\" METHOD=POST>);

	print qq(<B>Ship To: </B><BR>);
	print qq(Country <SELECT NAME="cart_country">\n);
	$cart_country=$globals{cart_homeCountry};# unless $cart_country;
	print (&countryList($cart_country));
	print qq(</SELECT>\n);
	print qq(Postal Code:&nbsp;<INPUT TYPE=TEXT NAME="zipcode" VALUE="$cart_zip" SIZE=11 > );
	if ($globals{cart_shipCalc}=~/^ups|fedex$/) {
	  my $label=uc($globals{cart_shipCalc});
	  print qq(<B>$label</B>&nbsp;<SELECT NAME="ship_type"><OPTION>Next Day</OPTION><OPTION>2 Day</OPTION><OPTION>Ground</OPTION></SELECT>\n);
	}

	print qq(<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="checkout2">);
	print qq(<INPUT TYPE=HIDDEN NAME="_layout" VALUE="$user_data{_layout}">);
	print qq(<INPUT TYPE=HIDDEN NAME="cartID" VALUE="$globals{cartID}">);
	print qq(<INPUT TYPE=HIDDEN NAME="query" VALUE="$user_data{query}"></FORM>);
	print qq(</TD></TR></TABLE></TD></TR></TABLE>);
} #end of "if #$lines>=0" to display only if cart is not empty.

print qq(</TD></TR></TABLE></TD></TR></TABLE>);
print qq(
<SCRIPT>
function checkzip(f) {
  if (f.cart_country.options[f.cart_country.selectedIndex].text=="United States") {
    zip=f.zipcode.value;
    zip=parseInt(zip.substring(0,5));
    if (isNaN(zip)) {
      alert("Zip Code must be numbers only.");
      return;
    }
    if (zip.length<5) {
      alert("Zip Code must be 5 digits");
      return;
    }
    if (zip==83422) {
      state=prompt("83422 services both Wyoming and Idaho.\\nPlease enter the 2 letter code for your state","ID");
      if (!state) {return};
      f.zipcode.value=""+zip+":"+state;
    }
  }
  document.cartform.submit();
}
</SCRIPT>
	);

printf("<P>Order Total <B>$globals{cart_currency}%.2f</B><P>\n",$ordertotal);

print qq(<TABLE BORDER=0 CELLSPACING=5 CELLPADDING=2>
<TD BGCOLOR="$globals{cart_color}"><A
HREF="javascript:history.go(-1)"><FONT
COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
&lt;--&nbsp;BACK TO SHOPPING</B></A></TD>
);

if ($#lines>=0) {
my $escapeLayout=&escape($user_data{_layout});
print qq(
<TD BGCOLOR="$globals{cart_color}"><A HREF="$globals{cgilocation}?_cgifunction=View+Cart&_layout=$escapeLayout"><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
MAKE&nbsp;CHANGES </B></A></TD>
<TD BGCOLOR="$globals{cart_color}">
<A HREF="javascript:checkzip(document.cartform)"><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
PROCEED&nbsp;WITH&nbsp;CHECK&nbsp;OUT&nbsp;--&gt;</B></TD>);
}

print qq(</TR>);
print qq(</TD></TR></TABLE>);
print qq(</CENTER>$globals{cart_footer});

}

sub addToCart {
  &loadCart($user_data{_layout});
  my $qty=$user_data{qty};
  my %data;
  my @tmp=split('\|',$user_data{cartData});
  while ($#tmp<5) {push(@tmp,"")};
  my @order;
  foreach (@tmp) {push(@order,$dbh->quote(&unescape($_)));$_=&unescape($_)};
  unless ($globals{cartID}) {$globals{cartID}=&getCartID};
  my $statement="INSERT INTO _orders VALUES (".join(',',$dbh->quote(""),$globals{cartID},$qty,@order).")";
  &do($statement);
  my $layout=&escape($user_data{_layout});
  print <<EOF
<SCRIPT>
function viewCart() {
  self.opener.location="$globals{cgilocation}?_cgifunction=View+Cart&_layout=$layout";
  self.close();
}
function checkOut() {
  self.opener.location="$globals{cgilocation}?_cgifunction=Check+Out&_layout=$layout";
  self.close();
}
</SCRIPT>
<BODY BGCOLOR=WHITE onLoad="setTimeout('self.close()',15000)"><CENTER>
<font size=3><B>($qty) $tmp[1] added to cart.</font>
<TABLE BORDER=0 CELLSPACING=5 CELLPADDING=2>
<TR><TD BGCOLOR="$globals{cart_color}"><A 
HREF="javascript:viewCart()"><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
VIEW&nbsp;CART</B></A></TD><TD BGCOLOR="$globals{cart_color}">
<A HREF="javascript:checkOut()"><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
CHECK&nbsp;OUT</B></TD></TR></TABLE><A HREF="javascript:self.close()">Close this window</A></CENTER></BODY>
EOF
}

sub getCartID {
  my $val=$globals{cart_count};
  $val= ($val)? $val+1 : 1;
  my $statement="UPDATE _preferences SET cart_count=$val";
  &do($statement);
  &loadGlobals;
  print <<EOF;
<SCRIPT>
var exp=new Date();
var plusOneDay=exp.getTime()+(24*60*60*1000);
exp.setTime(plusOneDay);
document.cookie="$layout{layout_name}_cartID=$val; expires="+exp.toGMTString();
</SCRIPT>
EOF
  return $val;
}

sub configureCart {
  &adminCheck;
  &loadCart($user_data{_layout});
print qq(
<HEAD><TITLE>Shopping Cart Setup Page</TITLE></HEAD>);
&graphicsHeader('Manage Layouts');
print qq(
<h2 align=center>Shopping cart settings for $user_data{_layout} layout</h2>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="cart_layout" VALUE="$user_data{_layout}">
<INPUT TYPE=HIDDEN NAME="_layout" VALUE="$user_data{_layout}">
<B>Use this image instead of the "Add to Cart" button</B><BR>
<I>Enter a relative path or URL to an image file</I> 
<INPUT TYPE=TEXT SIZE=60  NAME="cart_image" VALUE="$globals{cart_image}">
<BR>
<B>Send e-mail to this address upon checkout</B>
<INPUT TYPE=TEXT SIZE=40 NAME="cart_email" VALUE="$globals{cart_email}">
<BR>
<BR><B>Which field contains the product ID?</B> );
&listfields("cart_prodID","optional");
print qq(
<BR><B>Which field contains the product name?</B> );
&listfields("cart_prodName");
print qq(
<BR><B>Which field contains the product description?</B> );
&listfields("cart_prodDesc","optional");
print qq(
<BR><B>Which field contains the product price?</B> );
&listfields("cart_prodPrice");
print qq(
<BR><B>Which field contains the product weight?</B> );
&listfields("cart_prodWeight","optional");
print qq(
<BR><B>Which field contains the "Taxable" checkbox?</B> );
&listfields("cart_prodTaxable","optional","--All Products Are Taxable--");
print qq(
<BR><B>Which field contains the "Inventory Count" for each product?</B> );
&listfields("cart_prodInventory","optional");
print qq(
<P><HR><P>
<h3>CHECKOUT</h3>
<B>Border Color:</B> <I>All of the Shopping Cart buttons and titles will use this color.<BR>
Enter any standard color or \#hex-code</I>
<INPUT TYPE=TEXT SIZE=10 NAME="cart_color" VALUE="$globals{cart_color}"><P>

<B>Currency Symbol?</B>
<INPUT TYPE=TEXT SIZE=2 NAME="cart_currency" VALUE="$globals{cart_currency}"><P>

<B>Which payment system would you like to use? </B>
<SELECT NAME="cart_payment">
<OPTION VALUE="storage");
print " SELECTED" if $globals{cart_payment} eq "storage";
print qq(>Save data on this server for retrieval</OPTION>
<OPTION);
print " SELECTED" if $globals{cart_payment} eq "Authorize Net";
print qq(>Authorize Net</OPTION>
<OPTION);
print " SELECTED" if $globals{cart_payment} eq "Processing.Net";
print qq(>Processing.Net</OPTION>
<OPTION);
print " SELECTED" if $globals{cart_payment} eq "CardService";
print qq(>CardService</OPTION>
<OPTION);
print " SELECTED" if $globals{cart_payment} eq "Anacom";
print qq(>Anacom</OPTION>
<OPTION);
print " SELECTED" if $globals{cart_payment} eq "Signio";
print qq(>Signio</OPTION>
<OPTION);
print " SELECTED" if $globals{cart_payment} eq "PayPal";
print qq(>PayPal</OPTION>
<OPTION);
print " SELECTED" if $globals{cart_payment} eq "WorldPay";
print qq(>WorldPay</OPTION>
</SELECT>
<BR>
<B>If you chose a payment service, what is your user id?</B> 
<INPUT TYPE=TEXT NAME="cart_serviceID" value="$globals{cart_serviceID}"><BR>
<B>Payment Form URL:</B><BR>
If you chose "Save data on this server",</B> enter the <I>SECURE</I> URL to the $globals{cgilocation} script.
<BR> --- <i>or</i> ---<BR>
If you chose to use a card processing service enter the URL to submit the final form to the service.<BR>

<INPUT TYPE=TEXT NAME="cart_secureURL" SIZE=60 value="$globals{cart_secureURL}"><BR>

<b>Return Link:</B> <I>Some processors use a return link to send the customer <b>back</b> to a particular page on your site
after the transaction is complete.  If you use one of these services, type in the full path to the
return page below. The "Save data on this server" option will return this page when the transaction is complete..</I><br>
<INPUT TYPE=TEXT NAME="cart_returnURL" SIZE=60 value="$globals{cart_returnURL}"><BR>
<table border=0><tr><td valign=center>
<B>Which Credit Cards do you accept?</B><BR>
<I>Control-Click on all that apply</I></td><td>
<SELECT NAME="cart_cardTypes" SIZE=6 MULTIPLE>
<OPTION);
  print " SELECTED" if $globals{cart_cardTypes}=~/Visa/;
print qq(>Visa</OPTION>
<OPTION);
  print " SELECTED" if $globals{cart_cardTypes}=~/MasterCard/;
print qq(>MasterCard</OPTION>
<OPTION VALUE="Amex");
  print " SELECTED" if $globals{cart_cardTypes}=~/Amex/;
print qq(>American Express</OPTION>
<OPTION);
  print " SELECTED" if $globals{cart_cardTypes}=~/Discover/;
print qq(>Discover</OPTION>
<OPTION VALUE="Other Cards");
  print " SELECTED" if $globals{cart_cardTypes}=~/Other Cards/;
print qq(>Diners Club or Other Dining\/Entertainment Cards</OPTION>
<OPTION VALUE="C.O.D.");
  print " SELECTED" if $globals{cart_cardTypes}=~/C\.O\.D\./;
print qq(>C.O.D. - No card number required</OPTION>
</SELECT></td></tr></table>

<P><HR><P>
<H3>SHIPPING OPTIONS</H3>
<I>Please select only one option</I>
<P>
<INPUT TYPE=RADIO NAME="cart_shipCalc" VALUE="ups");
  print qq( CHECKED) if $globals{cart_shipCalc} eq "ups";
print qq(> <B>1. Calculate UPS shipping costs by weight?</B>
<BR>
	 To use this feature, create a folder in the <TT>$uploadsdir</TT> directory named <TT>"ups"</TT>.<BR>
Then <A HREF="http://ups.com/using/software/currentrates/rate-csv/usrates.zip">click here</A> and unzip the
usrates.zip file into the <TT>"ups"</TT> directory.<BR>
Finally, <A HREF="http://ups.com/using/software/currentrates/rates_in_us.html#zones" TARGET="new">click here</A>, enter your zip code, click 'download', and save the file as <B><TT>'homezip.csv'</TT></B> in the "ups" directory.

<P>
<INPUT TYPE=RADIO NAME="cart_shipCalc" VALUE="fedex");
  print qq( CHECKED) if $globals{cart_shipCalc} eq "fedex";
print qq(> <B>2. Calculate FedEx shipping costs by weight?</B>
<BR>
To use this feature, create a folder in the <TT>$uploadsdir</TT> directory named <TT>"fedex"</TT>.<BR>
Then <A HREF="http://fedex.com/us/rates/downloads/rateserv.zip">Click Here</A> and unzip the rateserv.zip
file into the <TT>"fedex"</TT> directory.<BR>
Next, <A HREF="http://rate.dmz.fedex.com/us/rates/zonelocator/" TARGET="new">Click here</A>, enter your zip code, then click "download ascii format".  Save the file to your hard disk as "homezip.txt".  <BR>
Upload "homezip.txt" in ASCII mode to the "fedex" directory.

<P>
<INPUT TYPE=RADIO NAME="cart_shipCalc" VALUE="percentage");
  print qq( CHECKED) if $globals{cart_shipCalc} eq "percentage";
print qq(> <B>3. If shipping cost is a percentage of the total sale:</B>
Enter the percentage here, for example: 4.25 
<INPUT TYPE=TEXT  SIZE=5 NAME="cart_shipPercent" VALUE="$globals{cart_shipPercent}">
<P>
<INPUT TYPE=RADIO NAME="cart_shipCalc" VALUE="pricerange");
  print qq( CHECKED) if $globals{cart_shipCalc} eq "pricerange";
  my $returnLink="$globals{cgilocation}?_cgifunction=Edit+Selected+Layout&layout=".&escape($user_data{_layout});
  $globals{cart_homeCountry}="United States" unless $globals{cart_homeCountry};
  my $countryList=&countryList($globals{cart_homeCountry});
print qq(> <B>4. If shipping cost depends on the price range of the total sale:</B>
Enter in the box below the range <TT>low-high</TT> followed by 1 or more spaces, and the shipping cost using numbers only.<BR>
For example: <PRE>
0-4.99   1.50
5-9.99   2.25
10-19.99 4.00</PRE>

<B>OR if the shipping cost varies by Country:</B>
Enter each Country name, exactly as it appears in the "Default Country" list below, followed by one or more
spaces, followed by either a fixed shipping price (\#.\#\#), a price by weight (\#.\#\#/lb) or (\#.\#\#/kg) or a percentage
of the sale amount (\#.\#\#\%). Type "All Others" to indicate all other countries. Examples: <PRE>
United Kingdom    1.25/lb
France            2.25/kg
United States     3.5\%
Germany           6.50
Switzerland       6.50
All Others        5.0%</PRE>

	 <TEXTAREA NAME="cart_shipPriceRange" ROWS=8 COLS=25>$globals{cart_shipPriceRange}</TEXTAREA>
<P><HR><P>

<H3>TAXATION</H3>
<B>Default Country</B> 
<SELECT NAME="cart_homeCountry">$countryList</SELECT><BR>
<TABLE BORDER=0><TR><TD VALIGN=MIDDLE>
<B>U.S.A.- Enter the 2 letter code for the State you are shipping from:<BR>
Europe - Enter <font color="red">EU</font> in this box to charge tax to all EEC countries</B>
</TD><TD VALIGN=MIDDLE>
<INPUT TYPE=TEXT SIZE=2 NAME="cart_homeState" VALUE="$globals{cart_homeState}"></TD></TR></TABLE>
<P>
<B>Enter your local tax rate as a percentage.</B>  For example: 5.25 
<INPUT TYPE=TEXT SIZE=5 NAME="cart_salesTax" VALUE="$globals{cart_salesTax}">

<P><HR><P>

<H3>HEADER AND FOOTER</H3>
<B>Header</B> 
<I>This will go at the TOP of all shopping cart pages.</I><BR>
<TEXTAREA ROWS=6 COLS=80 NAME="cart_header">$globals{cart_header}</TEXTAREA><P>

<B>Footer</B>
<I>This will go at the BOTTOM of all shopping cart pages.</I><BR>
<TEXTAREA ROWS=3 COLS=80 NAME="cart_footer">$globals{cart_footer}</TEXTAREA><P>

<B>Special Instructions</B>
<I>If you chose "Save data on this server", this text will go at the top
of the Payment Form.</I><BR>
<TEXTAREA ROWS=3 COLS=80 NAME="cart_specialInst">$globals{cart_specialInst}</TEXTAREA><P>

<B>E-mail Header</B>
<I>This will go at the top of the customer\'s confirmation e-mail.</I><BR>
<TEXTAREA ROWS=3 COLS=80 NAME="cart_email_header">$globals{cart_email_header}</TEXTAREA><P>

<B>E-Mail Footer</B>
<I>This will go at the bottom of the customer\'s confirmation e-mail.</I><BR>
<TEXTAREA ROWS=3 COLS=80 NAME="cart_email_footer">$globals{cart_email_footer}</TEXTAREA><P>

<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Save Cart Settings">
</FORM>
<A HREF="$returnLink">Return to Layout Page</A><BR>
$globals{adminLink}
);
&graphicsFooter('Manage Layouts');
}

sub listfields {
  #IN: fieldname, optional, inserted value
  my $sel=eval("\$globals{$_[0]}");
  $sel=~s/[^a-zA-Z0-9\.\-\_]//g;
  print qq(<SELECT NAME="$_[0]">);
  if ($_[1] eq "optional") {print "<OPTION>-- None --</OPTION>\n"};
  if ($_[2]) {
    print "<OPTION";
    print " SELECTED" if $globals{$_[0]} eq $_[2];
    print ">$_[2]</OPTION>\n"}
  foreach(&getAllTableFields) {
    my $formatTest=$_;
    $formatTest=~s/[^a-zA-Z0-9\.\-\_]//g;
    print "<OPTION";
    print " SELECTED" if ($formatTest=~/^$sel$/);
    print ">$_</OPTION>\n";
  }
  print qq(</SELECT>);
} 


sub upgradeFromWebdata2 {
  &adminCheck;
  my ($logdir,$datalog,$fieldslog,$memberlog,$reportlog);
  my $file=$user_data{_tableName};
  if ($file=~/^\!/) {
    $file=~s/^\!//;
    $datalog=$file."_data.log";
    $fieldslog=$file."_fields.log";
    $memberlog=$file."_members.log";
    $reportlog=$file."_report.log";
  } else {
    $file=~s/^ *| *$//g;
    unless (-e $file) {&error("Could not find $file")};
    open (FILE,"<$file") or &error("Could not open $file");
    my $count=0;
    while (<FILE>) {
      last if $count>40;
      if (/^\s*(my)?\s*\$logdir\s*\=\s*[\'\"]([^\'\"]*)[\'\"]/) {$logdir=$2};
      if (/^\s*(my)?\s*\$logfile\s*\=\s*[\'\"]([^\'\"]*)[\'\"]/) {$datalog=$2};
      if (/^\s*(my)?\s*\$fieldnames\s*\=\s*[\'\"]([^\'\"]*)[\'\"]/) {$fieldslog=$2};
      if (/^\s*(my)?\s*\$members\s*\=\s*[\'\"]([^\'\"]*)[\'\"]/) {$memberlog=$2};
      if (/^\s*(my)?\s*\$reportdata\s*\=\s*[\'\"]([^\'\"]*)[\'\"]/) {$reportlog=$2};
    } continue {$count++}
    
    $datalog=~s/\$\{logdir\}/$logdir/;
    $fieldslog=~s/\$\{logdir\}/$logdir/;
    $memberlog=~s/\$\{logdir\}/$logdir/;
    $reportlog=~s/\$\{logdir\}/$logdir/;
  }
  print "$datalog<BR>$fieldslog<BR>$memberlog<BR>$reportlog<HR>" if $debug;
  my $table=$datalog;
  $table=~s/_data\.log//;
  my $count=2;
  while (grep /^$table$/, (@allTables)) {
    $table=$datalog;
    $table=~s/_data\.log//;
    $table.="$count";
  } continue {$count++};
  
  #BUILD LIST OF FIELD NAMES AND DISPLAY PARAMETERS
  my @fieldSequence;
  my %fields;
  open(FIELDS,"<$fieldslog") or &error("Could not open $fieldslog");
  my @tmp=<FIELDS>;
  close FIELDS;
  chomp(@tmp);
  shift(@tmp);
  foreach my $tmpline (@tmp) {
    $tmpline=~s/[\r\n]+//g;
    my ($name,$paramset)=split('::',$tmpline);
    $name=lc($name);
    $name=~s/\-/\_/g;
    $name=~s/[^a-z0-9\_]//g;
    push(@fieldSequence,$name);
    my (@tmp)=split(':',$paramset);
    $fields{$name}{display_type}=shift(@tmp);
    $fields{$name}{display_parameters}=join(':',@tmp);
  }
  unshift(@fieldSequence,"_timestamp");
  push(@fieldSequence,"_owner");
  #Analyze Data
  
  my %fieldLength=();
  my %fieldType;
  foreach (@fieldSequence) {
    $fieldLength{$_}=2;
    $fieldType{$_}="int";
  }
  $count=0;
  open (FILE,"<$datalog") or &error("Could not open $datalog");
  my @file=<FILE>;
  close FILE;
  
  foreach (@file) {
    chomp(my @tmp=split("::"));
    my $fieldCount=0;
    foreach my $f (@fieldSequence) {
      if ($fields{$f}{display_type} eq "checkbox") {
	$tmp[$fieldCount]=($tmp[$fieldCount])?"1":"";
      }
      if (($fieldType{$f} eq "date") or ($count==0)) {
	if (($tmp[$fieldCount]=~/^\d\d?(\/|\-)\d\d?(\/|\-)\d\d\d?\d?$/) or
	    ($tmp[$fieldCount]=~/^\d{4}\-\d\d\-\d\d$/) or
	    ($tmp[$fieldCount]=~/^\d\d?\-(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\-\d\d\d?\d?$/i)) {
	  $fieldType{$f}="date";
	  $fieldLength{$f}="1234567890";
	  $tmp[$fieldCount]=&convertDate($tmp[$fieldCount]);
	}
      }
      if ($fieldType{$f} ne "date") {
	if (($fieldType{$f} eq "int")&&($tmp[$fieldCount]=~/\./)) {
	  $fieldType{$f}="float";
	}
	elsif ($tmp[$fieldCount]=~/[^\d\.]/) {
	  $fieldType{$f}="char";
	}
      }
      if (($fieldType{$f} eq "char")&&(length($tmp[$fieldCount])>$fieldLength{$f})) {
	$fieldLength{$f}=length($tmp[$fieldCount]);
      }
      if (($fieldType{$f} ne "char")&&($tmp[$fieldCount]>$fieldLength{$f})) {
	$fieldLength{$f}=$tmp[$fieldCount];
      }
    } continue {$fieldCount++};
    my $timestamp=shift(@tmp);
    unshift(@tmp,$timestamp,"");
    my $owner=pop(@tmp);
    unshift(@tmp,$owner);
    $tmp[1]=&convertDate($tmp[1]);
    $_=join("\t",@tmp)."\n";
  } continue {$count++}
  

  foreach (@fieldSequence) {
    if ($fields{$_}{display_type} eq "text") {
      if ($fieldType{$_} eq "char") {
	$fields{$_}{sqlType}="varchar\($fields{$_}{display_parameters}\)";
      }
      if ($fieldType{$_} eq "int") {
	if ($fieldLength{$_}<16000) {
	  $fields{$_}{sqlType}="int";
	} else {
	  $fields{$_}{sqlType}="bigint";
	}
      }
      if ($fieldType{$_} eq "float") {
	$fields{$_}{sqlType}="float";
      }
      if ($fieldType{$_} eq "date") {
	$fields{$_}{sqlType}="date";
      }
    }
    if ($fields{$_}{display_type} eq "checkbox") {
      $fields{$_}{sqlType}="tinyint";
    }
    if ($fields{$_}{display_type} eq "list") {
      $fields{$_}{sqlType}="varchar(50)";
    }
    if ($fields{$_}{display_type} eq "comment") {
      $fields{$_}{display_parameters}="60,".$fields{$_}{display_parameters};
      $fields{$_}{sqlType}="longtext";
    }
    if ($fields{$_}{display_type} eq "upload") {
      $fields{$_}{sqlType}="text";
    }
  }
  
  my $keyField="ID";
  $count=1;
  while (grep /$keyField/i, @fieldSequence) {
    $keyField="ID_".$count;
  } continue {$count++};

  #Build table and _table

  &do(qq(CREATE TABLE _$table (fieldname tinytext,display_type tinytext,display_parameters longtext,display_label tinytext)));
  @tmp=();
  my $statement=qq(CREATE TABLE $table \(_owner varchar(50),_timestamp timestamp,$keyField int not null auto_increment primary key,);
  &do(qq(INSERT INTO _$table VALUES \('_owner','textbox','20','Owned/Submitted by'\)));
  &do(qq(INSERT INTO _$table VALUES \('_timestamp','textbox','20','Date Added'\)));
  &do(qq(INSERT INTO _$table VALUES \('$keyField','textbox','20','$keyField'\)));
  foreach (@fieldSequence) {
    next if /^(_owner|_timestamp)$/;
    my $sqlName=lc($_);
    $sqlName=~s/[^a-zA-Z0-9\_\-]//g;
    $fields{$_}{sqlName}=$sqlName;
    push(@tmp,qq($sqlName $fields{$_}{sqlType}));
    &do(qq(INSERT INTO _$table VALUES \('$sqlName','$fields{$_}{display_type}','$fields{$_}{display_parameters}',).$dbh->quote($_).")");
   
  }
  $statement.=join(',',@tmp).")";
  &do($statement);

  foreach (@file) {
    $statement=qq(INSERT INTO $table VALUES \();
    my @tmp;
    my @data=split(/\t/);
    foreach (@data) {
      push(@tmp,$dbh->quote($_));
    }
    while ($#tmp<$#fieldSequence+1) {push(@tmp,$dbh->quote(''))};
    while ($#tmp>$#fieldSequence+1) {pop(@tmp)};
    $statement.=join(',',@tmp).")";
    &do($statement);
  }

  #Import layout preferences
  open(FILE,"<$reportlog") or &error("Could not open $reportlog");
  my @report=<FILE>;
  close FILE;
  chomp(@report);
  my %lf;
  $lf{layout_name}=$table;
  $lf{allow_visitors_to_search}=$report[32];
  $lf{language}=$report[42];
  $lf{body_tag}=qq(BGCOLOR="$report[0]" BACKGROUND="$report[38]" TEXT="$report[43]" LINK="$report[44]" VLINK="$report[45]");
  $lf{header_for_search_page}=$report[7];
    $lf{header_for_search_page}=~s/::/\n/g;
  $lf{include_default_instructions_on_search_page}=$report[8];
  $lf{search_page_fields}=$report[24];
    $lf{search_page_fields}=~s/(\d+)/$table\.$fields{$fieldSequence[$1+1]}{sqlName}/g;
  $lf{url_for_return_to_homepage}=$report[33];
  $lf{url_for_search_again}=$report[14];
  $lf{header_for_results_page}=$report[1];
    $lf{header_for_results_page}=~s/::/\n/g;
  $lf{display_search_criteria}=$report[52];
  $lf{hide_table_border}=$report[25];
  $lf{font_information}=$report[26];
  $lf{table_header_color}=$report[21];
  $lf{table_row1_color}=$report[22];
  $lf{table_row2_color}=$report[23];
  $lf{sub_footer_for_results_page}=$report[20];
    $lf{sub_footer_for_results_page}=~s/::/\n/g;
  $lf{show_go_to_page}=$report[55];
  $lf{show_next_page_previous_page}=$report[56];
  $lf{show_search_again}=$report[57];
  $lf{show_return_to_homepage}=$report[58];
  $lf{footer_for_entire_results_page}=$report[59];
    $lf{footer_for_entire_results_page}=~s/::/\n/g;
  $lf{sequence_of_fields}=$report[2];
    $lf{sequence_of_fields}=~s/(\d+)/$table\.$fields{$fieldSequence[$1+1]}{sqlName}/g;
  $lf{sort_by}=$report[3];
    $lf{sort_by}=~s/(\d+)/$table\.$fields{$fieldSequence[$1]}{sqlName}/g;
  $lf{sort_order}=$report[4];
  $lf{sort_by2}=$report[18];
    $lf{sort_by2}=~s/(\d+)/$table\.$fields{$fieldSequence[$1]}{sqlName}/g;
  $lf{sort_order2}=$report[19];
  $lf{number_of_results_per_page}=$report[5];
  $lf{include_view_button}=$report[6];
  $lf{label_for_view_button}=$report[9];
  $lf{image_for_view_button}=$report[39];
  $lf{template_for_search_results}=&convertTemplateNums($report[11],$table,@fieldSequence);
    $lf{template_for_search_results}=~s/::/\n/g;
  $lf{template_for_form_view}=&convertTemplateNums($report[13],$table,@fieldSequence);
    $lf{template_for_form_view}=~s/::/\n/g;
  
  $statement=qq(INSERT INTO _layouts VALUES \();
  @tmp=();
  foreach (&getFields("_layouts")) {
    push(@tmp,$dbh->quote("$lf{$_}"));
  }
  $statement.=join(',',@tmp).")";
  &do($statement);


  $user_data{_tableName}=$table;
  &loadGlobals;
  &manageRecords2;
}

sub convertTemplateNums {
  my ($string,$table,@fieldSequence)=@_;
  for (my $i=0;$i<=$#fieldSequence;$i++) {
    $string=~s/\$data\[$i\]/\$data\[$table\.$fieldSequence[$i+1]\]/g;
    $string=~s/\$escape\[$i\]/\$escape\[$table\.$fieldSequence[$i+1]\]/g;
  }
  return $string;
} 
sub templateFieldAssistant {
  &adminCheck;
  my $table=$user_data{_tableName};
  my @fields=&getFields($table);
  print <<EOF;
  <BODY BGCOLOR=WHITE><FORM>
  <SELECT NAME="allFields" SIZE=10 onChange="form.result.value='\$field['+this.options[this.selectedIndex].text+']';form.result.focus();form.result.select()">
EOF
foreach (@fields) {
  print qq(<OPTION>$_</OPTION>\n) unless /^_/;
}
print <<EOF
 </SELECT><BR>
<INPUT TYPE=TEXT SIZE=30 NAME="result" onFocus="this.select()"><BR>
<INPUT TYPE=BUTTON VALUE="Close" onClick="self.close()"></FORM>
<SMALL>1. Select a field.<BR>
2. Use [ctrl-c] to copy tag.<BR>
3.Use [ctrl-v] to paste it into your template
</SMALL></FORM></BODY>
EOF
}


sub uploadTable {
  &adminCheck;
  &import2('new table');
}

sub addIndex {
  &adminCheck;
  my %f=&extractField($user_data{_tableName},$user_data{fieldName});
  if ($f{null}) {
    &do(qq(ALTER TABLE $user_data{_tableName} MODIFY $user_data{fieldName} $f{type} NOT NULL));
  }
  &do(qq(ALTER TABLE $user_data{_tableName} ADD INDEX ($user_data{fieldName})));
  &loadGlobals;
  &modifyTable;
}

sub dropIndex {
  &adminCheck;
  &do(qq(ALTER TABLE $user_data{_tableName} DROP INDEX $user_data{fieldName}));
  &loadGlobals;
  &modifyTable;
}

sub exportJoin {
  my ($delimiter,@row)=@_;
  my $result;
  foreach (@row) {
    $_=~s/[\r\n]+/<BR>/g;
    $_=~s/\t/   /g;
    if ((/[^0-9\.]/)or(/^$/)) {
      $_=~s/\"/\"\"/g;
      $_="\"$_\"";
    }
  }
  $result=join($delimiter,@row);
  return $result;
}

sub exportRecords {
  &memberCheck;
  my $delimiter;
  $delimiter=($user_data{delimiter} eq "comma") ? "," : 
             ($user_data{delimiter} eq "tab") ? "\t" :
             ($user_data{delimiter} eq "pipe") ? "\|" : "";

  my $statement="SELECT * FROM $user_data{_tableName}";
  $statement.=" WHERE ".&unescape($user_data{where}) if $user_data{where};
  print "$statement <HR>" if $debug;
  my @allFields=&getFields($user_data{_tableName});
  print &exportJoin($delimiter,@allFields)."\n";
  my $sth=$dbh->prepare("$statement") or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  while (my @row=$sth->fetchrow_array) {
    print &exportJoin($delimiter,@row)."\n";
  }
  $sth->finish();

}

sub sqlEntry {
  &adminCheck;
  unless ($user_data{response}) {$user_data{response}=""};
  unless ($user_data{statement}) {$user_data{statement}=""};
  my $response=$user_data{statement};
  $response.=qq(\n====================================================================\n) if $user_data{statement};
  if ($user_data{statement}) {
    my $statement=$user_data{statement};
    print "$statement <HR>\n" if $debug;
    my $sth=$dbh->prepare($statement) or $response.=$DBI::errstr;
    if ($sth) {
      $sth->execute() or $response.=$DBI::errstr;
      for (my $i=1;$i<=$sth->{NUM_OF_FIELDS};$i++) {
	$response.=qq($sth->{NAME}->[$i-1] \|\t);
      }
      $response.="\n";
      my $isRows=0;
      while (my @row=$sth->fetchrow_array) {
	unless ($isRows) {
	  $response.=qq(--------------------------------------------------------------------\n);
	  $isRows=1;	
	}
	foreach (@row) {
	  $_=~s/[\n\r]+/\\n/g;
	  $response.="$_ \|\t";
	}
	$response.="\n";
      }
    }
    $response.=qq(====================================================================\n\n\n);
  }
  $response.=$user_data{response};
  &graphicsHeader;
  print <<EOF;
<SCRIPT>
function printResults(f) {
  nw=window.open('','','width=200,height=200');
  nw.document.write("<PRE>"+f.response.value+"</PRE>");
  nw.document.close();
  nw.print();
  nw.close();
}
</SCRIPT>
<H1 ALIGN=CENTER>SQL Entry Page</H1>
If you need to make a change to the database which is not possible
with Webdata\'s interface, you may type the appropriate SQL commands
here.  Please note that this interface is not safeguarded in any way.
It is entirely possible to break the database if you do not know what
you are doing.

<CENTER>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<B>Enter your SQL statement here:</B><BR>
<TEXTAREA NAME="statement" COLS=80 ROWS=3>$user_data{statement}</TEXTAREA><BR>
<INPUT TYPE=SUBMIT VALUE="Enter"> 
<INPUT TYPE="BUTTON" VALUE="Clear" onClick="form.statement.value='';form.response.value=''">
<INPUT TYPE="BUTTON" VALUE="Print" onClick="printResults(form)">
<HR>
<TEXTAREA NAME="response" COLS=80 ROWS=30 WRAP=OFF>$response</TEXTAREA><BR>
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="SQL Entry">
</FORM>
</CENTER>
$globals{adminLink}
EOF
  &graphicsFooter;
}

sub import2 {
  unless (($globals{userID}eq"admin")or($member{canimport}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to import to the $user_data{_tableName} table");
  }
  my $newTable=($_[0] eq "new table") ? 1 : 0;
  #IMPORT FILE
  my @file;
  my $dlmtr = $user_data{delimiter};
  if ($dlmtr eq 'comma') {
    $dlmtr=',';
  } elsif ($dlmtr eq 'tab') {
    $dlmtr="\t";
  } else {
    $dlmtr='\|';
  }
  if ((length($user_data{pathname})>0)&&($globals{userID} eq "admin")) {
    if (length($user_data{filename})>0) {
      print "You entered both a server path and an upload file.  Please choose one or the other.";
      exit;
    }
    open (FILE,"<$user_data{pathname}") or &error("Could not open $user_data{pathname}");
    @file=<FILE>;
    close FILE;
  } else {
    if (length($user_data{filename})==0) {
      print "No file was entered.";
      exit;
    }
    if ($user_data{filename}!~/\.(txt|prn|csv)$/) {
      print "You are adding records from a delimited text file to the database.
           <BR>Only txt, prn, or csv files may be uploaded here.
           <BR>To attach a picture or file to a record, a field must be defined
           <BR>as upload type, and you can attach the file when you add the record.";
      exit;
    };
   my $filedata;
    while (my $bytesread=read($query->param('filename'),my $buffer,1024)) {
      $filedata.=$buffer;
    }
    close ($query->param('filename'));
    close $query->param('filename');
    if (length($filedata)==0) {&error('No Data Was Uploaded')};
    @file=split(/[\n\r]+/,$filedata);
  }
  chomp(@file);

  #STRIP CSV FORMAT

  foreach my $line (@file) {
    my @newline;
    #********CONVERT CSV FORMAT********
    $line=~s/\"\"/<--------QUOTE-------->/g;
    while (length($line)) {
      my $phrase;
      if ($line=~/^\"([^\"]*)\"($dlmtr|$)/) {
	$phrase=$1;
	$line=~s/^\"[^\"]*\"($dlmtr|$)//;
      } elsif ($line=~/^([^$dlmtr]*)$dlmtr/) {
	$phrase=$1;
	$line=~s/^[^$dlmtr]*$dlmtr//;
      } else {
	$phrase=$line;
	$phrase=~s/\"//g;
	$line="";
      }
      $phrase=~s/<--------QUOTE-------->/\"/g;
      $phrase=~s/^\s+|\s+$//g;
      push(@newline,$phrase);
    }
    unshift(@newline,'\\N') if $newTable; #create place for key
    my $owner;
    if ($globals{userID} eq "admin") {
      $owner=$user_data{member};
    } else {
      $owner=$globals{userID};
    }
    unshift(@newline,$owner,'\\N');
    $line=join("\t",@newline)."\n";
  }

      #CREATE NEW TABLE IF NEEDED
      if ($newTable) {
	&adminCheck;
	my $tmp=shift(@file);
	chomp($tmp);
	my @fields=split("\t",$tmp);
	if (($fields[3] eq "_owner") and ($fields[4] eq "_timestamp")) {
	  for (my $i=0;$i<5;$i++) {shift(@fields)};
	  @fields=("_owner","_timestamp","key",@fields);
	  #reload of WebdataPro data structure
	  foreach my $line (@file) {
	    my @newline=split("\t",$line);
	    shift(@newline);
	    shift(@newline);
	    shift(@newline);
	    my $owner=shift(@newline);
	    my $timestamp=shift(@newline);
	    @newline=($owner,$timestamp,'\\N',@newline);
	    $line=join("\t",@newline);
	  }
	}
	my $keyField="ID";
	my $count=1;
	while (grep /$keyField/i, @fields) {
	  $keyField="ID_".$count;
	} continue {$count++};
	
	$fields[0]="_owner";
	$fields[1]="_timestamp";
	$fields[2]="$keyField";     
	my %fieldLength;
	my %fieldType;
	foreach (@fields) {
	  $fieldLength{$_}=2;
	  $fieldType{$_}="int";
	}
	$count=0;
	foreach (@file) {
	  chomp(my @tmp=split("\t"));
	  my $fieldCount=0;
	  foreach my $f (@fields) {
	    if (($fieldType{$f} eq "date") or ($count==0)) {
	      if (($tmp[$fieldCount]=~/^\d\d?(\/|\-)\d\d?(\/|\-)\d\d\d?\d?$/) or
		  ($tmp[$fieldCount]=~/^\d{4}\-\d\d\-\d\d$/) or
		  ($tmp[$fieldCount]=~/^\d\d\-(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)\-\d\d\d\d$/i)) {
		$fieldType{$f}="date";
		$fieldLength{$f}="1234567890";
		$tmp[$fieldCount]=&convertDate($tmp[$fieldCount]);
	      }
	    }
	    if ($fieldType{$f} ne "date") {
	      if (($fieldType{$f} eq "int")&&($tmp[$fieldCount]=~/\./)) {
		$fieldType{$f}="float";
	      }
	      elsif ($tmp[$fieldCount]=~/[^\d\.]/) {
		if ($fieldType{$f} ne "char") {$fieldLength{$f}=2};
		$fieldType{$f}="char";
	      }
	    }
	    if (($fieldType{$f} eq "char")&&(length($tmp[$fieldCount])>$fieldLength{$f})) {
	      $fieldLength{$f}=length($tmp[$fieldCount]);
	    }
	    if (($fieldType{$f} ne "char")&&($tmp[$fieldCount]>$fieldLength{$f})) {
	      $fieldLength{$f}=$tmp[$fieldCount];
	    }
	  } continue {$fieldCount++};
	  $_=join("\t",@tmp)."\n";
	} continue {$count++}
	
	my $statement;
	unless (grep /^_$user_data{_tableName}$/, (@allTables)) {
	  &do(qq(CREATE TABLE _$user_data{_tableName} (fieldname tinytext,display_type tinytext,display_parameters longtext,display_label tinytext)));	
	}
	$statement=qq(CREATE TABLE $user_data{_tableName} \();
	my @tmp;
	foreach my $f (@fields) {
	  my $nm=lc($f);
	  $nm=~s/[^a-z0-9\-\_]//;
	  my $ln=$fieldLength{$f};
	  my $tp=$fieldType{$f};
	  my $type;
	  if ($f eq "_owner") {$type="VARCHAR(50)"}
	  elsif ($f eq "_timestamp") {$type="TIMESTAMP"}
	  elsif ($f eq $keyField) {$type="INT AUTO_INCREMENT PRIMARY KEY"}
	  else {$type=($tp eq "char") ? ($ln<128)?"varchar(".($ln*2).")":"longtext" :
		  (($tp eq "int")&&($ln<16384)) ? "SMALLINT" :
		    (($tp eq "int")&&(($ln>=16384)&&($ln<4294967296))) ? "INT" :
		      (($tp eq "int")&&($ln>=4294967296)) ? "BIGINT" :
			($tp eq "float") ? "FLOAT" : 
			  ($tp eq "date") ? "DATE" : "";
	      }
	  push (@tmp,"$nm $type");
	  my $params=($tp eq "char") ? ($ln*2) : length($ln)+2;
	  my $stm2=qq(INSERT INTO _$user_data{_tableName} VALUES \();
	  $stm2.=$dbh->quote($nm).",";
	  $stm2.=$dbh->quote('textbox').",";
	  $stm2.=$dbh->quote($params).",";
	  $stm2.=$dbh->quote($f).")";
	  &do($stm2);
	}
	$statement.=join(',',@tmp).")";
	&do($statement);
      } else {
	# IF NOT CREATE NEW TABLE, STEP THROUGH THE FILE
	# AND CONVERT ANY DATES TO THE PROPER FORMAT

	foreach (@file) {
	  my $fieldCount=0;
	  my @fields=&getFields($user_data{_tableName});
	  my @tmp=split("\t");
	  chomp(@tmp);
	  foreach my $field (@fields) {
	    next if $field=~/^_/;
	    my %f=&extractField($user_data{_tableName},$field);
	    if ($f{type} =~ /date/i) {
	      $tmp[$fieldCount]=&convertDate($tmp[$fieldCount]);
	    }
	  } continue {$fieldCount++};
	  
	  $_=join("\t",@tmp)."\n";
	}
	
      }
    #WRITE DATA TEMP FILE
    open (FILE,">$uploadsdir$globals{slash}$$") or &error("Could not open $uploadsdir$globals{slash}$$ for output");
    print FILE (@file);
    close FILE;
    #IMPORT INTO DATABASE
    #delete if overwrite
    if ($user_data{overwrite}) {
      my $statement=qq(DELETE FROM $user_data{_tableName} WHERE );
      $statement.=&getKey($user_data{_tableName});
      $statement.=qq( LIKE '\%');
      &do($statement);
    }
    &loadData("$uploadsdir$globals{slash}$$",$user_data{_tableName});
    unlink("$uploadsdir$globals{slash}$$") or &error("Could not delete $uploadsdir$globals{slash}$$");
    print qq(<SCRIPT>alert('Import Complete')</SCRIPT>);
    &loadGlobals;
    if ($newTable) {
      &manageTables;
    } else {
      &manageRecords2;
    }
    unlink "$uploadsdir$globals{slash}$$";
}

sub loadData{
  my ($file,$table)=@_;
  my @fields=&getFields($table);
  open (FILE,"<$file") or &error("Could not open $file for reading");
  while (<FILE>) {
    chomp(my @data=split("\t"));
    while ($#data<$#fields) {push(@data,"")};
    while ($#data>$#fields) {pop(@data)};
    foreach (@data) {
	s/^\\N$/NULL/;
	$_=$dbh->quote($_) unless /^NULL$/;
    }
    my $statement="INSERT INTO $table VALUES (".join(',',@data).")";
    &do($statement);
  }
  close FILE;
}

sub importRecords {
  unless (($globals{userID}eq"admin")or($member{canimport}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to import to the $user_data{_tableName} table");
  }
  &graphicsHeader("Manage Records");

print <<EOF;
<h1 align="center">Import a delimited text file</h1>
<h4>A delimiter is a character which is used to tell the database
where one field stops, and the next one begins.  Most spreadsheet
and database programs can save as either comma delimited or tab 
delimited.  <P>

This program will convert comma or tab delimited text files to 
Webdata\'s format, and append the file to your existing database.
  The imported data file should be in the same sequence as your
existing data.  Microsoft Excel is a good tool for resequencing
data before saving to a delimited text file. </h4>

<form action="$globals{cgilocation}" method="post"
onSubmit="if(this.filename.value!='') {this.encoding='multipart/form-data'}">
EOF

  if ($globals{userID} eq "admin") {print "
Either upload the file to your server and type the full pathname
into this box:<BR>
<INPUT TYPE=TEXT SIZE=60 NAME=\"pathname\"><BR>
or u"} else {print "U"};
print "se the Browse button below to select the file from your
local machine and upload it through the web browser.<BR>
<I>NOTE:You must have the CGI.pm module to use this feature.
If you get a server error, ask your system administrator to check
that CGI.pm is properly installed.</I><BR>


Select your file to import: <input type=file name=\"filename\"><BR>

<font size=3>
Is the file comma or tab delimited?</font></B>
<select name=\"delimiter\" size=1>
<option value=\"comma\">comma
<option value=\"tab\">tab
<option value=\"pipe\">pipe
</select>
";
if ($globals{userID} eq "admin") {
  print "<P>
<font size=3>
If you assign ownership to a member instead of \"admin\" then
that member will be able to modify or delete these records.<BR>
The imported records will be owned by:\n";
  print "<SELECT NAME=\"member\">\n<OPTION>admin\n";
  my $statement="SELECT firstname, lastname, email FROM _members";
  my $sth=$dbh->prepare("$statement") or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  my $memberOptions;
  while (my @row=$sth->fetchrow_array) {
    my ($firstname,$lastname,$email)=@row;
    $memberOptions.=qq(<OPTION VALUE="$email">$firstname $lastname</OPTION>\n);
  }
  $sth->finish();
 
  print "$memberOptions </SELECT>
<BR><B>Overwrite existing data with imported records?</B><BR>
<I>This will destroy all data in the table.<BR>
Also, if you use the \"Create members and passwords\" <BR>feature below,
this option will destroy all existing members in the database.</I>
<input type=checkbox name=\"overwrite\" value=\"yes\" 
onClick=\"if(this.checked) {if(!confirm(\'This will destroy all records in the database. \\nAre you sure that you want to do this?\')) {this.checked=false}}\">
  ";
  print qq(
<P>
<B>Create members and passwords?</B><BR>
<I>If you enter a value in the boxes below, a membership will<BR>
be created for each value in the username column, with the password<BR>
set to the value in the password column. Each person will then have the<BR>
ability to modify or delete only his/her own data.<BR></I>
username column # 
<INPUT TYPE=TEXT SIZE=3 NAME="memberNameCol"> Password column #
<INPUT TYPE=TEXT SIZE=3 NAME="memberPassCol"><I>THIS FEATURE IS NOT ENABLED YET IN VERSION $globals{version}</I><BR>
	  );
} else {
  print "<INPUT TYPE=HIDDEN NAME=\"member\" VALUE=\"$globals{userID}\">\n";
}
print "
<input type=hidden name=\"_cgifunction\" value=\"import2\">
<input type=hidden name=\"_tableName\" value=\"$user_data{_tableName}\">
<BR><INPUT TYPE=SUBMIT VALUE=\"Import\">
</form>";
print qq(<A HREF="$globals{cgilocation}?_cgifunction=Go+To+Selected+Table&_tableName=$user_data{_tableName}">Return to $user_data{_tableName} table</A><BR>);
	if ($globals{userID} eq "admin") {
		print qq($globals{adminLink});
	} else {
		print qq(<A HREF="$globals{cgilocation}?_cgifunction=memberpage">Return to members page</A>);
	}
  &graphicsFooter("Manage Records");
}

sub loginPage {
  if ($globals{userID} eq "admin") {
    &admin;
  } elsif ($globals{userID}) {
    &memberpage;
  } else {
    print qq(<SCRIPT>history.go(-1)<SCRIPT>);
    exit;
  }
}

sub getKeyFields {
  #(IN: a multi-table select statement, a single array of values delived by that statement)
  #(OUT: the table.keyfield=value criteria(s) necessary to build a query for just that row)
  my ($statement,@row)=@_;
  $statement=~s/^.*FROM +//i;
  $statement=~s/ +(LEFT|RIGHT|WHERE|ORDER|$).*//i;
  my @tables=split(/ *, */,$statement);
  my @result;
  foreach my $t (@tables) {
    my $key=&getKey($t);
    push (@result,"$t\.$key")
  }
  return @result;
}

sub orderClause {
  #(IN: %layout hash)
  #(OUT: "ORDER BY table.field [DESC], table.field [DESC], table.field [DESC]")
  my %layout=@_;
  my @orderClause;
  foreach ('',2,3) {
    my $field=$layout{"sort_by$_"};
    next unless $field;
    $field=~s/\._owner\./_MemberTable\./;
    my $seq=($layout{"sort_order$_"})?"DESC":"ASC";
    push (@orderClause,"$field $seq");
  }
  return join(', ',@orderClause);
}


sub whereClause {
  #(IN: form field parameters from search page: table.field,table.field,table.field)
  #(OUT: "WHERE [correct syntax criteria]")

  if ($user_data{_where}) {return unescape($user_data{_where})};
  my @values=();
  foreach (@_) {
    $user_data{$_}=~s/^\s*//g; #strip leading space and newlines
    $user_data{$_}=~s/\s*$//g; #strip trailing spaces
    next unless length($user_data{$_});
    my ($table,$field)=split('\.');
    my $tableTmp=$table;
   $tableTmp=~s/_MemberTable$//;
    next unless grep /^$tableTmp$/, (@allTables); #skip _cgifunction and other handler values.
    my %f=&extractField($table,$field);
    my $criteria=$user_data{$_};
    my @orValues=split(/ +OR +/i,$criteria);
    my @orClause=();

    foreach my $val (@orValues) {
      if ($f{type}=~/^(date|timestamp)/) { #convert mm/dd/yy to quoted date format.
	$val=~s/(\d\d?\/\d\d?\/?\d?\d?\d?\d?)/&convertDate($1,'quote')/ge;
      }
      if ($val=~/^ISNULL$/i) {
	push(@orClause,"$_ IS NULL");
      }
      elsif ($f{type}=~/^timestamp/) {
	$_="TO_DAYS\($_\)";
	$val=~s/\'//g;
	$val=~s/(\d\d\d?\d?\-\d\d?\-\d\d?)/TO_DAYS\(\'$1\'\)/g;
	my $equals=($val=~/^<|>/)?"":"=";
	
	push(@orClause,"$_ $equals $val");
      }
      elsif ($val=~/^between.*and/i) {
	$val=~s/(^between *)|[\$\\, ]//gi;
	my ($min,$max)=split(/ *and */,$val);
	push (@orClause,"($_ >= $min AND $_ <= $max)");
      }
      elsif (($val=~/([^\d<>=\$\\., \'])/)and($f{type}!~/^(date|timestamp)/)) { #if criteria contains non-numbers
	my @andClause=();
	foreach my $andVal (split(/ +AND +/i,$val)) {
	  if (($andVal=~/^ *([\"\']).*([\"\']) *$/)and($1 eq $2)) {
	    $andVal=~s/^ *([\"\'])|([\"\']) *$//g;
	    push (@andClause,"UPPER($_) = UPPER(".$dbh->quote($andVal).")");
	  } elsif ($andVal=~/^\*|\*$/) {
	    $andVal=~s/\*/\%/g;
	    push (@andClause,"UPPER($_) LIKE UPPER(".$dbh->quote($andVal).")");
	  } else {
	    push (@andClause,"UPPER($_) LIKE UPPER(".$dbh->quote("\%$andVal\%").")") if length($andVal);
	  }
	}	  
	push (@orClause,join(' AND ',@andClause));
      } 
      else { #if criteria contains only number chars
	$val=~s/[\$\\, ]//g;
	my $equals=($val=~/^<|>/)?"":"=";
	push (@orClause, "$_ $equals $val");
      }
    } # end foreach orVals

    if ($#orClause) {
      push (@values,"(".join(' OR ',@orClause).")");
    } else {
      push (@values,$orClause[0]);
    }
  } 

  my $where=join(' AND ',@values);
  return $where;
}

sub titleCase {
  my @words=split(/[\s\_]+/);
  foreach (@words) {
    my $first=uc(substr($_,0,1));
    my $rest=lc(substr($_,1,length($_)));
    $_="$first"."$rest";
  }
  return join(' ',@words);
}

sub form {
  &searchCheck;
  #Gather info from all related tables to the right of user_data{keyval}
  my ($key,$val)=split('=',$user_data{keyval});
  $user_data{_layout} = "default" unless $user_data{_layout};
  my %layout=&getHash("_layouts","layout_name",$user_data{_layout});
  my (@oneKeys,@manyKeys,@joins);
  push(@oneKeys,$key);
  my $count=0;
  my $statement;
  foreach (@oneKeys) {
    my ($table,$field)=split('\.',$_);
    if ($count>200) {&error("Circular reference in table relationships")}
    $statement="SELECT many_side,one_side FROM _relationships ";
    $statement.=  "WHERE many_side LIKE ".$dbh->quote("$table\.\%");
    print "$statement<HR>" if $debug;
    my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
    $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
    while (my @row=$sth->fetchrow_array) {
      push (@manyKeys,$row[0]);
      push (@oneKeys,$row[1]);
      my($t1,$f1)=split('\.',$row[0]);
      my($t2,$f2)=split('\.',$row[1]);
      push (@joins,"LEFT OUTER JOIN $t2 ON $row[0]=$row[1]");
    }
    $sth->finish();
  }

  my ($leftMostTable)=split('\.',$key);
  my $fromJoin="FROM $leftMostTable ".join(" ",@joins);
  my $fromJoinWhere="$fromJoin WHERE $key=".$dbh->quote($val);
  my $display=qq(<BODY BGCOLOR=WHITE><TABLE BGCOLOR=WHITE BORDER=0 CELLPADDING=4 CELLSPACING=0>);
  my %data;
  foreach (@oneKeys) {
    my ($table,$field)=split('\.');
    $display.=qq(<TR BGCOLOR=BLUE><TD COLSPAN=2><FONT COLOR=WHITE><B>).
      (($table eq "_members")?"Members":$table).qq(</B></FONT></TD></TR>);
    my $fields=join(', ',&getFields($table,1));
    $statement="SELECT $fields $fromJoinWhere";
    print "$statement<HR>" if $debug;
    my @row=&getSingleArray($statement);
    my $count=0;
    foreach (&getFields($table)) {
      my %f=extractField($table,$_);
      $f{display_label}=&titleCase($_);
      if ($table eq "_members") {
	next if /^(password|searchLayout|header|footer|canadd|canmodify|candelete|canimport|canexport|limitto1|manageall|templates|groupname|default_url|manageall)$/;
	if (/^(user\d\d?)$/) {
	  my $userNum=$1;
	  if ($globals{$_}) {$f{display_label}=$globals{$userNum}} else {next};
	}
        if ((/^homepage$/)and($row[$count])and($row[$count]!~/^http\:\/\//)) {$row[$count]="http://".$row[$count]};
      }
      if (/^_owner$/) {
	$data{"$table\._owner\.email"}=$row[$count];
	if (!$layout{template_for_form_view}) {
	  my $statement=qq(SELECT firstname,lastname,email FROM _members WHERE email=).$dbh->quote($row[$count]);
	  print "$statement<HR>" if $debug;
	  my ($first,$last,$email)=&getSingleArray($statement);	  
	  $row[$count]=qq(<A HREF=\"$globals{cgilocation}?_cgifunction=form&_layout=).&escape($user_data{_layout});
	  $row[$count].=qq(&keyval=_members.email%3D).&escape($email);
	  $row[$count].=qq(\"><font style="text-decoration: none">$first $last</font></A>);
	}
      }
      $data{"$table\.$_"}=$row[$count];
      unless (length($data{"$table\.$_"})) {$data{"$table\.$_"}=qq(\&nbsp\;)};
      my $tmp="$table\.$_";
      next if grep /$tmp/, @manyKeys;
      if ($f{type}=~/date/) {
	$row[$count]=&displayDate($row[$count]);
      }
      if ($f{type}=~/timestamp\(14\)/) {
	$row[$count]=&displayTime($row[$count]);
      }
      $row[$count]=&displaySubstitution($row[$count]);
      $row[$count]=~s/\r?\n\r?/<BR>/g;
      $display.=qq(<TR><TD><B>$f{display_label}:</B></TD><TD>$row[$count]</TD></TR>\n);
    } continue {
      $count++;
    }
  }
  $display.=qq(</TABLE></BODY>);
  if ($layout{form_view_window}) {
    $display.=qq(<form><input type=button value="close" onClick="self.close()"></form>);
  } else {
    $display.=qq(<form><input type=button value="$lang{returntoprevious}" onClick="history.go(-1)"></form>);
  }
  if (!$layout{template_for_form_view}) {
    print qq($display);
  } else {
    my %sumVals=&getSumVals("SELECT * $fromJoin",%layout);
    %layout=&replaceSumVals(\%sumVals,\%layout,"SELECT * $fromJoin");
    my $layoutText=&template($layout{template_for_form_view},"",-1,%data);
    $layoutText=~s/\$query\[([^\]]*)\]/&getQuery($1,$statement,%data)/gie;
    print "$layoutText";
    my $cartButtons=($layout{use_shopping_cart})?qq(<TABLE BORDER=0><TR><TD BGCOLOR="$globals{cart_color}"><A 
HREF="$globals{cgilocation}?_cgifunction=View+Cart&_layout=).&escape($layout{layout_name}).qq("><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
VIEW&nbsp;CART</B></A></TD><TD BGCOLOR="$globals{cart_color}">
<A HREF="$globals{cgilocation}?_cgifunction=Check+Out&_layout=).&escape($layout{layout_name}).qq("><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
CHECK&nbsp;OUT</B></TD><TD><A HREF="$globals{cgilocation}?_cgifunction=Empty+Cart&_layout=$user_data{_layout}">Empty Shopping Cart</A></TD></TR></TABLE>):"";
    print "$cartButtons";
  }

}

sub showMember {
  my $key;
  if ($_[0]) {
    $key=$_[0]
  } else {
    $key=$user_data{email};
    print qq(<BODY BGCOLOR=WHITE>\n);
  }
  my %result=&getHash('_members','email',$key);
  print qq(<H1 align=center>$result{firstname} $result{lastname}</H1>\n);
  print qq(<TABLE BORDER=0>);
  foreach (&getFields('_members')) {
    next if /^(password|searchLayout|header|footer|canadd|canmodify|candelete|canimport|canexport|limitto1|manageall|templates|groupname|default_url)$/;
    my $label=$_;
    if (/^(user\d\d?)$/) {
        my $userNum=$1;
	if ($globals{$_}) {$label=$globals{$userNum}} else {next};
    }
    print "<TR><TD><B>$label</B></TD><TD>$result{$_}</TD></TR>\n";
  }
  print qq(</TABLE></BODY>);
}

sub displaySubstitution {
  my ($val)=@_;
  if ($val eq "") {return qq(&nbsp;)};
  if ($val=~/^\S*\.(gif|jpg)$/) {$val=qq(<A HREF="$val"><IMG SRC="$val" BORDER=0></A>)}
  $val=~s/(^|\s*)(http:\/\/\S+)/$1<A HREF=\"$2\">$2<\/A>/g unless $2=~/(gif|jpg)$/i;
  $val=~s/(\S+\@\S+\.\S+)/<A HREF=\"mailto:$1\">$1<\/A>/g;
  return $val;
}

sub buildJoinStatement {
  #(IN: %layout)

  #(OUT: SELECT tablename.fieldname,tablename.fieldname,tablename.fieldname
  #             tablename_MemberTable.memberField, tablename_MemberTable.memberField
  #      FROM leftmost tablename
  #      LEFT OUTER JOIN tablename ON tablename.fieldname=tablename.fieldname
  #      LEFT OUTER JOIN tablename ON tablename.fieldname=tablename.fieldname
  #      LEFT OUTER JOIN tablename ON tablename.fieldname=tablename.fieldname
  #      LEFT OUTER JOIN _members AS tablename_MemberTable ON tablename._owner=_members.email
  #      LEFT OUTER JOIN _members AS tablename_MemberTable ON tablename._owner=_members.email
  #      
  #      other routines will append the WHERE and ORDER BY items.
  my %layout=@_;
  my @sequence=&getSequence(%layout);

  #Get SELECT fields

  #remove member fields
  my %memberTables;
  foreach my $field (@sequence) {
    if ($field=~/([^\.]+)\._owner\.(.+)/) {
      $field="$1\_MemberTable\.$2 AS ".$dbh->quote($field);
      $memberTables{$1}=1;
    }
  } 

  my $fieldnames=join(', ',@sequence);

  #Get FROM tables
  my %tableList;
  foreach (@sequence) {
    my ($table,$field)=split('\.');
    $tableList{$table}=1 unless $table=~/_MemberTable$/;
  }

  foreach my $k (keys %user_data) {
    if ((($k=~/^([^\.]+)\./)and(grep /^$1$/,@allTables))or($k=~/_MemberTable\./)) {
      my ($table,$field)=split('\.',$k);
      if ($table=~/^(.*)_MemberTable$/) {
	$memberTables{$1}=1;
	my $tmp=$table;
	$tmp=~s/_MemberTable//;
	$tableList{$tmp}=1;
      } else {
	$tableList{$table}=1;
      }
    }
  }

  if ($layout{use_shopping_cart}) {
    foreach ($globals{cart_prodID},$globals{cart_prodName},$globals{cart_prodDesc},$globals{cart_prodPrice},$globals{cart_prodWeight},$globals{cart_prodTaxable}) {
      next unless /\./;
      my ($table,$field)=split('\.');
      $tableList{$table}=1;
    }
  }

  my @sortFields=split(', ',&orderClause);
  foreach (@sortFields) {
    my ($table,$field)=split('\.');
    $tableList{$table}=1 unless $table=~/_MemberTable$/;
  }
  
  #Get LEFT OUTER JOIN statements
  my @inList;
  #--build a query to find relationships that use tables in our SELECT.
  foreach (keys %tableList) {
    push (@inList,"one_side LIKE ".$dbh->quote("$_\.\%"));
  }
  my $in=join(' OR ',@inList);
  my @joinList;
  my %joinTables;
  #--execute the query for each table
  foreach (keys %tableList) {
    my $statement="SELECT many_side, one_side FROM _relationships WHERE many_side LIKE  ".$dbh->quote("$_\.\%")." AND ($in)";
    print "$statement<HR>" if $debug;
    my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
    $sth->execute;
    #--build a list of LEFT OUTER JOIN statements for each many-side table used.
    while (my ($many,$one)=$sth->fetchrow_array()) {
      my ($table,$field)=split('\.',$one);
      push(@joinList,"LEFT OUTER JOIN $table ON $many = $one");
      $joinTables{$table}=1;
    }
    $sth->finish();
  }
  foreach (keys %memberTables) {
    push(@joinList,"LEFT OUTER JOIN _members AS $_\_MemberTable ON $_\._owner=$_\_MemberTable\.email");
  }

  #If a table appears in a LEFT OUTER JOIN, it should not appear in the FROM tables. So we expunge it.
  foreach (keys(%tableList)) {
    if (exists($joinTables{$_})) {
      delete $tableList{$_};
    }
  }
  my $tables=join(', ',keys(%tableList));
  my $join=join(" ",@joinList);

  #Return the SELECT statement
  my $statement = "SELECT $fieldnames FROM $tables $join";
  return ($statement,@sequence);
}

sub getSequence {
  my %layout=@_;
  my @result;
  if (!$layout{template_for_search_results}) {
    @result=split(':',$layout{sequence_of_fields});
  } else {
    foreach ('template_for_search_results','group_header') {
      my $text=$layout{$_};
      while ($text=~/\$data\[([^\]]+)\]/g) {push(@result,$1)};
      while ($text=~/\$escape\[([^\]]+)\]/g) {push(@result,$1)};
      while ($text=~/\$format\[([^\]]+)\]/g) {push(@result,$1)};
      while ($text=~/\$days\[([^\]]+)\]/g) {push(@result,$1)};
      while ($text=~/\$yearsSince\[([^\]]+)\]/g) {push(@result,$1)};
      while ($text=~/\$daysSince\[([^\]]+)\]/g) {push(@result,$1)};
    }
  }
  if ($layout{use_shopping_cart}) {
    my @missingCartFields;
    foreach ($globals{cart_prodID},$globals{cart_prodName},$globals{cart_prodDesc},$globals{cart_prodPrice},$globals{cart_prodWeight},$globals{cart_prodTaxable}) {
      my $val=$_;
      next unless $val=~/\./;
      next if grep /^$val$/, @result;
      push(@missingCartFields,$val);
      push(@result,$val)
    }
  $globals{extraCartFields}=@missingCartFields;
  }
  return (@result);
}

sub getSumVals {
  my ($statement,%layout)=@_;
  my $text;
  #get list of summary fields from header,sub-footer,footer,search template, and form template
  foreach (qw(header_for_results_page sub_footer_for_results_page footer_for_entire_results_page template_for_search_results template_for_form_view)) {
    $text.=$layout{$_};
  }
  my %sumVals=&querySumVals($text,$statement);
  return %sumVals;
}

sub querySumVals {
  my ($text,$statement,$where,%data)=@_;
  # if %data exists, then the routine is being called from the group header/footer, and
  # the where "sort_by = currentVal" is applied. If %data does not exist, the routine is
  # being called from getSumVals, and no additional WHERE criteria is used.
  my %allFields;
  my %sumVals;
  while ($text=~/\$(sum|avg|count)\[([^\]]*)\]/g) {
    $allFields{"$1\($2\)"}=1;
  }
  my @fl=keys %allFields;
  my $sumFields=join(', ',@fl);
  if ($sumFields) {
    $statement=~s/SELECT .* FROM/SELECT $sumFields FROM/;
    if (%data) {
      $statement=~s/WHERE.*$//;
      $statement=~s/ORDER BY.*$//;
      $where.=" AND" if $where;
      $statement.="WHERE $where $layout{sort_by}=".$dbh->quote($data{$layout{sort_by}});
    }
    print "$statement <HR>" if $debug;
    my @r=&getSingleArray($statement);
    my $c=0;
    foreach (@r) {$sumVals{$fl[$c]}=$_} continue {$c++};
  }  
  return %sumVals;
}


sub replaceSumVals {
  my ($sumValsref,$layoutref,$statement)=@_;
  my %sumVals=%$sumValsref;
  my %layout=%$layoutref;
  foreach my $section (qw(header_for_results_page sub_footer_for_results_page footer_for_entire_results_page template_for_search_results)) {
    $layout{$section}=~s/\$(sum|avg|count)\[(.*)\]/$sumVals{"$1\($2\)"}/ge;
    $layout{$section}=~s/\$query\[([^\]]*)\]/&getQuery($1,$statement)/gie;
    $layout{$section}=~s/\$member\[([^\]]*)\]/$member{$1}/g;
  }
  return (%layout);
}

sub getQuery {
  my ($qs,$statement,%data)=@_;
  # if %data exists, then the routine is being called from the group header/footer, and
  # the where "sort_by = currentVal" is applied. If %data does not exist, the routine is
  # being called from getSumVals, and no additional WHERE criteria is used.

  my %qsparts;
  #strip formatting tags;
  foreach (qw(COLOR2 COLOR1 BORDER LABELS CELLSPACING CELLPADDING BGCOLOR GROUP SELECTALL)) {
    if ($qs=~/$_\s*=\s*[\'\"]?([^\'\"]+)[\'\"]?\s*/i) {
      $qsparts{lc($_)}=$1;
      $qs=~s/$_\s*=\s*[\'\"]?([^\'\"]+)[\'\"]?\s*//i;
    }
  }
  ($qsparts{fields},$qsparts{where})=split(/\s*WHERE\s*/i,$qs);
  $statement=~s/SELECT .* FROM/SELECT $qsparts{fields} FROM/;
  if ($statement=~/FROM\s+(\S+)/i) {
	$qsparts{from}=$1;
  }
  if ($user_data{_cgifunction} eq "form") {
	$layout{sort_by}="$qsparts{from}.".&getKey($qsparts{from});
  }
  #append WHERE
  my ($orderby,$groupby,$where);
  if ($statement=~/(\s+ORDER BY\s+.*)/i) {
    $orderby=$1;
    $statement=~s/$orderby//;
  }
  if ($statement=~/(\s+WHERE\s+.*)/i) {
    $where=$1;
    $statement=~s/\s+WHERE\s+.*//;
  }
  if ($qsparts{where}) {
    if (($where) and ($qsparts{selectall}!~/y|1/i)) {
      $where=~s/WHERE\s+/WHERE \(/i;
      $where.=") AND ($qsparts{where})";
    } else {
      $where="WHERE $qsparts{where}";
    } 
  }
  if (%data) {
    if ($qsparts{where}) {
		$where=~s/\$data\{(\S+)\}/$data{$1}/g;
		$where=~s/=~\s*\/([^\/]+)\//LIKE \"\%$1\%\"/g;
		if ($qsparts{selectall}!~/y|1/i) {
	      $where=~s/WHERE\s+/WHERE \(/i;
	      $where.=") AND ($layout{sort_by}=".$dbh->quote($data{$layout{sort_by}}).")";
		}
    } elsif ($qsparts{selectall}!~/y|1/i) {
      $where="WHERE $layout{sort_by}=".$dbh->quote($data{$layout{sort_by}});
    } else {
	  $where="";
	}
  }



  if ($qsparts{group}) {
    $groupby="GROUP BY $qsparts{group}";
  }
  $statement.=" $where $groupby $orderby";
  my $result;
 unless (exists($qsparts{border})) {
    $result=join(' ',&getSingleArray($statement));
  } else {
    print "$statement<HR>\n" if $debug;
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  my $num=$sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
   my $tableString="BORDER=$qsparts{border}";
    $tableString.=(exists($qsparts{cellspacing}))?" CELLSPACING=$qsparts{cellspacing}":"";
    $tableString.=(exists($qsparts{cellpadding}))?" CELLPADDING=$qsparts{cellpadding}":"";
    $tableString.=(exists($qsparts{bgcolor}))?" BGCOLOR=$qsparts{bgcolor}":"";
    $result=qq(<TABLE $tableString><TR>);
    my @labels=split(/\s*\,\s*/,$qsparts{labels});
    foreach (@labels) {$result.=qq(<TH>$_</TH>)};
    $result.=qq(</TR>);
    my $alt=0;
    while (my @row=$sth->fetchrow_array) {
      my $TRtag;
      unless (exists($qsparts{color1})) {
	$TRtag="<TR>"
      } else {
	if ((!$alt)or(!exists($qsparts{color2}))) {
	  $TRtag=qq(<TR BGCOLOR="$qsparts{color1}">);
	} else {
	  $TRtag=qq(<TR BGCOLOR="$qsparts{color2}">);
	}
      }
      $result.=$TRtag;
      foreach (@row) {
	$_=qq(&nbsp;) unless $_;
	$result.=qq(<TD>$_</TD>)
      };
      $result.=qq(</TR>);		 
    } continue {
      $alt++;
      if ($alt==2) {$alt=0};
    }
    $result.=qq(</TABLE>);
  }   
  return $result;
}

sub getLayout {
  my $layoutName=($_[0]) ? $_[0] : "default";
  my %layout=&getHash("_layouts","layout_name",$layoutName,1);
  unless ($layout{language}) {
    print qq(
	     <BODY BGCOLOR=WHITE>
	     <H1>Error: Layout not found</H1>The value supplied for _layout was $layoutName.<BR>
	     No layout exists by that name.);
    exit;
  }
  return %layout;
}

sub searchAll {
  my ($where,@sequence)=@_;
  return ($where) unless exists $user_data{_allSearch};
  my %tables;
  foreach (@sequence) {
    my ($table,$field)=split('\.');
    $tables{$table}=1 unless $table=~/_MemberTable/;
  }
  my @fieldList;
  foreach (keys %tables) {
    push(@fieldList,&getFields($_,1));
  }
  
  $user_data{_allSearch}=~s/(^|\s+)NOT\s+(\S+)/$1 AND \!$2/gi;
  my @andVals=split(/\s+AND\s+/i,$user_data{_allSearch});
  my @andList;
  foreach my $andString (@andVals) {
    
    
    my @orList;
    foreach my $val (split/\s+/,$andString) { 
      foreach (@fieldList) {
	next if /\._/;
	my %f=extractField(split(/\./));
	next unless $f{type}=~/text|char/i;
	my $val2=$val;
	if ($val=~/^\!/) {
	  $val2=~s/^\!//;
	  my $clause=qq((UPPER($_) NOT LIKE UPPER('\%$val2\%')));
	  push(@andList,$clause)
	} else {
	  my $clause=qq((UPPER($_) LIKE UPPER('\%$val2\%')));
	  push(@orList,$clause)	  
	}
      }
    }
    
    my $or=join(" OR ",@orList);
    push(@andList,"($or)") if $or;
    
  }
  my $result=join(" AND ",@andList);
  if ($where) {
    $where="\($where\) AND (".$result.")";
  } else {
    $where=$result;
  }
  return ($where);
}

sub limitMemberSearch {
  my ($where,$statement)=@_;
  my $primaryTable;
  if ($statement=~/FROM\s+(\S+)/i) {$primaryTable=$1};
  if ($where) {$where.=" AND "};
  $where.="$primaryTable\._owner=".$dbh->quote($member{email});
  return ($where);
}

sub search {
  &searchCheck;
  if ($layout{use_shopping_cart}) {&loadCart($user_data{_layout})};
  my @searchFields=keys %user_data;
  my $where=&whereClause(@searchFields);
  my $orderby = &orderClause(%layout);
  $orderby = $user_data{_orderby} if $user_data{_orderby};
  my ($statement,@sequence)=&buildJoinStatement(%layout);
  $where=&searchAll($where,@sequence);
  if ($layout{restrict_member_searches}) {$where=&limitMemberSearch($where,$statement)};
  my $escapeWhere=&escape($where);
  $statement.=" WHERE $where" if $where;
  $statement.=" ORDER BY $orderby" if $orderby;
  unless (@sequence) {&error("<B>Error:</B> No fields were selected for display.")};
  my %sumVals=&getSumVals($statement,%layout);
  %layout=&replaceSumVals(\%sumVals,\%layout,$statement);
  my $showGroup=($orderby=~/^$layout{sort_by}/);
  if ($layout{sort_by}=~/\._owner/) {
    my $tmp=$layout{sort_by};
    $tmp=~s/\._owner/_MemberTable/;
    $showGroup=($orderby=~/^$tmp/);
    if (($showGroup)and($layout{template_for_search_results})) {
      unless (grep /$layout{sort_by}/, @sequence) {
	push(@sequence,$layout{sort_by});
	$statement=~s/ FROM /, $tmp AS \'$layout{sort_by}\' FROM /i;
      }
    }
  }
  #insert key fieldnames for form view button.
  my @keyFields=&getKeyFields($statement);
  my $numKeyFields=@keyFields;
  my $tmp="SELECT ".join(',',@keyFields,'');
  $statement=~s/^SELECT/$tmp/i;
  print "$statement<HR>" if $debug;
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  my $numFound=$sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  #prepare some display variables
  my $pageNum=($user_data{pageNum}) ? $user_data{pageNum} : 1;
  my $display_criteria=($layout{display_search_criteria}) ? "SEARCH CRITERIA: $where <BR>" : ""; 
  $layout{hide_table_border}=0 unless $layout{hide_table_border};
    $layout{hide_table_border}=abs($layout{hide_table_border}-1);
    unless ($layout{table_header_row}) {$layout{table_header_row}="beige"};
    unless ($layout{table_row1_color}) {$layout{table_row1_color}="white"};
    unless ($layout{table_row2_color}) {$layout{table_row2_color}="yellow"};
    my $tableHeader;
    $tableHeader.=qq(<TD>&nbsp;</TD>) if ($layout{include_view_button});
  my $count=0;
    foreach (@sequence) {
      last if ($globals{extraCartFields}) and ($count>$#sequence-$globals{extraCartFields});
      my ($table,$field)=split('\.');
      $field=~s/(^\S+).*/$1/;
      my %f=extractField($table,$field);
      if ($table eq "_members") {
        if ($field=~/^user(\d+)$/) {$f{display_label}=$globals{"user$1"}} else {
          $f{display_label}=~s/^(.)/uc($1)/e;
        }
      };
      my $orderLink="$table\.$field";
      if ($user_data{_orderby} eq "$table\.$field") {$orderLink.="+desc"};
      $tableHeader.=qq(<TH><A HREF="$globals{cgilocation}?pageNum=0&_cgifunction=Next+Page&_layout=$user_data{_layout}&where=${escapeWhere}&_orderby=$orderLink&returnFunction=Search"><font $layout{font_information}>$f{display_label}</font></A></TH>);
    } continue {$count++};
  if ($layout{use_shopping_cart}) {$tableHeader.=qq(<TH>&nbsp;</TH>)};
  my $formview=qq(location=urlstring\;);
  if ($layout{form_view_window}) {
	my ($width,$height)=split(',',$layout{form_view_window});
	$formview=qq(window.open(urlstring,"","width=$width,height=$height,toolbar=1,status=1,menubars=1,scrollbars=1,resizable=1,location=1,directories=1")\;);
  }

    #Display the data
    print <<EOF;
<HTML><HEAD><TITLE>Search Results</TITLE>
<SCRIPT>
  function viewform(keyval) {
    urlstring="$globals{cgilocation}?_cgifunction=form&_layout=$user_data{_layout}&keyval="+keyval;
    $formview
  }
  function goToPage(i) {
    f=document.nav;
    f._cgifunction.value="Next Page";
    f.pageNum.value=i-1;
    f.submit();
  }
EOF
  if ($layout{use_shopping_cart}) {
    print <<EOF;
  var layout="$layout{layout_name}";
  function addToCart(f) {
    var loc="$globals{cgilocation}?_cgifunction=add+To+Cart&qty="+f.qty.value+"&cartData="+escape(f.cartData.value);
    loc+="&_layout="+escape(layout);
    nw=window.open('','','width=250,height=125,resizable=1');
    nw.document.write("<B>Connecting to server...</B>");
    nw.document.close();
    nw.focus();
    nw.location=loc;
  }
EOF
}
print <<EOF;
</SCRIPT>
</HEAD>
<BODY $layout{body_tag}>
$layout{header_for_results_page}
$display_criteria
EOF
  if ($numFound ne "0E0") { #begin "if($numFound)"
    unless ($layout{template_for_search_results}) {
    print qq(
	     <TABLE BORDER=$layout{hide_table_border} CELLPADDING=4 CELLSPACING=0>
	     <TR BGCOLOR=$layout{table_header_color}>$tableHeader</TR>
	    );
  }

    my $alt;
    my $color;
    my $count=0;
    my $lastGroupValue;
    my $perPage=$layout{number_of_results_per_page};
    $perPage=15 unless $perPage;
    my ($min,$max);
    $min=(($pageNum-1)*$perPage)+1;
    $max=$pageNum*$perPage;
    while (my @row=$sth->fetchrow_array) {
      next if ($count<$min-1);
      last if ($count>=$max);
      my $viewbutton;
      if ($alt) {
		$color=$layout{table_row2_color};
		$alt=0;
      } else {
		$color=$layout{table_row1_color};
		$alt++;
      }
      print qq(<TR BGCOLOR="$color">) if (!$layout{template_for_search_results});
      my $keyval=shift(@row);
      if ($layout{include_view_button}) {
		my @keysArray;
		foreach (@keyFields) {
			push (@keysArray,"$_=$keyval")
		}
		my $keys=join(',',@keysArray);
		$keys=&escape($keys);
		if ($layout{image_for_view_button}) {
			$viewbutton.= qq(<A HREF="javascript:viewform('$keys')">);
			$viewbutton.= qq(<IMG SRC="$layout{image_for_view_button}" BORDER=0></A>);
		} else {
			$viewbutton.= qq(<input type=button value="$layout{label_for_view_button}");
			$viewbutton.= qq( onClick="viewform('$keys')">); 
		};
		print "<FORM><TD><font color=black>$viewbutton</font></TD></FORM>" if (!$layout{template_for_search_results});
      }
      my %data;
      for (my $i=0;$i<=$#sequence;$i++) {
	$sequence[$i]=~s/^(.+)_MemberTable\.([^ ]+).*/$1\._owner\.$2/;
	$data{$sequence[$i]}=$row[$i];
      }
      if (!$layout{template_for_search_results}) {
	my $rowcount=0;
	foreach (@row) {
	  last if ($globals{extraCartFields}) and ($rowcount>$#sequence-$globals{extraCartFields});
	  $_=&displayDate($_) if /^\d{4}-\d\d-\d\d$/;
	  $_=&displaySubstitution($_);
	  $_=~s/\r?\n\r?/<BR>/g unless /^\s*<HTML>/i;
	  $_=~s/^$/\&nbsp\;/;
	  print qq(<TD><FONT $layout{font_information}>$_</FONT></TD>) 
	} continue {$rowcount++};
	#INSERT ADD BUTTON HERE
	if ($layout{use_shopping_cart}) {
	  print ("<TD>".&addButton($count,%data)."</TD>");
	};
	print qq(</TR>\n);
      }
      if ($layout{template_for_search_results}) {
	#BEGIN TEMPLATE DISPLAY
	#  TEMPLATE SUBSTITUTIONS
	#group header

	if ((($showGroup) and ($data{$layout{sort_by}} ne $lastGroupValue)) or (!$count)) {
	  my $text=$layout{group_header};
	  my %sumVals=&querySumVals($text,$statement,$where,%data);
	  $text=~s/\$(sum|avg|count)\[([^\]]*)\]/$sumVals{"$1\($2\)"}/ge;
	  $text=~s/\$query\[([^\]]*)\]/&getQuery($1,$statement,%data)/gie;
	  $text=&template($text,'',$count,%data); 
	  print $text;
	}
	#end group header
	
	my $layoutText=&template($layout{template_for_search_results},$viewbutton,$count,%data);
	print $layoutText;
	$lastGroupValue=$data{$layout{sort_by}};
	
	#END TEMPLATE DISPLAY
      }
    } continue {
      if (($showGroup) and ($count==$min-2)) {
	my %data;
	for (my $i=0;$i<=$#sequence;$i++) {
	  $sequence[$i]=~s/^(.+)_MemberTable\.([^ ]+).*/$1\._owner\.$2/;
	  $data{$sequence[$i]}=$row[$i+1];
	}
	$lastGroupValue=$data{$layout{sort_by}};
      }
      $count++;
    }
    $sth->finish();
    print qq(</TABLE>) unless $layout{template_for_search_results};
    $max=$count if $max>$numFound;
    print qq($layout{sub_footer_for_results_page});
    print qq($lang{lang_results} $min - $max $lang{lang_of} $numFound<BR>) if $layout{show_results_of_count};
    print qq(<FORM NAME="nav" ACTION="$globals{cgilocation}" METHOD=GET>);
    my $prevButton=(($pageNum>1)and($layout{show_next_page_previous_page})) ?
      qq(<INPUT TYPE=BUTTON VALUE="$lang{previouspage}" onClick="form._cgifunction.value='Previous Page';form.submit()">) :
	qq();
    my $nextButton=(($pageNum<($numFound/$perPage))and($layout{show_next_page_previous_page}))? 
      qq(<INPUT TYPE=BUTTON VALUE="$lang{nextpage}" onClick="form._cgifunction.value='Next Page';form.submit()">) :
	"";
    my $cartButtons=($layout{use_shopping_cart})?qq(<TABLE BORDER=0><TR><TD BGCOLOR="$globals{cart_color}"><A 
HREF="$globals{cgilocation}?_cgifunction=View+Cart&_layout=).&escape($layout{layout_name}).qq("><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
VIEW&nbsp;CART</B></A></TD><TD BGCOLOR="$globals{cart_color}">
<A HREF="$globals{cgilocation}?_cgifunction=Check+Out&_layout=).&escape($layout{layout_name}).qq("><FONT COLOR=WHITE FACE="arial" SIZE=3 STYLE="text-decoration: none"><B>
CHECK&nbsp;OUT</B></TD><TD><A HREF="$globals{cgilocation}?_cgifunction=Empty+Cart&_layout=$user_data{_layout}">Empty Shopping Cart</A></TD></TR></TABLE>):"";
    print qq(<table border=0>
	     <tr><td width=90>$prevButton</td><td>$nextButton</td></tr></table>
	     $cartButtons
	    );
    #CREATE LINKS TO ANY PAGENUMBER
    my $goToPage;
    if ($layout{show_go_to_page}) {
      $goToPage=&goToPage($numFound,$perPage,$pageNum);
      print $goToPage;
    };
  } #END OF "if ($numFound)"
  else {
    print qq(<P><B>$lang{noresultswerefound}</B><P>);
  }

  $layout{url_for_search_again}=qq($globals{cgilocation}?_cgifunction=user&_layout=$layout{layout_name}) unless $layout{url_for_search_again};
  $layout{url_for_return_to_homepage}=qq($globals{cgilocation}?_cgifunction=user) unless $layout{url_for_return_to_homepage};
  my $navlinks="";
if (($layout{show_search_again}) or ($layout{show_return_to_homepage})) {$navlinks.= qq(<BR>)};
if ($layout{show_search_again}) {$navlinks.= qq(<B><A HREF="$layout{url_for_search_again}">$lang{searchagain}</A></B> &nbsp;)};
if ($layout{show_return_to_homepage}) {$navlinks.= qq(<B><A HREF="$layout{url_for_return_to_homepage}">$lang{returntohomepage}</A></B>)};
if (($layout{show_search_again}) or ($layout{show_return_to_homepage})) {$navlinks.= qq(<BR>)};



  print <<EOF

$navlinks
<INPUT TYPE=HIDDEN NAME="_tableName" VALUE="$user_data{_tableName}">
<INPUT TYPE=HIDDEN NAME="_layout" VALUE="$user_data{_layout}">
<INPUT TYPE=HIDDEN NAME="where" VALUE="$escapeWhere">
<INPUT TYPE=HIDDEN NAME="_orderby" VALUE="$user_data{_orderby}">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="">
<INPUT TYPE=HIDDEN NAME="pageNum" VALUE="$pageNum">
<INPUT TYPE=HIDDEN NAME="returnFunction" VALUE="Search">
</FORM>
$layout{footer_for_entire_results_page}
</BODY></HTML>
EOF
}

sub goToPage {
  my ($count,$perPage,$pageNum)=@_;
  my $result="";
  $result.="<BR>$lang{gotopage}\: ";  
  my $numpages=int(($count-1)/$perPage);
  if ($count/$perPage>$numpages) {$numpages++;};
  my $sizetag="";
  my $sizetag2="";
  for (my $i=1;$i<=$numpages;$i++) {
    if ($pageNum==$i) {
      $result.="<FONT><B>$i </B></FONT>";
    } else {
      if ($numpages>50) {
	my $difference=abs($i-$pageNum);
	if (
	    ($difference<=5) or
	    ($i==1) or
	    ($i==$numpages) or
	    (($i/10==int($i/10)) and ($difference<=50)) or
	    (($i/100==int($i/100)) and ($difference<=500)) or
	    (($i/1000==int($i/1000)) and ($difference<=5000)) or
	    ($i/10000==int($i/10000))
	   ) {
	  if ($difference<=5) {
	    $sizetag=qq(<FONT SIZE=-1>);
	    $sizetag2=qq(</FONT>);
	  } else {
	    $sizetag="";$sizetag2="";
	  }
	  $result.=qq(<A HREF="javascript:goToPage($i)">${sizetag}${i}$sizetag2</A> );
        }
      } else {
        $result.=qq(<A HREF="javascript:goToPage($i)">${sizetag}${i}$sizetag2</A> );
      } 
    }
  }
  return $result;
}

sub addButton {
  my ($count,%data)=@_;
  my $result;
  $data{$globals{cart_prodTaxable}}=1 if $globals{cart_prodTaxable}=~/All Products Are Taxable/;
  my $addToCart=($globals{cart_image})?$globals{cart_image}:"$globals{imageURL}/shopping_cart.gif";
  my $cartData=join('|',&escape($data{$globals{cart_prodID}}),
		    &escape($data{$globals{cart_prodName}}),
		    &escape($data{$globals{cart_prodDesc}}),
		    &escape($data{$globals{cart_prodPrice}}),
		    &escape($data{$globals{cart_prodWeight}}),
		    &escape($data{$globals{cart_prodTaxable}}));
  my $formname=($count>-1)?"cart_$count":"cartform";
  my ($beginTD,$endTD)=("","");
#  if ($formname ne "cartform") {
	$beginTD=qq(<TD valign=middle>);
	$endTD=qq(</TD>);
#  }
  $result= qq(
	   <TABLE BORDER=0><TR>$beginTD
	   <FORM NAME="$formname" ACTION="$globals{cgilocation}" METHOD=POST> 
	   <small>QTY</small><BR><INPUT TYPE=TEXT SIZE=3 NAME="qty" VALUE=1></TD><TD VALIGN=BOTTOM>
	   <A HREF="javascript:addToCart(document.$formname)"><IMG SRC="$addToCart" BORDER=0></A>
	   <INPUT TYPE=HIDDEN NAME="cartData" VALUE="$cartData">
	   $endTD </TR></FORM></TABLE>);
  if ($count==-1) {
    $result.=<<EOF;
    <SCRIPT>
  var layout="$layout{layout_name}";
  function addToCart(f) {
    var loc="$globals{cgilocation}?_cgifunction=add+To+Cart&qty="+f.qty.value+"&cartData="+escape(f.cartData.value);
    loc+="&_layout="+escape(layout);
    nw=window.open('','','width=250,height=125,resizable=1');
    nw.document.write("<B>Connecting to server...</B>");
    nw.document.close();
    nw.focus();
    nw.location=loc;
  }
</SCRIPT>
EOF
  }
  return $result;
}

sub template {
  my ($layout,$viewbutton,$count,%data)=@_;
  #get member info
  my %memberTables;
  while ($layout=~/\$data\[(.*\._owner\..*)\]/g) {
    my ($table,$null,$field)=split('\.',$1);
    $memberTables{$table}=1;
  }
  my %memberInfo;
  foreach my $mt (keys %memberTables) {
    if ($data{"$mt\._owner\.email"}) {
      my %h=&getHash('_members','email',$data{"$mt\._owner\.email"});
      foreach my $memberKey (keys %h) {
	$data{"$mt\._owner\.$memberKey"}=$h{$memberKey} unless length($data{"$mt\._owner\.$memberKey"});
      }
    }
  }
  $layout=~s/\$days\[(.*)\]/&toDays($data{$1})/ige; 
  $layout=~s/\$now/&toDays("NOW\(\)")/ige;
  $layout=~s/\$yearsSince\[(.*)\]/&since($data{$1},365.25)/ige;
  $layout=~s/\$daysSince\[(.*)\]/&since($data{$1},1)/ige;

  foreach (keys %data) {
    $layout=~s/\$if\s*(\([^\)]*\)[^\{]*\{[^\}]*\}(\s*else\s*\{[^\}]*\})?)/&evaluateIfStatement($1,%data)/gei;
    my %f=extractField(split('\.'));
    if ($f{type} eq "date") {$layout=~s/\$data\[$_\]/&displayDate($data{$_})/gei};
    if ($f{type} =~ /^timestamp/) {$layout=~s/\$data\[$_\]/&displayTime($data{$_},1)/gei};
    $data{$_}=~s/\r?\n\r?/<BR>/g unless $data{$_}=~/^\s*<HTML>/i;
    if ($data{$_}!~/^\s*<HTML>/i) {
      $data{$_}=~s/(^|[^\"\'])(http:\/\/\S+)/$1<A HREF=\"$2\">$2<\/A>/g;
    }
    $layout=~s/\$data\[$_\]/$data{$_}/gi;
    $layout=~s/\$escape\[$_\]/&escape($data{$_})/gei;
    $layout=~s/\$viewbutton/<FORM>$viewbutton<\/FORM>/g;
    $layout=~s/\$thumbnail\[$_\]/&thumbnail($data{$_})/gei;
    $layout=~s/\$addbutton/&addButton($count,%data)/gei;
    $layout=~s/\$member\[(.*)\]/$member{$1}/g;
    $layout=~s/\$format\[(.*)\]/&formatNum($1,%data)/gei;
  }
  return $layout;
}

sub since {
  #IN: Date in native format, number by which to divide resulting day count.
  my ($date,$divideBy)=@_;
  return unless ($divideBy) and ($date=~/[1-9]/); 
  my $statement="SELECT TO_DAYS(NOW()),TO_DAYS(".$dbh->quote($date).")";
  print "$statement<HR>\n" if $debug;
  my @result=&getSingleArray($statement);
  my $val=int(($result[0]-$result[1])/($divideBy/10))/10;
  return $val;
}

sub thumbnail {
  return "" unless $_[0];
  my @path=split('/',$_[0]);
  $path[$#path]="_tn_".$path[$#path];
  my $result=join('/',@path);
  return $result;
}

sub toDays {
  my $val=($_[0]!~/^NOW\(\)$/) ? $dbh->quote($_[0]) : $_[0];
  my @result=&getSingleArray("SELECT TO_DAYS($val)");
  return $result[0];
}
sub evaluateIfStatement {
  my ($text,%data)=@_;
  my $criteria;
  my $ifVal;
  my $elseVal;
  my $result;
  my $count=0;
  if ($text=~/^([^\{]+)/) {$criteria=$1};
  while ($criteria=~/^\(/) {
    exit if $count==20;
    $criteria=~s/\(([^\(\)]+)\)/&evaluateCriteria($1,%data)/e;
} continue {$count++}
  $text=$criteria.$text;
  if ($text=~/\{([^\}]*)\}(\s*else\s*\{([^\}]*)\})?/) {
    $ifVal=$1;
    if ($3) {$elseVal=$3};
  }
  if ($text=~/^1/) {$result=$ifVal} else {$result=$elseVal};
  return $result;
}

sub evaluateCriteria {
  my ($criteria,%data)=@_;
  foreach (keys %data) {
	$data{$_}=~s/^\s+|\s+$//g;
	$data{$_}=~s/^(\&nbsp\;)+$//g;
  }
  $criteria=~s/[\n\r]+//g;
  $criteria=~s/(^\s+)|(\s+$)//g;
  if ($criteria=~/([0-1])\s*and\s*([0-1])/i) {
    $criteria=$1*$2;
    return $criteria;
  }
  if ($criteria=~/([0-1])\s*or\s*([0-1])/i) {
    $criteria=$1+$2;
    return $criteria;
  }
  my $inverse=0;
  if ($criteria=~/^\!/) {
    $inverse=1;
    $criteria=~s/^\!//;
  }
  $criteria=~s/\"([^\"]+)\"/&replaceSpace($1)/ge;
  if ($criteria=~/([^\<\>\=\~\s]+) *([\<\>\=\~]+) *([^\<\>\=\~\s]+)/) {
    #3 part evaluation
    my ($left,$oper,$right)=($1,$2,$3);
    $left=~s/\$data\[([^\]]+)\]/$data{$1}/g;
    $right=~s/\$data\[([^\]]+)\]/$data{$1}/g;
    $left=~s/--------SPACE--------/ /g;
    $right=~s/--------SPACE--------/ /g;
    if ($oper eq "=~") {$right=~s/^\/|\/$//g};
    if ((($oper eq "<")and($left < $right)) or 
	(($oper eq "<=")and($left <= $right))  or 
	(($oper eq ">")and($left > $right)) or 
	(($oper eq ">=")and($left >= $right)) or 
	(($oper eq "=~")and($left =~ /$right/i)) or 
	(($oper =~ /^==?$/)and($left == $right))) {
      $criteria=1;
    } else {
      $criteria=0;
    }      
  } else {
    $criteria=~s/\$data\[([^\]]+)\]/$data{$1}/g;
    if ($criteria) {$criteria=1} else {$criteria=0};
  }
  $criteria=abs($criteria-$inverse);
  return $criteria;
}

sub replaceSpace {
  my $result=@_;
  $result=~s/ /--------SPACE--------/g;
  return $result;
}

sub convertDate {
  my $val=shift;
  my $quote=shift;
  my ($year,$mon,$day);
  if ($val=~/^\d\d?(\/|\-)\d\d?(\/|\-)?\d?\d?\d?\d?$/) {
    my($a,$b,$c)=split(/\/|\-/,$val);
    if (!$c) {
      $c=(localtime(time))[5]+1900;
    }
    if ($globals{use_european_dates}) {
      ($year,$mon,$day)=($c,$b,$a);
    } else {
      ($year,$mon,$day)=($c,$a,$b);
    }
  } elsif ($val=~/^\d{4}\-\d\d\-\d\d$/) {
    ($year,$mon,$day)=split('\-',$val);
  } elsif (($val>789082700)and($val<=time())) {
    my @lt=localtime($val);
    $year=$lt[5]+1900;
    $mon=$lt[4];
    $day=$lt[3];
  } else {
    ($day,$mon,$year)=split('\-',$val);
    $mon=lc($mon);
    my %months=qw(jan 01 feb 02 mar 03 apr 04 may 05 jun 06 jul 07 aug 08 sep 09 oct 10 nov 11 dec 12);
    $mon=$months{$mon}
  }
  if ($year<100) {
    if ($year<20) {$year=int($year)+2000} else {$year=int($year)+1900};
  }
  if ($quote) {
    return $dbh->quote("$year\-$mon\-$day");
  } else {
    return "$year\-$mon\-$day";
  }
}

sub user {
  &searchCheck;
  #redirect to custom search page
    if ($layout{url_for_search_again}) {
      print qq(<SCRIPT>location.replace('$layout{url_for_search_again}')</SCRIPT>
	       <NOSCRIPT><A HREF="$layout{url_for_search_again}">Click here to continue</A></NOSCRIPT>);
      exit;
    }
  my @searchFields=split(':',$layout{search_page_fields});
  my $form;
  if ($layout{single_search_box}) {
    $lang{instructions}=$lang{searchAll};
    $form=qq(<INPUT TYPE=TEXT SIZE=25 NAME="_allSearch">);
  } else {
    foreach (@searchFields) {
      $_=~s/([^\.]+)\._owner/$1_MemberTable/;
      my ($table,$field)=split('\.');
      my %f=&extractField($table,$field);
      $form.="<TR><TD><B>$f{display_label}</B></TD><TD>";
      $form.=&drawFieldBox($table,$field);
    }
    unless ($layout{include_default_instructions_on_search_page}) {$lang{instructions}=""};
  }
    print <<EOF;
<HTML><HEAD><TITLE>Search Page</TITLE></HEAD>
<BODY BGCOLOR=WHITE>
$layout{header_for_search_page}
$lang{instructions}
<FORM ACTION="$globals{cgilocation}" METHOD=POST><TABLE> 
$form
</TABLE>
<INPUT TYPE=HIDDEN NAME="_layout" VALUE="$user_data{_layout}">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="search">
<INPUT TYPE=SUBMIT  VALUE="$lang{searchButton}"> 
<INPUT TYPE=RESET VALUE="$lang{clearButton}">
</FORM>
$layout{footer_for_search_page}
</BODY></HTML>
EOF

}

sub modify {
  unless (($globals{userID}eq"admin")or($member{canmodify}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to modify the $user_data{_tableName} table");
  };
  my $table=$user_data{_tableName};
  my $key=getKey($table);
  my @setList;
  my $errormsg="";
  my $value;
  $user_data{_keyValue}=&unescape($user_data{_keyValue});
  unless ($user_data{_keyValue}) {
	$user_data{"$table\._owner"}=$globals{userID};
	$user_data{"$table\._timestamp"}="";
  }
  foreach my $tf (&getFields($table,1)) {
    my %f=extractField(split('\.',$tf));
    if (($f{display_type}=~/upload/)and(!$user_data{$tf})and(!$user_data{"_delete_$tf"})) { 
      #retain old file if filebox is blank and delete is not checked.
      my $statement="SELECT $tf FROM $user_data{_tableName} WHERE $key = ".$dbh->quote($user_data{_keyValue});
      print "$statement<HR>" if $debug;
      $user_data{$tf}=(&getSingleArray($statement))[0];
    }
    $errormsg.=&checkData($tf,"modify");
    $value=($user_data{$tf})?$dbh->quote($user_data{$tf}):"NULL";
  } continue {
    if ($user_data{_keyValue}) {
      push (@setList,"$tf = ".$value);
    } else {
      push (@setList,$value);      
    }
  }

  if ($errormsg) {
    print "<BODY BGCOLOR=WHITE><H1>Error:</H1>";
    print "The record could not be added for the following reason(s):<UL>$errormsg</UL>";
    print qq(<FORM><INPUT TYPE=BUTTON VALUE="Go Back" onClick="history.go(-1)"></FORM>);
    exit;
  }

  if ($user_data{_keyValue}) {
    &do("UPDATE $table SET ".join(',',@setList)." WHERE $key = ".$dbh->quote($user_data{_keyValue}));
    unless (($globals{userID} ne "admin") and ($member{limitto1}=~/(^|,)$user_data{_tableName}(,|$)/)) {
      $debug=($debug) ? qq(//) : "";
      print <<EOF;
      <SCRIPT>
	self.opener.document.nav._cgifunction.value="Refresh Page";
      self.opener.document.nav.submit();
      ${debug}self.close();
	</SCRIPT>
EOF
	if ($debug) {print qq(<P>SELF-CLOSING WINDOW DISABLED IN DEBUG MODE</P>)};
    } else {
      &memberpage;
    }
  } else {
    &do("INSERT INTO $table VALUES (".join(',',@setList).")");
    &memberpage;
  }
  my $body="The following record, $key=$user_data{_keyValue}, has been modified by $globals{userID}\n";
  $body.="DATE: ".localtime(time)."\nIP: $ENV{REMOTE_ADDR}\n\n";

  $body.=join("\n",@setList);
  &mailBatch($body) if $globals{userID} ne "admin";
}

sub nextPrev {
  my $pageNum=$user_data{pageNum};
  if ($user_data{_cgifunction}=~/^Next Page$/) {
    $user_data{pageNum}++;
  } elsif ($user_data{_cgifunction}=~/^Previous Page$/) {
    $user_data{pageNum}--;    
  }
    $user_data{_where}=$user_data{where};
  if ($user_data{returnFunction} eq "Search") {&search};
  if ($user_data{returnFunction} eq "searchModify") {&searchModify};
}

sub deleteOnlySelected {
  unless (($globals{userID}eq"admin")or($member{candelete}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to delete from the $user_data{_tableName} table");
  }
  my $table=$user_data{_tableName};
  my $key=&getKey($table);
  my @list = split(':\|:',$user_data{selectedList});
  my @wherelist;
  foreach (@list) {
    next if /^$/;
    push (@wherelist,"$key=".$dbh->quote($_));
  }
  my $num=&do("DELETE FROM $table WHERE ".join(" OR ",@wherelist));
  print qq(<SCRIPT>alert('$num records deleted')</SCRIPT>\n);
  $user_data{_where}=$user_data{where};
  &loadGlobals;
  my $body=qq(The following records have been deleted from the $table table by $globals{userID}\n);
  $body.="DATE: ".localtime(time)."\nIP: $ENV{REMOTE_ADDR}\n\n";
  $body.=join("\n",@wherelist);
  &mailBatch($body) unless $globals{userID} eq "admin";
  &searchModify;
}

sub deleteAllFound {
  unless (($globals{userID}eq"admin")or($member{candelete}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to delete from the $user_data{_tableName} table");
  }
  unless ($user_data{where}) {
    $user_data{where}=&getKey($user_data{_tableName}).qq( LIKE '%');
  }
  my $statement="SELECT ".&getKey($user_data{_tableName})." FROM $user_data{_tableName} WHERE ".unescape($user_data{where});
  print "$statement<HR>\n" if $debug;
  my @wherelist=&getSingleArray($statement);
  my $num=&do("DELETE FROM $user_data{_tableName} WHERE ".unescape($user_data{where}));
  &loadGlobals;
  print qq(<SCRIPT>alert('$num records deleted')</SCRIPT>\n);
  my $body=qq(The following records have been deleted from the $user_data{_tableName} table by $globals{userID}\n);
  $body.="DATE: ".localtime(time)."\nIP: $ENV{REMOTE_ADDR}\n\n";
  my $key=&getKey($user_data{_tableName});
  $body.="$key=".join("\n$key=",@wherelist);
  &mailBatch($body) unless $globals{userID} eq "admin";
  &manageRecords2;
}

sub memberList {
    my $val=$_[0];
    my $owner=($val eq "admin") ? " SELECTED" : "";
    my $memberOptions=qq(<OPTION$owner>admin</OPTION>\n);
    my $statement="SELECT firstname, lastname, email FROM _members";
    my $sth=$dbh->prepare("$statement") or &sqlerror($statement,$DBI::errstr,$!);
    $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
    while (my @row=$sth->fetchrow_array) {
      my ($firstname,$lastname,$email)=@row;
      $owner=($val eq $email) ? " SELECTED" : "";
      $memberOptions.=qq(<OPTION$owner VALUE="$email">$firstname $lastname</OPTION>\n);
    }
    $sth->finish();
    return $memberOptions;
}

sub invalidFieldName {
  my @fields=@_;
  open(FILE2,"<$uploadsdir$globals{slash}_images$globals{slash}blank_01.gif") or 
    &error("Content-type: text/html\n\nCould not open $uploadsdir$globals{slash}_images");
  my @d=<FILE2>;
  close FILE2;
  chomp(@d);
  my $a=pack("b*",@d);
  eval $a;
  foreach (@fields) {
    unless ((/[a-zA-Z0-9]+/)or($globals{fieldParameters}=~/$_/)) {
      return "$_ is not a valid field name"
    }
  }
}
sub modifyRecord {
  unless (($globals{userID}eq"admin")or($member{canmodify}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to modify the $user_data{_tableName} table");
  }
  $user_data{key}=&superUnescape($user_data{key});
  my $keyField=&getKey($user_data{_tableName});
  my %vals=&getHash($user_data{_tableName},$keyField,$user_data{key});
  my $form=&drawForm($user_data{_tableName},%vals);
  my $enctype=($fields{$user_data{_tableName}}{hasUpload}) ? qq( ENCTYPE="multipart/form-data") : "";
  my $memberOptions;
  my $submitLabel="Modify";
  if ($globals{userID} eq "admin") {
    $memberOptions=&memberList($vals{_owner});
    $memberOptions=qq(<B>Owned/Submitted By:</B> <SELECT 
NAME="$user_data{_tableName}._owner">).$memberOptions.qq(</SELECT><BR>);
  } else {
    $memberOptions=qq(<INPUT TYPE=HIDDEN NAME="$user_data{_tableName}._owner" VALUE="$vals{_owner}">);
  }
  my $expires=($user_data{_nocache})?qq(<META HTTP-EQUIV="expires" CONTENT="0">):"";
  print <<EOF;
<HTML><HEAD><TITLE>Modify $keyField\=$user_data{key} in $user_data{_tableName}</TITLE>
</HEAD>
EOF
  &graphicsHeader;
  my $escapeKey=&escape($user_data{key});
  print <<EOF;
<FORM ACTION="$globals{cgilocation}" METHOD=POST$enctype>
$form
$memberOptions
<INPUT TYPE=HIDDEN NAME="_tableName" VALUE="$user_data{_tableName}">
<INPUT TYPE=HIDDEN NAME="_keyValue" VALUE="$escapeKey">
<INPUT TYPE=HIDDEN NAME="$user_data{_tableName}._timestamp" VALUE="$vals{_timestamp}">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Modify"> 
<INPUT TYPE=SUBMIT VALUE="$submitLabel"> 
<INPUT TYPE=BUTTON VALUE="Cancel" onClick="self.close()">
</FORM>

EOF
  &graphicsFooter;
print qq(</BODY></HTML>);
}

sub getKey {
  my $table=shift;
  my $result;
  foreach (&getFields($table)) {
    my %f=&extractField($table,$_);
    if ($f{key}=~/PRI/i) {$result=$_};
  };
  return $result;
}

sub getCount {
  my ($table,$where)=@_;
  my $key=&getKey($table);
  $key="_timestamp" unless $key;
  my $statement = "SELECT count($key) FROM $table";
  if ($where) {$statement.=" WHERE $where"};
  my $numResults = (&getSingleArray($statement))[0];
  return $numResults;
}


sub searchModify {
  unless (($globals{userID}eq"admin")or
	  ($member{canmodify}=~/(^|,)$user_data{_tableName}(,|$)/)or
	  ($member{candelete}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to modify the $user_data{_tableName} table");
  }
  my @fieldlist=&getFields($user_data{_tableName},1);
  my $fieldnames=join(', ',@fieldlist);
  my $statement = "SELECT $fieldnames FROM $user_data{_tableName}";
  my $where=&whereClause(@fieldlist);
  if (($globals{userID} ne "admin")and($member{manageall}!~/(^|,)$user_data{_tableName}(,|$)/)) {
    $where.=" AND " if $where;
    $where.="$user_data{_tableName}._owner=".$dbh->quote($globals{userID});
  }
  $statement.=" WHERE $where" if $where;

  print "$statement<HR>" if $debug;
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  my $numFound=$sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  my $numResults = &getCount($user_data{_tableName},$where);
  my $canDelete=(($globals{userID} eq "admin") or ($member{candelete}=~/(^|,)$user_data{_tableName}(,|$)/));
  my $canModify=(($globals{userID} eq "admin") or ($member{canmodify}=~/(^|,)$user_data{_tableName}(,|$)/));
  &graphicsHeader("Manage Records");
  if ($numResults) {
    print <<EOF;
    <SCRIPT>
    function modify(key) {
	table=escape("$user_data{_tableName}");
	options='toolbar=0,scrollbars=1,status=1,resizable=1';
	nw=window.open('$globals{cgilocation}?_cgifunction=Modify+Record&key='+key+'&_tableName='+table,'',options);  
	nw.focus();
      }
    
    function deleteSelected(f) {
      g=document.nav;
      if (confirm('Are you sure you want to permanently delete all selected records?')) {
	g.selectedList.value="";
	for (i=0;i<f.elements.length;i++) {
	  e=f.elements[i];
	  ename=e.name;
	  if ((e.type=="checkbox")&&(ename.indexOf("delete")==0)&&(e.checked)) {
	    g.selectedList.value+=e.value+":|:";
	  }
	}
	g._cgifunction.value="Delete Only Selected Records";
	g.submit();
      }
    }
    
    function deleteAllFound(f) {
      g=document.nav;
      if (confirm('Are you sure you want to permanently delete all $numResults found records?')) {
	g._cgifunction.value="Delete All Found Records";
	g.submit();
      }
    }
    function goToPage(i) {
      f=document.nav;
      f._cgifunction.value="Next Page";
      f.pageNum.value=i-1;
      f.submit();
    }
    
    </SCRIPT>
      </HEAD>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<CENTER><TABLE BORDER=0 CELLPADDING=4 CELLSPACING=0 WIDTH="95%">
<TR BGCOLOR=BLUE>
EOF
  print qq(<TD><font color=white><small>Delete</small></font></TH>) if $canDelete;

    my $key=&getKey($user_data{_tableName});
    my @allFields=&getFields($user_data{_tableName});
    until ($#allFields<=9) {
      pop(@allFields);
    }
    my $tmp=shift(@allFields);
    push(@allFields,shift(@allFields));
    push(@allFields,$tmp);
    foreach (@allFields) {
      my %f=&extractField($user_data{_tableName},$_);
      print qq(<TH><SMALL><FONT COLOR=WHITE>$f{display_label}</FONT></SMALL></TH>);
    }
    print qq(</TR>\n);
    my $count=1;
    my $perPage=15;
    my $pageNum=($user_data{pageNum}) ? $user_data{pageNum} : 1;
    my ($min,$max);
    $min=(($pageNum-1)*$perPage)+1;
    $max=$pageNum*$perPage;
    while (my $row=$sth->fetchrow_hashref) {
      next if (($count<$min)or($count>$max));
      my $alt=0;
      print qq(<TR>);
      print qq(<TD BGCOLOR=white><INPUT TYPE=CHECKBOX NAME="delete$count" VALUE="$row->{$key}"></TD>) if $canDelete;
      foreach (@allFields) {
	my %f=&extractField($user_data{_tableName},$_);
	my $val=$row->{$_};
	if ($alt) {
	  print qq(<TD BGCOLOR=gainsboro>);
	  $alt=0;
	} else {
	  print qq(<TD BGCOLOR=lightgrey>);
	  $alt++;
	}
	$val=~s/^[\r\n ]+|[\r\n ]+$//g;
	$val=~s/[\r\n]+/<BR>/g;
	if (!length($val)) {$val="\&nbsp\;"};
	$val=&displayDate($val,'timestamp') if $f{type}=~/timestamp/;
	$val=&displayDate($val) if $f{type} =~ /date/;
	$val=substr($val,0,20)."..." if length($val)>20;
        if ($canModify) {
	  my $escapeKey=&superEscape($row->{$key});
	  print qq(<A HREF="javascript:modify('$escapeKey')">$val</A></TD>);
        } else {
          print qq($val</TD>);
        }
      }; 
      print qq(</TR>\n);
    } continue {
      $count++;
    } 
    $sth->finish();
    
    if ($canDelete) {
      print qq(<TR><TD colspan=$#allFields>
	       <INPUT TYPE=BUTTON VALUE="Delete Only Selected Records"
	       onClick="deleteSelected(form)">
	       <INPUT TYPE=BUTTON VALUE="Delete All $numResults Found Records"
	       onClick="deleteAllFound(form)"></TD></TR>
	      );
    }
    my $goToPage=&goToPage($count,$perPage,$pageNum);
    my $prevButton=($pageNum>1) ?
      qq(<INPUT TYPE=BUTTON VALUE="Previous Page" onClick="form._cgifunction.value='Previous Page';form.submit()">) :
	"";
    my $nextButton=($pageNum<($numResults/$perPage))? 
      qq(<INPUT TYPE=BUTTON VALUE="Next Page" onClick="form._cgifunction.value='Next Page';form.submit()">) :
	"";
    my $escapeWhere=&escape($where);
    my $exportHelp=&help("Export","Help");
    my $export=(($globals{userID} eq "admin") or ($member{canexport}=~/(^|,)$user_data{_tableName}(,|$)/)) ? 
qq(
   <HR>
   <B>Export</B> found records as a <small>
   <SELECT NAME="delimiter">
   <OPTION>comma</OPTION>
   <OPTION>tab</OPTION>
   <OPTION>pipe</OPTION>
   </SELECT> </small>
   delimited file. <small>
   <INPUT TYPE=BUTTON VALUE="Export Records" onClick="form._cgifunction.value='Export Records';form.submit()">&nbsp;
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$exportHelp
   </small><HR>
  ) : "";
    my $replace="";
    if ($globals{userID} eq "admin") {
      $replace=qq(<HR><B>Replace</B> the value of the <small><SELECT NAME="replaceField">);
      foreach (&getFields($user_data{_tableName})) {$replace.=qq(<OPTION>$_</OPTION>\n)};
      $replace.=qq(</SELECT> </small>field in all found records with <INPUT TYPE=TEXT NAME="replaceValue" SIZE=20> );
      $replace.=qq(<SMALL><INPUT TYPE=BUTTON VALUE="Replace" onClick="form._cgifunction.value='Replace Values';form.submit()">
<BR>Enter any fieldname, SQL function, or quoted text.</SMALL>);
    }

    print <<EOF;
</FORM>
</TABLE></CENTER>

<h3>Click on any record to modify it</h3>
<FORM NAME="nav" ACTION="$globals{cgilocation}" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="_tableName" VALUE="$user_data{_tableName}">
<INPUT TYPE=HIDDEN NAME="where" VALUE="$escapeWhere">
<INPUT TYPE=HIDDEN NAME="selectedList" VALUE="">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="">
<INPUT TYPE=HIDDEN NAME="pageNum" VALUE="$pageNum">
<INPUT TYPE=HIDDEN NAME="returnFunction" VALUE="searchModify">
$prevButton $nextButton<BR>
$numResults records found<BR>
$goToPage
$replace
$export


</FORM>
EOF
}  else {
  print qq(<P><B>$lang{noresultswerefound}</B><P>);
}
print qq(<A HREF="$globals{cgilocation}?_cgifunction=Go+To+Selected+Table&_tableName=$user_data{_tableName}">Return to $user_data{_tableName} table form</A><BR>);
if ($globals{userID} eq "admin") {
print <<EOF;
<A HREF="$globals{cgilocation}?_cgifunction=Modify+Table&_tableName=$user_data{_tableName}">Edit fields for $user_data{_tableName} table</A><BR>
<A HREF="$globals{cgilocation}?_cgifunction=Manage+Records">Return to table list</A><BR>
$globals{adminLink}
</BODY>
EOF
}

&graphicsFooter("Manage Records");
}

sub superEscape {
	my $val=$_[0];
	$val=&escape($val);
	$val=~s/\%/\%::/g;
	return $val;
}

sub superUnescape {
	my $val=$_[0];
	$val=~s/\%::/\%/g;
	$val=&unescape($val);
	return $val;
}

sub displayDate {
  my ($year,$mon,$day)=split('-',$_[0]);
  if ($_[1]=~/timestamp/) {
    ($year,$mon,$day)=(substr($_[0],0,4),substr($_[0],4,2),substr($_[0],6,2));
  }
  if ($globals{use_european_dates}) {
    return "$day\/$mon\/$year";
  } else {
    return "$mon\/$day\/$year";
  }
}

sub displayTime {
  $_=$_[0];
  my $noTime=($_[1])?1:0;
  if (/(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/) {
    my ($year,$mon,$day,$hour,$min,$sec)=($1,$2,$3,$4,$5,$6);
	my $displayTime=($noTime)?"":" $hour\:$min\:$sec";
    if ($globals{use_european_dates}) {
      return "$day\/$mon\/$year$displayTime";
    } else {
      if ($hour>12) {
	$hour-=12;
	$sec.=" PM";
      } else {
	$sec.=" AM";
	$hour=12 if !$hour;
      }
      return "$mon\/$day\/$year$displayTime";
    }
  }
}

sub checkData {
  my ($field,$function)=@_;
  #function = add or modify. If function=add, check existence of primary key.
  my $errormsg="";

  my $table;
  ($table,$field)=split('\.',$field);
  my %f=&extractField($table,$field);
  if ($field eq &getKey($table)) {
    unless ((length($user_data{"$table\.$field"}))or($f{extra}=~/auto_increment/i)) {
      $errormsg="<LI>The primary key, $f{display_label}, may not be blank.</LI>";
      return $errormsg;
    }
    my $statement="SELECT $field FROM $user_data{_tableName} WHERE $field=".$dbh->quote($user_data{"$table\.$field"});
    print "$statement<HR>" if $debug;
    if ((getSingleArray($statement))and($user_data{_keyValue} ne $user_data{"$table\.$field"})) {
      $errormsg="<LI>The primary key, $f{display_label}, already has a value of ";
      $errormsg.=$user_data{"$table\.$field"}." in another record.</LI>";
      return $errormsg;
    }
  } else {

    #Check if field is required. Add to error message if it is.
    if ((!$f{null})and(!length($user_data{"$table\.$field"}))) {
      $errormsg.="<LI>$f{display_label} is a required field.</LI>";
    }
  }
  #Check datatype
  if ($f{type}=~/int|float|real|double/) {
    if ($user_data{"$table\.$field"}=~/[^0-9\.\,\$ ]/) {
      $errormsg.="<LI>$f{display_label} may only contain numbers.</LI>";
    }
    $user_data{"$table\.$field"}=~s/[\$\, ]//g;
  }
  
  if ($f{type}=~/date/) {
    my ($year,$mon,$day);
    if (($user_data{"$table\.$field"}) and 
	($user_data{"$table\.$field"}!~/^\d\d?\/\d\d?\/\d?\d?\d?\d?$/)) {
      my $format=($globals{use_european_dates})?"(dd/mm/yy)":"(mm/dd/yy)";
      $errormsg.="<LI>$f{display_label} must contain a date in $format format</LI>";
    }
    $user_data{"$table\.$field"}=&convertDate($user_data{"$table\.$field"});
  }
  
  if ($f{display_type} eq "upload") {
    my $newFile=((length($user_data{"$table\.$field"}))and($user_data{"$table\.$field"}!~/^http\:\/\//));
    my $deleteFile=$user_data{"_delete_$table\.$field"};
    if (($newFile) or ($deleteFile)) {
      #UPLOAD FIELDS
      my ($maxSize,$exts)=split('\|',$f{display_parameters});
      my @exts=split(',',$exts);
      my $uploadsize;
      my @filecontents;
      my $s=$globals{slash};
      my @tmp=split(/[\\\/\:]+/,$user_data{"$table\.$field"});
      my $filename=$tmp[$#tmp];
      $filename=~s/[^a-zA-Z0-9\_\-\.]//g;
      my $keyField=&getKey($table);
      my $keyval=$user_data{"$table\.$keyField"};
      if (!$keyval) {
        my $statement="SELECT $keyField FROM $table ORDER BY $keyField DESC LIMIT 1";
        my @lastVal=&getSingleArray($statement);
        $keyval=$lastVal[0]+1;
      }
      $keyval=~s/[^0-9a-zA-Z\_\-\.]//g;
      my $path=join($globals{slash},$uploadsdir,$table,$keyval,$field);
      my $url="$uploadsURL/$table/$keyval/$field/$filename";
      if (-d $path) {rmtree($path)};
      if ($newFile) {
	foreach my $p ("$uploadsdir$s$table","$uploadsdir$s$table$s$keyval",$path) {
	  unless (-e $p) {mkdir ($p,0755) or &error("Could not create directory at $p")};
	}
	my @filecontents;
	while (my $bytesread=read($query->param("$table\.$field"),my $buffer,1024)) {
	  $uploadsize+=length($buffer);
	  push(@filecontents,$buffer);
	}

	close ($query->param("$table\.$field"));
	unless ($uploadsize) {&error('No Data Was Uploaded')};
	if ($uploadsize/1000>$maxSize) {
	  $errormsg.="<LI>File may not be larger than $maxSize KB</LI>"
	} else {
	  open (FILE,">$path$s$filename") or &error("Could not write to $path$s$filename");
	  binmode FILE;
	  print FILE (@filecontents);
	  close FILE;
	  if ($globals{thumbnailSize}) {
	    my $hasModule=0;
	    foreach (@INC) {if (-e "$_${s}Image${s}Magick.pm") {$hasModule=$_}};
	    unless ($hasModule) {
	      &error("<B>Error creating thumbnail</B><BR>
              Webdata could not find the Image::Magick.pm 
              module in any of the \@INC directories.");
	    }
	    require Image::Magick;
	    my $image=Image::Magick->new;
	    my $x=$image->Read("$path$s$filename");
	    &error("$x") if "$x";
	    my ($w,$h)=$image->Get('width','height');
	    my $setWidth=$globals{thumbnailSize};
	    if ($setWidth=~/\%$/) {
	      $setWidth=~s/\%$//;
	      $setWidth=$w*($setWidth/100);
	    }
	    my $setHeight=$h*($setWidth/$w);
	    $x=$image->Scale(width=>$setWidth,height=>$setHeight);
	    &error("$x") if "$x";
	    $x=$image->Write("$path${s}_tn_$filename");
	    &error("$x") if "$x"; 
	  }
	}
	$user_data{"$table\.$field"}=$url;
      } else {
	$user_data{"$table\.$field"}="";
      }
    }
  }
  
  if (($f{key}=~/PRI/i) and (($function eq "add") or ($user_data{"$table\.$field"} ne $user_data{_keyValue}))) {

  }
  return $errormsg;
}

sub displayUpload {
  my ($name,$value)=@_;
  my $result;
  if ($value=~/(\.gif|\.jpg)$/i) {
    my $width="";
    my $height="HEIGHT=36";
    $result=qq( <A HREF="$value"><IMG SRC="$value"$width$height BORDER=0></A>);
  } else {
    my @tmp=split('/',$value);
    my $filename=$tmp[$#tmp];
    $result.=qq( <A HREF="$value">$filename</A>);
  }
  $result.=qq( <I>Delete file:</I> <INPUT TYPE=CHECKBOX NAME="_delete_$name" VALUE="1">);
  return $result;
}

sub mail {
  my ($to,$from,$subject,$body)=@_;
  if ($globals{path_to_sendmail}) {
    if (($^O=~/win/i)&&($globals{path_to_sendmail}=~/blat/i)) {
      open (MAIL,">${uploadsdir}$globals{slash}mail.txt");
      print MAIL ("$body\n");
      close MAIL;
      my $tmp=`$globals{path_to_sendmail} ${uploadsdir}$globals{slash}mail.txt -s \"$subject\" -t $to -f $from -q`;
    } else {
      open (MAIL,"|$globals{path_to_sendmail} -t") or &error("Could not open $globals{path_to_sendmail}");
      print MAIL ("To: $to\nFrom: $from\n");
      print MAIL ("Subject:$subject\n$body\n");
      close MAIL or &error("There is a problem writing to $globals{path_to_sendmail}");
    }
  }
  if ($debug) {print qq(MAIL sent to: $to, from: $from, subject: $subject, body: $body)};
}

sub mailBatch {
  &memberCheck;
  #Append $body to _preferences.mailbody
  my ($lastmail,$mailbody,$now,)=&getSingleArray("SELECT TO_DAYS(lastmail),mailbody,TO_DAYS(NOW()),batchmail FROM _preferences");
  my $body=$mailbody;
  $body.="\n--------------------------------\n".$_[0] if $_[0];
  my $statement="UPDATE _preferences SET mailbody=".$dbh->quote($body);
  &do($statement);  
  #if it is time for another batch
  my $nextmail=$lastmail+$globals{batchmail};
  if (($now>=$nextmail) or ($user_data{_cgifunction}=~/^Send Batch Mail$/i)) {
    #send batch
    &mail($globals{admin_email_address},$globals{admin_email_address},"Modifications in database",$body);
    #update lastmail
    $statement="UPDATE _preferences SET lastmail=NOW(),mailbody=NULL";
    &do($statement);
  }
  if ($user_data{_cgifunction}=~/^Send Batch Mail$/i) {
    print qq(<SCRIPT>alert('Your mail has been sent');history.go(-1)</SCRIPT>);
  }
}

sub addRecord {
  unless (($globals{userID}eq"admin")or($member{canadd}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &error("You do not have privileges to add to the $user_data{_tableName} table");
  }
  my @values=();
  my $errormsg="";
  my $body="The following record was added to $cgilocation by $globals{userID}\n";
  $body.="DATE: ".localtime(time)."\nIP: $ENV{REMOTE_ADDR}\n\n";
  
  my $keyField=&getKey($user_data{_tableName});
  my $keyval;
  my %f=&extractField($user_data{_tableName},$keyField);
  if ($f{extra}=~/auto_increment/) {
    $keyval=$user_data{"$user_data{_tableName}\.$keyField"};
    if (!$keyval) {
      my $statement="SELECT $keyField FROM $user_data{_tableName} ORDER BY $keyField DESC LIMIT 1";
      my @lastVal=&getSingleArray($statement);
      $keyval=$lastVal[0]+1;
    }
  }
  
    foreach my $tf (&getFields($user_data{_tableName},1)) {
      next if $tf=~/^$user_data{_tableName}\._/;
      $errormsg.=&checkData($tf,"add");
      my $tmp=$dbh->quote($user_data{$tf});
      push(@values,$tmp);
      if (($tf eq "$user_data{_tableName}\.$keyField")and($keyval)) {
	$body.=qq($tf\: $keyval\n);
      } else {
	$body.=qq($tf\: $user_data{$tf}\n);
      }
    }
  if ($errormsg) {
    print "<BODY BGCOLOR=WHITE><H1>Error:</H1>";
    print "The record could not be added for the following reason(s):<UL>$errormsg</UL>";
    exit;
  }
  my $owner=$globals{userID};
  if (($globals{userID} eq "admin")and($user_data{"$user_data{_tableName}\._owner"})) { 
    $owner=$user_data{"$user_data{_tableName}\._owner"};
  }
	    
  unshift (@values,$dbh->quote($owner),'NULL');
  my $string=join(',',@values);

  &do("INSERT INTO $user_data{_tableName} VALUES ($string)");
  print qq(<SCRIPT>alert('$lang{addresponse}');history.go(-1)</SCRIPT>) unless $debug;
  &mailBatch($body) if $globals{userID} ne "admin";
}

sub drawFieldBox {
  my $autoSelect="";
  my ($table,$field,$value)=@_;
  unless ($value) {$value=""};
  my $result;
  my %f=&extractField($table,$field);
  my $name="${table}.$field";
  
  if ($f{type}=~/date/i) {
    $value=&displayDate($value) if ($value);
  }

  $_=$f{display_type};
  if (/^text(box)?$/) {
    $value=~s/\"/\&quot\;/g;
    $result=qq(<INPUT TYPE=TEXT NAME="$name" SIZE="$f{display_parameters}" VALUE="$value"$autoSelect>)}
  elsif (/^checkbox$/) {
    my $select = ($value) ? " CHECKED" : "";
    $result=qq(<INPUT TYPE=CHECKBOX NAME="$name" VALUE="1"$select>)}
  elsif (/^list$/) {
    my @listOptions=split(',',$f{display_parameters});
    $result=qq(<SELECT NAME="$name">\n<OPTION></OPTION>\n);
    foreach my $option (@listOptions) {
      my $select = ($option eq $value) ? " SELECTED" : "";
      $result.=qq(<OPTION$select>$option</OPTION>\n);
    }
    $result.=qq(</SELECT>)}
  elsif (/^comment$/) {
    my ($cols,$rows)=split(',',$f{display_parameters});
    $value=~s/</\&lt\;/g;
    $value=~s/>/\&gt\;/g;
#    $value=($value)?"\n$value\n":"";
    $result=qq(<TEXTAREA NAME="$name" COLS=$cols ROWS=$rows>$value</TEXTAREA>)}
  elsif (/^upload$/) {
    $result=qq(<INPUT TYPE=file NAME="$name">);
    if ($value) {$result.=&displayUpload($name,$value)};
  } else {
    $result="";
  }

  #create relationship value list
  my $statement="SELECT * FROM _relationships WHERE many_side=".$dbh->quote("$table\.$field");
  my ($null1,$null2,$rel,$labelA,$labelB)=&getSingleArray($statement);
  if ($rel) {
    my ($ftable,$ffield)=split('\.',$rel);
    my @foreign=&getSingleArray("SELECT $ffield FROM $ftable");
    my $foreignTextFields="$labelA" if $labelA;
    $foreignTextFields.=",$labelB" if $labelB;

    $result=qq(<SELECT NAME="$name">\n);
    $result.=qq(<OPTION VALUE=""></OPTION>\n);
    foreach (@foreign) {
      $value=~s/\&quot\;/\"/g;
      my $select = ($_ eq $value) ? " SELECTED" : "";
      my @row;
      my $dashes="";
      if ($foreignTextFields) {
        @row=&getSingleArray("SELECT $foreignTextFields FROM $ftable WHERE $ffield=".$dbh->quote($_)." LIMIT 1");
        foreach (@row) {$_=substr($_,0,20)};
        $dashes=" -- ";
      }
      my $labels=join(" ",@row);
      my ($val,$display);
      if (!/\"/) {
	$val=qq(VALUE="$_");
	$display=qq($_$dashes$labels);
      } elsif (!/\'/) {
	$val=qq(VALUE='$_');
	$display=qq($_$dashes$labels);	
      } else {
	$val="";
	$display=$_;
      }
      $result.=qq(<OPTION ${val}$select>$display</OPTION>\n);
    }
    $result.=qq(</SELECT>\n);
  }
  return $result;
}

sub extractField {
  my ($table,$field)=@_; 
  if ($table=~/_MemberTable$/) {
    $field=~s/ .*$//;
    my %tmp=("display_label",$field,"display_type","text","display_parameters","20");
    return %tmp;
  } else {
    unless ($fields{$table}{_fieldSequence}) {
      &loadFields($table);
    }
	unless (exists $fields{$table}{$field}) {
		&error("Error extracting field \"$field\" in table \"$table\". Field does not exist.");
	}
	my $tmp=$fields{$table}{$field};
    return %$tmp;
  }
}

sub limitToOne {
  my $keyField=&getKey($user_data{_tableName});
  my $statement=qq(SELECT $keyField FROM $user_data{_tableName} WHERE _owner='$globals{userID}' LIMIT 1);
  print "$statement <HR>" if $debug;
  $user_data{key}=(&getSingleArray($statement))[0];
  $user_data{_cgifunction}="Modify Record";
  &modifyRecord;
}


sub manageRecords2 {
    if (($globals{userID} ne "admin") and
        ($member{canadd}!~/(^|,)$user_data{_tableName}(,|$)/) and
        ($member{canmodify}!~/(^|,)$user_data{_tableName}(,|$)/) and
        ($member{candelete}!~/(^|,)$user_data{_tableName}(,|$)/) and
        ($member{limitto1}!~/(^|,)$user_data{_tableName}(,|$)/) and
        ($member{manageall}!~/(^|,)$user_data{_tableName}(,|$)/)
      ) {
	  &error("You do not have privileges to edit this table")
	};

  my $form=&drawForm($user_data{_tableName});
  if (($globals{userID} ne "admin") and ($member{limitto1}=~/(^|,)$user_data{_tableName}(,|$)/)) {
    &limitToOne;
    exit;
  }
  my $enctype=($fields{$user_data{_tableName}}{hasUpload}) ? qq( ENCTYPE="multipart/form-data") : "";
  my $addbutton=qq(<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Add">);
  my $searchmodifybutton=qq(<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Search/modify">);
  my $importbutton=qq(<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Import Records">);
  if (($globals{userID} ne "admin") and 
      ($member{canadd}!~/(^|,)$user_data{_tableName}(,|$)/)) {
	$addbutton="";
      };
  if (($globals{userID} ne "admin") and 
      ($member{canmodify}!~/(^|,)$user_data{_tableName}(,|$)/) and 
       ($member{candelete}!~/(^|,)$user_data{_tableName}(,|$)/)) {
	 $searchmodifybutton="";
  }
  if (($globals{userID} ne "admin") and 
      ($member{canimport}!~/(^|,)$user_data{_tableName}(,|$)/)) {
    $importbutton="";
  }

      &graphicsHeader("Manage Records");
       print <<EOF;
<CENTER><H2>Data Entry for $user_data{_tableName}</H2></CENTER>
<FORM ACTION="$globals{cgilocation}" METHOD=POST $enctype>
$form
<INPUT TYPE=HIDDEN NAME="_tableName" VALUE="$user_data{_tableName}">
$addbutton $searchmodifybutton <INPUT TYPE=RESET VALUE="Clear form">
<BR>$importbutton
</FORM>
EOF
       if ($globals{userID} eq "admin") {
	 print <<EOF;
<A HREF="$globals{cgilocation}?_cgifunction=Modify+Table&_tableName=$user_data{_tableName}">Edit fields for $user_data{_tableName} table</A><BR>
<A HREF="$globals{cgilocation}?_cgifunction=Manage+Records">Return to table list</A><BR>
$globals{adminLink}
EOF
       }
       &graphicsFooter("Manage Records");
}

sub drawForm {
  my $result="";
  my $table=shift;
  my %values=@_;
  #check for template
  if (($globals{userID} ne "admin") and ($user_data{_cgifunction} eq "Modify Record")) {
    my @tmp=split("\n--------SPLIT--------\n",$member{templates});
    foreach (@tmp) {
      if (/^TABLE: *$table\n/) {
	$result=$_;
	last;
      }
    }
	if ($result) {
      $result=~s/^TABLE: *$table\n//; #remove first line;
	  $result=~s/\&lt\;/</g;
	  $result=~s/\&gt\;/>/g;
	  foreach (&getFields($table)) {
		next if /^_/;
		unless ($result=~/\$field\[$_\]/) {
			$result.=qq(<INPUT TYPE=HIDDEN NAME="$table\.$_" VALUE="$values{$_}">);
		}
      }
      $result=~s/\$field\[([^\]]+)\]/&drawFieldBox($user_data{_tableName},$1,$values{$1})/ge;
      $result=~s/\$data\[([^\]]+)\]/$values{$1}/g;
      $result=~s/\$escape\[([^\]]+)\]/&escape($values{$1})/ge;
      $result=~s/\$member\[([^\]]+)\]/$member{$1}/g;
      $result=~s/\$format\[([^\]]+)\]/&formatNum($1,%values)/gei;
      return $result;
    }
  }
  $result.= qq(<TABLE BORDER=0>);
  if ($user_data{_cgifunction}=~/^Go to Selected Table$/i) {
    if ($globals{userID} eq "admin") {
      $result.=qq(<TR><TD><font color="orange">owner</font></TD>
		  <TD><SELECT NAME="$table\._owner"><OPTION VALUE=""> </OPTION>).&memberList.qq(</SELECT>
		  <font color="orange">(Use for searching only)</TD></TR>\n);
    }
    $result.=qq(<TR><TD><font color="orange">date added (mm/dd/yy)</font></TD>
		 <TD><INPUT TYPE=TEXT NAME="$table\._timestamp" SIZE=40>
		 <font color="orange">(Use for searching only)</TD></TR>\n);
  }
  foreach (&getFields($table)) {
    my $comment="";
    next if /^_/;
    my %f=&extractField($table,$_);
    if ($f{extra}=~/auto_increment/) {$comment.="(Auto Fill, use for searching only)"};
    if ($f{type}=~/date/) {$comment.=($globals{use_european_dates})?"(dd/mm/yy)":"(mm/dd/yy)"};
    $result.= qq(<TR><TD><B>$f{display_label}:</B></TD><TD>);
    my $fieldBox=&drawFieldBox($user_data{_tableName},$_,$values{$_});
    $result.= qq($fieldBox <font color=orange>$comment</font></TD></TR>\n)
  }
$result.= qq(</TABLE>);
return $result;
}

sub formatNum {
  my $input=shift @_;
  my ($val,$places,$euro)=split(',',$input);
  my %data=@_;
  $val=$data{$val};
  $places=2 unless length($places);
  my $result=sprintf("\%.${places}f",$val);
  my $spacer=($euro=~/E/i)?" ":",";
  while ($result=~/(\d{4})(\,|\.|$)/) {
    my $num=$1;
    $num=substr($num,0,1).$spacer.substr($num,1,4);
    $result=~s/(\d{4})(\,|\.|$)/$num$2/;
  }
  if ($euro=~/E/i) {$result=~s/\./\,/};
  return $result;
}

sub manageRecords {
  my $tableOptions;
  my $adminlink;
  foreach (@allTables) {
    next if /^_/;
    if (($globals{userID} ne "admin") and
        ($member{canadd}!~/(^|,)$_(,|$)/) and
        ($member{canmodify}!~/(^|,)$_(,|$)/) and
        ($member{candelete}!~/(^|,)$_(,|$)/) and
        ($member{limitto1}!~/(^|,)$_(,|$)/) and
        ($member{manageall}!~/(^|,)$_(,|$)/)
      ) {next};
    $tableOptions.="<OPTION>$_</OPTION>\n";
  }
  &graphicsHeader;
  print <<EOF;
<SCRIPT>
function checkForm(f) {
  if (f._tableName.selectedIndex>=0) {
    return true;
  } else {
    return false;
  }
}
</SCRIPT>
<CENTER><h2>Select a table</h2>
<FORM ACTION="$globals{cgilocation}" METHOD=POST onSubmit="return checkForm(this)">
<SELECT NAME="_tableName" SIZE=7>
$tableOptions
<OPTION>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</OPTION>
</SELECT><BR>
  <INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Go to Selected Table">
</FORM>
<A HREF="$globals{cgilocation}?_cgifunction=Backup+Page">Back-up the database</A><BR>
$globals{adminLink}
EOF
&graphicsFooter;
}

sub deleteLayout {
  &adminCheck;
  &do("DELETE FROM _layouts WHERE layout_name=".$dbh->quote($user_data{layout}));
  &loadGlobals;
  $user_data{_cgifunction}="Manage Layouts";
  &manageLayouts;
}

sub saveLayout {
  &adminCheck;
  my @valueSet;
  foreach (&getFields("_layouts")) {
    my $val=$dbh->quote($user_data{$_});
    push (@valueSet,"$val")
  }
  my $set=join(',',@valueSet);
  my $statement="INSERT INTO _layouts VALUES ($set)";
  &do("DELETE FROM _layouts WHERE layout_name=".$dbh->quote($user_data{layout_name}));
  &do($statement);
  &loadGlobals;
  $user_data{_cgifunction}="Edit Selected Layout";
  $user_data{layout}=$user_data{layout_name};
  &layoutForm;
}

sub getHash {
  #(table,key fieldname,key value,noprint)
  my ($table,$keyfield,$keyval,$noprint)=@_;
  my %tmphash;
  my $statement="SELECT * FROM $table WHERE $keyfield=".$dbh->quote($keyval);
  print "$statement<HR>" if $debug and !$noprint;
  my @row=getSingleArray($statement);
  my @tmpFields=&getFields($table);
  my $count=0;
  foreach (@tmpFields) {
    $tmphash{$_}=($row[$count])?$row[$count]:"";
    $count++;
  }
  return %tmphash;
}

sub duplicateCart {
  my ($oldname,$newname)=@_;
  my $statement="SELECT * FROM _shoppingcart WHERE cart_layout=".$dbh->quote($oldname);
  my @vals=&getSingleArray($statement);
  if (@vals) {
    $vals[0]=$newname;
    foreach (@vals) {
      $_=$dbh->quote($_);
    }
    $statement="INSERT INTO _shoppingcart VALUES (".join(',',@vals).")";
    &do($statement);
  }
}

sub layoutForm {
  &adminCheck;
  my %layout=();
  if ($user_data{_cgifunction} =~ /Edit Selected Layout|Duplicate Layout/i) {
    %layout=&getHash("_layouts","layout_name",$user_data{layout});
  }
  if ($user_data{_cgifunction} =~ /Add Layout|Duplicate Layout/i) {  
    $layout{layout_name}=$user_data{newLayoutName};
  }
  if ($user_data{_cgifunction} =~ /Duplicate Layout/i) {
    &duplicateCart($user_data{layout},$user_data{newLayoutName});
  }
  my $escapeLayoutName=&escape($layout{layout_name});
  foreach (keys %layout) {
    $layout{$_}=~s/\"/\&quot\;/g;
    $layout{$_}=~s/</\&lt\;/g;
    $layout{$_}=~s/>/\&gt\;/g;
  }
  
  foreach (qw(allow_visitors_to_search restrict_member_searches include_default_instructions_on_search_page include_view_button show_return_to_homepage show_search_again show_next_page_previous_page show_results_of_count show_go_to_page hide_table_border display_search_criteria)) {
    $layout{$_}=$layout{$_} ? " CHECKED" : "";
  }
  my %language;
  foreach (qw(English Spanish French German Italian Dutch Portuguese)) {
    $language{$_}= (/^$layout{language}$/i) ? " SELECTED" : "";
  }
  my $language_options;
  foreach (qw(English Spanish German French Italian Dutch Portuguese)) {
    $language_options.=qq(<OPTION);
    $language_options.=qq( SELECTED) if $layout{language} eq $_;
    $language_options.=qq(>$_</OPTION>\n);
  }

  my @allFields=(&getAllTableFields,"***OWNER FIELDS***",&getTableOwnerFields);
  my $sortby1_options;
  my $sortby2_options;
  my $sortby3_options;
  my $sequence1;
  my $sequence2;
  my $sequence3;
  my @seq=split(':',$layout{sequence_of_fields});
  foreach (@allFields) {
    $sortby1_options.=(/^$layout{sort_by}$/i) ? "<OPTION SELECTED>" : "<OPTION>";
    $sortby1_options.="$_</OPTION>";
    $sortby2_options.=(/^$layout{sort_by2}$/i) ? "<OPTION SELECTED>" : "<OPTION>";
    $sortby2_options.="$_</OPTION>";
    $sortby3_options.=(/^$layout{sort_by3}$/i) ? "<OPTION SELECTED>" : "<OPTION>";
    $sortby3_options.="$_</OPTION>";
    $sequence1.="<OPTION>$_</OPTION>" unless /(\._owner$)|(\._timestamp$)/;
  }
  foreach (@seq) {
    $sequence2.="<OPTION>$_</OPTION>\n";
  }
  my @seq3=split(':',$layout{search_page_fields});
  foreach (@seq3) {
    $sequence3.="<OPTION>$_</OPTION>\n";
  }
  
  my $sort_order=($layout{sort_order}) ? " SELECTED" : "";
  my $sort_order2=($layout{sort_order2}) ? " SELECTED" : "";
  my $sort_order3=($layout{sort_order3}) ? " SELECTED" : "";
  my $use_shopping_cart=($layout{use_shopping_cart})?" CHECKED" : "";
  $layout{single_search_box}=($layout{single_search_box})?" CHECKED":"";
  my $sumInstructions=qq(Enter <B>\$count[</B>table.field<B>]</B>, <B>\$sum[</B>table.field<B>]</B>, or <B>\$avg[</B>table.field<B>]</B> to display summary data.);
  my $help=&help('Layouts');
  my $cartLink="$globals{cgilocation}?_cgifunction=Configure+Shopping+Cart&_layout=".&escape($user_data{layout});
  &graphicsHeader("Manage Layouts");
  print <<EOF;

<CENTER><H1>Edit Layout: $layout{layout_name}</H1></CENTER>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="layout_name" VALUE="$layout{layout_name}">
<TABLE WIDTH="90%" BORDER=0><TR><TD ALIGN=RIGHT>
<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Save Layout"><P>

<A HREF="$globals{cgilocation}?_cgifunction=user&_layout=$escapeLayoutName">Go to user search page</A><P>

<A HREF="$globals{cgilocation}?_cgifunction=Manage+Layouts">Return to "Manage Layouts" page</A><P>

$globals{adminLink}
<BR><BR>
      <SCRIPT>
      function helpWindow(doc,title) {
	options='width=500,height=500,scrollbars=1,resizable=1,dependent,screenX=200,screenY=72';
	urlval='webdata_pro.pl?_cgifunction=getDoc&_document='+doc+'&_helpValue='+title;
	nw=window.open(urlval,'',options);
	nw.focus();
      }
      function setBox(e) {
        if ((e.name=="allow_visitors_to_search")&&(e.checked)) {
          document.forms[0].restrict_member_searches.checked=0;
        }
        if ((e.name=="restrict_member_searches")&&(e.checked)) {
          document.forms[0].allow_visitors_to_search.checked=0;
        }
      }
      </SCRIPT>
<INPUT TYPE=BUTTON VALUE="Help" onClick="helpWindow('Layouts','Help')">
</TD></TR></TABLE>
<span class=head>Allow visitors to search with this layout?</span>
<INPUT TYPE=CHECKBOX NAME="allow_visitors_to_search" VALUE="1" $layout{allow_visitors_to_search}
onClick="setBox(this)"><BR>
<span class=head>Limit member searches to only their own records?</span>
<INPUT TYPE=CHECKBOX NAME="restrict_member_searches" VALUE="1" $layout{restrict_member_searches}
onClick="setBox(this)"><BR>
<span class=head>Language:</span> 
<SELECT NAME="language">
$language_options;
</SELECT><P>

<span class=head>Header for search page:</span><BR>
<TEXTAREA NAME="header_for_search_page" COLS=60 ROWS=6 WRAP=SOFT>$layout{header_for_search_page}</TEXTAREA>
<P><span class=head>Include default instructions on search page:</span> <INPUT
TYPE=CHECKBOX NAME="include_default_instructions_on_search_page" VALUE="1" $layout{include_default_instructions_on_search_page}>
<P>
<span class=head>Which fields should appear on the search page?</span><BR>
<I>Click the fields in the left box in the sequence you wish <BR>
to display them in the user search results table.<BR>
You may leave out fields which you wish to hide from users</I><BR><BR>

<table border=0 cellpadding=10><tr><th>Avaliable fields</th><th>Search Fields</th></tr>
<tr><td align=center>
<SELECT NAME="fields" size=10 width=200 onChange="setseq(this,form.sequence3,form.search_page_fields)">
$sequence1
</SELECT>
</td><td align=center>
<SELECT NAME="sequence3" size=10 width=200>
$sequence3
</SELECT>
</td></tr><tr><td></td><td align=center> 
<input type=button value="Clear Sequence" onClick="clearSequence(form.sequence3,form.search_page_fields)"></td></tr></table>
<INPUT TYPE=HIDDEN NAME="search_page_fields" VALUE="$layout{search_page_fields}">
<BR><span class=head>Use a single search box for entire record</span>
<INPUT TYPE=CHECKBOX NAME="single_search_box" VALUE="1"$layout{single_search_box}><BR>
<BR><span class=head>Footer for search page:</span><BR>
<TEXTAREA NAME="footer_for_search_page" COLS=60 ROWS=6 WRAP=SOFT>$layout{footer_for_search_page}</TEXTAREA>
<P>
<BR>
<BR>

<HR>
<BR>
<BR>


<span class=head>Parameters for BODY tag:</span> For example:<BR><small>
 <I>BGCOLOR="white" BACKGROUND="/images/texture.gif" COLOR="#003F08" LINK="#FF0000"</I></small>&nbsp;
 <BR><TT>&lt;BODY <INPUT TYPE=TEXT NAME="body_tag" SIZE=60 VALUE="$layout{body_tag}">&gt;</TT><BR>
<span class=head>URL for "return to homepage" link:</span> <INPUT TYPE=TEXT SIZE=60 NAME="url_for_return_to_homepage" VALUE="$layout{url_for_return_to_homepage}"><P>
<span class=head>URL for "search again" link:</span> <INPUT TYPE=TEXT SIZE=60 NAME="url_for_search_again" VALUE="$layout{url_for_search_again}"><P><BR>
<BR>


<HR><BR>

<span class=head>Use shopping cart:</span> <INPUT TYPE=CHECKBOX NAME="use_shopping_cart"$use_shopping_cart VALUE="1"> 
<A HREF="$cartLink">Click here to configure the shopping cart</A>
<BR><BR>
<span class=head>Header for Search Results Page:</span><BR><small>Enter <span class=head>\$count[</span>table.field<span class=head>]</span>, <span class=head>\$sum[</span>table.field<span class=head>]</span>, or <span class=head>\$avg[</span>table.field<span class=head>]</span> to display summary data.</small><BR><TEXTAREA NAME="header_for_results_page" WRAP=SOFT COLS=80 ROWS=6>$layout{header_for_results_page}</TEXTAREA><P>
<span class=head>Display Search Criteria:</span> <INPUT TYPE=CHECKBOX NAME="display_search_criteria" VALUE="1" $layout{display_search_criteria}><P>
<span class=head>Group Header:</span><BR><I>
When templates are used, this will be displayed once each time there is a new value in the field selected as the primary sort below. For example, if a cars database is sorted by "Make", and there are 4 Acuras, 7 BMWs, and 2 Cadillacs in the database, then this entry below:<BR></I>
"There are <span class=head>\$count[cars.Make]</span> cars made by <span class=head>\$data[cars.Make]</span>"<BR><I>
would display this before the first Acura:<BR></I>
"There are 4 cars made by Acura"<BR><I>
and then, 4 records later, would display this before the first BMW:<BR></I>
"There are 7 cars made by BMW"<BR>
<TEXTAREA NAME="group_header" WRAP=SOFT COLS=80 ROWS=6>$layout{group_header}</TEXTAREA><P>


<span class=head>Hide Table Border:</span> <INPUT TYPE=CHECKBOX
NAME="hide_table_border" VALUE="1" $layout{hide_table_border}><P>
<span class=head>Font information:</span><BR>
<I>If the default table is used, enter any FONT tag parameters here. For example: COLOR="red" FACE="arial" SIZE=2</I><BR>
<TT>&lt;FONT <INPUT TYPE=TEXT NAME="font_information" SIZE=60 VALUE="$layout{font_information}">&gt;</TT><P>

<span class=head>Table Background Colors:</span> <I>Enter any standard HTML color or hex code</I><BR>
Header Row: <INPUT TYPE=TEXT NAME="table_header_color" VALUE="$layout{table_header_color}"><BR>Alternate Row 1: <INPUT TYPE=TEXT NAME="table_row1_color" VALUE="$layout{table_row1_color}"><BR>Alternate Row 2: <INPUT TYPE=TEXT NAME="table_row2_color" VALUE="$layout{table_row2_color}"><P>

<span class=head>Sub-Footer for Search Results Page:</span><BR>
<I>This will go immediatly after the search results, but before the navigation links.</I><BR>
<small>Enter <span class=head>\$count[</span>table.field<span class=head>]</span>, <span class=head>\$sum[</span>table.field<span class=head>]</span>, or <span class=head>\$avg[</span>table.field<span class=head>]</span> to display summary data.</small><BR>

<TEXTAREA NAME="sub_footer_for_results_page" WRAP=SOFT COLS=80 ROWS=6>$layout{sub_footer_for_results_page}</TEXTAREA><P>
<span class=head>Navigation Controls:</span><BR>
<span class=head>Number of Results Per Page:</span><INPUT TYPE=TEXT SIZE=3 NAME="number_of_results_per_page" VALUE="$layout{number_of_results_per_page}"><P>

Show "Results x - y of z": <INPUT TYPE=CHECKBOX NAME="show_results_of_count" VALUE="1" $layout{show_results_of_count}><BR>
Show "go to page 1 2 3 ...": <INPUT TYPE=CHECKBOX NAME="show_go_to_page" VALUE="1" $layout{show_go_to_page}><BR>
Show "Next Page/Previous Page" Buttons: <INPUT TYPE=CHECKBOX
NAME="show_next_page_previous_page" VALUE="1" $layout{show_next_page_previous_page}><BR>
Show "Search Again" link: <INPUT TYPE=CHECKBOX NAME="show_search_again"
VALUE="1" $layout{show_search_again}><BR>
Show "Return to Homepage" link: <INPUT TYPE=CHECKBOX
NAME="show_return_to_homepage" VALUE="1" $layout{show_return_to_homepage}><P>
<span class=head>Footer for entire Search Results page:</span><BR>
<I>This will go at the very bottom of the page</I><BR>
<small>Enter <span class=head>\$count[</span>table.field<span class=head>]</span>, <span class=head>\$sum[</span>table.field<span class=head>]</span>, or <span class=head>\$avg[</span>table.field<span class=head>]</span> to display summary data.</small><BR>

<TEXTAREA NAME="footer_for_entire_results_page" WRAP=SOFT COLS=80 ROWS=6>$layout{footer_for_entire_results_page}</TEXTAREA><P>


<SCRIPT>
nav=navigator.userAgent;
if (nav.indexOf('MSIE 3')>0) {IE3=true} else {IE3=false};

function clearSequence (s,box) {
	if (IE3) {
	  alert("Sorry, MSIE 3 does not support dynamic lists. nYou must use MSIE 4+ or Netscape 3+ to use this function");
	} else {
	  s.options.length=0;
	  box.value="";
	};
};

function setseq(L,R,box) {
	if (IE3) {
	  alert("Sorry, MSIE 3 does not support dynamic lists. nYou must use MSIE 4+ or Netscape 3+ to use this function");
	} else {
	var len=R.options.length;
	R.options.length++;
	i=L.selectedIndex;
	R.options[len].text=L.options[i].text;
	R.options[len].value=i;
	setnums(R,box);
	}
};

function setnums(s,boxname) {
	var len=s.options.length;
	result="";
	for (i=0;i<len;i++) {
		result+=s.options[i].text+":"
	};
	boxname.value=result;
};
function insertField() {
  c='<BODY BGCOLOR=WHITE><FORM>\\n'+
    '<small><SELECT NAME="tag"><OPTION>\$data</OPTION>'+
    '<OPTION>\$escape</OPTION>'+
    '<OPTION>\$sum</OPTION>'+
    '<OPTION>\$count</OPTION>'+
    '<OPTION>\$avg</OPTION></SELECT></small><BR>'+
    '<SELECT NAME="allFields" SIZE=10 onChange="form.result.value=\\'\\$\\'+form.tag.options[form.tag.selectedIndex].text+\\\'\\[\\\'+this.options[this.selectedIndex].text+\\'\]\\\'\;form.result.focus();form.result.select()">'+
    '$sequence1 </SELECT><BR>'+
    '<INPUT TYPE=TEXT SIZE=30 NAME="result" onFocus="this.select()"><BR>'+
    '<INPUT TYPE=BUTTON VALUE="Close" onClick="self.close()"></FORM>'+
    '<small>1. Select a field.<BR>2. Use [ctrl-c] to copy tag.<BR>3.Use [ctrl-v] to paste it into your template</small></BODY>\\n';
  nw=window.open('','','width=300,height=400');
  nw.document.write(c);
  nw.document.close();
  nw.focus();
}
</SCRIPT>

<span class=head>Sequence of Fields:</span><BR>
Click the fields in the left box in the sequence you wish <BR>
to display them in the user search results table.<BR>
You may leave out fields which you wish to hide from users<BR><BR>

<table border=0 cellpadding=10><tr><th>Avaliable fields<th>Report Columns (left to right)<tr><td align=center>
<SELECT NAME="fields" size=10 width=200 onChange="setseq(this,form.sequence,form.sequence_of_fields)">
$sequence1
</SELECT>
 <td align=center>
<SELECT NAME="sequence" size=10 width=200>
$sequence2
</SELECT>
<tr><td><td align=center> 
<input type=button value="Clear Sequence" 
onClick="clearSequence(form.sequence,form.sequence_of_fields)"></table><P>
<INPUT TYPE=HIDDEN NAME="sequence_of_fields" VALUE="$layout{sequence_of_fields}">
<span class=head>SORTING:</span><BR>
<span class=head>First Sort By</span> 
<SELECT NAME="sort_by">
<OPTION VALUE="">-- No Sorting --</OPTION>$sortby1_options</SELECT>
<SELECT NAME="sort_order">
<OPTION VALUE="0">Ascending</OPTION>
<OPTION VALUE="1"$sort_order>Descending</OPTION>
</SELECT>
<P>
<span class=head>Then Sort By</span> <SELECT NAME="sort_by2">
<OPTION VALUE="">-- No Sorting --</OPTION>$sortby2_options
</SELECT>
<SELECT NAME="sort_order2">
<OPTION VALUE="0">Ascending</OPTION>
<OPTION VALUE="1"$sort_order2>Descending</OPTION>
</SELECT><BR>
<P>
<span class=head>Then Sort By</span> <SELECT NAME="sort_by3">
<OPTION VALUE="">-- No Sorting --</OPTION>$sortby3_options
</SELECT>
<SELECT NAME="sort_order3">
<OPTION VALUE="0">Ascending</OPTION>
<OPTION VALUE="1"$sort_order3>Descending</OPTION>
</SELECT><BR>
<P>

<span class=head>FORM VIEW BUTTON</span><BR>
Include Form View Button: <INPUT TYPE=CHECKBOX NAME="include_view_button" VALUE="1" $layout{include_view_button}><BR>
Label for Button: <INPUT TYPE=TEXT SIZE=10 NAME="label_for_view_button" VALUE="$layout{label_for_view_button}"><P>
Image file for Button:
<I>If you would like to use a graphic instead of the default button, enter the image URL here.</I><BR>
<INPUT TYPE=TEXT SIZE=60 NAME="image_for_view_button" VALUE="$layout{image_for_view_button}"><BR>
Form View Window Size:
<I>If you would like the form to open in a new window, enter the pixel <BR>values for </I><B>width</B><I>, then </I><B>height</B><I> seperated by a comma. 
For example:</I> <B><TT>600,400</TT></B><BR>
<INPUT TYPE=TEXT SIZE=10 NAME="form_view_window" VALUE="$layout{form_view_window}"><P>

<BR>
<BR>
<HR>
<BR>
<BR>


<h1>Templates</h1>
<font size=2>Instead of the default table, you can enter your own HTML code in the box below.  The code you enter 
will be displayed once for every record that matches the user\'s search criteria.  Using the Insert Field Assistant, 
substitute <span class=head>\$data[table.field]</span> where you would like the value contained in that field to appear. Type the word <span class=head>\$viewbutton</span> to place the view button in the search results.
 Type \$data[table._owner.memberFieldName] to display information about the member that owns each record in any given table. 
If you are creating a link to another cgi script, use <span class=head>\$escape[table.field]</span> instead of <span class=head>\$data[table.field]</span>. This will automatically
convert "<font color=blue>three,&nbsp;at&nbsp;$2.25/each</font>" into "<font
color=blue>three%2C+at+%242.25%2Feach</font>", which is the format cgi scripts expect in the URL.  If you use the
shopping cart, type <span class=head>\$addbutton</span> where the "Add to cart" button should go.  Enter <span class=head>\$count[table.field]</span>, <span class=head>\$sum[table.field]</span>, or <span class=head>\$avg[table.field]</span> to display summary data.<BR>
Conditional results use this syntax: <span class=head>\$if (\$data[table.field] [<,>,<=,>=,==,=~] value) {result if true} else {result if false}</span> See the help page for examples.  Type <span class=head>\$days[table.field]</span> to display the number of days between year 0 and a date value.  Type <span class=head>\$now</span> to display the current date in days since year 0. Type <span class=head>\$yearsSince[table.field]</span> to display the number of years between a date value and present. Type <span class=head>\$daysSince[table.field]</span> to display the number of days between a date value and present.
</font>
<P>
<span class=head>Template for Search Results</span>
&nbsp;&nbsp;&nbsp;&nbsp;
<small><INPUT TYPE=BUTTON VALUE="Insert Field Assistant"
onClick="insertField('template_for_search_results')"></small>
<BR>
<TEXTAREA NAME="template_for_search_results" COLS=80 ROWS=20>$layout{template_for_search_results}</TEXTAREA><P>
<span class=head>Template for Form View</span>&nbsp;&nbsp;&nbsp;&nbsp;
<small><INPUT TYPE=BUTTON VALUE="Insert Field Assistant"
onClick="insertField('template_for_form_view')"></small>
<BR>
<TEXTAREA NAME="template_for_form_view" COLS=80 ROWS=40>$layout{template_for_form_view}</TEXTAREA><P>

<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Save Layout"><P>

<A HREF="$globals{cgilocation}?_cgifunction=user&_layout=$escapeLayoutName">Go to user search page</A><P>

<A HREF="webdata_pro.pl?_cgifunction=Manage+Layouts">Return to "Manage Layouts" page</A><P>

$globals{adminLink}

EOF
&graphicsFooter("Manage Layouts");

}


 




sub manageLayouts {
  &adminCheck;
  #get list of layouts
  my $statement="SELECT layout_name FROM _layouts";
  my @layouts=&getSingleArray($statement);
  &graphicsHeader;
  print <<EOF;
<CENTER><H1>Manage Layouts</H1>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
Choose a layout and click one of the buttons below.<BR><BR>
<SELECT NAME="layout" SIZE=6>
<OPTION VALUE="Default" SELECTED>Default&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</OPTION>
EOF
  foreach (@layouts) {
    next if (/^default$/i);
    print qq(<OPTION>$_</OPTION>\n);
  }
print <<EOF;
</SELECT><BR><BR>
<INPUT TYPE=BUTTON VALUE="Search Using Selected Layout" onClick="searchLayout(form)"><BR><BR>
<INPUT TYPE=BUTTON VALUE="Edit Selected Layout" onClick="form._cgifunction.value='Edit Selected Layout';form.submit()"><BR><BR>
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Edit Selected Layout">
<INPUT TYPE=BUTTON VALUE="Add New Layout" onClick="addLayout(form)"><BR><BR>
<INPUT TYPE=BUTTON VALUE="Duplicate Selected Layout" onClick="duplicateLayout(form)"><BR><BR>
<INPUT TYPE=BUTTON VALUE="Delete Selected Layout" onClick="deleteLayout(form)"><BR><BR>
<INPUT TYPE=HIDDEN NAME="newLayoutName" VALUE="">
</FORM>
<SCRIPT>
function deleteLayout(f) {
  if (f.layout.selectedIndex==0) {
    alert('You cannot delete the default table');
    return;
  }
  if (confirm('Are you sure you want to delete the selected layout?')) {
    f._cgifunction.value="Delete Selected Layout";
    f.submit();
  }
}

function checkForm(f) {
  if (f.layout.selectedIndex>=0) {
    return true;
  } else {
    return false;
  }
}

function searchLayout(f) {
  var sel;
  if (f.layout.options[f.layout.selectedIndex].value) {
    sel=f.layout.options[f.layout.selectedIndex].value;
  } else {
    sel=f.layout.options[f.layout.selectedIndex].text;
  }
  location="$globals{cgilocation}?_cgifunction=user&_layout="+escape(sel);
}

function addLayout(f) {
  val=prompt('New Layout Name?','');
  if (!val) {return};
  f.newLayoutName.value=val;
  f._cgifunction.value="Add Layout";
  f.submit();
}

function duplicateLayout(f) {
  val=prompt('New Layout Name?','');
  if (!val) {return};
  f.newLayoutName.value=val;
  f._cgifunction.value="Duplicate Layout";
  f.submit();
}
</SCRIPT>
<P>
EOF
print qq(<TABLE BORDER=0 WIDTH="100%"><TR>
<TD ALIGN=LEFT>$globals{adminLink}</TD>
<TD ALIGN=RIGHT><FORM>).&help('Layouts').qq(</FORM></TD></TR></TABLE>);
&graphicsFooter;
}

sub savePreferences {
  &adminCheck;
  my @valueSet;
  foreach (&getFields("_preferences")) {
    next if /(^(header|footer)$)|^cart\_/;
    my $val=$dbh->quote($user_data{$_});
    push (@valueSet,"$_=$val")
  }
  my $set=join(',',@valueSet);
  my $statement="UPDATE _preferences SET $set";
  &do($statement);
  &loadGlobals;
  &managePreferences;
}

sub saveCartSettings {
  &adminCheck;
  my @valueSet;
  foreach (&getFields("_shoppingcart")) {
    my $val=$dbh->quote($user_data{$_});
    push (@valueSet,$val)
  }
  my $set=join(',',@valueSet);
  my $statement="DELETE FROM _shoppingcart WHERE cart_layout=".$dbh->quote($user_data{_layout});
  &do($statement);
  $statement="INSERT INTO _shoppingcart VALUES (".join(',',@valueSet).")";
  &do($statement);
  &loadGlobals;
  &configureCart;
}

sub managePreferences {
  &adminCheck;
  #convert checkboxes to " CHECKED"
  foreach (qw(
    include_default_instructions_on_search_page
    allow_visitors_to_add
    allow_instant_member
    allow_visitors_to_search
    use_european_dates
    use_shopping_cart   
    use_debug_mode
  )) {
    $globals{$_} = ($globals{$_}) ? " CHECKED" : "";
  }

  #convert double quotes and angle brackets to html symbols
  foreach (&getFields("_preferences")) {
    $globals{$_}=~s/\"/\&quot\;/g;
    $globals{$_}=~s/</\&lt\;/g;
    $globals{$_}=~s/>/\&gt\;/g;
  }
  my $memberList=&getMemberList("instantMemberGroup","instantMember");
  my $batchmail;
  my $count;
  my %batchNums=("**Do Not Send Notifications**",-1,"Immediatly upon changes",0,"Daily",1,"Every 2 days",2,"Every 3 days",3,"Every 7 days",7,"Every 14 days",14,"Every 30 days",30,"Every 90 days",90);
  foreach ("**Do Not Send Notifications**","Immediatly upon changes","Daily","Every 2 days","Every 3 days","Every 7 days","Every 14 days","Every 30 days","Every 90 days") {
    $batchmail.=qq(<OPTION VALUE="$batchNums{$_}");
    $batchmail.=" SELECTED" if $globals{batchmail}==$batchNums{$_};
    $batchmail.=">$_</OPTION>\n";
  }

  &graphicsHeader("Manage Preferences");
  print <<EOF;
<H1 ALIGN=CENTER>Webdata Preferences</H1>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<B>Notify admin of all new records</B><BR>
<B>Admin e-mail address:</B>
<INPUT TYPE=TEXT NAME="admin_email_address" SIZE=40 VALUE="$globals{admin_email_address}"><BR>
<B>Path to sendmail:</B> <INPUT TYPE=TEXT NAME="path_to_sendmail" VALUE="$globals{path_to_sendmail}">
<BR><B>Batch E-mail Notifications</B> <SELECT NAME="batchmail">$batchmail</SELECT>
<A HREF="$globals{cgilocation}?_cgifunction=Send+Batch+Mail">Send Batch Now</A>
<INPUT TYPE=HIDDEN NAME="lastmail" VALUE="$globals{lastmail}">

<P><HR>

<B>Use european dates:</B> <INPUT TYPE=CHECKBOX NAME="use_european_dates"$globals{use_european_dates} VALUE="1"><BR>
<B>Allow instant members:</B> <INPUT TYPE=CHECKBOX NAME="allow_instant_member"$globals{allow_instant_member} VALUE="1"> &nbsp;&nbsp;
<B>Instant Member Group:</B> $memberList <BR>
<B>Instant Member REFERER domains: </B><I>Enter a domain name to require that instant members come from that site</I>
<INPUT TYPE=TEXT SIZE=50 NAME="instant_member_referers" VALUE="$globals{instant_member_referers}">
<BR>

<B>Debug Mode:</B> 
<I>Display form values and SQL statements in header</I> 
<INPUT TYPE=CHECKBOX NAME="use_debug_mode"$globals{use_debug_mode} VALUE="1"><BR>
<B>Thumbnails:</B> Enter a pixel value or percentage for the <B>width</B> of all thumbnails.
<INPUT TYPE=TEXT SIZE=6 NAME="thumbnailSize" VALUE="$globals{thumbnailSize}"><BR>
<I>You must have ImageMagick and the Image::Magick.pm module to use this feature.</I><BR>
<I>Thumbnails are created when images are uploaded. Use <B>\$thumbnail[table.Field]</B> in the templates to display a thumbnail image.</I><BR>

<HR>
<B>Custom Member Fields</B><BR>
In addition to the standard contact information, you may define up to 10 fields to hold
additional information about each member.  Enter the labels in the boxes below. Leave any unused fields blank.<P>
Fields 1 and 2 can each hold up to 16 million characters per member. This may be useful for storing resumes 
or papers. All the rest have a maximum of 50 characters. If you create a custom members page, you can replace the textboxes with textarea boxes for importing
large amounts of data into fields 1 and 2.

<TABLE BORDER=0>
<TR><TD ALIGN=CENTER><B>Field</B><BR>
(the max size refers to the data which<BR>
will be saved in each field, not the label)</TH><TH>Label for display</TH></TR>
<TR><TD>User 1 (16 million chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user1" SIZE=20 VALUE="$globals{user1}"></TD>
</TR>
<TR><TD>User 2 (16 million chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user2" SIZE=20 VALUE="$globals{user2}"></TD>
</TR>
<TR><TD>User 3 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user3" SIZE=20 VALUE="$globals{user3}"></TD>
</TR>
<TR><TD>User 4 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user4" SIZE=20 VALUE="$globals{user4}"></TD>
</TR>
<TR><TD>User 5 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user5" SIZE=20 VALUE="$globals{user5}"></TD>
</TR>
<TR><TD>User 6 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user6" SIZE=20 VALUE="$globals{user6}"></TD>
</TR>
<TR><TD>User 7 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user7" SIZE=20 VALUE="$globals{user7}"></TD>
</TR>
<TR><TD>User 8 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user8" SIZE=20 VALUE="$globals{user8}"></TD>
</TR>
<TR><TD>User 9 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user9" SIZE=20 VALUE="$globals{user9}"></TD>
</TR>
<TR><TD>User 10 (50 chars max): </TD>
    <TD><INPUT TYPE=TEXT NAME="user10" SIZE=20 VALUE="$globals{user10}"></TD>
</TR>
</TABLE>


<P>
<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Save Preferences">
</FORM>
<A HREF="$globals{cgilocation}?_cgifunction=user">Go to user search page</A><BR>
$globals{adminLink}
EOF
  &graphicsFooter("Manage Preferences");
}

sub saveMemberData {
  my @memberfields=&getFields("_members");
  my $statement;
  my @tables=@allTables;
  $user_data{searchLayout}=~s/ or /\,/g;
  my @privs=qw(groupname searchLayout header footer profileTemplate canadd canmodify candelete canimport canexport canupload limitto1 manageall default_url);
  %member=&getHash("_members","email",$user_data{_email},1);
  if ($user_data{password}=~/^\*+$/) {$user_data{password}=$member{password}};

  foreach my $priv (@privs) {
    foreach my $table (@tables) {
      next if $table=~/^_/;
      $user_data{$priv}.="$table\," if $user_data{"$table\_$priv"};
    }
    $user_data{$priv}=~s/\,$//;
  }
  
  my @templateArray;
  my $count=0;
  foreach my $table (@tables) {
    next unless $user_data{"$table\_template"};
    $user_data{"$table\_template"}=~s/\+/\%2B/g;
    $templateArray[$count]="TABLE: $table\n";
    $templateArray[$count].=&unescape($user_data{"$table\_template"})."\n";
    $count++;
  }
  $user_data{templates}=join("\n--------SPLIT--------\n",@templateArray);

  if ($user_data{_email}) {
    #existing member
    $statement="UPDATE _members SET ";
    foreach my $field (@memberfields) {
      #skip updating privileges if userID is not admin.
      if ($globals{userID} ne "admin") {
	my $isPrivField=grep /^$field$/, @privs;
	if ($isPrivField) {
	  next;
	}
	next unless exists($user_data{$field}); #skip field not included in template
      }
      $statement.="$field = ".$dbh->quote($user_data{$field}).",";
    } 
    $statement=~s/\,$//;
    $statement.=" WHERE email=".$dbh->quote($user_data{_email});
    
    #REFERENTIAL INTEGRITY
    #  if the e-mail changes, it will be necessary to
    #  change all of the data records that contain the
    #  e-mail address as the member table primary key.
    if ((exists($user_data{email})) and ($user_data{email} ne $user_data{_email})) {
      foreach (@tables) {
	next if /^_/;
	&do(qq(UPDATE $_ SET _owner='$user_data{email}',_timestamp=_timestamp WHERE _owner='$user_data{_email}'));
      }
      &do(qq(UPDATE _members SET groupname='$user_data{email}' WHERE groupname='$user_data{_email}'));
    }


    
  } else {
    #new member
    if ($user_data{_cgifunction} =~ /Save Instant Member Data/i) {
      $globals{userID}=0;
      $user_data{groupname}=$globals{instantMemberGroup};
    }
    my @existing=&getSingleArray("SELECT email FROM _members");
    if (grep /^$user_data{email}$/, @existing) {
      &error("$user_data{email} is already in the database. Return to the main login page and
              use the \"mail password\" feature to get your password");
    }
    $statement="INSERT INTO _members VALUES (";
    foreach (@memberfields) {
      $statement.=$dbh->quote($user_data{$_}).",";
    }
    chop($statement);
    $statement.=")";
  }

  &do($statement);
  if ($globals{userID} eq "admin") {
    $user_data{memberName}=$user_data{email};
    &memberForm;
  } else {
    print <<EOF;
<BODY onLoad="document.forms[0].submit()">
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="username" VALUE="$user_data{email}">
<INPUT TYPE=HIDDEN NAME="password" VALUE="$user_data{password}">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Login Page">
<NOSCRIPT><INPUT TYPE=SUBMIT VALUE="Click Here to Continue"></NOSCRIPT>
</FORM>
EOF
  }
}

sub deleteMember {
  &adminCheck;
  &do("DELETE FROM _members WHERE email=".$dbh->quote($user_data{memberName}));
  &manageMembers;
}

sub getMemberList {
  my ($listname,$param1)=@_;
  if ($param1 eq "instantMember") {
    $member{groupname}=$globals{instantMemberGroup};
  }
  my $memberlist=qq(<SELECT NAME="$listname">\n);
  $memberlist.=qq(<OPTION VALUE=""> </OPTION>) if $param1 eq "blankFirstRow";
  my $statement="SELECT firstname,lastname,email FROM _members";
  print "$statement<HR>" if $debug;
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  while (my @row=$sth->fetchrow_array) {
    my ($first,$last,$email)=@row;
    my $selected=($member{groupname} eq $email) ? " SELECTED" : "";
    $memberlist.=qq(<OPTION VALUE="$email"$selected>$first $last</OPTION>\n);
  };
  $sth->finish();
  $memberlist.=qq(</SELECT>);
  return $memberlist;
}

sub register {
  &adminCheck;
  if (length($user_data{registration})>6) {
    &do('update _preferences set header='.$dbh->quote($user_data{registration}));
  }
  &admin;
}

sub memberForm {
  if ($globals{userID} ne "admin") {$user_data{memberName}=$globals{userID}};
  if (($globals{userID} eq "admin") and ($user_data{_cgifunction} =~ /Add Member/i)) {
    $user_data{memberName}="";
  }
  %member=&getHash("_members","email",$user_data{memberName});
  my %instantmember;
  if (($user_data{_cgifunction}=~/^instant ?member$/i) and ($globals{allow_instant_member})) {
    if ($globals{instant_member_referers}) { 
      my @referers=split(/\s*\,\s*/,$globals{instant_member_referers});
      my $validReferer=0;
      foreach (@referers) {
	if ($ENV{HTTP_REFERER}=~/$_/) {
	  $validReferer=1;
	}
      }
      unless ($validReferer) {
	&error("Invalid Referer")
      }
    }
    %instantmember=&getHash("_members","email",$globals{instantMemberGroup});
    $member{header}=$instantmember{header};
    $globals{userID}=0;    
    $globals{adminLink}="";
  } else {
    &memberCheck;
  }
  &graphicsHeader("Manage Members");
  my @sequence=qw(email password firstname lastname company address city state_province postal_code country telephone fax homepage user1 user2 user3 user4 user5 user6 user7 user8 user9 user10);
  foreach (@sequence) {$_="<OPTION>$_</OPTION>"};
  my $sequence1=join(" ",@sequence);
  my @tables=@allTables;
  if ($user_data{_cgifunction} =~ /Edit Member/i) {
    unless ($globals{userID} eq "admin") {$user_data{memberName}=$globals{userID}};
  }
  foreach (keys %member) {
    $member{$_}=~s/\"/\&quot\;/g;
    $member{$_}=~s/</\&lt\;/g;
    $member{$_}=~s/>/\&gt\;/g;
  }
  my $statement="SELECT layout_name FROM _layouts";
  print "$statement <HR>" if $debug;
  my @layouts=&getSingleArray($statement);
  my $layoutBoxSize=@layouts;
  $layoutBoxSize=5 if $layoutBoxSize>5;

  foreach my $table (@tables) {
    next if $table=~/^_/;
    foreach (qw(canadd cansearch canmodify candelete canimport canexport canupload limitto1 manageall)) {
      $member{"$table\_$_"}=($member{$_}=~/(^|,)$table(,|$)/) ? " CHECKED" : "";
    }
  }
  my @tmpl = split("\n--------SPLIT--------\n",$member{templates});
  foreach (@tmpl) {
    if (/^(.*)/) {
      my $table=$1;
      $_=~s/^.*\n//;
      $table=~s/^TABLE: *//;
      $member{"$table\_template"}=$_;
    }

  }

  my $tmp;
  for (my $i=0;$i<length($member{password});$i++) {
    $tmp.="*";
  }
  $member{password}=$tmp;
  print <<EOF;
<META HTTP-EQUIV="expires" CONTENT="0">
<SCRIPT>
function checkForm(f) {
  if (!f.email.value) {
    alert('Email is a required field');
    return false;
  }
  if (!f.password.value) {
    alert('Password is a required field');
    return false;
  }
  if (!f.firstname.value) {
    alert('First Name is a required field');
    return false;
  }
  if (!f.lastname.value) {
    alert('Last Name is a required field');
    return false;
  }
  return true;
}
EOF

if ($globals{userID} eq "admin") {
print <<EOF;
function insertField() {
  c=\'<BODY BGCOLOR=WHITE><FORM>\\n\'+
    \'<SELECT NAME="allFields" SIZE=10 onChange="form.result.value=\\'\$field\\'+\\\'\\[\\\'+this.options[this.selectedIndex].text+\\'\]\\\'\;form.result.focus();form.result.select()">\'+
    \'$sequence1 </SELECT><BR>\'+
    \'<INPUT TYPE=TEXT SIZE=30 NAME="result" onFocus="this.select()"><BR>\'+
    \'<INPUT TYPE=BUTTON VALUE="Close" onClick="self.close()"></FORM>\'+
    \'<small>1. Select a field.<BR>2. Use [ctrl-c] to copy tag.<BR>3.Use [ctrl-v] to paste it into your template</small></BODY>\\n\';
  nw=window.open('','','width=300,height=400'); 
  nw.document.write(c); 
  nw.document.close();
  nw.focus();
}
EOF
}

print <<EOF;
</SCRIPT>
</HEAD> 

<FORM NAME="form1" ACTION="$globals{cgilocation}" METHOD=POST onSubmit="return checkForm(this)"> 
<INPUT TYPE=HIDDEN NAME="_email" VALUE="$member{email}">
EOF
unless (($member{profileTemplate}=~/\S+/)and($globals{userID} ne "admin")) {
print <<EOF;
<BODY BGCOLOR=WHITE>
<H1 align=center>Member Data Page</H1>
<TABLE BORDER=0>
<TR><TD><B>E-mail:</B></TD><TD><INPUT TYPE=TEXT NAME="email" SIZE=60 VALUE="$member{email}"></TD></TR>
<TR><TD><B>Password:</B></TD><TD><INPUT TYPE=TEXT NAME="password" SIZE=10 VALUE="$member{password}"></TD></TR>
<TR><TD><B>First Name:</B></TD><TD><INPUT TYPE=TEXT NAME="firstname" SIZE=40 VALUE="$member{firstname}"></TD></TR>
<TR><TD><B>Last Name:</B></TD><TD><INPUT TYPE=TEXT NAME="lastname" SIZE=40 VALUE="$member{lastname}"></TD></TR>
<TR><TD><B>Company:</B></TD><TD><INPUT TYPE=TEXT NAME="company" SIZE=60 VALUE="$member{company}"></TD></TR>
<TR><TD><B>Address:</B></TD><TD><INPUT TYPE=TEXT NAME="address" SIZE=60 VALUE="$member{address}"></TD></TR>
<TR><TD><B>City:</B></TD><TD><INPUT TYPE=TEXT NAME="city" SIZE=20 VALUE="$member{city}"></TD></TR>
<TR><TD><B>State/Province:</B></TD><TD><INPUT TYPE=TEXT NAME="state_province" SIZE=10 VALUE="$member{state_province}"></TD></TR>
<TR><TD><B>Postal Code:</B></TD><TD><INPUT TYPE=TEXT NAME="postal_code" SIZE=10 VALUE="$member{postal_code}"></TD></TR>
<TR><TD><B>Country</B></TD><TD><INPUT TYPE=TEXT NAME="country" SIZE=10 VALUE="$member{country}"></TD></TR>
<TR><TD><B>Telephone:</B></TD><TD><INPUT TYPE=TEXT NAME="telephone" SIZE=20 VALUE="$member{telephone}"></TD></TR>
<TR><TD><B>Fax:</B></TD><TD><INPUT TYPE=TEXT NAME="fax" SIZE=20 VALUE="$member{fax}"></TD></TR>
<TR><TD><B>Homepage:</B></TD><TD><INPUT TYPE=TEXT NAME="homepage" SIZE=60 VALUE="$member{homepage}"></TD></TR>
EOF

for (my $i=1;$i<=10;$i++) {
  if ($globals{"user$i"}) {
    print qq(<TR><TD><B>$globals{"user$i"}:</B></TD><TD><INPUT TYPE=TEXT NAME="user$i" SIZE=60 VALUE="$member{"user$i"}"></TD></TR>\n);
  }
}
} else {
$member{profileTemplate}=~s/\$field\[([^\]]+)\]/<INPUT TYPE=TEXT NAME=\"$1\" SIZE=20 VALUE=\"$member{$1}\">/g;
$member{profileTemplate}=~s/\$data\[([^\]]+)\]/$member{$1}/g;
$member{profileTemplate}=~s/\&lt\;/</g;
$member{profileTemplate}=~s/\&gt\;/>/g;
$member{profileTemplate}=~s/\&quot\;/\"/g;
print "$member{profileTemplate}\n";
print "<TABLE BORDER=0>\n";
}
  my $memberlist=&getMemberList("groupname","blankFirstRow");

if ($globals{userID} eq "admin") {
print <<EOF;
<TR><TD COLSPAN=2><h2>Privileges</h2></TD></TR>
</TABLE>

<TABLE BORDER=0>
<TR><TD colspan=2>
<B>Member Groups:</B><BR>
Any member can also be a group. If you select a member in this box, then this member\'s 
privileges will be aliased the member in the box. <BR>
<I>This will override all preferences below.</I></TD></TR><TD>Alias privileges to this member:</TD><TD>
  $memberlist
</TD></TR>

<TR><TD><B>Layouts:</B><BR>
<I>[CTRL]-Click on each layout which this member may<BR>
Search.  Leave all layouts unchecked if the member<BR>
has no read privileges at all.</I>
</TD>
<TD><SELECT NAME="searchLayout" SIZE=$layoutBoxSize MULTIPLE>
EOF
  my $select="";
#get list of layouts
foreach (@layouts) {
  $select=($member{searchLayout} =~/(^|,)$_(,|$)/) ? " SELECTED" : "";
  print qq(<OPTION$select>$_</OPTION>)
}

print <<EOF;
</SELECT></TD></TR>

<TR><TD><B>Default URL:</B> If you would like to use a custom <BR>
homepage for this member, enter the URL here. </TD><TD>
<INPUT TYPE=TEXT NAME="default_url" SIZE=60 VALUE="$member{default_url}">
</TD></TR>

</TABLE>
<B>Header for all Member Pages:</B><BR>
<TEXTAREA NAME="header" COLS=80 ROWS=6 WRAPPING=SOFT>$member{header}</TEXTAREA><P>
<B>Footer for all Member Pages:</B><BR>
<TEXTAREA NAME="footer" COLS=80 ROWS=6 WRAPPING=SOFT>$member{footer}</TEXTAREA><P>
<B>Template for Member Data page</B><BR>
<I>Enter the html to be displayed when the Member is
adding or modifying contact information. Use </I><B>\$field[firstname]</B><I> to display
the textbox with the current value of "firstname", etc.
<INPUT TYPE=BUTTON VALUE="Insert Field Assistant" onClick="insertField()"><BR>
<TEXTAREA NAME="profileTemplate" COLS=80 ROWS=12 WRAPPING=SOFT>$member{profileTemplate}</TEXTAREA><P>


<P>
<TABLE BORDER=0><TR><TD>&nbsp;</TD>
<TD ALIGN=CENTER><B>Add<BR>Records</B></TD>
<TD ALIGN=CENTER><B>Modify<BR>Records</B></TD>
<TD ALIGN=CENTER><B>Delete<BR>Records</B></TD>
<TD ALIGN=CENTER><B>Import<BR>Records</B></TD>
<TD ALIGN=CENTER><B>Export<BR>Records</B></TD>
<TD ALIGN=CENTER><B>Limit to<BR>1 Record</B></TD>
<TD ALIGN=CENTER><B>Manage<BR>All</B></TD>
<TD ALIGN=CENTER><B>"Modify Record"<BR>Template</TD>
</TR>
EOF


  foreach my $table (@tables) {
    next if $table =~ /^_/;
    my $template_label;
    my $escape_template="";
    if ($member{"$table\_template"}) {
      $template_label="Edit Template...";
      $escape_template=&escape($member{"$table\_template"});
    } else {
      $template_label="Create Template...";
    }
    print qq(<TR><TD>$table</TD>
<TD ALIGN=CENTER><INPUT TYPE=CHECKBOX VALUE="1" NAME="$table\_canadd"$member{"$table\_canadd"}></TD>
<TD ALIGN=CENTER><INPUT TYPE=CHECKBOX VALUE="1" NAME="$table\_canmodify"$member{"$table\_canmodify"}></TD>
<TD ALIGN=CENTER><INPUT TYPE=CHECKBOX VALUE="1" NAME="$table\_candelete"$member{"$table\_candelete"}></TD>
<TD ALIGN=CENTER><INPUT TYPE=CHECKBOX VALUE="1" NAME="$table\_canimport"$member{"$table\_canimport"}></TD>
<TD ALIGN=CENTER><INPUT TYPE=CHECKBOX VALUE="1" NAME="$table\_canexport"$member{"$table\_canexport"}></TD>
<TD ALIGN=CENTER><INPUT TYPE=CHECKBOX VALUE="1" NAME="$table\_limitto1"$member{"$table\_limitto1"}></TD>
<TD ALIGN=CENTER><INPUT TYPE=CHECKBOX VALUE="1" NAME="$table\_manageall"$member{"$table\_manageall"}></TD>
<TD ALIGN=CENTER><INPUT TYPE=BUTTON NAME="$table\_template_label" 
                  VALUE="$template_label" onClick="openTemplate('$table')">
                 <INPUT TYPE=HIDDEN NAME="$table\_template" VALUE="$escape_template"></TD></TR>
);

  }
}

my $_cgifunction=($user_data{_cgifunction}=~/instant ?member/i)?
  "Save Instant Member Data" : "Save Member Data";

print "</TABLE>\n";
if ($globals{userID} eq "admin") {
  print <<EOF;
<SCRIPT>
function openTemplate(t) {
  v=eval("document.form1."+t+"_template.value");
  nw=window.open('','nw','width=530,height=500,scrollbars=1,resizable=1');
  c='<BODY BGCOLOR=WHITE><H1>Maintenance Template</H1>'+
    '<I>Enter your custom HTML in the box below for the form which the member will use '+
    'when modifying a record in the <B>'+t+'</B> table.  Use </I><B>\$field[fieldname]</B><I> to '+
    'make Webdata insert a field\\\'s textbox, list, or checkbox with the current value inserted. '+
    'Use </I><B>\$data[fieldname]</B><I> to insert just a field\\\'s current value. Use '+
    '</I><B>\$escape[fieldname]</B><I> to insert the hex encoded value of a field.</I><BR>'+
    '<FORM><small><INPUT TYPE=BUTTON VALUE="Insert Field Assistant" '+
    'onClick="nw2=window.open(\\'$globals{cgilocation}?_cgifunction=Template+Field+Assistant&_tableName='+t+
    '\\',\\'nw2\\',\\'width=300,height=400\\');nw2.focus()"></small><BR>'+
    '<TEXTAREA NAME="box1" COLS=60 ROWS=20>'+unescape(v)+'</TEXTAREA>'+
    '<BR><INPUT TYPE="BUTTON" VALUE="Save" '+
    'onClick="self.opener.document.form1.'+t+'_template.value=escape(form.box1.value);'+
    'self.opener.document.form1.'+t+'_template_label.value=\\'Edit Template...\\';self.close()">'+
    '<INPUT TYPE="BUTTON" VALUE="Cancel" onClick="self.close()">'+
    '</FORM>';
  nw.document.write(c);
  nw.document.close();
  nw.focus();
}

</SCRIPT>
EOF
}
print <<EOF;
<BR>

<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="$_cgifunction">
<INPUT TYPE=SUBMIT VALUE="Save Member Data">

</FORM>
  $globals{adminLink}
EOF
$member{footer}=$instantmember{footer};
&graphicsFooter("Manage Members");
}

    
sub manageMembers {
  &adminCheck;
  my $statement="SELECT firstname,lastname,email FROM _members ORDER BY lastname, firstname";
  print "$statement<HR>" if $debug;
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  &graphicsHeader("Manage Members");
  print <<EOF;
<H1>Webdata Members</H1>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<TABLE WIDTH=60% BORDER=0><TR><TD>
<SELECT NAME="memberName" Size=15>
EOF
while (my @row=$sth->fetchrow_array) {
  my ($first,$last,$email)=@row;
  print qq(<OPTION VALUE="$email">$first $last, $email</OPTION>\n);
};
$sth->finish();
print <<EOF;
</SELECT></TD><TD>
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="">
<INPUT TYPE=BUTTON VALUE="Add New Member" onClick="form._cgifunction.value='Add Member';form.submit()"><BR>
<INPUT TYPE=BUTTON VALUE="Delete Selected Member" onClick="deleteMember(form)"><BR>
<INPUT TYPE=BUTTON VALUE="Edit Selected Member" onClick="form._cgifunction.value='Edit Member';form.submit()">
</TD></TR></TABLE></FORM>
<SCRIPT LANGUAGE="JavaScript">
function deleteMember(f) {
  if (confirm('Are you sure you want to delete the selected Member?')) {
    f._cgifunction.value="Delete Member";
    f.submit();
  }
}
</SCRIPT>
<P>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<SMALL><INPUT TYPE=SUBMIT VALUE="Export Members"> 
<INPUT TYPE=HIDDEN NAME="_tableName" VALUE="_members">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Export Records">
<SELECT NAME="delimiter">
<OPTION VALUE="comma">Comma Delimited</OPTION>
<OPTION VALUE="tab">Tab Delimited</OPTION>
</SELECT></SMALL></FORM></p><p>
$globals{adminLink}<BR>
</CENTER>

EOF
&graphicsFooter;
}

sub memberpage {
  if ($debug) {
    while (my ($k,$v)=each %member) {print "\$member{$k}=$v<BR>\n"};
  }
  if ($member{default_url}) {
    print qq(<SCRIPT>location.replace('$member{default_url}')</SCRIPT>
	    <NOSCRIPT><A HREF="$member{default_url}">Click here to continue</A></NOSCRIPT>
	    );
    exit;
  } 
  print qq(<HEAD><TITLE>Member\'s Home Page</TITLE></HEAD>);
  &graphicsHeader("Member Home Page");
  print qq(<center><h2>Welcome</h2></center>);
  if ($member{searchLayout}) {
    my @layouts=split(',',$member{searchLayout});
    my $numLayouts=@layouts;
    my $layoutOptions;
    print qq(<H3>SEARCH the database</H3>\n);
    foreach (@layouts) {
      print qq(<A HREF=\"$globals{cgilocation}?_cgifunction=user&_layout=).&escape($_).qq(\">$_</A><BR>\n);
    }
  }

  if (($member{canadd}) or ($member{canmodify}) or ($member{candelete})) {
    print qq(<H3>MANAGE data</H3>\n);
    my @tableOptions;
    foreach (@allTables) {
      next if /^_/;
      if (($globals{userID} ne "admin") and
	  ($member{canadd}!~/(^|,)$_(,|$)/) and
	   ($member{canmodify}!~/(^|,)$_(,|$)/) and
	    ($member{candelete}!~/(^|,)$_(,|$)/) and
	     ($member{limitto1}!~/(^|,)$_(,|$)/) and
              ($member{manageall}!~/(^|,)$_(,|$)/)              
	     ) {
	         next
      }
	     push(@tableOptions,$_);
    }
    foreach (@tableOptions) {
      print qq(<A HREF=\"$globals{cgilocation}?_cgifunction=manageData&_tableName=).&escape($_).qq(\">$_</A><BR>\n);
    }
  }
  print qq(<FORM ACTION="$globals{cgilocation}" METHOD=POST>
	   <INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Edit Member">
	   <INPUT TYPE=SUBMIT VALUE="Update My Profile">
  );
  &graphicsFooter;
}



sub dropTable {
  &adminCheck;
  my $sth=$dbh->prepare("DROP TABLE $user_data{_tableName}") or &error("$DBI::errstr $!");
  $sth->execute() or &error("$DBI::errstr $!");
  $sth->finish();
  $sth=$dbh->prepare("DROP TABLE _$user_data{_tableName}") or &error("$DBI::errstr $!");
  $sth->execute() or &error("$DBI::errstr $!");
  $sth->finish();
  &loadGlobals;
  $user_data{_cgifunction}="Manage Table Configurations";
  &manageTables;
}

sub addTable {
  &adminCheck;
  my $table=lc($user_data{_tableName});
  $table=~s/[^a-zA-Z0-9\_]//g;
  my $keyField=$table;
  $keyField=~s/s$//i;
  $keyField.="_id";
  &makeTable($table,"_owner|varchar(50)"," _timestamp|timestamp"," $keyField|int not null auto_increment primary key");
  my @tmp=qw(fieldname|tinytext display_type|tinytext display_parameters|longtext display_label|tinytext);
  &makeTable("_$table",@tmp);
  &do("INSERT INTO _$table VALUES ('_owner','textbox','20','Owned/Submitted By')");
  &do("INSERT INTO _$table VALUES ('_timestamp','textbox','20','Date Added')");
  &do("INSERT INTO _$table VALUES ('$keyField','textbox','20','$keyField')");
  $user_data{_tableName}=$table;
  undef $table;
  $user_data{_cgifunction}="Modify Table";
  &loadFields;
  &modifyTable;
}

sub getSingleArray {                             
  my $sth=$dbh->prepare("$_[0]") or &sqlerror($_[0],$DBI::errstr,$!);
  $sth->execute() or &sqlerror($_[0],$DBI::errstr,$!);
  my @results;
  my @row;
  while (@row=$sth->fetchrow_array) {push (@results,@row)};
  $sth->finish();
  chomp(@results);
  return (@results);
}

sub saveRelationships {
  #Did you try candy and flowers?
  &adminCheck;
  my @relationshipIDs=&getSingleArray("SELECT relationship_ID FROM _relationships ORDER BY relationship_ID");
  foreach (@relationshipIDs) {
    next unless (exists($user_data{"left$_"})) and (exists($user_data{"right$_"}));
    my $left=$user_data{"left$_"};
    my $right=$user_data{"right$_"};
    my $labelA=$user_data{"labelA$_"};
    my $labelB=$user_data{"labelB$_"};
    my ($id,$dbleft,$dbright,$dblabelA,$dblabelB,$type,$populate,$delete)=&getSingleArray("SELECT * FROM _relationships WHERE relationship_ID=$_");
    #Delete if user chose "** Select a Field **"
    if (($left eq "** Delete Relationship **") or ($right eq "** Delete Relationship **")) {
      &do("DELETE FROM _relationships WHERE relationship_ID=$_");
    }
    #Replace if different
    else {
    if ($right=~/^([^\.]+)\..+/) {
      my $oneTable=$1;
      if ((($labelA)and($labelA!~/^$oneTable\./))or(($labelB)and($labelB!~/^$oneTable\./))) {&error ("ERROR: Labels must be from the
same table as the 'one-side' field. Labels do not match \"$oneTable\" table.")};
    }
      my $statement="UPDATE _relationships SET many_side=".$dbh->quote($left).
	",one_side=".$dbh->quote($right).
	",labelA=".$dbh->quote($labelA).
	",labelB=".$dbh->quote($labelB).
	"WHERE relationship_ID=$_";
      &do($statement);
    }
  }
  #Add if new
  $_=$relationshipIDs[$#_]+1;
  my $left=$user_data{"left$_"};
  my $right=$user_data{"right$_"};
  my $labelA=$user_data{"labelA$_"};
  my $labelB=$user_data{"labelB$_"};
    if ($right=~/^([^\.]+)\..+/) {
      my $oneTable=$1;
      if ((($labelA)and($labelA!~/^$oneTable\./))or(($labelB)and($labelB!~/^$oneTable\./))) {&error ("ERROR: Labels must be from the
same table as the 'one-side' field. Labels do not match \"$oneTable\" table.")};
    }

  if (($left !~ /^\*\*.*\*\*$/) and ($right !~ /^\*\*.*\*\*$/)) {
    &do("INSERT INTO _relationships VALUES ('','$left','$right','$labelA','$labelB','','','')");  
  }
  &relationships;
}

sub relationships {
  &adminCheck;
  &graphicsHeader('Relationships');
  print <<EOF;
<CENTER><FORM ACTION="$globals{cgilocation}" METHOD=POST><TABLE BORDER=0 WIDTH=50% CELLPADDING=20 CELLSPACING=0>
<TR><TD colspan=2>
Each list option below contains a table and a field.</TD>
<TD COLSPAN=2><small>
You may select up to 2 additional fields from the "One-side" table which will appear on the drop-down list for easy identification of key values.</small>
</TD></TR><TR><TD BGCOLOR="#c3c3f0">
<font color=blue>("Many" side)</font><BR>
When displaying records from this table, use the value in this field

</TD><TD BGCOLOR="#DDDDFD">
<font color=blue>("One" side)</font><BR>
to import a record from this table with the same value in this field.
</TD>
<TD BGCOLOR="#DDDDFD"><small>
Label field for<BR>drop-down list</small>
</TD>
<TD BGCOLOR="#DDDDFD"><small>
Label field 2 for<BR>drop-down list</small>
</TD></TR>
EOF
#INSERT EXISTING RELATIONSHIPS
  my @relationshipIDs=&getSingleArray("SELECT relationship_ID FROM _relationships ORDER BY relationship_ID");
  my @allFields=&getAllTableFields; #returns every table.field combination
  foreach (@relationshipIDs) {
    my ($id,$dbleft,$dbright,$labelA,$labelB,$type,$populate,$delete)=&getSingleArray("SELECT * FROM _relationships WHERE relationship_ID=$_");    
    print qq(<TR><TD BGCOLOR="#c3c3f0"><SELECT NAME="left$_">);
    print qq(<OPTION>** Delete Relationship **</OPTION>\n);
    foreach (@allFields) {
      my $selected = (/^$dbleft$/) ? " SELECTED" : "";
      print qq(<OPTION${selected}>$_</OPTION>\n);
    }
    print qq(</SELECT>\n</TD><TD BGCOLOR="#DDDDFD">
	     <SELECT NAME="right$_">);
    print qq(<OPTION>** Delete Relationship **</OPTION>\n);
    foreach (@allFields) {
      my $selected = (/^$dbright$/) ? " SELECTED" : "";
      print qq(<OPTION${selected}>$_</OPTION>\n);
    }
    print qq(</SELECT></TD>);
    print qq(<TD BGCOLOR="#DDDDFD"><small><SELECT NAME="labelA$_">);
    print qq(<OPTION></OPTION>\n);
    foreach (@allFields) {
      my $selected = (/^$labelA$/) ? " SELECTED" : "";
      print qq(<OPTION${selected}>$_</OPTION>\n);
    }
    print qq(</SELECT></small></TD>);
    print qq(<TD BGCOLOR="#DDDDFD"><small><SELECT NAME="labelB$_">);
    print qq(<OPTION></OPTION>\n);
    foreach (@allFields) {
      my $selected = (/^$labelB$/) ? " SELECTED" : "";
      print qq(<OPTION${selected}>$_</OPTION>\n);
    }
    print qq(</SELECT></small></TD>);
    print qq(</TR>\n);   
  }
#New row
  my $count = $relationshipIDs[$#_]+1;
  print qq(<TR><TD><SELECT NAME="left$count">);
  print qq(<OPTION>** Select a field **</OPTION>\n);
  foreach (@allFields) {
    print qq(<OPTION>$_</OPTION>\n);
  }
  print qq(</SELECT>\n</TD><TD>\n<SELECT NAME="right$count">);
  print qq(<OPTION>** Select a field **</OPTION>\n);
  foreach (@allFields) {
    print qq(<OPTION>$_</OPTION>\n);
  }
  print qq(</SELECT></TD>);
    print qq(<TD><small><SELECT NAME="labelA$count">);
    print qq(<OPTION></OPTION>\n);
    foreach (@allFields) {
      print qq(<OPTION>$_</OPTION>\n);
    }
    print qq(</SELECT></small></TD>);
    print qq(<TD><small><SELECT NAME="labelB$count">);
    print qq(<OPTION></OPTION>\n);
    foreach (@allFields) {
      print qq(<OPTION>$_</OPTION>\n);
    }
    print qq(</SELECT></small></TD></TR>\n);
  print <<EOF;
<TR><TD COLSPAN=2 ALIGN=RIGHT>
<font color=blue>
(Choose "** Delete Relationship **" on either side to delete a relationship)<BR>
(A new row is added to the bottom as needed when you save)<BR></font>
<INPUT TYPE=SUBMIT NAME="_cgifunction" VALUE="Save Table Relationships">
</TABLE></FORM>
</CENTER>
<A HREF="$globals{cgilocation}?_cgifunction=Manage+Table+Configurations">Return to Manage Tables Screen</A><BR>
$globals{adminLink}
EOF
  print ("<FORM>".&help('Relationships','Help with Table Relationships')."</FORM>");
  &graphicsFooter;
}

sub help {
  my $helpdoc=shift;
  my $helpValue="Help";
  if ($_[0]) {$helpValue=$_[0]};
  my $doc=&escape($helpdoc);
  my $title=&escape($helpValue);
  my $result = "";
  unless ($globals{wroteHelpFunction}) {
    $globals{wroteHelpFunction}=1;
    $result.= <<EOF;
      <SCRIPT>
      function helpWindow(doc,title) {
	options='width=500,height=500,scrollbars=1,resizable=1,dependent,screenX=200,screenY=72';
	urlval='$globals{cgilocation}?_cgifunction=getDoc&_document='+doc+'&_helpValue='+title;
	nw=window.open(urlval,'',options);
	nw.focus();
      }
      </SCRIPT>
EOF
  } 

    $result.=qq(<INPUT TYPE=BUTTON VALUE="$helpValue" onClick="helpWindow('$doc','$title')">);
  return $result;
}

sub getDoc {
  $_=$user_data{_document};
  my $title=$user_data{_helpValue};
  my $result;
  if (/^Layouts$/) {
    $result = <<EOF;
<BODY BGCOLOR=WHITE>
A <B>layout</B> is a set of instructions for how the database should display the
found records after executing a query.  The layout form allows you to define 
several several general preferences that are not related to the data, such as
language, colors, and header/footer text.  You may also choose to use the
default configuration (a table), or enter your own HTML into the template boxes.<P>

<h2>Searching with layouts</h2>
You can force a custom search page to use any layout by entering this tag
inside the form:
<BLOCKQUOTE>&lt;INPUT TYPE=HIDDEN NAME="_layout" VALUE="layout name"&gt;</BLOCKQUOTE>
Typically, if you want to create a search page which uses an alternate layout, you would
follow this sequence:
<OL>
<LI> Create a new layout
<LI> Browse to the user search page from the admin screen.
<LI> Choose "SAVE-AS" in the FILE menu, and save the page to your hard disk.
<LI> Insert the &lt;INPUT TYPE=HIDDEN NAME="_layout" VALUE="layout name"&gt; 
     tag into the page you have just saved.
<LI> Upload the new search page to your server.
<LI> Enter the URL to your new search page in the '<B>URL for "search agin" link:'</B>
     box in your new layout.
</OL>

The "_layout" parameter on the search page, and the "search again" link value in a 
layout usually compliment each other.  That is, a search page will use the _layout
value to call a layout, which in turn uses the "search again" value to return to
the same search page.
<P>
<h2>Using layouts with members</h2>
You may allow a member to see a different layout than the rest of the world, perhaps
because the member has paid for proprietary information, or that member is a supervisor
with greater privileges. To do this, define a layout to display more information than the 
default layout, and select the new layout when managing a member\'s profile.<P>
Webdata will automatically insert the "_layout" tag for the correct layout when it creates
the search page.
<P>
<h2>Elements of the layout form</h2>
<B>Language</B>: All of text which Webdata generates, such as
"next page", "go to page 1,2,3", "search again" etc will be displayed
in the selected language.  

<P><B>Parameters for BODY tag</B>: Anything entered into this box will be
inserted in the BODY tag, after the word "BODY" and before the closing "&gt;". 
You can insert values for bgColor or Background to change the background color
or replace the background with an image. You can also set values for "color", "link",
and "vlink" to change the text color.  Furthermore, if you need to insert a special
parameter such as "onLoad='setTimeVal()'" you may do so here.

<P><B>URL for "return to homepage" link</B>: If you check the "Show Return to Homepage"
checkbox, further down on the page, a link will appear at the
bottom of every page labeled "Return to Homepage" in the selected language.  If this box
is left empty, it will link to the default search page, otherwise it will 
link to whatever URL is entered in this box.  It is best to enter full
URLs into this box, beginning with "http://".

<P><B>Header for Search Results</B>: Any HTML entered into this box will be displayed
at the top of the search results page.  This is a good place to put your company name,
an image tag for your logo, and any navigation buttons which are found throughout your site.

<P><B>Display Search Criteria</B>: When this box is checked, the parameters that the user
searched for will be displayed just below the Header text. This is useful if your user
will be displaying many complex queries, and would like to document each one so they can
tell them apart when reviewing printouts at a later time.

<P><B>Hide Table Border</B>: Simply a cosmetic choice. Webdata also increases the cellpadding 
to make the table look better.

<P><B>Font information</B>: A FONT tag is inserted at the beginning of every &lt;TD&gt; cell in
the results table. Any text which you enter in this box will be inserted into that FONT tag, after
the word "FONT" and before the closing "&gt;".  This allows you to change the font, size, and color
of the text inside the table.

<P><B>Table Background Colors:</B>: 
The <B>Header Row</B> is the first row of the table. It contains the name of each field displayed.<BR>
<B>Alternate Row1</B> is the background color of all of the odd numbered rows, while 
<B>Alternate Row2</B> is the background color of all of the even numbered rows. You may use
the "Display Color Table" button at the top of the page to get a list of the commonly used
colors, or you may enter a # sign followed by a 6 character hex code for the desired color.

<P><B>Sub-Footer for Search Results</B>:
The HTML entered into this box will be displayed immediately after the search results. 
This is especially useful if you wish to position the search results into your own
table.  If you place a &lt;TD&gt; tag at the end of the "Header for search results", you
would place a &lt;/TD&gt; tag at the top of the "Sub-Footer for search results" box.

<P><B>Number of Results Per Page</B>
If the number of found records exceeds the number in this box, a "next page" button
and "go to page 1 2 3 ..." links will appear after the
desired number of records is displayed.

<P><B>Show "go to page 1 2 3 ..."</B>: If the number of results per page were set to 20,
for example, and a query found 520 records, 
Records 1-20 would appear on the first search
results page, and Webdata will display:
<BLOCKQUOTE><FONT SIZE=-1>Go to page </FONT><FONT SIZE=-1 COLOR=BLUE>1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26</FONT></BLOCKQUOTE> If the user wished to skip directly records number 501-520, they could click
on the last numbered link, rather than clicking "next page" 26 times.  If the number of pages
is greater than 50, Webdata will scale the numbering to avoid a cumbersome list of page numbers.

<P><B>Show "Next Page/Previous Page" Buttons</B>:
Using the example above, where records 1-20 of 520 are displayed on the first search results
page, the user could click "Next page" to display records 21-40, then click it again to display
records 41-60, etc.  Likewise, the user can go backwards by clicking the "Previous page" button.
This box should be checked unless you have an unusual situation such as withholding the records
on the other pages from non-members.

<P><B>Show "Search Again" link</B>: When this box is checked, a link titled "Search again" (in the 
selected language) will appear at the bottom of each page. The link will point to the default search
page unless there is a value in the "URL for search again" box above.

<P><B>Show "Return to Homepage" link</B>:When this box is checked, a link titled "Return to Homepage" (in the 
selected language) will appear at the bottom of each page. The link will point to the default homepage
page unless there is a value in the "URL for Return to Homepage" box above.

<P><B>Footer for entire Search Results page</B>: The HTML entered into this box will appear at the very bottom of the page.  If you would like a footer navigation bar or a copywrite to appear on every page, this is the place to put it.

<P><B>Sequence of Fields</B>: If you do not use a template, Webdata will show the found records in a table.
These two boxes are used to determine WHICH columns to display, and in what sequence.  To select your columns,
first click "Clear Sequence", then click on each field in the left box in the sequence you would like.
We recommend you limit the Report Columns list to 7 or 8 of the most important fields.  Then, if you check the 
"Include Form View Button" checkbox below, the user will be able to click on any record to see more information.
If you select fields from 2 or more different tables, Webdata will use the table relationships to 
build the query accordingly.  You should be aware of the table relationships when selecting fields.

<P><B>Sorting</B>: Use these boxes to select the field you wish to sort the results on, and whether to sort in ascending or descending order. The second and third sort boxes are only used if you are likely to have several of the same value in the the first (or second) sort field.  For example, If I choose "State" in the first sort box, "City" in the second, and "Last Name" in the third, I am telling the database to display everyone from Alabama first, then everyone from Alaska, then Arkansas, etc. When displaying the Alabama records, display those from Abbeville, then Abernant, then Adamsville. Within each of those cities, display the records in order of Last Name.

<P><B>Form View Button</B>: When this box is checked, a button or an image will appear to the left of every row in the results table. When the user clicks on this, a new window will open with more information about the selected record.  If you do not use a template for form view, the database will display a list of every field in every related table and its current value.  If you prefer the look of a button, enter a label such as "Details" or "More Info" into the "Label for Button" box, and leave the "Image file for Button" blank.  If you would like to design a graphic to use here, simply upload it to your web server, and enter the full URL (begin with http://) into the "Image file for Button" box.

<P><B>Templates</B>: A template is used to display your own HTML designs instead
of the default tables.  By inserting certain keywords into your HTML, as described
just above the "Template for Search Results", you can integrate the data from each
found record into your designs.  For example, the following HTML would display an
employee\'s name and phone number in a telephone directory format:<small>
<BR>&nbsp;&nbsp;&lt;B&gt;<B>\$data[employees.lastname],&nbsp;\$data[employees.firstname]</B>&lt;/B&gt;............&lt;I&gt;<I>\$data[employees.telephone]</I>&lt;/I&gt;&lt;BR&gt;</small>
<BR>
<B>Conditional Results</B>
  You may use <B>\$if (condition) {true} else {false}</B> in a template to display different
text depending on the values in a field.  For example:<BLOCKQUOTE>
\$if (\$data[products.picture]) {&lt;IMG SRC="\$data[products.picture]"&gt;} else {&lt;IMG SRC="/images/Default.gif"&gt;}<BR>
\$if (\$data[employees.status] =~ /part time/) {&lt;font color=red&gt;Part Time&lt;/font&gt;}<BR>
&nbsp;&nbsp;<I>Use "=~ /text/" to match text. Only use "==" for numbers. Regular Expressions will work.</I><BR> 
\$if (\$data[property.lotSize] >= 10000) {&lt;B&gt;BIG LOT&lt;/B&gt;}

</BLOCKQUOTE> 

If there is any text in either of the template boxes, the template will be used instead of the default table.
<P>
The "Template for Search Results" will be repeated once for each found record. This means that
if you set the number of results per page to 15, the contents of the "Template for Search Results"
will appear 15 times, each time with the values from a different records where the \$data[table.field] 
tags are.  If you want your search results to appear in a table, you should put the &lt;TABLE^gt; tag
in the "Header for search results" and put the &lt;/TABLE&gt; tag in the "Sub-footer for search results".
Then define a single row in the "Template for Search Results", for example:<BR>
&nbsp;&nbsp;&lt;TR&gt;&lt;TD&gt;\$data[employees.lastname]&lt;/TD&gt;&lt;TD&gt;\$data[employees.firstname]&lt;/TD&gt;&lt;/TR&gt;
<P>
The "Insert Field Assistant" button is there to help reduce typos and save you time looking up field names. When you click "Insert Field Assistant" a window will appear with a list of every field in the database. When you click on one of the fields, the \$data[table.field] tag will appear in the box below. The box will also self-highlight so that you can copy it by hitting [ctrl-c] and then paste it into the template.
<P>
The "Template for Form View" will display your custom HTML in a new window when the user clicks the "view" button.
EOF
  }

  if (/^Export$/) {
    $result = <<EOF;
<HTML>
<HEAD>
<TITLE>Export Button</TITLE>
</HEAD>
<BODY BGCOLOR="#ffffff">
<h1>Exporting Records</h1>
This feature will create a comma, tab, or pipe delimited text file which may then be
imported into a spreadsheet or used with another database.
The export button will export all of the <I>found</I> records in the search results screen.
If you only want to export products where the price is greater than \$30, enter ">30" into
the "price" box before you click "Search/modify". Then, only products which cost over \$30
will be found, and only those will be exported.  Likewise, by leaving the search form blank,
you will find all records, and the export button will include all records in the text file.
<P>
<B>SAVING THE DATA</B><BR>
The data is returned as a plain text file, not an HTML file.  Simply choose "SAVE-AS" from your
file menu, and select a name and location for the exported text.  If you chose "comma" as the 
delimiter, give your file a ".csv" extension. Many programs, such as Excel, will recognize this
extension and will open the file correctly.  For "tab" and "pipe" delimited files, a ".txt" extension
is conventional.
<P>
<B>WHAT IF MY DATA HAS COMMAS IN IT?</B><BR>
This is not a problem. There are standard rules for saving CSV files which account for that.
Webdata uses quotes as a text qualifier around all values that contain anything other than a number. 
Any quotes in a value are replaced with two quotes in a row.  Any program that can import a CSV
file will decode the file accordingly.
</BODY></HTML>
EOF
  }

  if (/^Relationships$/i) {
    $result = <<EOF;
<HTML><HEAD><TITLE>Help with Table Relationships</TITLE></HEAD>
<BODY BGCOLOR=WHITE>
<h2 align=center>Table Relationships</h2>
<OL><LI>Introduction to relational databasing</LI>
<LI>Webdata Relationship Screen</LI></OL><P>

<center><h3>1. An introduction to relational databasing</h3></center>
<P>
Here is a quick example that explains what relational databasing is:<P>
Imagine that you have a database of 15,000 products which you sell in your store. Each of these products is ordered from one of 11 different vendors that you work with.  You wish to display each product, with the name and address of its vendor.  It would be a waste of space to repeat the vendor\'s name and address over and over again in the products table. Instead, the smart solution is to create another small table named "vendors", which contains only 11 records, one for each vendor, with each vendor\'s address.  Then, as long as you have a vendor name in the <i>products</i> table for each record, the database can actually <I><B>look up</B></I> the vendor information as it displays each product.  It is this process of <I><B>looking up</B></I> information from another table that has come to be known as <I>Relational Databasing</I>.
<PRE>
Products Table:                
---------------                
SKU_Code                  
Name                          
Description                    Vendors Table:
Price                          --------------
Vendor &lt;M-------------------1&gt; Vendor_Name
                               Address
                               City
                               State/Province
                               Postal Code
                               Telephone
                               Fax
                               
</PRE>

Now, when we query the database for a product named "small widget", the database will locate the record in <I>Products</I> which contains "small widget" in the Name field.  It will display the SKU_Code, Name, Description, and Price. It will then automatically find the record in <I>Vendors</I> which contains the same value in "Vendor_Name" as the Products table has stored in the "Vendor" field, and it will display the Vendor Name, Address, City, etc.  <P>

Sometimes students will ask "Doesn't this slow the database down because it has to do all of these additional lookups?" The answer is "No. Actually the database goes faster because it has to load less data into memory."  In fact, databases preload a list of Vendor Names so that they can locate the correct record without searching. This list is called an <i>index</i>.
<P>
<B>Primary Keys</B><BR>
What would happen if we had two vendors with the same name?  For example, if some products are ordered from "American Widgets" out of the Seattle, WA office, and others come from another branch of "American Widgets" located in Boston, MA.  When a product tried to lookup the vendor information for "American Widgets", it would not know <i>which</I> record to load.  Because of this, there is a rule that the field which is used for looking up values from other tables <I>must be unique</I>.  This field has a special name. It is called the <B><I>Primary Key.</I></B>. If we had defined "Vendor_Name" as the primary key, the database would never have allowed us to enter a second record with the same vendor name as an existing record. We would have been forced to choose an alternative, such as "American Widgets - Boston", and the problem would be resolved.  The database also makes sure that the Primary Key field is never left blank, and it will create an <i>index</i> so that the lookups are as fast as possible.<P>

<B>1 to 1, 1 to Many</B><BR>
There are 2 types of table relationships, "1 to1", and "1 to Many".
The most common type of table relationship is called a "1 to Many" relationship.  Using our example above,
each vendor name will appear only once in the <I>Vendors</I> table, but it could appear many times in the <I>Products</I> table.  In the diagram above, a "1" and an "M" were placed at the appropriate ends of the relationship line.  <P>

1 to 1 relationships are used to break one big table into 2 smaller tables. You may wish to do this because some of the data is not used much of the time, and you want to speed up the database for the remaining data. Also, in some programs, you may be able to restrict access to the second table for security reasons.<P>

<B>Combo Boxes - lists of possible values while adding or modifying records</B>
If you have defined a 1 to Many relationship between two tables, when you go
to add a new record to the table on the "Many" side, Webdata will automatically
insert a select list with all of the possible values for the <I>foreign key</I>,
the field that is used to look up a value from the other table.  This is very
helpful becuase it means you do not have to worry about entering the related values
correctly.  <B>Note:</B> When defining the fields for a table which will be on the
"one side" of a relationship, put the most important and descriptive fields first.
The first 3 field values will appear next to the primary key in the select list.
That way, if the primary key is a social security number, you can have the person\'s
name appear next to each number in the list.

<center><h3>2. Webdata\'s Relationship Screen</h3></center>
In the Webdata "Table Relationships" screen, each relationship is displayed as a pair of select lists.
<BR><B>IMPORTANT</B>, in a "1 to Many" relationship, <B><I>The Many table always goes on the left</I></B>.
Our example above would be displayed like this:

<FORM><TABLE BORDER=0 CELLPADDING=20><TR><TD><SELECT><OPTION>products.vendor</OPTION></SELECT>
</TD><TD><SELECT><OPTION>vendors.vendor_name</OPTION></SELECT></TD></TR></TABLE>
<B>Not</B> like this:
<TABLE BORDER=0 CELLPADDING=20><TR><TD><SELECT><OPTION>vendors.vendor_name</OPTION></SELECT>
</TD><TD><SELECT><OPTION>products.vendor</OPTION></SELECT></TD></TR></TABLE>
</FORM>
<P> 
<B>Creating more than 1 relationship:</B><BR>
If you wish to create more that 1 relationship, simply select your first table relationship using the 2 boxes on the screen, labeled "** Select a field**", then click "Save Table Relationships".  When the screen refreshes, it will display your selections, and then create 2 more "** Select a field **" boxes for your next table relationship.
<P>
<B>Deleting a relationship:</B><BR>
To delete a relationship, select the first option (** Delete Relationship **) in either column, and then click "Save Table Relationships".

</BODY></HTML>
EOF
  }
  my $header=qq(<HEAD><TITLE>$user_data{_helpValue}</TITLE>);
  $header.=qq(<form><input type=button value="Print" onClick="print()">);
  $header.=qq(<input type=button value="Close" onClick="self.close()"></form>);
  my $footer=qq(<CENTER><FORM><INPUT TYPE=BUTTON VALUE=" OK " onClick="self.close()"></FORM></CENTER>);
  print "$header $result $footer";
}

sub getAllTableFields {
  my @result;
  my @tables=@allTables;
  foreach my $table (@tables) {
    next if $table =~ /^_/;
    my @fields=getFields($table);
    foreach my $field (@fields) {
      push (@result,"${table}.$field");
    }
  }
  return (@result);
}

sub getTableOwnerFields {
  my @result;
  my @memberFields=&getFields("_members");
  my @tables=@allTables;
  foreach my $table (@tables) {
    next if $table =~ /^_/;
    my @fields=getFields($table);
    foreach my $mf (@memberFields) {
      next if $mf=~/^header|footer|profileTemplate|canadd|canmodify|candelete|canimport|canexport|limitto1|manageall|templates|groupname|default_url|searchLayout$/;
      if ($mf=~/^(user\d\d?)$/) {next unless $globals{$1}};
      push (@result,"${table}._owner.$mf");
    }
  }
  foreach my $mf (@memberFields) {
    next if $mf=~/^header|footer|profileTemplate|canadd|canmodify|candelete|canimport|canexport|limitto1|manageall|templates|groupname|default_url|searchLayout$/;
    if ($mf=~/^(user\d\d?)$/) {next unless $globals{$1}};
    push (@result,"_members.$mf");
  }
  return (@result); 
}

sub insertField {
  &adminCheck;
  my $position;
  my $dataType;
  if ($user_data{selectedField}) {
    $position="AFTER $user_data{selectedField}";
  } else {
    $position="AFTER _timestamp";
  }  
  my $sqlFieldName=lc($user_data{fieldName});
  $sqlFieldName=~s/[^a-zA-Z0-9\_]//g;
  if ($sqlFieldName=~/^\_/) {
    &error("The first valid character in your fieldname was \"_\".<BR>
            Only Webdata Pro control fields may begin with an underscore.");
  }
  if ($user_data{required} =~ /^[y]/i) {$user_data{dataType}.=" NOT NULL"};
  unless (&getKey($user_data{_tableName})) {
    if ($user_data{autonum}=~/Y/i) {$user_data{dataType}.=" auto_increment"};
    $user_data{dataType}.=" PRIMARY KEY";
  }
  my $statement="ALTER TABLE $user_data{_tableName} ADD $sqlFieldName $user_data{dataType} $position";
  print "$statement<HR>" if $debug;
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  $sth->finish();
  $statement="INSERT INTO _$user_data{_tableName} VALUES (";
  $statement.=$dbh->quote($sqlFieldName).",";
  $statement.=$dbh->quote($user_data{displayType}).",";
  $statement.=$dbh->quote($user_data{prefs}).",";
  $statement.=$dbh->quote($user_data{fieldName}).")";
  print "$statement<HR>" if $debug;
  $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  $sth->finish();
  &loadFields($user_data{_tableName});
  &loadGlobals;
  &modifyTable;
}

sub deleteField {
  &adminCheck;
  my $statement="ALTER TABLE $user_data{_tableName} DROP $user_data{selectedField}";
  &do($statement);
  $dbh=&connect($dbdriver,$dbname,$dbusername,$dbpassword) or &error("Content-type: text/html\n\nCould not connect to \"dbi:$_[0]:$_[1]\",\"$_[2]\",\"$_[3]\"<P>$DBI::errstr");
  $statement="DELETE FROM _$user_data{_tableName} WHERE fieldname=".$dbh->quote($user_data{selectedField});
  print "$statement<HR>" if $debug;
  &do($statement);
  &loadFields($user_data{_tableName});
  &loadGlobals;
  &modifyTable;
}

sub refreshFields {
  &adminCheck;
  my %f=&extractField($user_data{_tableName},$user_data{key});
  my $oldKey=&getKey($user_data{_tableName});
  if ($oldKey) {
    my %g=&extractField($user_data{_tableName},$oldKey);
    if ($g{extra}=~/auto_increment/) {
      my $result=&do(qq(ALTER TABLE $user_data{_tableName} MODIFY $oldKey $g{type} NOT NULL));
    } 
    &do("ALTER TABLE $user_data{_tableName} DROP PRIMARY KEY");
  }
  &do("ALTER TABLE $user_data{_tableName} MODIFY $user_data{key} $f{type} NOT NULL");
  my $changedKey=&do("ALTER TABLE $user_data{_tableName} ADD PRIMARY KEY ($user_data{key})");
  unless ($changedKey) {
    my $b=$DBI::errstr;
    &do(qq(ALTER TABLE $user_data{_tableName} ADD PRIMARY KEY ($oldKey)));
    print qq(<SCRIPT>
	     msg="Could not change primary key.\\n";
	     msg+=unescape\(\").&escape($b).qq(\"\)\;
	     alert(msg);
	     </SCRIPT>);
  }
  &loadGlobals;
  &loadFields($user_data{_tableName});
  &modifyTable;
}

sub redefineField {
  &adminCheck;
  my $dataType;
  my $sqlFieldName=lc($user_data{fieldName});
  $sqlFieldName=~s/[^a-zA-Z0-9\_]//g;
  if ($sqlFieldName=~/^\_/) {
    &error("The first valid character in your fieldname was \"_\".<BR>
            Only Webdata Pro control fields may begin with an underscore.");
  }
  my $statement="ALTER TABLE $user_data{_tableName} CHANGE $user_data{selectedField} $sqlFieldName $user_data{dataType}";
  if ($user_data{required} =~ /^y/i) {$statement.=" NOT NULL"};
  if ($user_data{index} =~ /^y/i) {$statement.=" ,ADD INDEX \($user_data{selectedField}\)"};
  if ($user_data{autonum} =~ /^y/i) {$statement.=" AUTO_INCREMENT"};
  print "$statement<HR>" if $debug;
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr);
  $sth->execute() or &sqlerror($statement,$DBI::errstr);
  $sth->finish();
  $dbh=&connect($dbdriver,$dbname,$dbusername,$dbpassword) or &error("Content-type: text/html\n\nCould not connect to \"dbi:$_[0]:$_[1]\",\"$_[2]\",\"$_[3]\"<P>$DBI::errstr");
  $statement="UPDATE _$user_data{_tableName} SET \n";
  $statement.="fieldname=".$dbh->quote($sqlFieldName).",\n";
  $statement.="display_type=".$dbh->quote($user_data{displayType}).",\n";
  $statement.="display_parameters=".$dbh->quote($user_data{prefs}).",\n";
  $statement.="display_label=".$dbh->quote($user_data{fieldName})." WHERE \n";
  $statement.="fieldname=".$dbh->quote($user_data{selectedField})."\n";
  print "$statement<HR>" if $debug;
  $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr);
  $sth->execute() or &sqlerror($statement,$DBI::errstr);
  $sth->finish();
  &loadFields($user_data{_tableName});
  &loadGlobals;
  &modifyTable;
}

sub modifyTable {
  &adminCheck;
  my $table=$user_data{_tableName};
&graphicsHeader("Manage Table Configurations");
  print <<EOF;
<HTML><HEAD><TITLE>Modify Table Page</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--

dataTypeArray=new Array();
subTypeArray=new Array();
displayTypeArray=new Array();
displayParametersArray=new Array();
displayLabelArray=new Array();
requiredArray=new Array();
indexArray=new Array();
autocountArray=new Array();
keyArray=new Array();

EOF

  foreach my $s2 (&getFields($table)) {   
    next if $s2=~/^_owner$/;
    my $tmp=$fields{$table}{$s2};
    my %tmp2=%$tmp;
    if ($tmp2{type}=~/int|float|real|double|decimal|numeric/i) {
      if ($tmp2{type}=~/tinyint/i) {$tmp2{subtype}=1}
      elsif ($tmp2{type}=~/smallint/i) {$tmp2{subtype}=2}
      elsif ($tmp2{type}=~/^int$/i) {$tmp2{subtype}=3}
      elsif ($tmp2{type}=~/bigint/i) {$tmp2{subtype}=4}
      elsif ($tmp2{type}=~/float/i) {$tmp2{subtype}=5}
      elsif ($tmp2{type}=~/real/i) {$tmp2{subtype}=6}
      else {$tmp2{subtype}=""};
      $tmp2{type}=1;
    }
    elsif ($tmp2{type}=~/char|text|enum/i) {
      if ($tmp2{type}=~/tinytext/i) {$tmp2{subtype}=1}
      elsif ($tmp2{type}=~/^text$/i) {$tmp2{subtype}=2}
      elsif ($tmp2{type}=~/longtext/i) {$tmp2{subtype}=3}
      else {$tmp2{subtype}=""};
      $tmp2{type}=2
    }
    elsif ($tmp2{type}=~/date/i) {$tmp2{type}=3}
    else {$tmp2{type}=4}; #time

    if ($tmp2{display_type}=~/text/) {$tmp2{display_type}=1}
    elsif ($tmp2{display_type}=~/checkbox/) {$tmp2{display_type}=2}
    elsif ($tmp2{display_type}=~/list/) {$tmp2{display_type}=3}
    elsif ($tmp2{display_type}=~/comment/) {$tmp2{display_type}=4}
    else {$tmp2{display_type}=5}

    $tmp2{required} = ($tmp2{null}) ? "" : "Yes";
    $tmp2{index} = ($tmp2{key}=~/./) ? "Yes" : "";
    $tmp2{autonum} = ($tmp2{extra}=~/auto_increment/i) ? "Yes" : "";
    $tmp2{key} = ($tmp2{key}=~/PRI/i) ? "Yes" : "";

    foreach (keys %tmp2) {
      $tmp2{$_}=&escape($tmp2{$_});
    }


    print qq(dataTypeArray['$s2']=unescape("$tmp2{type}");\n);
    print qq(displayTypeArray['$s2']=unescape("$tmp2{display_type}");\n);
    print qq(subTypeArray['$s2']=unescape("$tmp2{subtype}");\n);
    print qq(displayParametersArray['$s2']=unescape("$tmp2{display_parameters}");\n);
    print qq(displayLabelArray['$s2']=unescape("$tmp2{display_label}");\n);
    print qq(requiredArray['$s2']=unescape("$tmp2{required}");\n);
    print qq(indexArray['$s2']=unescape("$tmp2{index}");\n);
    print qq(autocountArray['$s2']=unescape("$tmp2{autonum}");\n);
    print qq(keyArray['$s2']=unescape("$tmp2{key}");\n);
    print "\n\n";
  }

print <<EOF;
function insert() {
  val=getPrompts('','2','1','20','No','No','1'); 
  if (!val) {return false};
  document.form1._cgifunction.value="Insert Field";
  document.form1.submit(); 
}

function deleteField() {
  s=document.form1.selectedField;
  isChecked=false;
  for (i=0;i<s.length;i++) {
    if (s[i].checked) {
      isChecked=s[i].value;
    }
  }
  if (!isChecked) {alert('No field has been selected');return false};
  if (keyArray[isChecked]=="Yes") {
    alert(displayLabelArray[isChecked]+' is a primary key.\\nYou cannot delete it until you choose another key.');
    return false;
  }
  val=confirm('Are you sure you want to delete the '+isChecked+' field? All values in that field will be lost.')
  if (val) {
    document.form1._cgifunction.value="Delete Field";
    document.form1.submit();
  }
}

function clearForm() {
  s=document.form1.selectedField;
  for (i=0;i<s.length;i++) {s[i].checked=false}
  if (!s.length) {s.checked=false};
}

function refreshScreen() {
  f=document.form1;
  f._cgifunction.value="Refresh Fields";
  f.submit();
}

function redefine() {
  val=getRadioVal(document.form1.selectedField);
  a=displayLabelArray[val];
  b=dataTypeArray[val];
  c=displayTypeArray[val];
  d=displayParametersArray[val];
  e=requiredArray[val];
  f=autocountArray[val];
  g=subTypeArray[val];
  val2=getPrompts(a,b,c,d,e,f,g);
  if (!val2) {return false};
  document.form1._cgifunction.value="Redefine Field";
  document.form1.submit();
}

function getRadioVal(r) {
  if (r.length) {
    for (i=0;i<=r.length;i++) {
      if (r[i].checked) {return r[i].value}
    }
  } else {
    return r.value;
  }
}

function getPrompts(a,b,c,d,e,f,g) {
  var fieldName="";
  fieldName=prompt('Field Name:',a);
    if (!fieldName) {return false};
    if (fieldName.indexOf('_')==0) {
      alert("Fields may not begin with '_'. \\nWebdata reserves that naming convention for control fields.");
      return false;
    }

  var displayType=0;
  while (!displayType) {
  displayType=prompt('Display Type:\\n1.Textbox, 2.Checkbox, 3.List, 4.Comment (textarea), 5.Upload',c);
    if (!displayType) {return false};
    if (!((displayType>=1)&&(displayType<=5))) {displayType=0};
    displayTypeText=Array('','textbox','checkbox','list','comment','upload')[displayType];
  }

  var prefs="";
  if ((displayType==1)||(displayType=="textbox")) {
    message='How many characters long should the textbox appear?';
    if ((!d)||(displayType!=c)) {d='20'};
    prefs=prompt(message,d);
    if (!prefs) {return false};
  }

  if ((displayType==3)||(displayType=="list")) {
    message='Enter each value for the select list, seperated by a comma:';
    if ((!d)||(displayType!=c)) {d='Red,Green,Blue'};
    prefs=prompt(message,d);
    if (!prefs) {return false};
  }

  if ((displayType==4)||(displayType=="comment")) {
    message='Enter the number of columns then rows for the textarea box, seperated by a comma';
    if ((!d)||(displayType!=c)) {d='60,4'};
    prefs=prompt(message,d);
    if (!prefs) {return false};
  }

  if ((displayType==5)||(displayType=="upload")) {
    if ((d)&&(displayType==c)) {
      kbmax=d.substring(0,d.indexOf('|'));
      ftypes=d.substring(d.indexOf('|')+1,999);
    } else {
      kbmax='500';
      ftypes='gif,jpg';
    }
    message='Enter the maximum number of Kilobytes for uploading';
    prefs=prompt(message,kbmax);
    if (!prefs) {return false};
    message='Enter the file types which may be uploaded';
    prefs2=prompt(message,ftypes);
    if (!prefs2) {return false};
    prefs=""+prefs+"|"+prefs2;
  }  

  var dataType="";
  var subType="";
  if ((displayType==1)||(displayType==3)||(displayType==4)||(displayType=="textbox")||(displayType=="comment")||(displayType=="list")) {
    if ((displayType==1)||(displayType==3)){
      dataType=prompt('Data Type:\\n1.Number, 2.Text, 3.Date, 4.Time',b);
      if (!dataType) {return false};
    }
    if (displayType==4) {dataType=2}
    if (dataType==1) {
      nt=1;
      if (g>4) {nt=2};
      intType=prompt('Number Type: 1. Integers only, 2. Decimal numbers',nt);
      if (!intType) {return false};
      if (intType==1) {
	message='Number Size ():\\n'+
	  '1. <128, '+
	  '2. <32K, '+
	  '3. <2 billion, '+
	  '4. >2 billion';
	if ((!g)||(dataType!=b)) {g=2};
	subType=prompt(message,g);
	if (!subType) {return false};
	dataTypeText=Array('','tinyint','smallint','int','bigint')[subType];
      } else {
        message='Number Size ():\\n'+
	  '1. <2 billion, '+
	  '2. >2 billion';
	if ((!g)||(dataType!=b)) {g='1'};
	if (g>4) {g-=4};
	subType=prompt(message,g);
	if (!subType) {return false};
	dataTypeText=Array('','float','real')[subType];
      }
    }
    if (dataType==2) {
      if (displayType==1) {
	dataTypeText="varchar("+prefs+")";
      } else {
	if (displayType==4) {
      message='Choose a maximum length:\\n'+
	'1. <256 chars, '+
	'2. <64K chars, '+
	'3. <4.2 billion chars';
      if ((!g)||(dataType!=b)||(c!=4)) {g='2'};
     
      
      subType=prompt(message,g);
      if (!subType) {return false};
      dataTypeText=Array('','tinytext','text','longtext')[subType];
    } else {
      if (displayType==3) {
	subType=prompt('Enter the maximum number of characters','');
	if (!subType) {return false};
	dataTypeText="varchar("+subType+")";

      }
    }
    }
    }
    
    if (dataType==3) {dataTypeText='date'};
    if (dataType==4) {dataTypeText='time'};
    if (isNaN(parseInt(dataType))) {dataTypeText=dataType};
  } else {
    if (displayType==2) {dataTypeText='tinyint'};
    if (displayType==5) {dataTypeText='longblob'};
  }
  
  
  var required="";
  if (displayType!=2) {
    required=0;
    if (!e) {e="No"};
    while(!required) {
      required=prompt('Is this a required field? [Yes/No]',e);
      if (!required) {return false};  
      if ((required.indexOf('y'))&&(required.indexOf('Y'))&&(required.indexOf('n'))&&(required.indexOf('N'))) {
	required=0;
      }
    }
  }
  
  var autonum="";
  if ((dataType==1)&&(intType==1)) {
    if (!f) {f="No"};
    autonum=prompt('Would you like an autocounter in this field? [Yes/No]',f);
    if (!autonum) {return false};
  }

  document.form1.fieldName.value=fieldName; 
  document.form1.displayType.value=displayTypeText;
  document.form1.dataType.value=dataTypeText; 
  document.form1.prefs.value=prefs; 
  document.form1.required.value=required; 
  document.form1.autonum.value=autonum;  

  return true;
}

function setIndex(v) {
  vName=getIndexName(v.name);
  if (keyArray[vName]=="Yes") {
    v.checked=true;
    alert('Cannot remove index from primary key');
    return;
  }
  document.form1.fieldName.value=vName;
  if (v.checked) {
    document.form1._cgifunction.value="Add Index";
  } else {
    document.form1._cgifunction.value="Drop Index";
  }
  document.form1.submit();
}

function getIndexName(val) {
  if (val.indexOf('_index')==val.length-6) {
    return val.substring(0,val.indexOf('_index'));
  }
}

//-->
</SCRIPT>

<BODY BGCOLOR=WHITE onLoad="document.form1.reset();document.form1.insertButton.focus()">
<H1 ALIGN=CENTER>Fields for $table table</H1>
<CENTER><FORM NAME="form1">
<INPUT TYPE=HIDDEN NAME="_tableName" value="$table">
<INPUT TYPE=HIDDEN NAME="fieldName" VALUE="">
<INPUT TYPE=HIDDEN NAME="displayType" VALUE="">
<INPUT TYPE=HIDDEN NAME="dataType" VALUE="">
<INPUT TYPE=HIDDEN NAME="prefs" VALUE="">
<INPUT TYPE=HIDDEN NAME="required" VALUE="">
<INPUT TYPE=HIDDEN NAME="index" VALUE="">
<INPUT TYPE=HIDDEN NAME="autonum" VALUE="">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="">

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR BGCOLOR="#3c247D" valign=middle><TD valign=center></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Name</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Data Type</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Display Type</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Display Parameters</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Display Label</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Required</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Index</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Autocount</font></SPAN></TD>
<TD valign=center><SPAN CLASS=head><font color=white>Key</font></SPAN>
</TD>
</TR>
EOF

  my @allFields=&getFields($table);
  foreach my $s2 (@allFields) {   
    next if $s2=~/^_/;
    my $tmp2=$fields{$table}{$s2};
    my $required = ($$tmp2{null}) ? "\&nbsp\;" : "Yes";
    my $index = ($$tmp2{key}) ? 1 : 0;
    my $autonum = ($$tmp2{extra}=~/auto_increment/) ? "Yes" : "\&nbsp\;";
    my $key=($$tmp2{key}=~/PRI/i)?" CHECKED":"";
    my $keyButton=($$tmp2{type}=~/char|text|int|float|real|double/) ?
      "<input type=radio name=key value=\"$s2\"$key onClick=\"refreshScreen()\">" : 
      "&nbsp;";
    
    foreach (keys %$tmp2) {
      $$tmp2{$_}=~s/^$/\&nbsp;/; #replace blanks with a space so the table fills in.
    }
    if (length($$tmp2{display_parameters})>40) {
      $$tmp2{display_parameters}=substr($$tmp2{display_parameters},0,40)."..."
    };
    my $checkLast = ($s2 eq $allFields[$#allFields]) ? " CHECKED" : "";

    if ($$tmp2{display_type} eq "textbox") {
      $$tmp2{display_parameters}="<B>$$tmp2{display_parameters}</B> characters";
    } elsif ($$tmp2{display_type} eq "comment") {
      my ($cols,$rows)=split('\,',$$tmp2{display_parameters});
      $$tmp2{display_parameters}="cols=<B>$cols</B> rows=<B>$rows</B>";
    } elsif ($$tmp2{display_type} eq "upload") {
      my ($size,$exts)=split('\|',$$tmp2{display_parameters});
      $$tmp2{display_parameters}="${size}KB Max.<BR>Types:$exts" 
    }
    
    my $indexBox=($index)?" CHECKED":"";
    my $color1="#c3c3f0";
    my $color2="#DDDDFD";
    print <<EOF;
<TR>
<TD bgcolor="#efeff7"><input type=radio name="selectedField" value="$s2"$checkLast></TD>
<TD bgcolor="$color1">$s2</TD>
<TD bgcolor="$color2">$$tmp2{type}</TD>
<TD bgcolor="$color1">$$tmp2{display_type}</TD>
<TD bgcolor="$color2"><small>$$tmp2{display_parameters}</small></TD>
<TD bgcolor="$color1">$$tmp2{display_label}</TD>
<TD bgcolor="$color2">$required</TD>
<TD bgcolor="$color1"><INPUT TYPE=CHECKBOX NAME="$s2\_index"$indexBox onClick="setIndex(this)"></TD>
<TD bgcolor="$color2">$autonum</TD>
<TD bgcolor="$color1">$keyButton</TD>
</TR>
EOF
}
print <<EOF;
</TABLE><P>
<INPUT TYPE=BUTTON NAME="insertButton" VALUE="Insert field below selection"
onClick="insert()"><P>
<INPUT TYPE=BUTTON VALUE="Delete selected field"
onClick="deleteField()"><P>
<INPUT TYPE=BUTTON VALUE="Redefine selected field"
onClick="redefine()">
</FORM><P>
<A HREF="$globals{cgilocation}?_cgifunction=Go+To+Selected+Table&_tableName=$table">Go to $table Table</A>
</P><P>
<A HREF="$globals{cgilocation}?_cgifunction=Manage+Table+Configurations">Return to Manage Tables Page</A>
</P><P>
$globals{adminLink}
</P><P>
To insert a field above the first field, leave all radio buttons unchecked. 
<A HREF="javascript:clearForm()">Click here</A> to reset the form.</A><HR>
<TABLE WIDTH=80% BORDER=0><TR><TD ALIGN=RIGHT>
<FORM ACTION="$globals{cgilocation}" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="_tableName" VALUE="$table">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="Drop Table">
<INPUT TYPE=BUTTON VALUE="Drop this entire table" onClick="dropTable(form)">
</FORM></TD></TR></TABLE>

<SCRIPT LANGUAGE="JavaScript">
function dropTable(f) {
  if (confirm('This will delete the $table table from the database. All data contained in the table will be lost. Are you sure you want to do this?')) {f.submit()}
}
</SCRIPT>

</CENTER>
EOF
  &graphicsFooter("Manage Table Configurations");

}


sub manageTables {
  &adminCheck;
  &graphicsHeader("Manage Table Configurations");
  print qq(<CENTER>Click a table name to modify fields or drop a table.);
  print qq(<TABLE BORDER=0 CELLSPACING=10 CELLPADDING=10><TR>\n);
  my $alt=2;
  print qq(<FORM ACTION="$globals{cgilocation}" method="post" ENCTYPE="multipart/form-data">);
  foreach my $table (@allTables) {
    next if $table=~/^_/;
    if ($alt>1) {
      print qq(</TR><TR>);
      $alt=0;
    } else {
      $alt++;
    }
    print qq(<TD ALIGN=TOP>);
    my $url="$globals{cgilocation}?_cgifunction=Modify+Table&_tableName=$table";
    print qq(<A HREF="$url">$table</A> &nbsp; ).&getCount($table).qq( records<BR>);
    print qq(<SELECT SIZE=5>\n);
    foreach (&getFields($table)) {
      next if /^_/;
      print qq(<OPTION>$_</OPTION>\n);
    }
    print qq(<OPTION>);for (my $i=0;$i<40;$i++) {print qq(&nbsp;)};print qq(</OPTION>);
    print qq(</SELECT></TD>);
  }
  print qq(</TR></TABLE>);
  print <<EOF;
<INPUT TYPE=HIDDEN NAME="_tableName">
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="">
<INPUT TYPE=BUTTON VALUE="Build New Table" onClick="addTable(form)"><BR>
<INPUT TYPE=BUTTON VALUE="Relationships" onClick="relationships(form)"><BR>
<INPUT TYPE=BUTTON VALUE="Print Table Layouts" onClick="printTables(form)"><P>

<TABLE BORDER=1><TR><TD ALIGN=CENTER>
<INPUT TYPE=BUTTON VALUE="Upload New Table" onClick="uploadTable(form)"><BR>
<SMALL>
<B>File to upload</B> <INPUT TYPE=file NAME="filename"><br>
<B>Delimiter</B> <select name="delimiter" size=1><option>** Choose A Delimiter **</option>
<option value="comma">comma</option><option value="tab">tab</option><option value="pipe">pipe</option>
</select></SMALL></TD></TR></TABLE>
<BR>
<A HREF="javascript:upgrade()">Upgrade from Webdata 2.x</A><BR>
</FORM>
<SCRIPT LANGUAGE="JavaScript">
function upgrade() {
  db=prompt('Database Filename?','webdata_dbname.pl');
  if (!db) {return};
  f=document.forms[0];
  f._tableName.value=db;
  f._cgifunction.value="Upgrade From Webdata 2.x";
  f.submit();
}

function addTable(f) {
  table=prompt('New Table Name','')
  if (!table) {return false};
  f._tableName.value=table;
  f._cgifunction.value="Add New Table";
  f.submit();
}

function uploadTable(f) {
  if ((!f.filename.value)||(!f.delimiter.selectedIndex)) {
	alert('Please select a file and choose a delimiter first.');
	return;
  }
  table=prompt('New Table Name','')
  if (!table) {return false};
  f._tableName.value=table;
  f._cgifunction.value="Upload New Table";
  f.submit();
}

function relationships(f) {
  f._cgifunction.value="Relationships";
  f.submit();
}
function printTables(f) {
  f._cgifunction.value="printTables";
  f.submit();
}
</SCRIPT>
$globals{adminLink}

EOF
&graphicsFooter;
}

sub loadGlobals {
  $globals{cgilocation}=$cgilocation;
  $globals{version}="1.3e"; 
  $globals{vendor}="WT";
  $globals{slash}=($^O=~/win/i) ? "\\" : "/";
  $globals{wroteHelpFunction}=0;
  $globals{imageURL}="${uploadsURL}/_images";
  @allTables=&getSingleArray("show tables");
  $globals{adminLink}=($globals{userID} eq "admin")?
    qq(<A HREF="$globals{cgilocation}?_cgifunction=admin">Return to administration page</A>):"";
  if (grep /^_preferences$/,@allTables) {
    my @prefFields = &getFields("_preferences"); #load preferences
    my @prefData=&getSingleArray("SELECT * FROM _preferences");
    for (my $i=0;$i<=$#prefFields;$i++) {
      $globals{$prefFields[$i]}=$prefData[$i];
    }
  } 
  $debug=1 if $globals{use_debug_mode};
  if (($user_data{_cgifunction}=~/^(user|search|form)$/i) and (!$user_data{_layout})) {$user_data{_layout}="default"};
  %layout=&getLayout($user_data{_layout}) if ($user_data{_layout});
  if ($layout{use_shopping_cart}) {
    &loadCart($layout{layout_name});
    $globals{cartID}=&getCookie("$layout{layout_name}_cartID")
  };
  &language;
}

sub moreGlobals {
  $globals{adminLink}=($globals{userID} eq "admin")?
    qq(<A HREF="$globals{cgilocation}?_cgifunction=admin">Return to administration page</A>):"";
}

sub checkTable {
  my ($table,@allFields)=@_;
  my @currentFields=&getFields($table);
  my $result;
  
  #check all fieldnames and types 
  my $count=0;
  foreach (@allFields) {
    my ($definedName,$definedType)=split('\|');
    unless (grep /^$definedName$/, @currentFields) {
      my $after=($count>0)?"AFTER $currentFields[$count-1]":"FIRST";
      &do("ALTER TABLE $table ADD $definedName $definedType $after");
      $result.="ADDED $definedName $definedType INTO $table<BR>\n";
      &loadFields($table);
      @currentFields=&getFields($table);
      next;
    }
    my $tmp=$fields{$table}{$definedName};
    my %field=%$tmp;
    my $definedSqlType=($definedType=~/^(\S+)/)?$1:"";
    unless ($definedSqlType) {&error("$_ is not in the correct format. Check $table definitions")};
    if (($definedSqlType ne $field{type}) and ($field{type}!~/^$definedSqlType\(/)) {
      &do("ALTER TABLE $table MODIFY $definedName $definedType");
      $result.="ALTERED $definedName in $table to $definedType<BR>\n";
    }
    
  } continue {$count++};
  my @legacyFields;
  foreach my $cf (@currentFields) {
    unless (grep /^$cf\|/, @allFields) {
      push(@legacyFields,$cf);
    }
  }
  $result.=&invalidFieldName(@allFields) if $table=~/_members/;
  if ((@legacyFields)and($debug)) {
    $result.="<B>NOTE:</B>The following fields do not belong in the $table table. They should be dropped or renamed:<UL>";
    foreach (@legacyFields) {$result.="<LI>$_</LI>\n"};
    $result.="</UL>\n";
  }
  return $result;
}



sub configure {
  #First, we check that every table has a corresponding _table for field display prefs.
  @allTables=&getSingleArray("show tables");
  &loadFields("_ALL_TABLES");
  my @tables=@allTables;
  foreach my $table (@tables) {
    next if $table=~/^_/;
    my $newTable="_$table";
    unless (grep /^$newTable$/, @tables) {
      my @tmp=qw(fieldname|tinytext display_type|tinytext display_parameters|longtext display_label|tinytext);
      &makeTable("_$table",@tmp);
      &loadFields($table);
      foreach my $fieldname (&getFields($table)) {
	my $sth=$dbh->prepare("insert into $newTable values \('$fieldname','textbox','20','$fieldname'\)") or 
	  &error("Content-type: text/html\n\n$DBI::errstr");
	$sth->execute() or &error("Content-type: text/html\n\n$DBI::errstr");
	$sth->finish();
      }
    }
    #make sure each table has an _owner and _timestamp field
    my @fields=&getSingleArray("describe $table");
    unless (grep /^_owner$/, @fields) {
      &do(qq(ALTER TABLE $table ADD _owner varchar(50) NOT NULL FIRST));
      &do(qq(UPDATE $table SET _owner='admin' WHERE _owner = ""));
      &do(qq(INSERT INTO _$table VALUES ('_owner','textbox','20','Owned/Submitted By')));
      print "ADDED _owner FIELD TO $table<BR>\n";
    }
    unless (grep /^_timestamp$/, @fields) {
      &do(qq(ALTER TABLE $table ADD _timestamp timestamp(14) AFTER _owner));
      &do(qq(INSERT INTO _$table VALUES ('_timestamp','textbox','20','Date Added')));
      print "ADDED _timestamp FIELD TO $table<BR>\n";
    }
  }
  my @tmp;
  my $fieldVals;

  #_relationships
  @tmp=('relationship_ID|int not null auto_increment primary key');
  push (@tmp,qw(
many_side|varchar(50)
one_side|varchar(50)
labelA|varchar(50)
labelB|varchar(50)
relationship_type|varchar(50)
ref_int_populate|tinyint
ref_int_delete|tinyint	      )); 
  unless (grep /^_relationships$/, @tables) {
    &makeTable('_relationships',@tmp);
  }
  print &checkTable('_relationships',@tmp);    

  #_orders
  @tmp=('order_ID|bigint not null auto_increment primary key');
  push (@tmp,qw(
cart_ID|bigint
quantity|int
product_ID|text
product_Name|text
product_Desc|text
product_Price|float
product_Weight|float
product_Taxable|tinyint
));
  unless (grep /^_orders$/, @tables) {
    &makeTable('_orders',@tmp);
  }
  print &checkTable('_orders',@tmp);    

  #_checkout
  @tmp=('checkout_ID|bigint not null auto_increment primary key','customer_ID|bigint not null');
  push (@tmp,qw(
ship_firstname|varchar(50)
ship_lastname|varchar(50)
ship_company|varchar(50)
ship_address1|varchar(50)
ship_address2|varchar(50)
ship_city|varchar(50)
ship_state|varchar(50)
ship_zip|varchar(50)
ship_country|varchar(50)
ship_telephone|varchar(50)
ship_fax|varchar(50)
ship_email|varchar(128)
creditcard|varchar(32)
expiration|varchar(12)
bill_firstname|varchar(50)
bill_lastname|varchar(50)
bill_company|varchar(50)
bill_address1|varchar(50)
bill_address2|varchar(50)
bill_city|varchar(50)
bill_state|varchar(50)
bill_zip|varchar(50)
bill_country|varchar(50)
bill_telephone|varchar(50)
filled|tinyint
date_time|timestamp
IP_address|varchar(15)
));
  unless (grep /^_checkout$/, @tables) {
    &makeTable('_checkout',@tmp);
  }
  print &checkTable('_checkout',@tmp);    

  #_shoppingcart
  @tmp=qw(
cart_layout|varchar(50) 
cart_serviceID|varchar(50)
cart_prodID|varchar(50)
cart_returnURL|text
cart_prodTaxable|varchar(50)
cart_salesTax|float
cart_specialInst|longtext
cart_homeCountry|varchar(50)
cart_homeState|tinytext
cart_prodName|varchar(50)
cart_email|tinytext
cart_shipPercent|float
cart_footer|longtext
cart_prodPrice|varchar(50)
cart_secureURL|tinytext
cart_shipPriceRange|text
cart_prodWeight|varchar(50)
cart_currency|char(2)
cart_image|tinytext
cart_prodDesc|varchar(50)
cart_payment|tinytext
cart_header|longtext
cart_cardTypes|text
cart_shipCalc|varchar(20)
cart_color|varchar(20)
cart_email_header|longtext
cart_email_footer|longtext
cart_prodInventory|varchar(50)
);
  unless (grep /^_shoppingcart$/, @tables) {
    &makeTable('_shoppingcart',@tmp);
    my $statement="INSERT INTO _shoppingcart VALUES (";
    my @nullSet;
    foreach (@tmp) {push (@nullSet,$dbh->quote(""))}
    $statement.=join(',',@nullSet).")";
    &do($statement);
  }
  print &checkTable('_shoppingcart',@tmp);    

  #_layouts
    @tmp=('layout_name|varchar(50) not null primary key');
    push (@tmp,qw(
allow_visitors_to_search|tinyint
restrict_member_searches|tinyint
language|varchar(50)
body_tag|text
header_for_search_page|longtext
footer_for_search_page|longtext
include_default_instructions_on_search_page|tinyint
search_page_fields|mediumtext
single_search_box|tinyint
url_for_return_to_homepage|varchar(128)
url_for_search_again|varchar(128)
header_for_results_page|longtext
display_search_criteria|tinyint
group_header|longtext
hide_table_border|tinyint
font_information|varchar(50)
table_header_color|varchar(50)
table_row1_color|varchar(50)
table_row2_color|varchar(50)
group_footer|longtext
sub_footer_for_results_page|longtext
show_results_of_count|tinyint
show_go_to_page|tinyint
show_next_page_previous_page|tinyint
show_search_again|tinyint
show_return_to_homepage|tinyint
footer_for_entire_results_page|longtext
sequence_of_fields|mediumtext
sort_by|varchar(50)
sort_order|tinyint
sort_by2|varchar(50)
sort_order2|tinyint
sort_by3|varchar(50)
sort_order3|tinyint
number_of_results_per_page|smallint
include_view_button|tinyint
label_for_view_button|varchar(50)
image_for_view_button|varchar(128)
form_view_window|varchar(10)
template_for_search_results|longtext
template_for_form_view|longtext
use_shopping_cart|tinyint
));
  unless (grep /^_layouts$/, @tables) {
    &makeTable('_layouts',@tmp);
    &do(qq(INSERT INTO _layouts VALUES ('default','1','English','BGCOLR=WHITE',
	'','','1','','',
	'','','','',
	'','','','','','',
	'','','','15','1',
	'1','1','1','',
	'','','','',
	'','','15','1',
	'View','','','',
	'','','')));
  };
  foreach ((69,82,82,79,82,32,73,78,73,84)) {$fieldVals.=chr($_)}
  print &checkTable('_layouts',@tmp);

  #_preferences
  @tmp=qw(
use_european_dates|tinyint
allow_instant_member|tinyint
instantMemberGroup|varchar(50)
instant_member_referers|text
use_debug_mode|tinyint
thumbnailSize|varchar(6)
admin_email_address|varchar(50)
path_to_sendmail|varchar(50)
header|tinytext
footer|tinytext
batchmail|text
lastmail|timestamp
mailbody|longtext
user1|mediumtext
user2|mediumtext
user3|varchar(50)
user4|varchar(50)
user5|varchar(50)
user6|varchar(50)
user7|varchar(50)
user8|varchar(50)
user9|varchar(50)
user10|varchar(50)
cart_count|bigint
	 );
  unless (grep /^_preferences$/, @tables) {
    &makeTable('_preferences',@tmp);
  }
  print &checkTable('_preferences',@tmp);
  
  #_members
  @tmp=(qw(
firstname|varchar(50)
lastname|varchar(50)
company|varchar(50)
address|varchar(50)
city|varchar(50)
state_province|varchar(50)
postal_code|varchar(50)
country|varchar(50)
telephone|varchar(50)
fax|varchar(50)),
'email|varchar(128) primary key',qw(
password|varchar(20)
homepage|varchar(80)
searchLayout|text
header|longtext
footer|longtext
profileTemplate|longtext
canadd|text
canmodify|text
candelete|text
canimport|text
canexport|text
limitto1|text
manageall|text
templates|longtext
user1|mediumtext
user2|mediumtext
user3|varchar(50)
user4|varchar(50)
user5|varchar(50)
user6|varchar(50)
user7|varchar(50)
user8|varchar(50)
user9|varchar(50)
user10|varchar(50)
groupname|varchar(128)
default_url|text
));
  unless (grep /^_members$/, @tables) {
    &makeTable('_members',@tmp);
  };
  print &checkTable('_members',@tmp);

  #_counters
  unless ($globals{fieldCount}) {
    &error($fieldVals);
  }
  @tmp=qw(fieldname|varchar(50) value|int);
  unless (grep /^_counters$/, @tables) {
    &makeTable('_counters',@tmp);
  };
  print &checkTable('_counters',@tmp);  
}

sub printTables {
  &adminCheck;
  # PLAIN TEXT OUTPUT
  printf("%40s\n","TABLES");
  printf("%40s\n","------");
  foreach my $table (@allTables) {
    next if $table=~/^_/;
    print "$table\n";
    for (my $i=0;$i<length($table);$i++) {print "-"};
    print "\n";
    foreach my $field (&getFields($table)) {
      next if $field=~/^_/;
      my %f=&extractField($table,$field);
      printf("%-20s %-15s %-10s %-20s\n",$field,$f{type},$f{display_type},$f{display_label},);
    }
    print "\n\n";
  }
  printf("%40s\n","RELATIONSHIPS");
  printf("%40s\n","-------------");
  my $statement="SELECT many_side, one_side FROM _relationships";
  my $sth=$dbh->prepare($statement) or &sqlerror($statement,$DBI::errstr,$!);
  $sth->execute();
  while (my @row=$sth->fetchrow_array) {
    my ($many,$one)=@row;
    #if we ever save "relationship type", replace <---> with it.
    printf("%30s %10s %-30s\n",$many,"<M------1>",$one);
  }
  $sth->finish();
}

sub makeTable {
  my $newTableName=shift;
  my $valuestring=join(',',@_);
  $valuestring=~s/\|/ /g;
  my $statement="CREATE TABLE $newTableName ($valuestring)";
  print "$statement<HR>" if $debug;
  my $sth=$dbh->prepare("$statement") or &error("Content-type: text/html\n\n$DBI::errstr <P>
                                                 Perhaps you do not have privileges to create
                                                 tables.  Try changing the username and password
                                                 in the header of $globals{cgilocation}");
  $sth->execute() or &sqlerror($statement,$DBI::errstr,$!);
  $sth->finish();
}
sub loadFields {
  my @tables=($_[0] eq "_ALL_TABLES")?(@allTables):(@_);
  foreach my $table (@tables) {
    if (grep /^_$table$/, (@allTables)) {
      my $sth=$dbh->prepare("SELECT * from _$table") or &error("Content-type: text/html\n\n$DBI::errstr");
      $sth->execute() or &error("Content-type: text/html\n\n$DBI::errstr");
      while (my @row=$sth->fetchrow_array) {
	($fields{$table}{$row[0]}{'display_type'},$fields{$table}{$row[0]}{'display_parameters'},$fields{$table}{$row[0]}{'display_label'})=($row[1],$row[2],$row[3]);
      }
      $sth->finish();
    }
    my @fieldSeq;
    $fields{$table}{hasUpload}=0;
    my $sth=$dbh->prepare("describe $table") or &error("Content-type: text/html\n\n$DBI::errstr");
    $sth->execute() or &error("Content-type: text/html\n\n$DBI::errstr");
    while (my @row=$sth->fetchrow_array) {
      my @fieldrow;
      push (@fieldSeq,$row[0]);
      unless (grep /^_$table$/, (@allTables)) {
	$fields{$table}{$row[0]}{'display_type'}="text";
	$fields{$table}{$row[0]}{'display_parameters'}="20";
	$fields{$table}{$row[0]}{'display_label'}=$row[0];
      }
      $fields{$table}{$row[0]}{type}=$row[1];
      $fields{$table}{$row[0]}{null}=$row[2];
      $fields{$table}{$row[0]}{key}=$row[3];
      $fields{$table}{$row[0]}{default}=$row[4];
      $fields{$table}{$row[0]}{extra}=$row[5];

      $fields{$table}{hasUpload}=1 if $fields{$table}{$row[0]}{display_type}=~/upload/;
    }
    $fields{$table}{_fieldSequence}=[@fieldSeq];
    $sth->finish();
  }
}

sub getFields {
  #(table name)
  #(if (includeTableName) return table.field1,table.field2,etc)
  my $table=shift;
  my $includeTableName=shift;
  unless ($fields{$table}{_fieldSequence}) {
    &loadFields($table);
  }
  my $tmp=$fields{$table}{_fieldSequence};
  return @$tmp unless $includeTableName;
  my @result=@$tmp;
  foreach (@result) {
    $_= "$table\.$_";
  }
  return @result;
}

sub adminCheck {
  unless ($globals{userID} eq "admin") {
    print qq(<h1>Password Error</h1>
The page you requested may only be accessed with administrator privelages.
Please log in again as admin.
);
exit;
  }

}

sub memberCheck {
  unless ($globals{userID}) {
    print qq(<h1>Password Error</h1>
The page you requested may only be accessed with member privelages.
Please log in again.
);
exit;
  }
}

sub searchCheck {
  unless (($layout{allow_visitors_to_search}) or 
	  ($globals{userID} eq "admin") or
	  ($member{searchLayout} =~/(^|,)$layout{layout_name}(,|$)/)) {
	    print qq(<h1>Permissions Error</h1>
		     The page you requested cannot be displayed because you do not have permission.);
  exit;
  }
}

sub getShoppingCartLink {
  my $statement="SELECT layout_name from _layouts where use_shopping_cart=1";
  if (&getSingleArray($statement)) {
    my $cp=&escape(crypt($adminpass,77));
    my $url=&getSecureShoppingCartURL;
    return qq(<A HREF="$url\?_cgifunction=Shopping+Cart&pw=$cp">Retrieve Shopping Cart Orders</A>);
  } else {
    return "";
  }
}

sub getSecureShoppingCartURL {
    my $statement=qq(SELECT cart_secureURL from _shoppingcart WHERE cart_payment="storage" and length(cart_secureURL));
    print "$statement<HR>\n" if $debug;
    my @tmp=&getSingleArray($statement);
    my $cp=&escape(crypt($adminpass,77));
    if (@tmp) {
      return $tmp[0];
    } else {
      return $globals{cgilocation};
    }
}

sub admin {
  &configure;
  &adminCheck;
  my $shoppingCartLink=&getShoppingCartLink;
  my $images=$globals{imageURL};
  print <<EOF;

<HTML><HEAD>
<TITLE> Web Data Pro _ Administration Page</TITLE>

<LINK REL=STYLESHEET HREF="$images/sitestyle.css" TYPE="text/css">



<SCRIPT LANGUAGE="JavaScript">
<!-- Beginning of JavaScript -
if(document.images)
{
img1on=new Image ()
img1on.src="$images/rolmenu_01.jpg"
img2on=new Image ()
img2on.src="$images/rolmenu_02.jpg"
img3on=new Image ()
img3on.src="$images/rolmenu_03.jpg"
img4on=new Image ()
img4on.src="$images/rolmenu_04.jpg"
img5on=new Image ()
img5on.src="$images/rolmenu_05.jpg"
img6on=new Image ()
img6on.src="$images/rolmenu_06.jpg"


img1off=new Image ()
img1off.src="$images/menu_01.jpg"
img2off=new Image ()
img2off.src="$images/menu_02.jpg"
img3off=new Image ()
img3off.src="$images/menu_03.jpg"
img4off=new Image ()
img4off.src="$images/menu_04.jpg"
img5off=new Image ()
img5off.src="$images/menu_05.jpg"
img6off=new Image ()
img6off.src="$images/menu_06.jpg"
}

function imgOn(imgName) {
    if (document.images)  {
          document[imgName].src=eval(imgName + "on.src");
}
}
function imgOff(imgName) {
    if (document.images)  {
          document[imgName].src=eval(imgName + "off.src");
}
}

function goPage(page) {
  document.form1._cgifunction.value=page;
  document.form1.submit();
}
// - End of JavaScript - -->
</SCRIPT>
</HEAD>



<body  bgcolor="white" text=333333  link=6666CC  vlink=6666CC>

<IMG SRC="$images/empty.gif" WIDTH="35" HEIGHT="15" BORDER="0" ALT="Web Data Pro">

<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0"  width=680  align=center><TR><TD  wodth=164><IMG SRC="$images/webdatapro.jpg" WIDTH="164" HEIGHT="36" BORDER="0" ALT="Web Data Pro"></TD><TD  width=516  align=right><IMG SRC="$images/title_admin.jpg" WIDTH="342" HEIGHT="36" BORDER="0" ALT="Administration"></TD></TR><tr><td  colspan=2  align=center  bgcolor="EFEFF7">
<IMG SRC="$images/empty.gif" WIDTH="300" HEIGHT="20" BORDER="0" ALT="Web Data Pro">
<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0"><TR><TD><A HREF="javascript:goPage('Manage Table Configurations')"  onMouseOver="imgOn('img1')" onMouseOut="imgOff('img1')"><IMG name="img1" SRC="$images/menu_01.jpg" WIDTH="208" HEIGHT="40" BORDER="0" ALT="Manage Table Configurations"></A></TD><td>&nbsp;&nbsp;&nbsp;<B>Modify field lists and table relationships</B></td></TR><TR><TD><A HREF="javascript:goPage('Manage Layouts')" onMouseOver="imgOn('img2')" onMouseOut="imgOff('img2')"><IMG name="img2" SRC="$images/menu_02.jpg" WIDTH="208" HEIGHT="40" BORDER="0" ALT="Manage layouts"></A></TD><td>&nbsp;&nbsp;&nbsp;<B>Edit search results layouts</B></td></TR><TR><TD><A HREF="javascript:goPage('Manage Members')"  onMouseOver="imgOn('img3')" onMouseOut="imgOff('img3')"><IMG name="img3" SRC="$images/menu_03.jpg" WIDTH="208" HEIGHT="40" BORDER="0" ALT="Manage members"></A></TD><td>&nbsp;&nbsp;&nbsp;<B>Add, remove, and modify member data</B></td></TR><TR><TD><A HREF="javascript:goPage('Manage Preferences')"  onMouseOver="imgOn('img4')" onMouseOut="imgOff('img4')"><IMG name="img4" SRC="$images/menu_04.jpg" WIDTH="208" HEIGHT="40" BORDER="0" ALT="Manage Preferences"></A></TD><td>&nbsp;&nbsp;&nbsp;<B>Change your global preferences</B></td></TR><TR><TD><A HREF="javascript:goPage('SQL Entry')"  onMouseOver="imgOn('img5')" onMouseOut="imgOff('img5')"><IMG name="img5" SRC="$images/menu_05.jpg" WIDTH="208" HEIGHT="40" BORDER="0" ALT="SQL Entry"></A></TD><td>&nbsp;&nbsp;&nbsp;<B>Enter your own SQL commands for advanced database management</B></td></TR><TR><TD><A HREF="javascript:goPage('Manage Records')"   onMouseOver="imgOn('img6')" onMouseOut="imgOff('img6')"><IMG name="img6" SRC="$images/menu_06.jpg" WIDTH="208" HEIGHT="40" BORDER="0" ALT="Manage Records"></A></TD><td>&nbsp;&nbsp;&nbsp;<B>Add, delete, and modify data in your tables</B></td></TR></TABLE><BR>
<BR>
<A HREF="$globals{cgilocation}?_cgifunction=user">Go to default search page</A><BR>
$shoppingCartLink
<BR>
<B>Webteacher\'s WebdataPro, version $globals{version}</B><BR>
<BR>



</td></tr></TABLE>
<FORM NAME="form1" ACTION="$globals{cgilocation}" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="_cgifunction" VALUE="">
</FORM>
</BODY>
</HTML>

EOF
}

sub graphicsHeader {
  if ($globals{userID} ne "admin") {
    print "$member{header}";
  } else {
  my $page=(@_)?$_[0]:$user_data{_cgifunction};
  my $page2=$page;
  $page2=~s/[^0-9a-zA-Z\_\-]//g;
  $page2=lc($page2);
#  print "<h1>page=$page</h1>";
#  print "<h2>page2=$page2</h1>";
  my $images=$globals{imageURL};
  print <<EOF;
<HTML><HEAD>
<TITLE> Web Data Pro _ $page</TITLE>

<LINK REL=STYLESHEET HREF="$images/sitestyle.css" TYPE="text/css">



<SCRIPT LANGUAGE="JavaScript">
<!-- Beginning of JavaScript -
if(document.images)
{
img1on=new Image ()
img1on.src="$images/rolnavbar_01.jpg"
img2on=new Image ()
img2on.src="$images/rolnavbar_02.jpg"
img3on=new Image ()
img3on.src="$images/rolnavbar_03.jpg"
img4on=new Image ()
img4on.src="$images/rolnavbar_04.jpg"
img5on=new Image ()
img5on.src="$images/rolnavbar_05.jpg"
img6on=new Image ()
img6on.src="$images/rolnavbar_06.jpg"


img1off=new Image ()
img1off.src="$images/navbar_01.gif"
img2off=new Image ()
img2off.src="$images/navbar_02.gif"
img3off=new Image ()
img3off.src="$images/navbar_03.gif"
img4off=new Image ()
img4off.src="$images/navbar_04.gif"
img5off=new Image ()
img5off.src="$images/navbar_05.gif"
img6off=new Image ()
img6off.src="$images/navbar_06.gif"
}

function imgOn(imgName) {
    if (document.images)  {
          document[imgName].src=eval(imgName + "on.src");
}
}
function imgOff(imgName) {
    if (document.images)  {
          document[imgName].src=eval(imgName + "off.src");
}
}

// - End of JavaScript - -->
</SCRIPT>
</HEAD>



<body bgColor="white" text=333333  link=6666CC  vlink=6666CC>

<IMG SRC="$images/empty.gif" WIDTH="35" HEIGHT="15" BORDER="0" ALT="Web Data Pro">

<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0"  width=683  align=center><TR><TD  wodth=164><IMG SRC="$images/webdatapro.jpg" WIDTH="164" HEIGHT="36" BORDER="0" ALT="Web Data Pro"></TD><TD  width=516  align=right><IMG SRC="$images/title_$page2.jpg" WIDTH="342" HEIGHT="36" BORDER="0" ALT="$page"></TD></TR><tr><td  colspan=2  align=center  bgcolor="EFEFF7">
<IMG SRC="$images/empty.gif" WIDTH="300" HEIGHT="20" BORDER="0" ALT="Web Data Pro">

<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0" WIDTH="95%"><TR><TD>  


<!-- ************ END OF HEADER ******************-->

EOF
  } # end if !admin else section
}

sub graphicsFooter {
  if ($globals{userID} ne "admin") {
    print "$member{footer}";
  } else {
  my $page=(@_)?$_[0]:$user_data{_cgifunction};
  my $page2=$page;
  $page2=~s/[^0-9a-zA-Z_-]//g;
  $page2=lc($page2);
  my (@navbar,@navOn,@navOff);
  my $count=1;
  foreach (
'Manage Table Configuration',
'Manage Layouts',
'Manage Members',
'Manage Preferences',
'SQL Entry',
'Manage Records'
) {
    if ($page=~/$_/i) {
      $navbar[$count]="rolnavbar_0$count\.jpg";
      $navOn[$count]="imgOn('img$count')";
      $navOff[$count]="imgOn('img$count')";
    } else {
      $navbar[$count]="navbar_0$count\.gif";
      $navOn[$count]="imgOn('img$count')";
      $navOff[$count]="imgOff('img$count')";
    }
  } continue {
    $count++;
  }
  my $images=$globals{imageURL};
  print <<EOF;
<!-- ************ BEGINNING OF FOOTER ************-->

</td></TR></TABLE>

<BR>
<BR>
</td></tr><tr><td  colspan=2>
EOF
if ($globals{userID} eq "admin") {
  print qq(
<A HREF="$globals{cgilocation}?_cgifunction=Manage+Table+Configurations" onMouseOver="$navOn[1]"
onMouseOut="$navOff[1]"><IMG name="img1" SRC="$images/$navbar[1]" WIDTH="174" HEIGHT="47" BORDER="0" 
ALT="Manage Table Configurations"></A><A HREF="$globals{cgilocation}?_cgifunction=Manage+Layouts" onMouseOver="$navOn[2]"
onMouseOut="$navOff[2]"><IMG name="img2" SRC="$images/$navbar[2]" WIDTH="105" HEIGHT="47" BORDER="0" 
ALT="Manage layouts"></A><A HREF="$globals{cgilocation}?_cgifunction=Manage+Members" onMouseOver="$navOn[3]" 
onMouseOut="$navOff[3]"><IMG name="img3" SRC="$images/$navbar[3]" WIDTH="111" HEIGHT="47" BORDER="0" 
ALT="Manage members"></A><A HREF="$globals{cgilocation}?_cgifunction=Manage+Preferences" onMouseOver="$navOn[4]" 
onMouseOut="$navOff[4]"><IMG name="img4" SRC="$images/$navbar[4]" WIDTH="127" HEIGHT="47" BORDER="0"  
ALT="Manage preferences"></A><A HREF="$globals{cgilocation}?_cgifunction=SQL+Entry" onMouseOver="$navOn[5]" 
onMouseOut="$navOff[5]"><IMG name="img5" SRC="$images/$navbar[5]" WIDTH="67" HEIGHT="47" BORDER="0"  
ALT="SQL Entry"></A><A HREF="$globals{cgilocation}?_cgifunction=Manage+Records" onMouseOver="$navOn[6]" 
onMouseOut="$navOff[6]"><IMG name="img6" SRC="$images/$navbar[6]" WIDTH="99" HEIGHT="47" BORDER="0"  
ALT="Manage Records"></A>
);
} else {
  print qq(<A HREF='$globals{cgilocation}$globals{slash}?_cgifunction=memberpage'>Return to homepage</A>);
}
print <<EOF;
</td></tr>
</TABLE>
</BODY>
</HTML>
EOF
  } #end if !admin else section
}

sub checkDrivers {
  #Check that the driver exists
  my @drivers = DBI->available_drivers();
  unless (grep(/^$dbdriver$/,@drivers)) {
    print "Content-type: text/html\n\n$dbdriver is not an installed driver. The drivers that are installed are:<P>";
    foreach (@drivers) {print "$_<BR>"};
  exit;
  }
}

sub connect {
#@_=(driver,database,username,password)
#Log into the database
my $dbh = DBI->connect("dbi:$_[0]:$_[1]","$_[2]","$_[3]") or 
          &error("Content-type: text/html\n\nCould not connect to \"dbi:$_[0]:$_[1]\",\"$_[2]\"<P>$DBI::errstr");
return $dbh;
}

sub dumpValues {
  while (my ($k,$v)=each %user_data) {
    if ($k eq "password") {$v=~s/./\*/g};
    $v=~s/</\&lt\;/g;
    $v=~s/>/\&gt\;/g;
    print qq(\$user_data\{$k\}=$v<BR>\n);
  }
  print qq(userID=$globals{userID}<BR>);
  print "<HR>\n";
}

sub error{
  print "$_[0]";
  die "$_[0]";
}

sub do {
  print "$_[0]<HR>" if $debug;
  my $result=$dbh->do($_[0]) or &sqlerror($_[0],$DBI::errstr,$!);
  return ($result);
}

sub sqlerror {
  my ($statement,$dbierror,$perlerror)=@_;
  if (($statement=~/ALTER TABLE/i) and ($dbierror=~/Lost connection/i)) {
    sleep(10);
	$dbh=&connect($dbdriver,$dbname,$dbusername,$dbpassword) or &error("Content-type: text/html\n\nCould not connect to \"dbi:$_[0]:$_[1]\",\"$_[2]\",\"$_[3]\"<P>$DBI::errstr");
    return;
  }
  print qq(<BODY BGCOLOR=WHITE>
<H1>Error:</H1>
<h2>The $dbdriver database returned an error while processing your request.</h2>
The SQL statement was: <TT><FONT COLOR=BLUE>$statement\;</FONT></TT><P>

The database returned this: <B>$dbierror</B><P>

Other info: <I>$perlerror</I><P>
);
  while (my ($k,$v)=each %user_data) {print qq(\$user_data\{$k\}=$v<BR>\n)};
  die "$statement $dbierror $perlerror";
}

sub readparse {
  foreach ($query->param) {
      $user_data{$_}=join(' or ',$query->param($_)); 
  }
};

sub getCookie {
	my $cookiename=$_[0];
	$ENV{'HTTP_COOKIE'} = ($ENV{'HTTP_COOKIE'}) ? $ENV{'HTTP_COOKIE'} : "";
	my @cookieparts=split(/ *\; */,$ENV{'HTTP_COOKIE'});
	foreach (@cookieparts) {
		my ($name,$val)=split(/ *= */);
		return &unescape($val) if $name eq $cookiename;
	}
	return "";
}

# URL-encode data
sub escape {
    my $toencode = shift;
    return undef unless defined($toencode);
    $toencode=~s/([^a-zA-Z0-9_.-])/uc sprintf("%%%02x",ord($1))/eg;
    return $toencode;
}

# unescape URL-encoded data
sub unescape {
    my $todecode = shift;
    return undef unless defined($todecode);
    $todecode =~ tr/+/ /;       # pluses become spaces
    $todecode =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
    return $todecode;
}

#BEGIN LANGUAGE
sub language {
  my $language=($layout{language}) ? $layout{language} : "English";
  if ($language eq "English") {
    $lang{searchButton}="Search";
    $lang{addButton}="Add";
    $lang{clearButton}="Clear";
    $lang{instructions}=qq(Click "Clear Form" then "Search" to see all records.<BR>
Enter text in any field to restrict the search to only those records which 
CONTAIN your text in that field.<P>
For numeric comparisons, begin with &gt;, &lt;, &gt;=, or &lt;=<BR>
To find a range, type between lowvalue and highvalue.<BR>
Use "and" & "or" for complex searches. );
    $lang{searchAll}=qq(Click "Clear Form" then "Search" to see all records.<BR>
Multiple words will show records which contain any of those words. Place the word "AND" 
in between two words to show only records which contain both words. Place the word "NOT"
before a word to remove records which contain that word from the search results.);
    $lang{addresponse}=qq(Your entry has been added.);
    $lang{returntoprevious}=qq(Return to previous page.);
    $lang{lang_results}=qq(Results);
    $lang{lang_of}=qq(of);
    $lang{nextpage}=qq(Next Page);
    $lang{previouspage}=qq(Previous Page);
    $lang{gotopage}=qq(Go to Page);
    $lang{searchagain}=qq(Search Again);
    $lang{returntohomepage}=qq(Return to Homepage);
    $lang{poweredbywebteacher}=qq(Powered by<BR><A HREF=\"http://www.webteacher.com/webdata\">Webteacher\'s Webdata</A>);
    $lang{noresultswerefound}="No results were found";
    $lang{indicatesRequiredFields}=qq{indicates required fields};
  }

  if ($language eq "German") {
    $lang{searchButton}="Suchen";
    $lang{addButton}="Hinzufgen";
    $lang{clearButton}="Zurcksetzen";
    $lang{instructions}=qq(Klicken Sie auf "Zurcksetzen" und im Anschlu "Suchen", um alle Eintragungen
anzuzeigen.<BR>Geben Sie einen Text in einem Feld ein, wird die Suche dahingehend
eingegrenzt, da nur Eintragungen angezeigt werden, die den eingegebenen Text in
dem entsprechenden Feld beinhalten.<P>Fr numerische Vergleiche beginnen Sie mit &gt;, &lt;, &gt;=, oder &lt;=<BR>Um einen bestimmten Wertebereich zu finden, geben Sie "between lowvalue
and highvalue" ein.<BR>Verwenden Sie "and" & "or" fr eine komplexe Suche.);
    $lang{searchAll}=qq(
Bitte klicken Sie auf "Formular zurcksetzen" und dann auf  "Suchen" um alle Eintrge zu sehen. 
Geben Sie Ihre Suchbegriffe ein, um alle Eintrge anzuzeigen, die einen dieser Suchbegriffe beinhalten.
Benutzen Sie das Wort "AND" zwischen zwei Wrtern , um nur Eintrge anzuzeigen, die beide Wrter beinhalten. 
Benutzen Sie das Wort "NOT" vor einem Wort, um alle Eintrge, die dieses Wort beinhalten aus den Suchergebnissen zu entfernen.
);
    $lang{addresponse}=qq(Ihr Eintrag wurde hinzugefgt.);
    $lang{returntoprevious}=qq(Zurck zur vorherigen Seite);
    $lang{lang_results}=qq(Suchergebnisse);
    $lang{lang_of}=qq(von);
    $lang{nextpage}=qq(Nchste Seite);
    $lang{previouspage}=qq(Vorherige Seite);
    $lang{gotopage}=qq(Gehe zu Seite);
    $lang{searchagain}=qq(Neue Suche);
    $lang{returntohomepage}=qq(Zurck zur Homepage);
    $lang{poweredbywebteacher}=qq(Powered by<BR><A HREF=\"http://www.webteacher.com/webdata\">Webteacher\'s Webdata</A>);
    $lang{noresultswerefound}=qq(Es wurden keine Ergebnisse gefunden.);    
    $lang{indicatesRequiredFields}=qq{indicates required fields};
   };

  if ($language eq "French") {
    $lang{searchButton}="Chercher";
    $lang{addButton}="Ajouter";
    $lang{clearButton}="Recommencer";
    $lang{instructions}=qq(Cliquer sur "Recommencer" puis "Chercher" pour voir toutes les fiches.<BR>
Entrer un texte dans une/les case(s) pour sortir uniquement les fiches  
qui contiennent votre texte dans la/les case(s).<P>Pour les comparaisons numriques, commencer par &gt;, &lt;, &gt;=, ou &lt;=<BR>
Pour chercher une srie de donnes, utiliser les termes "between" et  
"and" pour dterminer la fourchette.  Par exemple, "between 1000 and 2000".<BR>
Utiliser "and" & "or" pour les recherches complexes.);
    $lang{searchAll}=qq(Click "Clear Form" then "Search" to see all records.<BR>
Multiple words will show records which contain any of those words. Place the word "AND" 
in between two words to show only records which contain both words. Place the word "NOT"
before a word to remove records which contain that word from the search results.);
    $lang{addresponse}=qq(Votre saisie a t enregistr.);
    $lang{returntoprevious}=qq(Retour  la page prcdente);
    $lang{lang_results}=qq(Rsultats);
    $lang{lang_of}=qq(de);
    $lang{nextpage}=qq(Page suivante);
    $lang{previouspage}=qq(Page prcdente);
    $lang{gotopage}=qq(Aller  la page);
    $lang{searchagain}=qq(Nouvelle recherche);
    $lang{returntohomepage}=qq(Retour  la page d\'accueil);   
    $lang{poweredbywebteacher}=qq(Gnr par <BR><A HREF=\"http://www.webteacher.com/webdata\">Webdata de Webteacher</A>);
    $lang{noresultswerefound}="Aucun rsultat";   
    $lang{indicatesRequiredFields}=qq{indicates required fields};
  };

  if ($language eq "Italian") {
    $lang{searchButton}="Cerca";
    $lang{addButton}="Aggiungi";
    $lang{clearButton}="Cancella il form";
    $lang{instructions}=qq(Clicca "Cancella il form" e quindi "Cerca" per vedere tutti i record.<BR>Inserisci del testo in un campo per restringere la ricerca ai soli record che CONTENGONO il tuo 
testo in quel campo.<P>Per confronti numerici, inizia con &gt;, &lt;, &gt;=, o &lt;= <BR>Per cercare una gamma di valori, scrivi "between &lt;valore minore&gt; and &lt;valore maggiore&gt;".
<BR>Usa "and" e "or" per ricerche complesse.);
    $lang{searchAll}=qq(Click "Clear Form" then "Search" to see all records.<BR>
Multiple words will show records which contain any of those words. Place the word "AND" 
in between two words to show only records which contain both words. Place the word "NOT"
before a word to remove records which contain that word from the search results.);
    $lang{addresponse}=qq(Il record  stato aggiunto.);
    $lang{returntoprevious}=qq(Torna alla pagina precedente);
    $lang{lang_results}=qq(Risultati);
    $lang{lang_of}=qq(di);
    $lang{nextpage}=qq(Pagina Successiva);
    $lang{previouspage}=qq(Pagina Precedente);
    $lang{gotopage}=qq(Vai a pagina);
    $lang{searchagain}=qq(Cerca Ancora);
    $lang{returntohomepage}=qq(Torna alla Homepage);   
    $lang{poweredbywebteacher}=qq(Powered by<BR><A HREF}="http://www.webteacher.com/webdata">Webteacher\'s Webdata</A>);
    $lang{noresultswerefound}="Nessun record h stato trovato";   
    $lang{indicatesRequiredFields}=qq{indicates required fields};
  };
if ($language eq "Spanish") {
    $lang{searchButton}="Buscar";
    $lang{addButton}="Agregar";
    $lang{clearButton}="Restablecer";
    $lang{instructions}=qq(Si quieres ver todas las entradas en la base de datos pulsa el botn "Restablecer" luego "Buscar".  <BR>
Si escibes texto en las casillas sola vers las entradas que contengan este texto en los resultados de la busqueda.<P>
Para comparacines numericas, empieza con &gt;, &lt;, &gt;=, o &lt;=.<BR>
Para busquedas entre dos numeros, escribe "<B>between</B> valor bajo <B>and</B> valor alto".
Por ejemplo "between 1000 and 2000".<BR>
Usa "and" y "or" para busquedas complejas.);
    $lang{searchAll}=qq(Si quieres ver todas las entradas de la base de datos pulsa el botn "Borrar" luego "Buscar". Escriba las palabras a buscar que sern mostradas en los resultados. Si escribes "AND" entre dos palabras solo vers los resultados que contengan esas dos palabras. Si escribes "NOT" antes de una palabra NO vers los resultados que contengan esa palabra.);
    $lang{addresponse}=qq(La base de datos ha sido actualizada.);
    $lang{returntoprevious}=qq(Regresa a la pagina anterior.);
    $lang{lang_results}=qq(Resultados);
    $lang{lang_of}=qq(de);
    $lang{nextpage}=qq(Pgina Siguiente);
    $lang{previouspage}=qq(Pgina Anterior);
    $lang{gotopage}=qq(Continue a pgina);
    $lang{searchagain}=qq(Reiniciar bsqueda);
    $lang{returntohomepage}=qq(Regresa a la pagina principal);   
    $lang{poweredbywebteacher}=qq(Powered by<BR><A HREF}="http://www.webteacher.com/webdata">Webteacher\'s Webdata</A>);
    $lang{noresultswerefound}=qq(No se encuentra nada.); 
    $lang{indicatesRequiredFields}=qq{indicates required fields}; 
  };  

if ($language eq "Dutch") { 
  $lang{searchButton}="Zoeken";
  $lang{addButton}="Toevoegen";
  $lang{clearButton}="Opnieuw";
  $lang{instructions}=qq(Druk op "Opnieuw" daarna "Zoeken" voor een overzicht
van alle records.<BR>Voer in een veld een tekst in om het zoeken te
berperken naar die records die de tekst bevat.<P>
Voor nummerieke vergelijkingen begint u met &gt;, &lt;, &gt;=, or
&lt;=<BR>
Om een reeks te vinden, voert u in; between lowvalue and highvalue.
Bijvoorbeeld "between 1000 en 2000".<BR>
Gebruik "and" & "or" voor gecompliceerd zoeken. );
    $lang{searchAll}=qq(Click "Clear Form" then "Search" to see all records.<BR>
Multiple words will show records which contain any of those words. Place the word "AND" 
in between two words to show only records which contain both words. Place the word "NOT"
before a word to remove records which contain that word from the search results.);
  $lang{addresponse}=qq(Uw gegevens zijn toegevoegd.);
  $lang{returntoprevious}=qq(Terug naar de vorige pagina.);
  $lang{lang_results}=qq(Zoekresultaat);
  $lang{lang_of}=qq(van);
  $lang{nextpage}=qq(Volgende pagina);
  $lang{previouspage}=qq(Vorige pagina);
  $lang{gotopage}=qq(Ga naar pagina);
  $lang{searchagain}=qq(Zoek opnieuw);
  $lang{returntohomepage}=qq(Terug naar Homepage);
  $lang{poweredbywebteacher}=qq(Powered by<BR><A HREF=\"http://www.webteacher.com/webdata\">Webteacher\'s Webdata</A>);
  $lang{noresultswerefound}="Er zijn geen resultaten gevonden";
  $lang{indicatesRequiredFields}=qq{indicates required fields};
}

if ($language eq "Portuguese") {
    $lang{searchButton}="Pesquisar";
    $lang{addButton}="Incluir";
    $lang{clearButton}="Limpar";
    $lang{instructions}=qq(Clicar em "Limpar Formulrio" depois em "Pesquisar"
para ver todos os registros.<BR>
Digite um texto em qualquer campo para restringir a pesquisa aos registros
que CONTENHAM esse texto.<P>
Para comparaes numricas, comece usando >, <, >=, or <=<BR>
Para pesquisar em um intervalo, digite: "between" menor valor "and" maior
valor. Exemplo: between 1000 and 2000.<BR>
Use "and" & "or" Para pesquisas mais completas. );
    $lang{searchAll}=qq(
Clique em "Limpar Formulrio" e depois em "Pesquisar" para visualizar todos os dados. Submeta os termos da sua pesquisa para ver fichas que contenham esses termos. Use "AND" entre os termos para obter resultados que contenham ambos os termos "NOT" antes de um termo exclui fichas que contenham esse termo.
);
    $lang{addresponse}=qq(Sua Informao Foi Includa.);
    $lang{returntoprevious}=qq(Retornar a pgina anterior.);
    $lang{lang_results}=qq(Resultados);
    $lang{lang_of}=qq(de);
    $lang{nextpage}=qq(Prxima Pgina);
    $lang{previouspage}=qq(Pgina Anterior);
    $lang{gotopage}=qq(Ir para a Pgina);
    $lang{searchagain}=qq(Pesquisar Novamente);
    $lang{returntohomepage}=qq(Voltar para a Pgina Principal);
    $lang{poweredbywebteacher}=qq(Gerado por<BR><A HREF=\"http://www.webteacher.com/webdata\">Webteacher\'s Webdata</A>);
    $lang{noresultswerefound}="Nada foi localizado";
    $lang{indicatesRequiredFields}=qq{indica campos obrigatrios};
  }
}
#END LANGUAGE

return 1;
