/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import jms.graphics.BorderedPanel;

class FileFormatPanel
extends BorderedPanel {
    public static final String JPG = new String(".jpg");
    public static final String GIF = new String(".gif");
    public static final String PNG = new String(".png");
    public static final String MPG = new String(".mpg");
    public static final String AVI = new String(".avi");
    public static final String MOV = new String(".mov");
    public static final String WAV = new String(".wav");
    public static final String AU = new String(".au");
    public static final String MID = new String(".mid");
    public static final String PDF = new String(".pdf");
    public static final String DOC = new String(".doc");
    public static final String TXT = new String(".txt");
    public static final String ZIP = new String(".zip");
    public static final String EXE = new String(".exe");
    public static final String JAR = new String(".jar");
    public static final String OTHER = new String("other");
    public static String ImagePath = new String("");
    private Vector listOfFileExt = new Vector();
    private TextField userEntryField;
    private Checkbox userCheckbox;
    private Checkbox currentCheckbox;

    public String getIconName() {
        Checkbox checkbox = (Checkbox)this.listOfFileExt.firstElement();
        if (checkbox == null) {
            return "iconthumbnail.gif";
        }
        CheckboxGroup cbg = checkbox.getCheckboxGroup();
        if (cbg.getSelectedCheckbox().getLabel().equals(OTHER)) {
            return "iconthumbnail.gif";
        }
        String extension = this.getSelection();
        return "icon" + extension.substring(1) + ".gif";
    }

    public static String getIconName(String file_name) {
        String str = FileFormatPanel.getExtension(String.valueOf(ImagePath) + file_name);
        if (str.equalsIgnoreCase(PNG) || str.equalsIgnoreCase(MPG) || str.equalsIgnoreCase(AVI) || str.equalsIgnoreCase(MOV) || str.equalsIgnoreCase(WAV) || str.equalsIgnoreCase(AU) || str.equalsIgnoreCase(MID) || str.equalsIgnoreCase(PDF) || str.equalsIgnoreCase(DOC) || str.equalsIgnoreCase(TXT) || str.equalsIgnoreCase(ZIP) || str.equalsIgnoreCase(EXE) || str.equalsIgnoreCase(JAR)) {
            return "icon" + str.substring(1) + ".gif";
        }
        return "iconthumbnail.gif";
    }

    public FileFormatPanel(String title) {
        super(title);
        CheckboxGroup cbg = new CheckboxGroup();
        this.listOfFileExt.addElement(new Checkbox(JPG, true, cbg));
        this.listOfFileExt.addElement(new Checkbox(MPG, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(WAV, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(PDF, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(ZIP, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(GIF, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(AVI, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(MID, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(DOC, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(EXE, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(PNG, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(MOV, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(AU, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(TXT, false, cbg));
        this.listOfFileExt.addElement(new Checkbox(JAR, false, cbg));
        this.userCheckbox = new Checkbox(OTHER, false, cbg);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 3);
        Checkbox c = null;
        int count = 1;
        boolean row = true;
        Enumeration e = this.listOfFileExt.elements();
        while (e.hasMoreElements()) {
            if (count % 5 == 0) {
                gbc.gridwidth = 0;
                gbc.anchor = 17;
            } else {
                gbc.gridwidth = 1;
            }
            c = (Checkbox)e.nextElement();
            gbl.setConstraints(c, gbc);
            this.add(c);
            this.userEntryField = new TextField(5);
            this.currentCheckbox = c;
            this.currentCheckbox.addItemListener(new 1());
            ++count;
        }
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbl.setConstraints(this.userCheckbox, gbc);
        this.add(this.userCheckbox);
        gbl.setConstraints(this.userEntryField, gbc);
        this.add(this.userEntryField);
        this.userCheckbox.addItemListener(new 2());
    }

    public void setSelection(String ext) {
        Checkbox checkbox = null;
        boolean other_ext = true;
        this.userEntryField.setEnabled(false);
        ((TextComponent)this.userEntryField).setText("");
        Enumeration e = this.listOfFileExt.elements();
        while (e.hasMoreElements()) {
            checkbox = (Checkbox)e.nextElement();
            if (!checkbox.getLabel().equals(ext)) continue;
            checkbox.setState(true);
            other_ext = false;
            break;
        }
        if (other_ext) {
            this.userCheckbox.setState(true);
            this.userEntryField.setEnabled(true);
            ((TextComponent)this.userEntryField).setText(ext);
        }
    }

    public String getSelection() {
        Checkbox checkbox = (Checkbox)this.listOfFileExt.firstElement();
        if (checkbox == null) {
            return null;
        }
        CheckboxGroup cbg = checkbox.getCheckboxGroup();
        if (cbg.getSelectedCheckbox().getLabel().equals(OTHER)) {
            return this.userEntryField.getText();
        }
        return cbg.getSelectedCheckbox().getLabel();
    }

    public static boolean isImage(String file_name) {
        String extension = FileFormatPanel.getExtension(file_name);
        return extension.equals(JPG) || extension.equals(GIF);
    }

    public static String getExtension(String file_name) {
        int pos = -1;
        String str = new String(file_name);
        while ((pos = str.indexOf(".")) != -1) {
            str = str.substring(pos + 1);
        }
        return "." + str;
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            FileFormatPanel.this.userEntryField.setEnabled(false);
            FileFormatPanel.this.repaint();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (FileFormatPanel.this.userCheckbox.getState()) {
                FileFormatPanel.this.userEntryField.setEnabled(true);
                FileFormatPanel.this.userEntryField.requestFocus();
                FileFormatPanel.this.repaint();
            }
        }

        /* synthetic */ 2() {
        }
    }
}

