/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import jms.graphics.BorderedPanel;

class NamingConventionPanel
extends BorderedPanel {
    private Checkbox fromLinksCheckbox;
    private Checkbox fromUrlsCheckbox;
    private Label fromLabel;
    private TextField fromField;
    private Label toLabel;
    private TextField toField;
    private Label digitLabel;
    private TextField digitField;
    private Label prefixLabel;
    private TextField prefixField;
    private Label suffixLabel;
    private TextField suffixField;
    private Checkbox loadEmbedImagesCheckbox;
    private int from;
    private int to;

    public NamingConventionPanel(String title) {
        super(title);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        CheckboxGroup cbg = new CheckboxGroup();
        this.fromLinksCheckbox = new Checkbox("Files from html links", true, cbg);
        this.fromUrlsCheckbox = new Checkbox("Files from a known naming convention", false, cbg);
        this.fromLabel = new Label("Start index:");
        this.fromField = new TextField(Integer.toString(this.from), 3);
        this.toLabel = new Label("Stop index:");
        this.toField = new TextField(Integer.toString(this.to), 3);
        this.digitLabel = new Label("Number of digits:");
        this.digitField = new TextField("1", 3);
        this.prefixLabel = new Label("Prefix:");
        this.prefixField = new TextField(10);
        this.suffixLabel = new Label("Suffix:");
        this.suffixField = new TextField(10);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.fromLinksCheckbox, gbc);
        this.add(this.fromLinksCheckbox);
        this.loadEmbedImagesCheckbox = new Checkbox("Embedded images", true, null);
        gbl.setConstraints(this.loadEmbedImagesCheckbox, gbc);
        this.add(this.loadEmbedImagesCheckbox);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.fromUrlsCheckbox, gbc);
        this.add(this.fromUrlsCheckbox);
        gbc.gridwidth = 1;
        gbl.setConstraints(this.prefixLabel, gbc);
        this.add(this.prefixLabel);
        gbl.setConstraints(this.prefixField, gbc);
        this.add(this.prefixField);
        gbc.anchor = 13;
        gbl.setConstraints(this.suffixLabel, gbc);
        this.add(this.suffixLabel);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.suffixField, gbc);
        this.add(this.suffixField);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbl.setConstraints(this.fromLabel, gbc);
        this.add(this.fromLabel);
        gbl.setConstraints(this.fromField, gbc);
        this.add(this.fromField);
        gbc.anchor = 17;
        gbl.setConstraints(this.toLabel, gbc);
        this.add(this.toLabel);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.toField, gbc);
        this.add(this.toField);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbl.setConstraints(this.digitLabel, gbc);
        this.add(this.digitLabel);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.digitField, gbc);
        this.add(this.digitField);
        this.fromLinksCheckbox.addItemListener(new 1());
        this.fromUrlsCheckbox.addItemListener(new 2());
    }

    public void disableFields() {
        this.fromLabel.setEnabled(false);
        this.fromField.setEnabled(false);
        this.toLabel.setEnabled(false);
        this.toField.setEnabled(false);
        this.digitLabel.setEnabled(false);
        this.digitField.setEnabled(false);
        this.prefixLabel.setEnabled(false);
        this.prefixField.setEnabled(false);
        this.suffixLabel.setEnabled(false);
        this.suffixField.setEnabled(false);
        this.loadEmbedImagesCheckbox.setEnabled(true);
    }

    public void enableFields() {
        this.fromLabel.setEnabled(true);
        this.fromField.setEnabled(true);
        this.toLabel.setEnabled(true);
        this.toField.setEnabled(true);
        this.digitLabel.setEnabled(true);
        this.digitField.setEnabled(true);
        this.prefixLabel.setEnabled(true);
        this.prefixField.setEnabled(true);
        this.suffixLabel.setEnabled(true);
        this.suffixField.setEnabled(true);
        this.loadEmbedImagesCheckbox.setEnabled(false);
    }

    public void setValues(String p, String s, String dn, String start, String stop, String from_links_state, String load_embed_images) {
        ((TextComponent)this.fromField).setText(start);
        ((TextComponent)this.toField).setText(stop);
        this.from = Integer.parseInt(start);
        this.to = Integer.parseInt(stop);
        ((TextComponent)this.digitField).setText(dn);
        ((TextComponent)this.prefixField).setText(p);
        ((TextComponent)this.suffixField).setText(s);
        String state = from_links_state.trim().toLowerCase();
        if (state.equals("on")) {
            this.fromLinksCheckbox.setState(true);
            this.disableFields();
            this.repaint();
        } else {
            this.fromUrlsCheckbox.setState(true);
            this.enableFields();
            this.repaint();
        }
        state = load_embed_images.trim().toLowerCase();
        if (state.equals("on")) {
            this.loadEmbedImagesCheckbox.setState(true);
        } else {
            this.loadEmbedImagesCheckbox.setState(false);
        }
    }

    public Hashtable getValues() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("prefixName", this.prefixField.getText());
        properties.put("suffixName", this.suffixField.getText());
        properties.put("digitNumber", this.digitField.getText());
        properties.put("startIndex", this.fromField.getText());
        properties.put("stopIndex", this.toField.getText());
        if (this.fromLinksCheckbox.getState()) {
            properties.put("fromLinksState", "on");
        } else {
            properties.put("fromLinksState", "off");
        }
        if (this.loadEmbedImagesCheckbox.getState()) {
            properties.put("loadEmbedImages", "on");
        } else {
            properties.put("loadEmbedImages", "off");
        }
        return properties;
    }

    public static int getNumber(String number) {
        String nd = number;
        if (nd == null) {
            return -1;
        }
        if ((nd = nd.trim()).equals("")) {
            return -1;
        }
        int n = -1;
        try {
            n = Integer.parseInt(nd);
            if (n < 0) {
                return -1;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public boolean downloadFilesFromLinks() {
        return this.fromLinksCheckbox.getState();
    }

    public boolean downloadEmbedImages() {
        return this.loadEmbedImagesCheckbox.getState();
    }

    public int getNumberOfDigits() {
        int n = NamingConventionPanel.getNumber(this.digitField.getText());
        if (n <= 0) {
            n = -1;
        }
        return n;
    }

    public int getStartIndex() {
        return NamingConventionPanel.getNumber(this.fromField.getText());
    }

    public int getStopIndex() {
        return NamingConventionPanel.getNumber(this.toField.getText());
    }

    public String getPrefixName() {
        return this.prefixField.getText();
    }

    public String getSuffixName() {
        return this.suffixField.getText();
    }

    public Dimension maximumSize() {
        return new Dimension(450, 200);
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (NamingConventionPanel.this.fromLinksCheckbox.getState()) {
                NamingConventionPanel.this.disableFields();
                NamingConventionPanel.this.repaint();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (NamingConventionPanel.this.fromUrlsCheckbox.getState()) {
                NamingConventionPanel.this.enableFields();
                NamingConventionPanel.this.prefixField.requestFocus();
                NamingConventionPanel.this.repaint();
            }
        }

        /* synthetic */ 2() {
        }
    }
}

