/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;
import jms.graphics.ImageDisplayerObserver;

public class ImageDisplayer
extends Frame
implements ImageObserver {
    public static int BORDER = 5;
    public static float ZOOM_FACTOR = 1.25f;
    public static int SCREEN_BORDER = 10;
    protected static Vector listOfDisplayedImages = null;
    private Image theImage;
    private float zooming = 1.0f;
    private Dimension imageSize;
    private Dimension initialImageSize;
    private ImageDisplayerObserver imageDisplayerObserver;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;

    public ImageDisplayer(String title, Image img, ImageDisplayerObserver ido) {
        super(title);
        this.theImage = img;
        this.imageDisplayerObserver = ido;
        this.init();
    }

    public ImageDisplayer(String image_name, ImageDisplayerObserver ido) {
        super(image_name);
        this.theImage = Toolkit.getDefaultToolkit().getImage(image_name);
        this.imageDisplayerObserver = ido;
        this.init();
    }

    public ImageDisplayer(String title, String image_name, ImageDisplayerObserver ido) {
        super(title);
        this.theImage = Toolkit.getDefaultToolkit().getImage(image_name);
        this.imageDisplayerObserver = ido;
        this.init();
    }

    public void init() {
        MediaTracker tracker = new MediaTracker(this);
        if (this.theImage != null) {
            try {
                tracker.addImage(this.theImage, 0);
                tracker.waitForID(0);
                tracker = null;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                System.out.println("Sorry, cannot load the image");
            }
        }
        this.initialImageSize = new Dimension(this.theImage.getWidth(this), this.theImage.getHeight(this));
        this.addMouseListener(new 1());
        this.addWindowListener(new 2());
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.repaint();
        return true;
    }

    public static void destroyAll() {
        ImageDisplayer id = null;
        if (listOfDisplayedImages != null) {
            Enumeration e = listOfDisplayedImages.elements();
            while (e.hasMoreElements()) {
                id = (ImageDisplayer)e.nextElement();
                id.destroy();
            }
        }
    }

    public void destroy() {
        if (this.theImage != null) {
            this.theImage.flush();
            this.theImage = null;
            if (this.imageDisplayerObserver != null) {
                this.imageDisplayerObserver.imageDisplayerDone(null);
            }
            System.gc();
        }
        this.dispose();
    }

    public void setFrameSize() {
        this.imageSize = new Dimension((int)((float)this.initialImageSize.width / this.zooming), (int)((float)this.initialImageSize.height / this.zooming));
        int w = 2 * BORDER + this.imageSize.width + this.getInsets().left + this.getInsets().right;
        int h = 2 * BORDER + this.imageSize.height + this.getInsets().bottom + this.getInsets().top;
        ((Component)this).setSize(w, h);
        this.repaint();
    }

    public boolean canZoomPlus(float zooming) {
        Dimension d = new Dimension((int)((float)this.initialImageSize.width / zooming), (int)((float)this.initialImageSize.height / zooming));
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        return d.width <= screen.width - SCREEN_BORDER && d.height <= screen.height - SCREEN_BORDER;
    }

    public boolean canZoomMinus(float zooming) {
        Dimension d = new Dimension((int)((float)this.initialImageSize.width / zooming), (int)((float)this.initialImageSize.height / zooming));
        return d.width >= this.initialImageSize.width && d.height >= this.initialImageSize.height;
    }

    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public Insets getInsets() {
        return new Insets(28, 4, 4, 4);
    }

    public Point getPositionOnScreen() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        int img_w = (int)((float)this.theImage.getWidth(this) / this.zooming);
        int img_h = (int)((float)this.theImage.getHeight(this) / this.zooming);
        int x = (int)(9.0f * (float)screen.width / 10.0f - (float)img_w);
        int y = (int)(9.0f * (float)screen.height / 10.0f - (float)img_h);
        if (x < 0 || y < 0) {
            this.zooming = 2.0f * this.zooming;
            this.getPositionOnScreen();
        }
        return new Point(screen.width / 10, screen.height / 10);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, d.width, d.height);
        if (this.imageSize == null) {
            this.setFrameSize();
        }
        g.drawImage(this.theImage, this.getInsets().left + BORDER, this.getInsets().top + BORDER, this.imageSize.width, this.imageSize.height, this);
    }

    public void run() {
        this.init();
        int w = 2 * BORDER + this.theImage.getWidth(this) + this.getInsets().left + this.getInsets().right;
        int h = this.getInsets().bottom + this.getInsets().top + 2 * BORDER + this.theImage.getHeight(this);
        Point p = this.getPositionOnScreen();
        ((Component)this).setLocation(p.x, p.y);
        ((Component)this).setSize((int)((float)w / this.zooming), (int)((float)h / this.zooming));
        this.setResizable(false);
        if (listOfDisplayedImages == null) {
            listOfDisplayedImages = new Vector();
        }
        if (!listOfDisplayedImages.contains(this)) {
            listOfDisplayedImages.addElement(this);
        }
        this.show();
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            float coef;
            if (((evt.getModifiers() & 4) != 0 || (evt.getModifiers() & 8) != 0) && ImageDisplayer.this.canZoomMinus(coef = ImageDisplayer.this.zooming * ZOOM_FACTOR)) {
                ImageDisplayer imageDisplayer = ImageDisplayer.this;
                imageDisplayer.zooming = imageDisplayer.zooming * ZOOM_FACTOR;
                ImageDisplayer.this.setFrameSize();
                return;
            }
            if ((evt.getModifiers() & 0x10) != 0 && ImageDisplayer.this.canZoomPlus(coef = ImageDisplayer.this.zooming / ZOOM_FACTOR)) {
                ImageDisplayer imageDisplayer = ImageDisplayer.this;
                imageDisplayer.zooming = imageDisplayer.zooming / ZOOM_FACTOR;
                ImageDisplayer.this.setFrameSize();
                return;
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            if (ImageDisplayer.this.theImage != null) {
                ImageDisplayer.this.theImage.flush();
                ImageDisplayer.this.theImage = null;
                ImageDisplayer.this.imageDisplayerObserver.imageDisplayerDone(null);
                System.gc();
            }
            ImageDisplayer.this.dispose();
        }

        /* synthetic */ 2() {
        }
    }
}

