/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import jms.de.StatusBarPanel;
import jms.de.ThumbnailsPanel;
import jms.graphics.AdminDialog;
import jms.graphics.BorderedPanel;
import jms.graphics.ConfirmBox;
import jms.graphics.GenericThumbnail;
import jms.graphics.ThumbnailListener;

class FilesPanel
extends BorderedPanel
implements ThumbnailListener {
    private ScrollPane scroller;
    private StatusBarPanel statusBar;
    private ThumbnailsPanel thumbnailsPanel;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;

    public FilesPanel(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.scroller = new ScrollPane();
        this.thumbnailsPanel = new ThumbnailsPanel();
        this.scroller.add(this.thumbnailsPanel);
        this.add("Center", this.scroller);
        Adjustable adju = this.scroller.getHAdjustable();
        adju.setUnitIncrement(10);
        adju = this.scroller.getVAdjustable();
        adju.setUnitIncrement(10);
        this.statusBar = new StatusBarPanel();
        this.add("South", this.statusBar);
        this.addComponentListener(new 1());
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void thumbnailEntered(ActionEvent evt) {
        GenericThumbnail gt = (GenericThumbnail)evt.getSource();
        this.writeStatus(gt.getInfo());
    }

    public void thumbnailExited(ActionEvent evt) {
        this.writeStatus("");
    }

    public void thumbnailDelete(ActionEvent evt) {
        block2: {
            GenericThumbnail gt = (GenericThumbnail)evt.getSource();
            ConfirmBox cb = new ConfirmBox(new Frame(), "DownloadExpert", "Delete file : " + gt.getFullFileName() + " ?");
            if (!cb.accept()) break block2;
            File f = new File(gt.getFullFileName());
            try {
                f.delete();
                this.remove(gt);
                gt = null;
                System.gc();
            }
            catch (SecurityException securityException) {}
        }
    }

    public void thumbnailProperties(ActionEvent evt) {
        GenericThumbnail gt = (GenericThumbnail)evt.getSource();
        if (gt == null) {
            return;
        }
        AdminDialog ad = new AdminDialog(new Frame(), "File Properties", gt.getProperties());
    }

    public synchronized void writeStatus(String new_status) {
        this.statusBar.writeStatus(new_status);
    }

    public void writeLoad(String load) {
        this.statusBar.writeLoad(load);
    }

    public void writeRate(String rate) {
        this.statusBar.writeRate(rate);
    }

    public synchronized void add(GenericThumbnail gt) {
        this.thumbnailsPanel.add((Component)this, gt);
        this.doLayout();
        this.validate();
    }

    public synchronized void remove(GenericThumbnail gt) {
        this.thumbnailsPanel.remove(this, gt);
        this.doLayout();
        this.validate();
    }

    public void reInitProgressBar(int current) {
        this.statusBar.reInitProgressBar(current);
    }

    public void setProgressBarValue(int value) {
        this.statusBar.setProgressBarValue(value);
    }

    public synchronized void removeAllFiles() {
        this.thumbnailsPanel.clear(true);
        Component[] thumbnails = this.thumbnailsPanel.getComponents();
        GenericThumbnail c = null;
        int i = 0;
        while (i < thumbnails.length) {
            c = (GenericThumbnail)thumbnails[i];
            ++i;
        }
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent event) {
            try {
                FilesPanel.this.thumbnailsPanel.manageResize();
            }
            catch (Exception exception) {}
            FilesPanel.this.repaint();
        }

        /* synthetic */ 1() {
        }
    }
}

