/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.layout.XYLayout;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.BorderItemPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.UIManager;

public class BevelPanel
extends BeanPanel
implements Serializable {
    public static final int FLAT = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    protected int bevelInner = 1;
    protected int bevelOuter = 0;
    protected boolean soft = false;
    protected BorderItemPainter border;
    protected Insets margins = new Insets(0, 0, 0, 0);
    protected String textureName;

    public BevelPanel() {
        super(new XYLayout());
        super.setBackground(UIManager.getColor("Panel.background"));
        super.setForeground(UIManager.getColor("Panel.foreground"));
        super.setFont(UIManager.getFont("Panel.font"));
        super.setOpaque(true);
        this.focusAware = false;
        this.resetEdges();
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Panel.background"));
        super.setForeground(UIManager.getColor("Panel.foreground"));
        super.setFont(UIManager.getFont("Panel.font"));
    }

    public BevelPanel(int bevelInner, int bevelOuter) {
        super.setLayout(new XYLayout());
        super.setBackground(SystemColor.control);
        super.setOpaque(true);
        if (bevelInner >= 0 && bevelInner <= 2) {
            this.bevelInner = bevelInner;
        }
        if (bevelOuter >= 0 && bevelOuter <= 2) {
            this.bevelOuter = bevelOuter;
        }
        this.focusAware = false;
        this.resetEdges();
    }

    public void setBevelInner(int bevelInner) {
        if (bevelInner >= 0 && bevelInner <= 2 && bevelInner != this.bevelInner) {
            this.bevelInner = bevelInner;
            this.resetEdges();
        }
    }

    public int getBevelInner() {
        return this.bevelInner;
    }

    public void setBevelOuter(int bevelOuter) {
        if ((bevelOuter == 0 || bevelOuter == 1 || bevelOuter == 2) && bevelOuter != this.bevelOuter) {
            this.bevelOuter = bevelOuter;
            this.resetEdges();
        }
    }

    public int getBevelOuter() {
        return this.bevelOuter;
    }

    public void setSoft(boolean soft) {
        if (soft != this.soft) {
            this.soft = soft;
            this.resetEdges();
        }
    }

    public boolean isSoft() {
        return this.soft;
    }

    public void setMargins(Insets margins) {
        if (!this.margins.equals(margins)) {
            this.margins = margins == null ? new Insets(0, 0, 0, 0) : margins;
            this.invalidate();
            this.repaint(100L);
        }
    }

    public Insets getMargins() {
        return this.margins;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i2 = ImageLoader.load(path, (Component)this);
            if (i2 == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i2);
            this.textureName = path;
            this.setTexture(i2);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public Insets getInsets() {
        Insets i2 = super.getInsets();
        Insets b2 = this.border != null ? this.border.getInsets() : new Insets(0, 0, 0, 0);
        return new Insets(i2.top + b2.top + this.margins.top, i2.left + b2.left + this.margins.left, i2.bottom + b2.bottom + this.margins.bottom, i2.right + b2.right + this.margins.right);
    }

    public Dimension getPreferredSize() {
        Dimension d2 = super.getPreferredSize();
        if (d2.width <= 10) {
            d2.width = 100;
        }
        if (d2.height <= 10) {
            d2.height = 100;
        }
        return d2;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Dimension size = this.getSize();
        if (this.border != null) {
            Rectangle rect = new Rectangle(0, 0, size.width, size.height);
            this.border.paint(null, g2, rect, 0, null);
        }
    }

    protected void resetEdges() {
        if (this.bevelInner == 0 && this.bevelOuter == 0) {
            this.border = null;
        } else {
            int style = 0;
            switch (this.bevelInner) {
                case 0: {
                    break;
                }
                case 1: {
                    style |= 0x400;
                    break;
                }
                case 2: {
                    style |= 0x800;
                }
            }
            switch (this.bevelOuter) {
                case 0: {
                    break;
                }
                case 1: {
                    style |= 0x100;
                    break;
                }
                case 2: {
                    style |= 0x200;
                }
            }
            this.border = new BorderItemPainter(style, 15, this.soft ? 4096 : 0);
        }
        this.invalidate();
        this.repaint(100L);
    }
}

