/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BorderItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    public static final int OUTER_RAISED = 256;
    public static final int OUTER_SUNKEN = 512;
    public static final int INNER_RAISED = 1024;
    public static final int INNER_SUNKEN = 2048;
    public static final int EDGE_RAISED = 1280;
    public static final int EDGE_SUNKEN = 2560;
    public static final int EDGE_ETCHED = 1536;
    public static final int EDGE_BUMP = 2304;
    public static final int EDGE_OUTER = 768;
    public static final int EDGE_INNER = 3072;
    public static final int EDGE_ALL = 3840;
    public static final int NONE = 0;
    public static final int PLAIN = 1;
    public static final int RAISED = 2;
    public static final int RECESSED = 3;
    public static final int EMBOSSED = 4;
    public static final int GROOVED = 5;
    public static final int BUTTON_UP = 6;
    public static final int BUTTON_DN = 7;
    public static final int WND_RAISED = 8;
    public static final int WND_RECESSED = 9;
    public static final int WELL_SET = 10;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int TOP_LEFT = 3;
    public static final int TOP_RIGHT = 6;
    public static final int BOTTOM_LEFT = 9;
    public static final int BOTTOM_RIGHT = 12;
    public static final int RECT = 15;
    public static final int FILL = 2048;
    public static final int SOFT = 4096;
    public static final int FLAT = 16384;
    public static final int MONO = 32768;
    private static int[] edges = new int[]{0, 0, 1024, 2048, 2304, 1536, 1280, 2560, 1280, 2560, 1536};
    private static int[] flagses = new int[]{0, 0, 0, 0, 0, 0, 4096, 4096, 0, 0, 0};
    private int edge;
    private int which;
    private int flags;
    private transient ItemPainter painter;

    public BorderItemPainter(int edgeOrStyle, int which, int flags) {
        if ((edgeOrStyle & 0xF00) == 0) {
            this.edge = edges[edgeOrStyle];
            this.flags = flagses[edgeOrStyle] | flags;
        } else {
            this.edge = edgeOrStyle;
            this.flags = flags;
        }
        this.which = which;
    }

    public BorderItemPainter(int edgeOrStyle, int which) {
        this(edgeOrStyle, which, 0);
    }

    public BorderItemPainter(int edgeOrStyle) {
        this(edgeOrStyle, 15, 0);
    }

    public BorderItemPainter() {
        this(0, 15, 0);
    }

    public BorderItemPainter(ItemPainter painter, int edgeOrStyle, int which, int flags) {
        this(edgeOrStyle, which, flags);
        this.painter = painter;
    }

    public BorderItemPainter(ItemPainter painter, int edgeOrStyle, int which) {
        this(edgeOrStyle, which);
        this.painter = painter;
    }

    public BorderItemPainter(ItemPainter painter, int edgeOrStyle) {
        this(edgeOrStyle);
        this.painter = painter;
    }

    public BorderItemPainter(ItemPainter painter) {
        this();
        this.painter = painter;
    }

    public int getEdgeOrStyle() {
        return this.edge;
    }

    public void setEdgeOrStyle(int newEdge) {
        if ((newEdge & 0xF00) == 0) {
            this.edge = edges[newEdge];
            this.flags = flagses[newEdge] | this.flags;
        } else {
            this.edge = newEdge;
        }
    }

    public int getWhichEdges() {
        return this.which;
    }

    public void setWhichEdges(int newWhich) {
        this.which = newWhich;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int newFlags) {
        this.flags = newFlags;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ItemPainter newPainter) {
        this.painter = newPainter;
    }

    public Insets getInsets() {
        int thickness = ((this.edge & 0x300) != 0 ? 1 : 0) + ((this.edge & 0xC00) != 0 ? 1 : 0);
        return new Insets(thickness * ((this.which & 2) != 0 ? 1 : 0), thickness * ((this.which & 1) != 0 ? 1 : 0), thickness * ((this.which & 8) != 0 ? 1 : 0), thickness * ((this.which & 4) != 0 ? 1 : 0));
    }

    public Dimension getPreferredSize(Object data, Graphics g2, int state, ItemPaintSite site) {
        Insets insets = this.getInsets();
        if (this.painter != null) {
            Dimension inner = this.painter.getPreferredSize(data, g2, state, site);
            return new Dimension(inner.width + insets.left + insets.right, inner.height + insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    public void paint(Object data, Graphics g2, Rectangle bounds, int state, ItemPaintSite site) {
        boolean trans;
        Rectangle clip = g2.getClipBounds();
        if (clip == null) {
            return;
        }
        g2.clipRect(bounds.x, bounds.y, bounds.width, bounds.height);
        boolean bl = trans = site != null ? site.isTransparent() : false;
        if (trans) {
            this.flags &= 0xFFFFF7FF;
        }
        BorderItemPainter.drawEdge(g2, bounds, this.edge, this.which, this.flags);
        if (this.painter != null) {
            Insets insets = this.getInsets();
            int thickness = ((this.edge & 0x300) != 0 ? 1 : 0) + ((this.edge & 0xC00) != 0 ? 1 : 0);
            bounds.x += insets.left;
            bounds.width -= insets.left + insets.right;
            bounds.y += insets.top;
            bounds.height -= insets.top + insets.bottom;
            g2.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
            this.painter.paint(data, g2, bounds, state, site);
        }
        g2.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public static boolean drawEdge(Graphics g2, Rectangle bounds, int edge, int which, int flags) {
        int ci;
        Color[] brColors;
        Color[] tlColors;
        Rectangle b2 = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        if ((flags & 0x8000) != 0) {
            if ((edge & 0x300) != 0) {
                BorderItemPainter.paintFrame(g2, b2, which, SystemColor.windowBorder, SystemColor.windowBorder);
                b2.grow(-1, -1);
            }
            if ((flags & 0x800) != 0) {
                g2.setColor(SystemColor.window);
                g2.drawRect(b2.x, b2.y, b2.width, b2.height);
            }
            return true;
        }
        if ((flags & 0x4000) != 0) {
            if ((edge & 0x300) != 0) {
                BorderItemPainter.paintFrame(g2, b2, which, SystemColor.controlShadow, SystemColor.controlShadow);
                b2.grow(-1, -1);
            }
            if ((flags & 0x800) != 0) {
                g2.setColor(SystemColor.control);
                g2.drawRect(b2.x, b2.y, b2.width, b2.height);
            }
            return true;
        }
        if ((edge & 0x300) != 0) {
            tlColors = new Color[]{SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow};
            brColors = new Color[]{SystemColor.controlDkShadow, SystemColor.controlDkShadow, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight};
            ci = ((edge & 0x200) != 0 ? 2 : 0) | ((flags & 0x1000) != 0 ? 1 : 0);
            BorderItemPainter.paintFrame(g2, b2, which, tlColors[ci], brColors[ci]);
            b2.grow(-1, -1);
        }
        if ((edge & 0xC00) != 0) {
            tlColors = new Color[]{SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow};
            brColors = new Color[]{SystemColor.controlShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlHighlight};
            ci = ((edge & 0x800) != 0 ? 2 : 0) | ((flags & 0x1000) != 0 ? 1 : 0);
            BorderItemPainter.paintFrame(g2, b2, which, tlColors[ci], brColors[ci]);
            b2.grow(-1, -1);
        }
        if ((flags & 0x800) != 0) {
            g2.setColor(SystemColor.control);
            g2.fillRect(b2.x, b2.y, b2.width, b2.height);
        }
        return true;
    }

    static void paintFrame(Graphics g2, Rectangle b2, int which, Color tlColor, Color brColor) {
        if ((which & 3) != 0) {
            g2.setColor(tlColor);
            if ((which & 1) != 0) {
                g2.drawLine(b2.x, b2.y + 1, b2.x, b2.y + b2.height - 1);
            }
            if ((which & 2) != 0) {
                g2.drawLine(b2.x, b2.y, b2.x + b2.width - 1, b2.y);
            }
        }
        if ((which & 0xC) != 0) {
            g2.setColor(brColor);
            if ((which & 4) != 0) {
                g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
            }
            if ((which & 8) != 0) {
                g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
            }
        }
    }

    static void paintFrameC(Graphics g2, Rectangle b2, int which, Color tlColor, Color brColor, Color bcColor) {
        if ((which & 3) != 0) {
            g2.setColor(tlColor);
            if ((which & 1) != 0) {
                g2.drawLine(b2.x, b2.y + 1, 1, b2.y + b2.height - 1);
            }
            if ((which & 2) != 0) {
                g2.drawLine(b2.x, b2.y, b2.x + b2.width - 2, b2.y);
                g2.setColor(bcColor);
                g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y);
            }
        }
        if ((which & 0xC) != 0) {
            g2.setColor(brColor);
            if ((which & 4) != 0) {
                g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
            }
            if ((which & 8) != 0) {
                g2.drawLine(b2.x + 1, b2.y + b2.height - 1, b2.width - 2, b2.y + b2.height - 1);
                g2.setColor(bcColor);
                g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x, b2.y + b2.height - 1);
            }
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof ItemPainter) {
            this.painter = (ItemPainter)data;
        }
    }
}

