/*
 * Decompiled with CFR 0.152.
 */
package CalendarBean;

import CalendarBean.CalendarBn;
import CalendarBean.CalendarBnException;
import CalendarBean.CalendarBnListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class DateEditor
extends PropertyEditorSupport
implements CalendarBnListener {
    private CalendarBn dp;
    private CalendarBn dpmin;
    private CalendarBn dpmax;
    private Label l = new Label();
    private Panel p = new Panel();

    public DateEditor() {
        this.dp = new CalendarBn();
        this.dp.setTitle("Select Date");
        this.dp.setEditableYearVisible(false);
        this.dp.showToday(false);
        this.dpmin = new CalendarBn();
        this.dpmin.setTitle("Select MinDate");
        this.dpmin.setBackground(Color.orange);
        this.dpmin.setEditableYearVisible(false);
        this.dpmin.showToday(false);
        this.dpmax = new CalendarBn();
        this.dpmax.setTitle("Select MaxDate");
        this.dpmax.setBackground(Color.yellow);
        this.dpmax.setEditableYearVisible(false);
        this.dpmax.showToday(false);
        this.dp.addCalendarBnListener(this);
        this.dpmin.addCalendarBnListener(this);
        this.dpmax.addCalendarBnListener(this);
        this.l.setFont(new Font("SansSerif", 0, 17));
        this.p.setLayout(new GridLayout(2, 2));
        this.p.add(this.dpmin);
        this.p.add(this.dp);
        this.p.add(this.dpmax);
        this.p.add(this.l);
        this.l.setBackground(Color.white);
        this.l.setForeground(Color.red);
    }

    public void dateChanged(CalendarBn calendarBn) {
        this.l.setText("Setting Date please wait ....");
        try {
            if (calendarBn == this.dpmin) {
                this.dp.setMinDate(this.dpmin.getDate());
                this.dpmax.setMinDate(this.dp.getMinDate());
            } else if (calendarBn == this.dpmax) {
                this.dp.setMaxDate(this.dpmax.getDate());
                this.dpmin.setMaxDate(this.dp.getMaxDate());
            }
        }
        catch (CalendarBnException calendarBnException) {}
        this.firePropertyChange();
    }

    public Component getCustomEditor() {
        return this.p;
    }

    public String getJavaInitializationString() {
        String string = this.dp.getYear() + "," + this.dp.getMonth() + "," + this.dp.getDay();
        string = String.valueOf(string) + "," + this.dpmin.getYear() + "," + this.dpmin.getMonth() + "," + this.dpmin.getDay();
        string = String.valueOf(string) + "," + this.dpmax.getYear() + "," + this.dpmax.getMonth() + "," + this.dpmax.getDay();
        return string;
    }

    public Object getValue() {
        return this.dp;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.translate(rectangle.x, rectangle.y);
        graphics.drawString(this.dp.getFormattedDate(this.dp.getDate(), this.dp.getDateFormat()), 2, 14);
    }

    public void setValue(Object object) {
        this.dp.removeCalendarBnListener(this);
        this.dpmin.removeCalendarBnListener(this);
        this.dpmax.removeCalendarBnListener(this);
        try {
            CalendarBn calendarBn = (CalendarBn)object;
            this.dp.setDate(calendarBn.getDate());
            this.dp.setMinDate(calendarBn.getMinDate());
            this.dp.setMaxDate(calendarBn.getMaxDate());
            this.dpmin.setMinDate(this.dp.getYear() - 200, 1, 1);
            this.dpmin.setDate(calendarBn.getMinDate());
            this.dpmin.setMaxDate(calendarBn.getMaxDate());
            this.dpmax.setDate(calendarBn.getMaxDate());
            this.dpmax.setMinDate(calendarBn.getMinDate());
            this.dpmax.setMaxDate(this.dp.getYear() + 200, 12, 31);
        }
        catch (CalendarBnException calendarBnException) {}
        this.dp.addCalendarBnListener(this);
        this.dpmin.addCalendarBnListener(this);
        this.dpmax.addCalendarBnListener(this);
        this.l.setText(" ");
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

