/*
 * Decompiled with CFR 0.152.
 */
package com.javazine.components;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public final class ImageButton
extends Canvas {
    Container parent;
    Image image;
    Dimension dSize;
    int w = 0;
    int h = 0;
    int dx = 0;
    int dy = 0;
    boolean trueSizeKnown;
    MediaTracker tracker;

    public ImageButton(Image image, Container container, int n, int n2) {
        if (image == null) {
            System.err.println("Canvas got invalid image object!");
            return;
        }
        this.image = image;
        this.parent = container;
        this.w = n;
        this.h = n2;
        this.tracker = new MediaTracker(this);
        this.tracker.addImage(image, 0);
        this.dSize = new Dimension(this.w, this.h);
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            if (!this.trueSizeKnown && this.tracker.checkAll(true)) {
                int n = this.image.getWidth(this);
                int n2 = this.image.getHeight(this);
                if (this.w < n) {
                    this.w = n;
                }
                if (this.h < n2) {
                    this.h = n2;
                }
                this.dx = (this.w - n) / 2;
                this.dy = (this.h - n2) / 2;
                this.trueSizeKnown = true;
                if (this.tracker.isErrorAny()) {
                    System.err.println("Error loading image: " + this.image);
                }
            }
            graphics.drawImage(this.image, this.dx, this.dy, this);
        }
    }

    public Dimension getPreferredSize() {
        return this.dSize;
    }

    public Dimension getMinimumSize() {
        return this.dSize;
    }
}

