/*
 * Decompiled with CFR 0.152.
 */
package com.javazine.components;

import com.javazine.components.ImageCanvasEvent;
import com.javazine.components.ImageCanvasListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public final class ImageCanvas
extends Canvas {
    Image image = null;
    Dimension dSize;
    int w = 0;
    int h = 0;
    int ih = 0;
    int iw = 0;
    int dx = 0;
    int dy = 0;
    Vector listeners = null;
    boolean errored = false;
    boolean trueSizeKnown = false;
    private Frame parent;

    public void fireEvent(ImageCanvasEvent imageCanvasEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = 0;
        while (n < vector.size()) {
            ImageCanvasListener imageCanvasListener = (ImageCanvasListener)vector.elementAt(n);
            imageCanvasListener.imageCanvasChanged(imageCanvasEvent);
            ++n;
        }
    }

    public ImageCanvas(Frame frame, int n, int n2) {
        this.parent = frame;
        this.w = n;
        this.h = n2;
        this.dSize = new Dimension(n, n2);
        this.listeners = new Vector();
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            this.getSize();
            this.w = this.getSize().width;
            this.h = this.getSize().height;
            this.ih = this.image.getHeight(this);
            this.iw = this.image.getWidth(this);
            if (this.iw > this.w || this.ih > this.h) {
                this.w = this.iw;
                this.h = this.ih;
                this.dSize = new Dimension(this.w, this.h);
                this.setSize(this.w, this.h);
                this.parent.pack();
            }
            this.dx = (this.w - this.iw) / 2;
            this.dy = (this.h - this.ih) / 2;
            graphics.drawImage(this.image, this.dx, this.dy, this);
            return;
        }
        graphics.setColor(Color.white);
        graphics.drawString("Unable to load image", 50, 50);
    }

    public void removeImageCanvasListener(ImageCanvasListener imageCanvasListener) {
        this.listeners.removeElement(imageCanvasListener);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        if ((n & 8) != 0) {
            this.fireEvent(new ImageCanvasEvent(this, 1));
        }
        if ((n & 3) != 0) {
            this.trueSizeKnown = true;
            this.ih = this.image.getHeight(this);
            this.iw = this.image.getWidth(this);
        }
        boolean bl2 = bl = (n & 0x70) != 0;
        if (bl) {
            this.fireEvent(new ImageCanvasEvent(this, 2));
            this.repaint();
        } else {
            this.repaint(100L);
        }
        return true;
    }

    public void addImageCanvasListener(ImageCanvasListener imageCanvasListener) {
        this.listeners.addElement(imageCanvasListener);
    }

    public Dimension getPreferredSize() {
        return this.dSize;
    }

    public Dimension getMinimumSize() {
        return this.dSize;
    }

    public void setImage(String string) {
        try {
            this.trueSizeKnown = false;
            this.ih = 0;
            this.iw = 0;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.image = toolkit.getImage(new URL(string));
            if ((this.checkImage(this.image, this) & 0x20) != 0) {
                this.fireEvent(new ImageCanvasEvent(this, 2));
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }
}

