/*Data Access Library. v. 1.1.
 *On thread dispatcher. Used to realize async. data access in manager and datastore
 *classes.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

class OnThreadActionDispatcher implements Runnable {

    private OnThreadActionExecutor _theOwner;
    private String _methodName;
    private Object _params[];
    private Thread _backgroundThread;

    public OnThreadActionDispatcher(OnThreadActionExecutor owner,String methodName,Object[] params) {
	_theOwner = owner;
	_methodName = methodName;
	_params = params;
	_backgroundThread = new Thread(this,"BG_Thread");
	_backgroundThread.start();
    }

    public boolean onBackground() {
	return _backgroundThread.getName().equals(Thread.currentThread().getName());
    }

    public void run() {
	try {
	_theOwner._executeAction(_methodName,_params);
	} catch(Exception ex) {
	    _theOwner._handleException(ex);
	}
    }

}
