/*Data Access Library. v. 1.1.
 *Parameter Event support. Support class of DA Library.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

/**Facilitates implementation of parameter event dispatchers.
 *@see ParameterEvent
 *@see ParameterListener
 *@see ParameterListenerAdapter
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
*/
public synchronized class ParameterSupport {

    protected ParameterListener _listeners[];
    protected Object _source;

    public ParameterSupport(Object src) {
	_source = src;
	_listeners = new ParameterListener[10];
    }

    public void addParameterListener(ParameterListener l) {
	int pos=0;
	for (;pos<_listeners.length && _listeners[pos]!=null;pos++) ;
	if (pos==_listeners.length) {
	    ParameterListener ta[] = new ParameterListener[_listeners.length+10];
	    System.arraycopy(_listeners,0,ta,0,_listeners.length);
	    _listeners = ta;
	}
	_listeners[pos] = l;
    }

    public void fireExceptionOccurred(Exception ex) {
	ParameterEvent ev = new ParameterEvent(_source);
	for (int i=0;i<_listeners.length && _listeners[i]!=null;i++) 
	    _listeners[i].exceptionOccurred(ev);
    }

    public void fireActionCompleted(ParameterEvent ev) {
	for (int i=0;i<_listeners.length && _listeners[i]!=null;i++) 
	    _listeners[i].actionCompleted(ev);
    }

    public void removeParameterListener(ParameterListener l) {
	int pos=0;
	for(;pos < _listeners.length && _listeners[pos]!= l;pos++);
	if (pos<_listeners.length) {
	    for(;pos < _listeners.length-1;pos++)
		_listeners[pos] = _listeners[pos+1];
	    _listeners[_listeners.length-1] = null;
	}
    }

}
