package com.db4o.bench;

import com.db4o.*;
import java.sql.*;

public class BenchUpdate
{
	private static String tag = "update on " + Integer.toString(BenchMark.runs);
	private static String intTag = tag + " int";
	private static String stringTag = tag + " string";
	
	private static String stringData = "Benchmarked";
	
	public static void db4oInt(ObjectContainer db){
		BenchInt intUpdate;
		BenchMark.start(intTag);
		ObjectSet i = db.get(new BenchInt());
		while(i.hasNext()){
			intUpdate = (BenchInt)i.next();
			intUpdate.i_int ++;
			db.set(intUpdate);
		}
		BenchMark.stop();
	}
	
	public static void db4oString(ObjectContainer db){
		BenchString stringUpdate;
		BenchMark.start(stringTag);
		ObjectSet i = db.get(new BenchString());
		while(i.hasNext()){
			stringUpdate = (BenchString)i.next();
			stringUpdate.i_string = stringData;
			db.set(stringUpdate);
		}
		BenchMark.stop();
	}
	
	public static void sqlInt(Statement s) throws SQLException{
		String sql = "update " + BenchSql.tableInt + " set " + BenchSql.fieldInt 
					 + " = " + BenchSql.fieldInt + " + 1";
		BenchMark.start(intTag);
		s.executeUpdate(sql);
		BenchMark.stop();
	}
	
	public static void sqlString(Statement s) throws SQLException{
		String sql = "update " + BenchSql.tableString + " set " + BenchSql.fieldString 
					 + " = '" + stringData + "'";
		BenchMark.start(stringTag);
		s.executeUpdate(sql);
		BenchMark.stop();
	}


	
	
	
}
