package com.db4o.samples;

import com.db4o.*;
import com.db4o.lib.Logger;

public class S09_Joining_Objects
{
	public static void main(String[] args)
	{
		try{

			ObjectContainer db = Db4o.openFile("samples.yap");
			Logger.log("*** S09 Adding all Individual to first Company as Employees");

			ObjectSet individuals = db.get(new Individual());
			ObjectSet companies = db.get(new Company());

			Company company = (Company)companies.next();
			company.employees = new Individual[individuals.size()];
			int i = 0;
			while(individuals.hasNext()){


				company.employees[i ++] = (Individual)individuals.next();
				// The employees array on company is filled with existing
				// Individual objects retrieved from the database


			}


			db.set(company);
			// A single call to set() updates the company object.


			db.close();


			// we can use the By-Class-Log we created in example 4 now
			S04_Get_By_Class.logByClass(Company.class);


		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
