package com.db4o.samples;

import com.db4o.*;
import com.db4o.lib.Logger;

public class S12_Delete
{
	public static void main(String[] args)
	{
		try{
			ObjectContainer db = Db4o.openFile("samples.yap");
			Logger.log("*** S12 Deleting Individual where firstName is 'Alice'");

			Individual templateAlice = new Individual();
			templateAlice.firstName = "Alice";
			Individual alice = (Individual)db.get(templateAlice).next();


			db.delete(alice);
			// A call to delete *only* deletes the single object
			// passed as parameter.

			// Persistent members will continue to be stored in the database
			// A future version of db4o will implement cascade-on-delete

			db.close();
			
			S03_Get_All.main(null); 
			// S03 is used to log the content of the database

		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
