package  com.db4o.sql;

import  com.db4o.lib.*;
import  java.sql.*;

// We are trying to keep all the DB-Driver
// specific stuff in this class
public class Sql {

   // false ignores the following two parameters
    public static final boolean debug = false;

	// import only 3 tables, to allow quick testing
    public static final boolean limitTables = false;

	// use of predefined parameters in SqlConfiguration instead of command line
    public static final boolean defaultParameters = false;

	// maximum length of Strings,
    // increase to maximum of your JDBC driver, if necessary
    // constants for access to table meta information
    public static final int STRING_LENGTH = 255;

    private static final int TABLE_NAME = 3;
    private static final int COLUMN_NAME = 4;
    private static final int DATA_TYPE = 5;

    // Data Types as Strings for calls to 'create table'
    static final String FLOAT = "Float";
    static final String INTEGER = "Integer";
    static final String DOUBLE = "Double";
    static final String STRING = "VARCHAR(" + new Integer(STRING_LENGTH).toString() + ")";

    // Names for the storage of db4o information
    // used for SqlExport and SqlReImport
    static final String FROM_ID = "db4oFromID";
    static final String TO_ID = "db4oToID";
    static final String ARRAYINDEX = "arrayIndex";
    static final String MAP = "db4oIDMap";

	// File  for intermediate storage of table names
    // to allow SqlImportContinue
    public static final String TABLE_FILE_NAME = "tables.txt";

    // for creation of Objects using SqlImport
    // enlarge or modify for your needs, if necessary
    static SqlField fieldForType (String a_dataType) {
        short dataType = new Short(a_dataType).shortValue();
        switch (dataType) {
			case Types.VARCHAR:
            case Types.DATE:
			case Types.TIME:
                return  new SqlFieldString();
            case Types.INTEGER:
                return  new SqlFieldLong();
            case Types.DOUBLE:
			case Types.DECIMAL:
                return  new SqlFieldDouble();
            case Types.FLOAT:
                return  new SqlFieldFloat();
        }
        return  null;
    }

    public static Connection connect (String a_driver, String a_connectString) {
        return  connect(new SqlConfiguration(a_driver, a_connectString));
    }

    public static Connection connect (SqlConfiguration a_Config) {
        try {
            Sql.log("Using driver: " + a_Config.getDriver());
            Driver drv = (Driver)Class.forName(a_Config.getDriver()).newInstance();
            Sql.log("Connecting with: '" + a_Config.getConnect() + "'");
            return  java.sql.DriverManager.getConnection(a_Config.getConnect(), a_Config.getUser(), a_Config.getPassword());
        } catch (Exception e) {
            Sql.exception("Connection failed.\r\nDriver:" + a_Config.getDriver()
                    + "\r\nConnectString:" + a_Config.getConnect() + "\r\nException:"
                    + e.getMessage());
            return  null;
        }
    }

    /**
     * @param a_statement
     */
    static void createMap (Statement a_statement) {
        SqlCreateTable create = new SqlCreateTable();
        create.setTable(MAP);
        create.addField(FROM_ID, INTEGER);
        create.addField(TO_ID, INTEGER);
        try {
            a_statement.execute(create.statement());
        } catch (Exception e) {
            log("Creation of table " + MAP + " failed. Probably present.");
        }
    }

    public static Statement createStatement (Connection c) {
        try {
            return  c.createStatement();
        } catch (Exception e) {
            Sql.exception("SqlCalls.createStatement Could not create Statement for passed connection");
            return  null;
        }
    }

    /**
     * @param a_log
     */
    static void error (String a_log) {
        log(a_log);
    }

    static ResultSet executeQuery (Statement s, String a_select) {
        try {
            return  s.executeQuery(a_select);
        } catch (Exception e) {
            // String msg =
            throw  new RuntimeException("SqlCalls.executeQuery throws exception for statement:"
                    + a_select);
        }
    }

    static void exception (String a_log) {
        Sql.log(a_log);
        // throw new RuntimeException(a_log);
    }

    static void getFields (DatabaseMetaData a_meta, SqlTable a_table) {
        try {
            ResultSet rs = a_meta.getColumns(null, null, a_table.getName(),
                    null);
            while (rs.next()) {
                SqlField field = fieldForType(rs.getString(DATA_TYPE));
                if (field != null) {
                    field.setName(rs.getString(COLUMN_NAME));
                    a_table.addField(field);
                }
            }
        } catch (Exception e) {
            error("Exception attempting to get fields from database. Table:"
                    + a_table.getName());
            error(e.getMessage());
        }
    }

    static Collection getTables (Connection a_connection, boolean a_getFields) {
        Collection col = new Collection();
        try {
            DatabaseMetaData meta = a_connection.getMetaData();
            String[] types =  {
                "TABLE"
            };
            ResultSet rs = meta.getTables(null, null, null, types);
            int max = 0;
            while (rs.next()) {
                if (Sql.debug && Sql.limitTables) {
                    max++;
                    if (max > 3) {
                        break;
                    }
                }
                SqlTable table = new SqlTable();
                table.setName(rs.getString(TABLE_NAME));
                Sql.log("Analyzing table: " + table.getName());
                if (a_getFields) {
                    getFields(meta, table);
                }
                col.add(table);
            }
        } catch (Exception e) {
            error("Exception attempting to get table names from database.");
            error(e.getMessage());
        }
        return  col;
    }

    static boolean hasPublicConstructor (Class a_Class) {
		try{
			Object o = a_Class.newInstance();
			if(o != null){
				return true;
			}
		}
		catch(Exception e){
		}
		return false;
    }

    static void log (String a_log) {
        msg(a_log);
    }

    public static void msg (String a_msg) {
        System.out.println(a_msg);
    }
}

