package com.db4o.sql;

import com.db4o.*;
import com.db4o.jgen.*;
import java.lang.reflect.*;
import java.sql.*;

abstract class SqlField
{
	private static Class[] i_SupportedClasses = {
		SqlFieldString.class,
		SqlFieldInteger.class,
		SqlFieldLong.class,
		SqlFieldBoolean.class,
		SqlFieldByte.class,
		SqlFieldChar.class,
		SqlFieldDouble.class,
		SqlFieldFloat.class,
		SqlFieldShort.class,
	};
	
	private static Class[] i_JavaClasses;
	private static Class[] i_WrapperClasses;
	private static int[] i_mapJavaToSupported;
	
	private static boolean i_initialized = initialize();
		
	protected String i_name;
	protected int i_column;
	protected Field i_field;

	String fieldCreate(Statement a_statement){
		return fieldCreate();
	}

	abstract String fieldCreate();
	
	String getName(){
		return i_name;
	}
	
	abstract Class getJavaClass();
	
	abstract Class getWrapperClass();
	
	private static boolean initialize(){
		i_JavaClasses = new Class[i_SupportedClasses.length];
		i_WrapperClasses = new Class[i_SupportedClasses.length];
		try{
			for(int i = 0; i < i_SupportedClasses.length; i ++){
				SqlField l_Field = (SqlField)i_SupportedClasses[i].newInstance();
				i_JavaClasses[i] = l_Field.getJavaClass();
				i_WrapperClasses[i] = l_Field.getWrapperClass();
			}
			return true;
		}
		catch(Exception e){
			throw new RuntimeException("SqlField.initialize failed");
		}
	}
	
	void insert(ObjectContainer a_container, Object a_onObject, SqlInsert a_insert, Statement a_statement){
		try{
			Object a_Object = i_field.get(a_onObject);		
			if(a_Object != null){
				insert1(a_container, a_onObject, a_Object, a_insert,a_statement);
			}
		}
		catch (Exception e){}
		
	}
	
	void insert1(ObjectContainer a_container, Object a_onObject, Object a_Object, SqlInsert a_insert, Statement a_statement){
		insert1(a_container, a_Object, a_insert);
	}
	
	void insert1(ObjectContainer a_container, Object a_Object, SqlInsert a_insert){
		a_insert.addField(i_name, a_Object.toString());
	}
	
	void instantiateOn(ObjectContainer a_db, Object a_onObject, long a_fromID, ResultSet a_rs, Connection a_con){
		// Version for SqlReImport
		try{
			Object object = instantiate(a_db, a_onObject, a_fromID, a_rs, a_con);
			if(object != null){
				i_field.set(a_onObject,object);	
			}
		}
		catch(Exception e){
			Sql.log("SqlField.instantiateOn failed");
			Sql.log(e.getMessage());
		}
	}
	
	void instantiateOn(Object a_onObject, ResultSet a_rs){
		// Version for SqlImport
		try{
			
			Object object = instantiate(a_rs);
			if (object != null){
				i_field.set(a_onObject,object);
			}
		}
		catch (Exception e){
			Sql.log("SqlField.instantiateOn failed");
			Sql.log(e.getMessage());
		}
	}
	
	Object instantiate(ObjectContainer a_db, Object a_onObject, long a_fromID, ResultSet a_rs, Connection a_con) throws Exception{
		return instantiate(a_rs);
	}
	
	abstract Object instantiate(ResultSet a_rs) throws Exception;
																	
	
	JField jfield(){
		Class l_class = getJavaClass();
		if (l_class != null){
			String className = l_class.getName();
			String javaLang = "java.lang.";
			if(className.indexOf(javaLang) == 0){
				className = className.substring(javaLang.length());
			}
			return new JField(className, getName());	
		}
		return null;
	}
	
	static SqlField make(SqlTable a_Table, Field a_Field){
		Class l_Class = a_Field.getType();
		SqlField l_NewField = make(l_Class);
		if(l_NewField != null){
			l_NewField.setField(a_Field);
			if (! l_NewField.onCreate(a_Table, l_Class)){
				l_NewField = null;	
			}
		}
		return l_NewField;
	}
	
	static SqlField make (Class a_Class){
		for (int i = 0;i < i_JavaClasses.length; i++){
			if (a_Class.equals(i_JavaClasses[i]) || a_Class.equals(i_WrapperClasses[i])){
				try{
					return (SqlField)i_SupportedClasses[i].newInstance();
				}
				catch (Exception e){
					throw new RuntimeException("SqlField.make newInstance failed");	
				}
			}
		}
		
		if (a_Class.isArray()){
			return new SqlFieldArray();	
		}
		
		if (Sql.hasPublicConstructor(a_Class)){
			return new SqlFieldObject();
		}
		
		return null;
	}
	
	boolean onCreate(SqlTable a_Table, Class a_Class){
		return true;
	}
	
	String select(){
		return getName();
	}
	
	void setColumn(int a_column){
		i_column = a_column;
	}
	
	void setField(Field a_Field){
		i_field = a_Field;
		i_name = a_Field.getName();
	}
	
	public void setName(String a_name){
		i_name = a_name;
	}
}
