package com.db4o.sql;

import com.db4o.lib.*;

abstract class SqlStatement
{
	protected String i_table;
	protected Collection i_fields;
	private int i_column = 0;
	private String i_where;
	private String i_orderBy;
	
	public SqlStatement(){
		i_fields = new Collection();
	}
	
	int addField(String a_field){
		if(a_field != null){
			i_fields.add(a_field);
			return ++i_column;
		}
		return 0;
	}
	
	protected abstract String createStatement();
	
	protected String fieldStatement(){
		Object[] fields = i_fields.toArray();
		String sql = " " + (String)fields[0];
		for (int i = 1; i < fields.length; i ++){
			sql = sql + ", " + (String)fields[i];
		}
		return sql;
	}
	
	public String getName(){
		return i_table;
	}
	
	void setTable(String a_table){
		i_table = a_table;
	}
	
	void setWhere(String a_column, long a_value){
		i_where = a_column + " = " + new Long(a_value).toString();
	}
	
	void setOrderBy(String a_orderBy){
		i_orderBy = a_orderBy;
	}
	
	String statement(){
		String sql = createStatement();
		if(i_where != null){
			sql = sql + " where " + i_where;
		}
		if(i_orderBy != null){
			sql = sql + " order by " + i_orderBy;
		}
		return sql;
	}
}
