//*****************************************************************
// 
//  JAVA Source for com.idautomation.linear 2.1
//  
//  Copyright, IDAutomation.com, Inc. 2000. All rights reserved.
//  
//  http://www.IDAutomation.com/
//  
//  NOTICE:
//  You may incorporate our Source Code in your application
//  only if you own a valid Java Barcode Package License
//  from IDAutomation.com, Inc. and the copyright notices 
//  are not removed from the source code.
//  
//  NOTE: "BarCode" is the class of the linear barcode encoder
//  For other class symbologies such as PDF417, replace all text of "BarCode"
//  with "PDF417".
//
//*****************************************************************

import java.io.*;
import com.idautomation.linear.*;
import com.idautomation.linear.encoder.*;

class CreateJPEG
{
    public static void main ( String [] args )
    {

      //Get the data to encode in barcode
      String message = null;
      BufferedReader in = new BufferedReader( new InputStreamReader( System.in ), 1 );
      System.out.print( "Enter data to encode: " );

      try
      {  message = in.readLine();
         if ( message == null )
            return;  // All done on EOF, so just exit.
      }
      catch ( IOException e )
      {  System.out.println( "\n\n*** Exception caught: " + e );
         return;
      }

      //NOTE: "BarCode" is the class of the linear barcode encoder

      BarCode bc=new BarCode();

      // set the data to encode
      bc.code=message;

      // select the barcode symbology
      bc.barType=bc.CODE128;

      // set the size
      bc.setSize(400,200);

      // create the file as the name of the message
      barCodeEncoder bce = new barCodeEncoder(bc, "JPEG", message + ".jpeg");

    }


}
