package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import com.jconfig.*;

/**
A very basic ImageViewerI implementation.

This class is a Panel, and displays GIFs or JPEGs in itself.

@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

class SImageViewer extends Panel implements ImageViewerI, WindowOwner {
	private ImageViewerOwner	owner;
	private FileSpecifier		theSpec;
	private OwnedFrame			theFrame;
	private File				theFile;
	private Image				theImage;

	public SImageViewer( OwnedFrame oldFrame, ImageViewerOwner onr,
							FileSpecifier spec, Rectangle rect ) {
		DiskObject			diskObj;

		owner = onr;
		theSpec = spec;

		theFile = theSpec.getFile();
		diskObj = theSpec.getDiskObject();

		if ( theFile == null && diskObj != null )
			theFile = diskObj.getFile();

		if ( theFile == null )
			throw new IllegalArgumentException( "can't get file from " + spec );

		if ( !theFile.exists() || theFile.isDirectory() )
			throw new IllegalArgumentException( "the file doesn't exist or is a directory " + theFile.getPath() );

		theImage = Toolkit.getDefaultToolkit().getImage( theFile.getPath() );

		if ( oldFrame == null ) {
			theFrame = new OwnedFrame( this );
			theFrame.reshape( rect.x, rect.y, rect.width, rect.height );
		}
		else {
			theFrame = oldFrame;
			theFrame.setWindowOwner( this );
			theFrame.removeAll();
		}
		
		theFrame.setLayout( new BorderLayout() );
		theFrame.add( "Center", this );

		if ( diskObj != null )
			theFrame.setTitle( diskObj.getDisplayName() );
		else
			theFrame.setTitle( theFile.getName() );
	}

	public FileSpecifier getFileSpecifier() {
		return theSpec;
	}

	public OwnedFrame getFrame() {
		return theFrame;
	}

	public void setVisible( boolean bState ) {
		if ( bState )
			theFrame.show();
		else
			theFrame.hide();
	}

	public void paint( Graphics g ) {
		Dimension		dd;
		
		dd = size();
		g.setColor( Color.red );
		g.fillRect( 0, 0, dd.width, dd.height );
		g.drawImage( theImage, 0, 0, this );
	}

	public void closeWindow( Window w ) {
		if ( w == theFrame )
			owner.closeImageViewer( this );
	}
}
