/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#include "comdefs.h"
#include "jmacros.h"
#include "stub_macros.h"
#include "ResFile.h"
#include <string.h>
#include "SResFile.h"
#include "CFSpec.h"
#include "Debugger.h"

#pragma export on

SFUNC( JINT, ResFileMRJ_nOpenExistingResFile ),
JINT vRef,
JINT parID, 
JBYTEARRAY pName )
{
	ErrCode		theErr;
	short		fileFD;
	DECLARECFSPEC( theSpec );
	
	UNUSED( pObj );
	
	BEGINTRY {
		CHECKNULL( pName );

		MAKECFSPEC( theSpec, vRef, parID, pName );
		
		fileFD = SResFile::openExistingResFile( theSpec );
	
	bail:
		
		DELETECFSPEC( theSpec );
	
	} ENDTRY

	return fileFD;
}

	//	private static native void nativeCloseResFile( int fileFD );

SFUNC( void, ResFileMRJ_nCloseResFile ),
JINT fileFD )
{
	UNUSED( pObj );
	UNUSED( pEnv );
	
	SResFile::closeResFile( fileFD );
}

	//	native int nativeGetResourceSize( int fileFD, int resName, int resID, int pSize[] );

SFUNC( JINT, ResFileMRJ_nGetResourceSize ),
JINT fileFD, 
JINT resName, 
JINT resID,
JINTARRAY pSize )
{
	ErrCode		theErr;
	long		resSize;

	UNUSED( pObj );
	
	BEGINTRY {
		CHECKSIZE( pSize, 1 );

		if ( fileFD < 1 ) {
			Debugger::debug( __LINE__, "jriGetResourceSize, bad fileFD", NULL, NULL, fileFD, 0 );
			theErr = paramErr;
			goto bail;
		}

		theErr = SResFile::getResourceSize( fileFD, resName, resID, &resSize );
		BAILERR( theErr );

		SETJINT1( pSize, resSize );
		
	bail:
		;
	
	} ENDTRY

	return theErr;
}

	//	native int nativeGetResource( int fileFD, int resName, int resID, byte pData[] );

SFUNC( JINT, ResFileMRJ_nGetResource ),
JINT fileFD, 
JINT resName, 
JINT resID,
JBYTEARRAY pRetData )
{
	char			*retDataP;
	ErrCode			theErr;
	long			retDataLen;

	UNUSED( pObj );
	
	BEGINTRY {
		CHECKNULL( pRetData );
		if ( fileFD < 1 ) {
			Debugger::debug( __LINE__, "jriGetResource, bad fileFD", NULL, NULL, fileFD, 0 );
			theErr = paramErr;
			goto bail;
		}

		retDataLen = GETBYTEARRAYLEN( pRetData );
		retDataP = (char*) LOCKBYTEARRAY( pRetData );

		theErr = SResFile::getResource( fileFD, resName, resID, retDataLen, (char*) retDataP );
		
		UNLOCKBYTEARRAY( pRetData, retDataP );
	
	bail:
		;
		
	} ENDTRY

	return theErr;
}

#pragma export off

