package com.tolstoy.imagemeister;

/**
Interface for the object which owns a BrowserDisplay object.
Currently, this is the Browser object.

The methods of this interface are called when a button or file/folder on the ImageMeister display is clicked, when
a key is pressed, or when the user closes the Frame containing the BrowserDisplay.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

interface BrowserDisplayOwnerI {
	static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	static final int		kButtonQuit = 0;
	static final int		kButtonAbout = 1;
	static final int		kButtonInfo = 2;
	static final int		kButtonShow = 3;
	static final int		kButtonUpALevel = 4;
	static final int		kCheckboxShowAllFiles = 5;
	static final int		kCheckboxNewWindow = 6;

	void browserButtonClicked( int which );
	void browserItemClicked( int which );
	void browserCloseButtonClicked();
	boolean browserKeyPressed( int which, int key );
}

