package com.tolstoy.imagemeister;

import java.awt.*;

/**
The GridScrollerPanel class is used to display the grid of file/folder icons.

When creating that class, you pass it an object which implements the GSPCallback interface.

The GridScrollerPanel class will call the paintItem() method to draw the individual icons which make up the grid.
It will call the itemDoubleClicked() method when an item is double-clicked,
and the handleKeyPress() method when a key is pressed.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

interface GSPCallback {
	static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	void itemDoubleClicked( int which );
	void paintItem( Graphics g, int which, int x, int y, int w, int h, boolean bSelected );
	boolean handleKeyPress( Event e, int curChic );
}

