package com.tolstoy.imagemeister;

import java.awt.*;

/**
A Frame which is owned by a class which implements the WindowOwner interface. These are the
Frames in which files are viewed, and which are passed to, for instance, a plugin's
'createImageViewer()' method.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

public class OwnedFrame extends Frame {
	private WindowOwner			owner;

/**
Create with the owner of the Frame.
*/
	
	public OwnedFrame( WindowOwner onr ) {
		owner = onr;
	}

/**
Create with the owner of the Frame, and the title of the Frame.
*/
	
	public OwnedFrame( WindowOwner onr, String title ) {
		super( title );
		owner = onr;
	}

/**
Set the owner of this Frame, which will have its 'closeWindow()' method called when the
user clicks in the close box of this Frame.
*/

	public void setWindowOwner( WindowOwner onr ) {
		owner = onr;
	}

	public boolean handleEvent( Event ev ) {
		if ( owner != null ) {
			if ( ev.id == Event.WINDOW_DESTROY ) {
				owner.closeWindow( this );
				return true;
			}
		}

		return false;
	}
}
