package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
To add new plugins to ImageMeister, you must create a zip file containing the classes needed
by your plugin, and place the zip file containing the classes in ImageMeister's 'plugins'
directory. One of the classes in the zip file must be named 'IMPluginFactory', and it must
implement the following interface.
<P>
ImageMeister will create an instance of your 'IMPluginFactory' class, and call its methods
to load your plugin(s).
<P>
When the registerPlugins() method of your 'IMPluginFactory' class is called, your class
can then call the PluginManager.addPlugin() method to add its plugin(s). 

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

public interface PluginFactoryI {
	static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

/**
Return the greatest interface version which this class knows about.
*/

	int getInterfaceVersion();

/**
This method will be called to allow your class to register its plugin(s). This method should
return the number of plugins successfully registered.
@param interfaceVersion the interface version currently supported
*/

	int registerPlugins( int interfaceVersion );

/**
Return an object implementing the PluginWatcherI interface, which will be called when each plugin
is loaded. May return null. See that interface for more information.
*/

	PluginWatcherI getPluginWatcher();
}
