package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
This interface is used to represent plugins. Objects which implement this interface are used
to create instances of image and info viewers, indicate which file types this plugin supports,
and return other information on the plugin.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

public interface PluginI {
	static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

/**
See the getName() method.
*/

	static final int			kDisplayName = 0;

/**
See the getName() method.
*/

	static final int			kMacStyleName = 1;

/**
See the getName() method.
*/

	static final int			kWinStyleName = 2;

/**
Return an array of FinderInfo objects, representing the Mac file types this plugin supports. May
return null.
*/

	FinderInfo[] getFinderInfo();

/**
Return an array of FileExtension objects, representing the non-Mac file types this plugin
supports. May return null.
*/

	FileExtension[] getFileExtension();

/**
Return an array of MIMEType objects, representing the MIME types this plugin
supports. May return null.
*/

	MIMEType[] getMIMEType();

/**
Given a FileSpecifier representing a file, return a boolean value indicating whether this plugin
can create an image viewer for that file. Note that any object contained by the FileSpecifier
may be null, with the exception that not both the DiskObject and the File contained by the
FileSpecifier will be null.
*/

	boolean canCreateImageViewer( FileSpecifier spec );

/**
Given a FileSpecifier representing a file, return a boolean value indicating whether this plugin
can create an info viewer for that file. Note that any object contained by the FileSpecifier
may be null, with the exception that not both the DiskObject and the File contained by the
FileSpecifier will be null.
*/

	boolean canCreateInfoViewer( FileSpecifier spec );

/**
Given a FileSpecifier representing a file, create an image viewer for that file. This method may
return null if the image viewer could not be created.
Note that any object contained by the FileSpecifier may be null, with the exception that
not both the DiskObject and the File contained by the FileSpecifier will be null.
@param frame if this is not null, show the file in this frame. Otherwise, create a new OwnedFrame,
and show the file in the new frame.
@param onr the object which owns this viewer
@param spec specifies the file to be shown
@param rect the suggested location and dimensions of the viewer. If the frame argument is null,
the WindowManager should be used to correctly place the new frame. Otherwise, the current
location and dimensions of the supplied frame should be used.
*/

	ImageViewerI createImageViewer( OwnedFrame frame, ImageViewerOwner onr, FileSpecifier spec, Rectangle rect );

/**
Given a FileSpecifier representing a file, create an info viewer for that file. This method may
return null if the info viewer could not be created.
Note that any object contained by the FileSpecifier may be null, with the exception that
not both the DiskObject and the File contained by the FileSpecifier will be null.
@param frame if this is not null, show the file in this frame. Otherwise, create a new OwnedFrame,
and show the file in the new frame.
@param onr the object which owns this viewer
@param spec specifies the file to be shown
@param rect the suggested location and dimensions of the viewer. If the frame argument is null,
the WindowManager should be used to correctly place the new frame. Otherwise, the current
location and dimensions of the supplied frame should be used.
*/

	InfoViewerI createInfoViewer( OwnedFrame frame, InfoViewerOwner onr, FileSpecifier spec, Rectangle rect );

/**
Return version information about this plugin. May return null.
*/

	VersionInfo getVersionInfo();

/**
Return the name of this plugin.
@param which if this is 'kDisplayName', return the generic name of this plugin. If this is
'kMacStyleName', return the Mac-style name, and if this is 'kWinStyleName', return the
Windows-style name. If 'which' is not one of these values, return null.
*/

	String getName( int which );

/**
For a hierarchy of plugins, return the parent of this plugin. May return null.
*/

	PluginI getParent();

/**
For a hierarchy of plugins, return an array of this plugin's child plugins. May return null.
*/

	PluginI[] getChildren();
	
/**
Return an IconPanel which shows the icon representing this plugin. May return null.
*/

	IconPanel getIconPanel();
}

