/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jdbees.JBeesAuthPanel;
import jdbees.JBeesConfirmPanel;
import jdbees.JBeesDateTimePanel;
import jdbees.JBeesMainFrame;
import jdbees.JBeesScheduleInfo;
import jdbees.JBeesURLPanel;

public class JBeesScheduleDlg
extends JDialog {
    private JBeesScheduleInfo jbsi;
    private JBeesURLPanel jurlp;
    private JBeesAuthPanel jap;
    private JBeesDateTimePanel jdtp;
    private JBeesConfirmPanel jcp;
    private JBeesMainFrame frame;

    public JBeesScheduleDlg(JBeesMainFrame frame, String title, JBeesScheduleInfo jbsi) {
        super((Frame)frame, true);
        this.setTitle(title);
        this.jbsi = jbsi;
        this.frame = frame;
        this.jurlp = new JBeesURLPanel(frame);
        this.jap = new JBeesAuthPanel();
        this.jdtp = new JBeesDateTimePanel();
        this.jcp = new JBeesConfirmPanel(this);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.jurlp);
        p.add(this.jdtp);
        p.add(this.jap);
        p.add(this.jcp);
        this.getContentPane().add((Component)p, "Center");
        this.addWindowListener(new 1());
        if (jbsi.getURL() != null) {
            this.jurlp.setURLText(jbsi.getURL());
            this.jurlp.setFileName(jbsi.getLocalFileName());
            if (jbsi.getUser() != null) {
                this.jap.setOn(true);
                this.jap.setUserText(jbsi.getUser());
                this.jap.setPasswdText(jbsi.getPasswd());
            }
            this.jdtp.setDateTime(jbsi.getDate());
        } else {
            this.doClip();
        }
    }

    private void doClip() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable ts = cb.getContents(this);
        if (ts != null && ts.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String urlstr = (String)ts.getTransferData(DataFlavor.stringFlavor);
                URL url = new URL(urlstr);
                this.jurlp.setURLText(urlstr);
                if (!urlstr.endsWith("/")) {
                    this.jurlp.setFileName(urlstr.substring(1 + urlstr.lastIndexOf("/")));
                }
            }
            catch (Exception exception) {}
        }
    }

    public JBeesScheduleDlg(JBeesMainFrame frame, String title, JBeesScheduleInfo jbsi, String url) {
        this(frame, title, jbsi);
        this.jurlp.setURLText(url);
        if (!url.endsWith("/")) {
            this.jurlp.setFileName(url.substring(1 + url.lastIndexOf("/")));
        }
    }

    public void showDlg() {
        this.setResizable(false);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d1 = this.getSize();
        ((Component)this).setLocation((d.width - d1.width) / 2, (d.height - d1.height) / 2);
        ((Component)this).setVisible(true);
    }

    public void doOK() {
        try {
            URL url = new URL(this.jurlp.getURLText());
            if (this.frame.urlExist(url.toString().trim().toLowerCase())) {
                throw new MalformedURLException("URL existed");
            }
            if (url.getHost() == null) {
                throw new MalformedURLException("Host must not be null");
            }
            if (url.getPort() < -1) {
                throw new MalformedURLException("Port incorrect");
            }
            if (!url.getProtocol().trim().equalsIgnoreCase("http") && !url.getProtocol().trim().equalsIgnoreCase("ftp")) {
                throw new MalformedURLException("Protocol not supported");
            }
            if (url.getPath() == null || url.getPath().length() == 0 || url.getPath().endsWith("/")) {
                throw new MalformedURLException("Must specify file name in URL");
            }
            if (this.jurlp.getFileName() == null || this.jurlp.getFileName().length() == 0) {
                throw new IOException("File name must be specified");
            }
            try {
                File dir;
                File f = new File(this.jurlp.getFileName());
                if (f.getParent() != null && !(dir = new File(f.getParent())).exists()) {
                    dir.mkdirs();
                }
                if (f.exists()) {
                    if (JOptionPane.showConfirmDialog(null, "File exist, override it?", "Confirm", 0) == 1) {
                        throw new IOException();
                    }
                } else {
                    f.createNewFile();
                }
                f.delete();
            }
            catch (IOException iOException) {
                throw new IOException("Bad file name");
            }
            String dateStr = String.valueOf(this.jdtp.getDay()) + "-" + this.jdtp.getMonth() + "-" + this.jdtp.getYear() + " " + this.jdtp.getHour() + ":" + this.jdtp.getMinute() + ":00" + " " + this.jdtp.getAMPM();
            DateFormat df = DateFormat.getDateTimeInstance();
            df.setLenient(false);
            df.parse(dateStr);
            if (this.jap.getOn()) {
                if (this.jap.getUserText().length() == 0 || this.jap.getPasswdText().length() == 0) {
                    throw new IOException("User and password must be specified");
                }
                this.jbsi.setUser(this.jap.getUserText());
                this.jbsi.setPasswd(this.jap.getPasswdText());
            }
            this.jbsi.setURL(this.jurlp.getURLText());
            this.jbsi.setLocalFileName(this.jurlp.getFileName());
            this.jbsi.setDate(dateStr);
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this.frame, "Bad URL! " + e.getMessage(), "Error", 0);
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this.frame, "Bad time" + e.getMessage(), "Error", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
        }
    }

    public void doCancel() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            ((Component)JBeesScheduleDlg.this).setVisible(false);
            JBeesScheduleDlg.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

