/*
 * Decompiled with CFR 0.152.
 */
package jdbees.ftpbatch.controller;

import java.net.URL;
import java.util.Vector;
import jdbees.JBeesConfInfo;
import jdbees.ftp.JBeesFtpControlChannel;

public class JBeesFTPBatchController {
    private boolean debug = false;
    private String host;
    private String user;
    private String passwd;
    private int port;
    private JBeesFtpControlChannel fcc;
    private JBeesConfInfo jbconf;
    private Vector files;
    private Vector dirs;

    public JBeesFTPBatchController(String host, int port, String user, String passwd, JBeesConfInfo jbconf) throws Exception {
        this.host = host;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.jbconf = jbconf;
        this.initFtpControlChannel();
    }

    public void initFtpControlChannel() throws Exception {
        String urlStr = "ftp://" + this.host + ":" + this.port;
        if (this.debug) {
            System.out.println(urlStr);
        }
        URL url = new URL(urlStr);
        this.fcc = this.user == null ? new JBeesFtpControlChannel(url, this.jbconf) : new JBeesFtpControlChannel(url, this.jbconf, this.user, this.passwd);
        this.fcc.authenticate();
        this.fcc.setCharType();
    }

    public void getStatus(String path) throws Exception {
        this.files = null;
        this.dirs = null;
        this.fcc.isPasvSupported();
        this.fcc.getFilesDirs(path);
        this.files = this.fcc.getFiles();
        this.dirs = this.fcc.getDirs();
        if (this.debug) {
            System.out.println("correctly exit getStatus()");
        }
    }

    public Vector getFiles() {
        return this.files;
    }

    public Vector getDirs() {
        return this.dirs;
    }

    public void close() throws Exception {
        this.fcc.close();
    }
}

