/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jdbees.JBeesAddOption;
import jdbees.JBeesAuthPanel;
import jdbees.JBeesConfirmPanel;
import jdbees.JBeesMainFrame;
import jdbees.JBeesQueueInfo;
import jdbees.JBeesURLPanel;

public class JBeesAddDlg
extends JDialog {
    private JBeesURLPanel jurlp;
    private JBeesAuthPanel jap;
    private JBeesConfirmPanel jcp;
    private JBeesMainFrame frame;
    private JBeesAddOption jbaop;

    JBeesAddDlg(JBeesMainFrame frame, JBeesAddOption jbaop, String title, JBeesQueueInfo jbqinfo) {
        this(frame, jbaop, title);
        this.jurlp.setURLText(jbqinfo.getURL());
        this.jurlp.setFileName(jbqinfo.getLocalFileName());
        if (jbqinfo.getUser() != null) {
            this.jap.setOn(true);
            this.jap.setUserText(jbqinfo.getUser());
            this.jap.setPasswdText(jbqinfo.getPasswd());
        }
    }

    public JBeesAddDlg(JBeesMainFrame frame, JBeesAddOption jbaop, String title, String url) {
        this(frame, jbaop, title);
        this.jurlp.setURLText(url);
        if (!url.endsWith("/")) {
            this.jurlp.setFileName(url.substring(1 + url.lastIndexOf("/")));
        }
    }

    public JBeesAddDlg(JBeesMainFrame frame, JBeesAddOption jbaop, String title) {
        super((Frame)frame, true);
        this.frame = frame;
        this.jbaop = jbaop;
        this.setTitle(title);
        this.jurlp = new JBeesURLPanel(frame);
        this.jap = new JBeesAuthPanel();
        this.jcp = new JBeesConfirmPanel(this);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.jurlp);
        p.add(this.jap);
        p.add(this.jcp);
        this.getContentPane().add((Component)p, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                JBeesAddDlg.this.setVisible(false);
                JBeesAddDlg.this.dispose();
            }
        });
        this.doClip();
    }

    private void doClip() {
        Clipboard cb;
        Transferable ts;
        if (!this.jbaop.isEditing() && (ts = (cb = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(this)) != null && ts.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String urlstr = (String)ts.getTransferData(DataFlavor.stringFlavor);
                URL url = new URL(urlstr);
                this.jurlp.setURLText(urlstr);
                if (!urlstr.endsWith("/")) {
                    this.jurlp.setFileName(urlstr.substring(1 + urlstr.lastIndexOf("/")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doOK() {
        try {
            URL url = new URL(this.jurlp.getURLText());
            if (this.frame.urlExist(url.toString().trim().toLowerCase())) {
                throw new MalformedURLException("URL existed");
            }
            if (url.getHost() == null) {
                throw new MalformedURLException("Host must not be null");
            }
            if (url.getPort() < -1) {
                throw new MalformedURLException("Port incorrect");
            }
            if (!url.getProtocol().trim().equalsIgnoreCase("http") && !url.getProtocol().trim().equalsIgnoreCase("ftp")) {
                throw new MalformedURLException("Protocol not supported");
            }
            if (url.getPath() == null || url.getPath().length() == 0 || url.getPath().endsWith("/")) {
                throw new MalformedURLException("Must specify file name in URL");
            }
            if (this.jurlp.getFileName() == null || this.jurlp.getFileName().length() == 0) {
                throw new IOException("File name must be specified");
            }
            try {
                File dir;
                File f = new File(this.jurlp.getFileName());
                if (f.getParent() != null && !(dir = new File(f.getParent())).exists()) {
                    dir.mkdirs();
                }
                if (f.exists()) {
                    if (JOptionPane.showConfirmDialog(null, "File exist, override it?", "Confirm", 0) == 1) {
                        throw new IOException();
                    }
                } else {
                    f.createNewFile();
                }
                f.delete();
            }
            catch (IOException e) {
                throw new IOException("Bad file name");
            }
            if (this.jap.getOn()) {
                if (this.jap.getUserText().length() == 0 || this.jap.getPasswdText().length() == 0) {
                    throw new IOException("User and password must be specified");
                }
                this.jbaop.setJBeesQueueInfo(this.jurlp.getURLText(), this.jurlp.getFileName(), this.jap.getUserText(), this.jap.getPasswdText());
            }
            this.jbaop.setJBeesQueueInfo(this.jurlp.getURLText(), this.jurlp.getFileName());
            this.jbaop.setWhatPushed(0);
            this.setVisible(false);
            this.dispose();
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this.frame, "Bad URL! " + e.getMessage(), "Error", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
        }
    }

    public void doCancel() {
        this.jbaop.setWhatPushed(1);
        this.setVisible(false);
        this.dispose();
    }
}

