/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import jdbees.JBeesConfInfo;
import jdbees.JBeesDownloadedFileInfo;
import jdbees.JBeesQueueInfo;
import jdbees.JBeesResumeFileInfo;
import jdbees.JBeesScheduleInfo;

public class JBeesInit {
    private String confFileName;
    private String resumeLogFileName;
    private String queueLogFileName;
    private String downloadedLogFileName;
    private String scheduleLogFileName;

    public JBeesInit() {
        String confDir = System.getProperty("JDBeesConfDir");
        String separator = System.getProperty("file.separator");
        if (confDir == null || confDir.length() == 0) {
            confDir = "." + separator;
        }
        this.confFileName = confDir + (confDir.endsWith(separator) ? "" : separator) + "jbees.conf";
        this.resumeLogFileName = confDir + (confDir.endsWith(separator) ? "" : separator) + "jbresume.log";
        this.queueLogFileName = confDir + (confDir.endsWith(separator) ? "" : separator) + "jbqueue.log";
        this.downloadedLogFileName = confDir + (confDir.endsWith(separator) ? "" : separator) + "jbdownloaded.log";
        this.scheduleLogFileName = confDir + (confDir.endsWith(separator) ? "" : separator) + "jbschedule.log";
    }

    public JBeesConfInfo getConfInfo() {
        if (this.fileExist(this.confFileName)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.confFileName));
                JBeesConfInfo jci = (JBeesConfInfo)ois.readObject();
                ois.close();
                return jci;
            }
            catch (Exception e) {
                return new JBeesConfInfo();
            }
        }
        return new JBeesConfInfo();
    }

    public Vector getResumeInfo() {
        if (this.fileExist(this.resumeLogFileName)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.resumeLogFileName));
                int size = ois.readInt();
                if (size > 0) {
                    Vector<JBeesResumeFileInfo> v = new Vector<JBeesResumeFileInfo>();
                    int i = 0;
                    while (i < size) {
                        JBeesResumeFileInfo jbrfi = (JBeesResumeFileInfo)ois.readObject();
                        v.add(jbrfi);
                        ++i;
                    }
                    ois.close();
                    return v;
                }
                ois.close();
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Vector getScheduleInfo() {
        if (this.fileExist(this.scheduleLogFileName)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.scheduleLogFileName));
                int size = ois.readInt();
                if (size > 0) {
                    Vector<JBeesScheduleInfo> v = new Vector<JBeesScheduleInfo>();
                    int i = 0;
                    while (i < size) {
                        JBeesScheduleInfo jbsi = (JBeesScheduleInfo)ois.readObject();
                        v.add(jbsi);
                        ++i;
                    }
                    ois.close();
                    return v;
                }
                ois.close();
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Vector getQueueInfo() {
        if (this.fileExist(this.queueLogFileName)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.queueLogFileName));
                int size = ois.readInt();
                if (size > 0) {
                    Vector<JBeesQueueInfo> v = new Vector<JBeesQueueInfo>();
                    int i = 0;
                    while (i < size) {
                        JBeesQueueInfo jbrfi = (JBeesQueueInfo)ois.readObject();
                        v.add(jbrfi);
                        ++i;
                    }
                    ois.close();
                    return v;
                }
                ois.close();
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Vector getDownloadedInfo() {
        if (this.fileExist(this.downloadedLogFileName)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.downloadedLogFileName));
                int size = ois.readInt();
                if (size > 0) {
                    Vector<JBeesDownloadedFileInfo> v = new Vector<JBeesDownloadedFileInfo>();
                    int i = 0;
                    while (i < size) {
                        JBeesDownloadedFileInfo jbrfi = (JBeesDownloadedFileInfo)ois.readObject();
                        v.add(jbrfi);
                        ++i;
                    }
                    ois.close();
                    return v;
                }
                ois.close();
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void setConfInfo(JBeesConfInfo jci) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.confFileName));
            oos.writeObject(jci);
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setResumeInfo(Vector v) {
        this.writeLog(v, this.resumeLogFileName);
    }

    public void setQueueInfo(Vector v) {
        this.writeLog(v, this.queueLogFileName);
    }

    public void setDownloadedInfo(Vector v) {
        this.writeLog(v, this.downloadedLogFileName);
    }

    public void setScheduleInfo(Vector v) {
        this.writeLog(v, this.scheduleLogFileName);
    }

    private void writeLog(Vector v, String logfile) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(logfile));
            oos.writeInt(v.size());
            int i = 0;
            while (i < v.size()) {
                oos.writeObject(v.elementAt(i));
                ++i;
            }
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean fileExist(String name) {
        File f = new File(name);
        return f.exists();
    }
}

