/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.util;

import com.jniwrapper.Function;
import com.jniwrapper.Library;
import com.jniwrapper.util.SoftCache;

public class FunctionCache {
    private SoftCache _cache = new SoftCache();
    private String _libraryName;
    private Library _library;

    public FunctionCache(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Library name must not be be emtpy or null.");
        }
        this._libraryName = string;
    }

    public FunctionCache(Library library) {
        if (library == null) {
            throw new NullPointerException();
        }
        this._library = library;
        this._libraryName = null;
    }

    private Library getLibrary() {
        if (this._library == null) {
            if (this._libraryName == null || this._libraryName.equals("")) {
                throw new IllegalStateException("Library name is not configured.");
            }
            this._library = new Library(this._libraryName);
        }
        return this._library;
    }

    public Function getFunction(String string) {
        Function function = (Function)this._cache.get(string);
        if (function != null) {
            return function;
        }
        function = this.getLibrary().getFunction(string);
        if (function != null) {
            this._cache.put(string, function);
        }
        return function;
    }
}

