/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.ui.User32;
import java.awt.image.BufferedImage;

public class Bitmap
extends GdiObject {
    private static final String FUNCTION_CREATE_BITMAP = "CreateBitmap";
    private static final String FUNCTION_CREATE_BITMAP_INDIRECT = "CreateBitmapIndirect";
    private static final String FUNCTION_CREATE_COMPATIBLE_BITMAP = "CreateCompatibleBitmap";
    private static final String FUNCTION_LOAD_BITMAP = "LoadBitmap";
    private static final String FUNCTION_GET_DIBITS = "GetDIBits";
    private static final String FUNCTION_CREATE_DIBITMAP = "CreateDIBitmap";
    public static final int DIB_RGB_COLORS = 0;
    public static final int DIB_PAL_COLORS = 1;
    public static final int CBM_INIT = 4;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;

    public Bitmap() {
    }

    public Bitmap(long value) {
        super(value);
    }

    public Bitmap(long width, long height, int planes, int bitsPerPel, UInt32[] colorData) {
        Function function = Gdi32.get(FUNCTION_CREATE_BITMAP);
        Parameter[] param = new Parameter[5];
        param[0] = new Int(width);
        param[1] = new Int(height);
        param[2] = new UInt((long)planes);
        param[3] = new UInt((long)bitsPerPel);
        if (colorData == null) {
            param[4] = new Handle();
        } else {
            ComplexArray arr = new ComplexArray((Parameter[])colorData);
            param[4] = new Pointer((Parameter)arr);
        }
        function.invoke((Parameter)this, param);
    }

    public Bitmap(long width, long height, long widthByte, long planes, long bitsPixel) {
        BitmapStructure bitmapStruct = new BitmapStructure(width, height, widthByte, planes, bitsPixel);
        Function function = Gdi32.get(FUNCTION_CREATE_BITMAP_INDIRECT);
        function.invoke((Parameter)this, (Parameter)new Pointer((Parameter)bitmapStruct));
    }

    public Bitmap(DC hDC, int width, int height) {
        Function function = Gdi32.get(FUNCTION_CREATE_COMPATIBLE_BITMAP);
        function.invoke((Parameter)this, (Parameter)hDC, (Parameter)new Int((long)width), (Parameter)new Int((long)height));
    }

    public Bitmap(PredefinedBitmap predefinedBitmap) {
        Function function = Gdi32.get(FUNCTION_LOAD_BITMAP);
        function.invoke((Parameter)this, (Parameter)new Handle(), (Parameter)new UInt32((long)predefinedBitmap.getValue()));
    }

    public Bitmap(String fileName) {
        this.loadFromFile(fileName);
    }

    public void loadFromFile(String fileName) {
        this.setValue(User32.loadResourceFromFile(fileName, GdiObject.ImageType.BITMAP.getValue()).getValue());
    }

    public static long getDIBits(DC dc, Bitmap bitmap, int startScan, int scanLines, Pointer bits, BitmapInfo bitmapInfo, int usage) {
        Int result = new Int();
        Function function = Gdi32.get(FUNCTION_GET_DIBITS);
        function.invoke((Parameter)result, new Parameter[]{dc, bitmap, new UInt((long)startScan), new UInt((long)scanLines), bits, new Pointer((Parameter)bitmapInfo), new UInt((long)usage)});
        return result.getValue();
    }

    public long getDIBits(DC dc, int startScan, int scanLines, Pointer bits, BitmapInfo bitmapInfo, int usage) {
        return Bitmap.getDIBits(dc, this, startScan, scanLines, bits, bitmapInfo, usage);
    }

    public static Bitmap createDIBitmap(DC dc, BitmapInfoHeader bitmapInfoHeader, int init, Pointer data, BitmapInfo bitmapInfo, int usage) {
        Bitmap result = new Bitmap();
        Function function = Gdi32.get(FUNCTION_CREATE_DIBITMAP);
        function.invoke((Parameter)result, new Parameter[]{dc, new Pointer((Parameter)bitmapInfoHeader), new UInt16(init), data, new Pointer((Parameter)bitmapInfo), new UInt((long)usage)});
        return result;
    }

    public BufferedImage toImage() {
        BitmapStructure bitmap = new BitmapStructure();
        this.getObject(this, (Parameter)bitmap);
        WindowDC dc = new WindowDC(null);
        int bitCount = (int)bitmap.getBitsPixel();
        BitmapInfo bitmapInfo = bitCount >= 16 ? new BitmapInfo() : new BitmapInfo(bitCount);
        BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
        int width = (int)bitmap.getBitmapWidth();
        int height = (int)bitmap.getBitmapHeight();
        bitmapInfoHeader.setWidth(width);
        bitmapInfoHeader.setHeight(height);
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(bitCount);
        bitmapInfoHeader.setCompression(Compression.RGB);
        if (bitCount == 4 || bitCount == 8) {
            int clrUsed = 1 << bitCount;
            bitmapInfoHeader.setClrUsed(clrUsed);
            bitmapInfoHeader.setClrImportant(clrUsed);
        }
        Pointer NULL = new Pointer(null, true);
        this.getDIBits(dc, 0, height, NULL, bitmapInfo, 0);
        int bytesCount = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray bits = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = Bitmap.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, bytesCount);
        this.getDIBits(dc, 0, height, new Pointer((Parameter)bits), bitmapInfo, 0);
        dc.release();
        PrimitiveArray colors = bitmapInfo.getColors();
        BufferedImage result = new BufferedImage(width, height, 1);
        int index = 0;
        int y = height - 1;
        while (y >= 0) {
            int x = 0;
            while (x < width) {
                int rgb = 0;
                switch (bitCount) {
                    case 8: {
                        RGBQuad color = (RGBQuad)colors.getElement(index++);
                        rgb = color.getRGB();
                        break;
                    }
                    case 16: {
                        int byte1 = this.readByte(bits, index++);
                        int byte2 = this.readByte(bits, index++);
                        int word = byte2 << 8 | byte1;
                        int b = (word & 0x1F) << 3;
                        int g = (word & 0x3E0) << 6;
                        int r = (word & 0x7C00) << 9;
                        rgb = b | g | r;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int alpha;
                        int b = this.readByte(bits, index++);
                        int g = this.readByte(bits, index++);
                        int r = this.readByte(bits, index++);
                        rgb = b | g << 8 | r << 16;
                        if (bitCount != 32) break;
                        if ((alpha = this.readByte(bits, index++)) == 0) {
                            alpha = 255;
                        }
                        rgb |= alpha << 24;
                    }
                }
                result.setRGB(x, y, rgb);
                ++x;
            }
            --y;
        }
        return result;
    }

    private int readByte(PrimitiveArray bits, int offset) {
        UInt8 element = (UInt8)bits.getElement(offset);
        return (int)element.getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FUNCTION_CREATE_BITMAP = FUNCTION_CREATE_BITMAP;
        FUNCTION_CREATE_BITMAP_INDIRECT = FUNCTION_CREATE_BITMAP_INDIRECT;
        FUNCTION_CREATE_COMPATIBLE_BITMAP = FUNCTION_CREATE_COMPATIBLE_BITMAP;
        FUNCTION_LOAD_BITMAP = FUNCTION_LOAD_BITMAP;
        FUNCTION_GET_DIBITS = FUNCTION_GET_DIBITS;
        FUNCTION_CREATE_DIBITMAP = FUNCTION_CREATE_DIBITMAP;
        DIB_RGB_COLORS = 0;
        DIB_PAL_COLORS = 1;
        CBM_INIT = 4;
    }

    public static class Compression
    extends EnumItem {
        public static final Compression RGB = new Compression(0);
        public static final Compression RLE8 = new Compression(1);
        public static final Compression RLE4 = new Compression(2);
        public static final Compression BITFIELDS = new Compression(3);
        public static final Compression JPEG = new Compression(4);
        public static final Compression PNG = new Compression(5);

        protected Compression(int value) {
            super(value);
        }
    }

    public static class PredefinedBitmap
    extends EnumItem {
        public static final PredefinedBitmap BTNCORNERS = new PredefinedBitmap(32758);
        public static final PredefinedBitmap BTSIZE = new PredefinedBitmap(32761);
        public static final PredefinedBitmap CHECK = new PredefinedBitmap(32760);
        public static final PredefinedBitmap CHECKBOXES = new PredefinedBitmap(32759);
        public static final PredefinedBitmap CLOSE = new PredefinedBitmap(32754);
        public static final PredefinedBitmap COMBO = new PredefinedBitmap(32738);
        public static final PredefinedBitmap DNARROW = new PredefinedBitmap(32752);
        public static final PredefinedBitmap DNARROWD = new PredefinedBitmap(32742);
        public static final PredefinedBitmap DNARROWI = new PredefinedBitmap(32736);
        public static final PredefinedBitmap LFARROW = new PredefinedBitmap(32750);
        public static final PredefinedBitmap LFARROWD = new PredefinedBitmap(32740);
        public static final PredefinedBitmap LFARROWI = new PredefinedBitmap(32734);
        public static final PredefinedBitmap MNARROW = new PredefinedBitmap(32739);
        public static final PredefinedBitmap REDUCE = new PredefinedBitmap(32749);
        public static final PredefinedBitmap REDUCED = new PredefinedBitmap(32746);
        public static final PredefinedBitmap RESTORE = new PredefinedBitmap(32747);
        public static final PredefinedBitmap RESTORED = new PredefinedBitmap(32744);
        public static final PredefinedBitmap RGARROW = new PredefinedBitmap(32751);
        public static final PredefinedBitmap RGARROWD = new PredefinedBitmap(32741);
        public static final PredefinedBitmap RGARROWI = new PredefinedBitmap(32735);
        public static final PredefinedBitmap SIZE = new PredefinedBitmap(32766);
        public static final PredefinedBitmap UPARROW = new PredefinedBitmap(32753);
        public static final PredefinedBitmap UPARROWD = new PredefinedBitmap(32743);
        public static final PredefinedBitmap UPARROWI = new PredefinedBitmap(32737);
        public static final PredefinedBitmap ZOOM = new PredefinedBitmap(32748);
        public static final PredefinedBitmap ZOOMD = new PredefinedBitmap(32745);

        private PredefinedBitmap(int value) {
            super(value);
        }
    }
}

