/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.IconInfo;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.shell.SHFileInfo;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.ui.User32;
import java.awt.image.BufferedImage;

public class Icon
extends GdiObject {
    static final FunctionName FUNCTION_LOAD_ICON = new FunctionName("LoadIcon");
    static final FunctionName FUNCTION_LOAD_IMAGE = new FunctionName("LoadImage");
    static final FunctionName FUNCTION_EXTRACT_ICON = new FunctionName("ExtractIcon");
    static final FunctionName FUNCTION_EXTRACT_ASSOCIATED_ICON = new FunctionName("ExtractAssociatedIcon");
    static final String FUNCTION_GET_ICON_INFO = "GetIconInfo";
    public static final int ICON_SMALL = 0;
    public static final int ICON_BIG = 1;
    public static final int ICON_SMALL_WIDTH = 16;
    public static final int ICON_SMALL_HEIGHT = 16;
    public static final int ICON_BIG_WIDTH = 32;
    public static final int ICON_BIG_HEIGHT = 32;
    private int _type = 0;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;

    public Icon() {
    }

    public Icon(int type) {
        this.setType(type);
    }

    public Icon(long value) {
        super(value);
    }

    public Icon(long value, int type) {
        super(value);
        this.setType(type);
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    static Function getFunction(Object functionName) {
        return User32.getInstance().getFunction(functionName.toString());
    }

    public void loadIcon(Pointer hInstance, String fileName) {
        Function function = Icon.getFunction(FUNCTION_LOAD_ICON);
        function.invoke((Parameter)this, new Parameter[]{hInstance, User32.getInstance().stringParam(fileName)});
    }

    public int getWidth(int type) {
        int width = type == 1 ? 32 : 16;
        return width;
    }

    public int getHeight(int type) {
        int height = type == 1 ? 32 : 16;
        return height;
    }

    public int getWidth() {
        return this.getWidth(this.getType());
    }

    public int getHeight() {
        return this.getHeight(this.getType());
    }

    public void loadFromFile(String fileName) {
        this.loadFromFile(fileName, this.getWidth(), this.getHeight());
    }

    public void loadFromFile(String fileName, int width, int height) {
        Handle handle = User32.loadResourceFromFile(fileName, GdiObject.ImageType.ICON.getValue(), width, height);
        this.setValue(handle.getValue());
    }

    public void loadStandardIcon(int id) {
        this.loadStandardIcon(id, this.getWidth(), this.getHeight());
    }

    public void loadStandardIcon(int id, int width, int height) {
        Function function = Icon.getFunction(FUNCTION_LOAD_IMAGE);
        function.invoke((Parameter)this, new Parameter[]{new Handle(), new Int32(id), new UInt32((long)GdiObject.ImageType.ICON.getValue()), new Int((long)width), new Int((long)height), new UInt32(32768L)});
        if (this.getValue() == 0L) {
            throw new LastErrorException("Cannot load icon for " + id + ".");
        }
    }

    public static Icon loadStandardIconByID(int id) {
        Icon result = new Icon();
        result.loadStandardIcon(id);
        return result;
    }

    public static Icon extractFromFile(String fileName, int iconType, int iconIndex) {
        Icon result = new Icon(iconType);
        Function extractIconFunction = Shell32.getInstance().getFunction(FUNCTION_EXTRACT_ICON.toString());
        extractIconFunction.invoke((Parameter)result, (Parameter)Module.getCurrent(), (Parameter)Shell32.getInstance().stringParam(fileName), (Parameter)new UInt((long)iconIndex));
        return result;
    }

    public static Icon extractSmallAssociatedIcon(String iconPath) {
        SHFileInfo fileInfo = SHFileInfo.getFileInfo(iconPath, 257);
        return fileInfo.getIcon();
    }

    public static Icon extractBigAssociatedIcon(String iconPath) {
        Icon result = new Icon();
        Function extractIconFunction = Shell32.getInstance().getFunction(FUNCTION_EXTRACT_ASSOCIATED_ICON.toString());
        extractIconFunction.invoke((Parameter)result, (Parameter)Module.getCurrent(), (Parameter)Shell32.getInstance().stringParam(iconPath), (Parameter)new Pointer((Parameter)new UInt16()));
        return result;
    }

    public IconInfo getIconInfo() {
        IconInfo result = new IconInfo();
        Function function = User32.getInstance().getFunction(FUNCTION_GET_ICON_INFO);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)new Pointer((Parameter)result));
        if (!returnValue.getValue()) {
            throw new LastErrorException("Failed to retrieve IconInfo");
        }
        return result;
    }

    public BufferedImage toImage() {
        IconInfo iconInfo = this.getIconInfo();
        Bitmap mask = iconInfo.getMaskBitmap();
        Bitmap color = iconInfo.getColorBitmap();
        WindowDC dc = new WindowDC(null);
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(color, (Parameter)bitmapStructure);
        int bitCount = (int)bitmapStructure.getBitsPixel();
        BitmapInfo bitmapInfo = bitCount >= 16 ? new BitmapInfo() : new BitmapInfo(bitCount);
        BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
        int width = (int)bitmapStructure.getBitmapWidth();
        int height = (int)bitmapStructure.getBitmapHeight();
        bitmapInfoHeader.setWidth(width);
        bitmapInfoHeader.setHeight(height);
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(bitCount);
        bitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
        if (bitCount == 4 || bitCount == 8) {
            int clrUsed = 1 << bitCount;
            bitmapInfoHeader.setClrUsed(clrUsed);
            bitmapInfoHeader.setClrImportant(clrUsed);
        }
        Pointer NULL = new Pointer(null, true);
        Bitmap.getDIBits(dc, color, 0, height, NULL, bitmapInfo, 0);
        int bytesCount = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray colorBits = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = Icon.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, bytesCount);
        Bitmap.getDIBits(dc, color, 0, height, new Pointer((Parameter)colorBits), bitmapInfo, 0);
        PrimitiveArray maskBits = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = Icon.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, bytesCount);
        Bitmap.getDIBits(dc, mask, 0, height, new Pointer((Parameter)maskBits), bitmapInfo, 0);
        dc.release();
        PrimitiveArray colors = bitmapInfo.getColors();
        BufferedImage result = new BufferedImage(width, height, 2);
        int index1 = 0;
        int index2 = 0;
        int y = height - 1;
        while (y >= 0) {
            int x = 0;
            while (x < width) {
                int rgb1 = 0;
                int rgb2 = 0;
                switch (bitCount) {
                    case 8: {
                        RGBQuad pixelColor1 = (RGBQuad)colors.getElement(index1++);
                        int r1 = (int)pixelColor1.getRed();
                        int g1 = (int)pixelColor1.getGreen();
                        int b1 = (int)pixelColor1.getBlue();
                        rgb1 = 0xFF000000 | b1 | g1 | r1;
                        RGBQuad pixelColor2 = (RGBQuad)colors.getElement(index2++);
                        int r2 = (int)pixelColor2.getRed();
                        int g2 = (int)pixelColor2.getGreen();
                        int b2 = (int)pixelColor2.getBlue();
                        rgb2 = b2 | g2 | r2;
                        break;
                    }
                    case 16: {
                        int byte1 = this.readByte(colorBits, index1++);
                        int byte2 = this.readByte(colorBits, index1++);
                        int word = byte2 << 8 | byte1;
                        int b1 = (word & 0x1F) << 3;
                        int g1 = (word & 0x3E0) << 6;
                        int r1 = (word & 0x7C00) << 9;
                        rgb1 = 0xFF000000 | b1 | g1 | r1;
                        byte1 = this.readByte(maskBits, index2++);
                        byte2 = this.readByte(maskBits, index2++);
                        word = byte2 << 8 | byte1;
                        int b2 = (word & 0x1F) << 3;
                        int g2 = (word & 0x3E0) << 6;
                        int r2 = (word & 0x7C00) << 9;
                        rgb2 = b2 | g2 | r2;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int b1 = this.readByte(colorBits, index1++);
                        int g1 = this.readByte(colorBits, index1++);
                        int r1 = this.readByte(colorBits, index1++);
                        rgb1 = b1 | g1 << 8 | r1 << 16;
                        if (bitCount == 32) {
                            int alpha;
                            if ((alpha = this.readByte(colorBits, index1++)) == 0) {
                                alpha = 255;
                            }
                            rgb1 |= alpha << 24;
                        } else {
                            rgb1 |= 0xFF000000;
                        }
                        int b2 = this.readByte(maskBits, index2++);
                        int g2 = this.readByte(maskBits, index2++);
                        int r2 = this.readByte(maskBits, index2++);
                        rgb2 = b2 | g2 << 8 | r2 << 16;
                        if (bitCount != 32) break;
                        ++index2;
                    }
                }
                if (rgb2 != 0) {
                    result.setRGB(x, y, rgb2);
                } else {
                    result.setRGB(x, y, rgb1);
                }
                ++x;
            }
            --y;
        }
        return result;
    }

    private int readByte(PrimitiveArray bits, int offset) {
        UInt8 element = (UInt8)bits.getElement(offset);
        return (int)element.getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FUNCTION_GET_ICON_INFO = FUNCTION_GET_ICON_INFO;
        ICON_SMALL = 0;
        ICON_BIG = 1;
        ICON_SMALL_WIDTH = 16;
        ICON_SMALL_HEIGHT = 16;
        ICON_BIG_WIDTH = 32;
        ICON_BIG_HEIGHT = 32;
    }

    public static class SystemIcon
    extends EnumItem {
        public static final SystemIcon SAMPLE = new SystemIcon(32512);
        public static final SystemIcon HAND = new SystemIcon(32513);
        public static final SystemIcon QUES = new SystemIcon(32514);
        public static final SystemIcon BANG = new SystemIcon(32515);
        public static final SystemIcon NOTE = new SystemIcon(32516);
        public static final SystemIcon WINLOGO = new SystemIcon(32517);
        private Icon _icon;

        public SystemIcon(int value) {
            super(value);
        }

        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = Icon.loadStandardIconByID(this.getValue());
            }
            return this._icon;
        }
    }
}

