/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.WideChar;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.LastError;
import com.jniwrapper.win32.io.FileInfo;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemException;
import com.jniwrapper.win32.io.FileSystemWatcher;
import com.jniwrapper.win32.io.WatcherStrategy;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;

class WinNTWatcherStrategy
extends WatcherStrategy {
    static final FunctionName FUNCTION_CREATE_FILE = new FunctionName("CreateFile");
    static final String FUNCTION_READ_DIRECTORY_CHANGES = "ReadDirectoryChangesW";
    static final int FILE_LIST_DIRECTORY = 1;
    static final int FILE_SHARE_READ = 1;
    static final int FILE_SHARE_DELETE = 4;
    static final int OPEN_EXISTING = 3;
    static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;
    static final int FUFFER_SIZE = 1024;
    static final int INVALID_HANDLE_VALUE = -1;
    private Handle _directory = new Handle();
    private Thread _watcherThread;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;

    public WinNTWatcherStrategy(FileSystemWatcher fileSystemWatcher) {
        super(fileSystemWatcher);
    }

    public void start() throws FileSystemException {
        FileSystemWatcher watcher = this.getFileSystemWatcher();
        final Kernel32 kernel32 = Kernel32.getInstance();
        String path = watcher.getPath();
        Function functionCreateFile = kernel32.getFunction(FUNCTION_CREATE_FILE.toString());
        functionCreateFile.invoke((Parameter)this._directory, new Parameter[]{kernel32.stringParam(path), new UInt32(1L), new UInt32(5L), new Pointer(null, true), new UInt32(3L), new UInt32(0x2000000L), new Pointer(null, true)});
        long handleValue = this._directory.getValue();
        if (this._directory.isNull() || handleValue == -1L) {
            throw new FileSystemException();
        }
        final PrimitiveArray buffer = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = WinNTWatcherStrategy.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, 1024);
        final Pointer bufferPointer = new Pointer((Parameter)buffer);
        final boolean watchSubtree = watcher.isWatchSubree();
        final int notifyFilter = (int)watcher.getOptions().getFlags();
        final UInt32 bytesReturned = new UInt32();
        this._watcherThread = new Thread(new Runnable(){

            public void run() {
                WinNTWatcherStrategy.this.setWatching(true);
                while (WinNTWatcherStrategy.this.isWatching()) {
                    Function functionReadDirectoryChanges = kernel32.getFunction(WinNTWatcherStrategy.FUNCTION_READ_DIRECTORY_CHANGES);
                    Int returnValue = new Int();
                    functionReadDirectoryChanges.invoke((Parameter)returnValue, new Parameter[]{WinNTWatcherStrategy.this._directory, bufferPointer, new UInt32(1024L), new Bool(watchSubtree), new UInt32((long)notifyFilter), new Pointer((Parameter)bytesReturned), new Pointer(null, true), new Pointer(null, true)});
                    long value = returnValue.getValue();
                    if (value == 0L) {
                        throw new IllegalStateException("Function ReadDirectoryChangesW failed. Last error: " + LastError.getValue());
                    }
                    WinNTWatcherStrategy.this.retrieveEvents(buffer.getBytes());
                }
                WinNTWatcherStrategy.this.setWatching(false);
            }
        });
        this._watcherThread.start();
    }

    private void retrieveEvents(byte[] buffer) {
        if (!this.isWatching()) {
            return;
        }
        FileSystemWatcher watcher = this.getFileSystemWatcher();
        int index = 0;
        int nextEntryIndex = 0;
        boolean lastEvent = false;
        ArrayList<FileActionInfo> actionInfos = new ArrayList<FileActionInfo>();
        while (index < 1024 && !lastEvent) {
            int nextEntryOffset = this.readDWORD(buffer, index);
            nextEntryIndex += nextEntryOffset;
            lastEvent = nextEntryOffset == 0;
            int action = this.readDWORD(buffer, index += 4);
            int fileNameLength = this.readDWORD(buffer, index += 4);
            index += 4;
            StringBuffer fileName = new StringBuffer(watcher.getPath());
            fileName.append(File.separatorChar);
            int i = 0;
            while (i < fileNameLength >> 1) {
                char c = this.readWCHAR(buffer, index);
                index += 2;
                fileName.append(c);
                ++i;
            }
            actionInfos.add(new FileActionInfo(new FileInfo(fileName.toString(), 0L, 0L, 0L), action));
            index = nextEntryIndex;
        }
        int actionInfoCount = actionInfos.size();
        ArrayList<FileSystemEvent> events = new ArrayList<FileSystemEvent>(actionInfoCount);
        int i = 0;
        while (i < actionInfoCount) {
            FileSystemEvent event = null;
            FileActionInfo actionInfo = (FileActionInfo)actionInfos.get(i);
            if (actionInfo.getAction() == 4) {
                if (i + 1 < actionInfoCount) {
                    FileActionInfo newActionInfo = (FileActionInfo)actionInfos.get(++i);
                    event = new FileSystemEvent(watcher, actionInfo.getAction(), actionInfo.getFileInfo(), newActionInfo.getFileInfo());
                }
            } else {
                event = new FileSystemEvent(watcher, actionInfo.getAction(), actionInfo.getFileInfo());
            }
            events.add(event);
            ++i;
        }
        FileFilter fileFilter = watcher.getFileFilter();
        Iterator i2 = events.iterator();
        while (i2.hasNext()) {
            FileSystemEvent event = (FileSystemEvent)i2.next();
            if (fileFilter != null) {
                File file1 = new File(event.getFileInfo().getFileName());
                File file2 = null;
                if (event.getOldFileInfo() != null) {
                    file2 = new File(event.getOldFileInfo().getFileName());
                }
                if (!fileFilter.accept(file1) && (file2 == null || !fileFilter.accept(file2))) continue;
                watcher.fireFileSystemEvent(event);
                continue;
            }
            watcher.fireFileSystemEvent(event);
        }
    }

    private int readDWORD(byte[] buffer, int offset) {
        UInt32 result = new UInt32();
        result.read(buffer, offset);
        return (int)result.getValue();
    }

    private char readWCHAR(byte[] buffer, int offset) {
        WideChar result = new WideChar();
        result.read(buffer, offset);
        return result.getValue();
    }

    public void stop() throws FileSystemException {
        this.setWatching(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FUNCTION_READ_DIRECTORY_CHANGES = FUNCTION_READ_DIRECTORY_CHANGES;
        FILE_LIST_DIRECTORY = 1;
        FILE_SHARE_READ = 1;
        FILE_SHARE_DELETE = 4;
        OPEN_EXISTING = 3;
        FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;
        FUFFER_SIZE = 1024;
        INVALID_HANDLE_VALUE = -1;
    }

    class FileActionInfo {
        private FileInfo _fileInfo;
        private int _action;

        public FileActionInfo(FileInfo fileInfo, int action) {
            this._fileInfo = fileInfo;
            this._action = action;
        }

        public FileInfo getFileInfo() {
            return this._fileInfo;
        }

        public int getAction() {
            return this._action;
        }
    }
}

