/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.FunctionExecutionException;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt32;
import com.jniwrapper.WideString;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.WinRegistry;

public class RegistryItem {
    public static int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static int HKEY_CURRENT_USER = -2147483647;
    public static int HKEY_LOCAL_MACHINE = -2147483646;
    public static int HKEY_USERS = -2147483645;
    public static int HKEY_PERFORMANCE_DATA = -2147483644;
    public static int HKEY_CURRENT_CONFIG = -2147483643;
    public static int HKEY_DYN_DATA = -2147483642;
    protected static long KEY_READ = 131097L;
    protected static long KEY_WRITE = 131078L;
    protected static long ERROR_SUCCESS = 0L;
    protected static long REG_OPTION_NON_VOLATILE = 0L;
    public static final int REG_SZ = 1;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_CREATED_NEW_KEY = 1;
    public static final int REG_OPENED_EXISTING_KEY = 2;
    private int _hKey;
    private String _path = null;
    private String _name = null;
    private int _type = 1;
    private Handle _handle = new Handle();
    private Parameter _value = null;

    public RegistryItem(int hKey, String path, String name, Parameter value, int type) {
        this.setHKey(hKey);
        this.setPath(path);
        this.setName(name);
        this.setValue(value);
        this.setType(type);
    }

    public RegistryItem(int hKey, String path, String name, String value) {
        this(hKey, path, name, (Parameter)new WideString(value), 1);
    }

    public RegistryItem(int hKey, String path, String name, int maxValueLength) {
        this(hKey, path, name, (Parameter)new WideString(maxValueLength), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        try {
            this.openKey(new UInt32(KEY_READ));
            this.queryKey();
            Object var2_1 = null;
            this.closeKey();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.closeKey();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        try {
            this.openKey(new UInt32(KEY_WRITE));
            this.saveKey();
            Object var2_1 = null;
            this.closeKey();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.closeKey();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        try {
            this.openKey(new UInt32(KEY_WRITE));
            this.deleteKey();
            Object var2_1 = null;
            this.closeKey();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.closeKey();
            throw throwable;
        }
    }

    private void openKey(UInt32 accessType) {
        long resultValue = WinRegistry.createKey(this.getHKey(), this.getPath(), REG_OPTION_NON_VOLATILE, accessType.getValue(), this._handle);
        if (ERROR_SUCCESS != resultValue) {
            throw new RegistryException("Can't open registry key: " + this.toString() + ". Error number: " + resultValue);
        }
    }

    private void closeKey() {
        long resultValue;
        try {
            resultValue = WinRegistry.closeKey(this._handle);
        }
        catch (FunctionExecutionException e) {
            throw new RegistryException(e);
        }
        if (ERROR_SUCCESS != resultValue) {
            throw new RegistryException("Error while closing the registry key for " + this.toString() + " with error code:" + resultValue);
        }
    }

    private void queryKey() {
        long resultValue;
        try {
            resultValue = WinRegistry.getValue(this._handle, this.getName(), this.getType(), this.getValue());
        }
        catch (FunctionExecutionException e) {
            throw new RegistryException(e);
        }
        if (ERROR_SUCCESS != resultValue) {
            throw new RegistryException("Error while reading the registry key for " + this.toString() + " with error code:" + resultValue);
        }
    }

    private void saveKey() {
        long resultValue;
        try {
            resultValue = WinRegistry.setValue(this._handle, this.getName(), this.getType(), this.getValue(), this.getValueSize());
        }
        catch (FunctionExecutionException e) {
            throw new RegistryException(e);
        }
        if (ERROR_SUCCESS != resultValue) {
            throw new RegistryException("Error while setting the registry key for " + this.toString() + " with error code:" + resultValue);
        }
    }

    private void deleteKey() {
        long resultValue;
        try {
            resultValue = WinRegistry.deleteKey(this._handle, this.getName());
        }
        catch (FunctionExecutionException e) {
            throw new RegistryException(e);
        }
        if (ERROR_SUCCESS != resultValue) {
            throw new RegistryException("Error while deleting the registry key for " + this.toString() + " with error code:" + resultValue);
        }
    }

    private int getValueSize() {
        return this.getValue().getLength();
    }

    public int getHKey() {
        return this._hKey;
    }

    public void setHKey(int hKey) {
        this._hKey = hKey;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Parameter getValue() {
        return this._value;
    }

    public void setValue(Parameter value) {
        this._value = value;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        switch (type) {
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                this._type = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("The type: " + type + " isn't supported.");
            }
        }
    }

    public String toString() {
        String result = this.getPath() + "->" + this.getName();
        return result;
    }

    static {
        REG_SZ = 1;
        REG_BINARY = 3;
        REG_DWORD = 4;
        REG_MULTI_SZ = 7;
        REG_CREATED_NEW_KEY = 1;
        REG_OPENED_EXISTING_KEY = 2;
    }
}

