/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.Wnd;

public class WindowDecorator {
    public static final int OPAQUE = 255;
    public static final int TRANSPARENT = 0;
    private Wnd _windowHandle;
    private boolean _transparent = false;
    private byte _transparency = (byte)-1;
    private boolean _palleteWindow = false;
    private boolean _topmost = false;
    private boolean _rounded = false;
    private boolean _captionVisible = true;
    private boolean _borderVisible = true;
    static final int DEFAULT_ELLIPSE_HEIGHT = 30;
    static final int DEFAULT_ELLIPSE_WIDTH = 30;

    public WindowDecorator() {
    }

    public WindowDecorator(Wnd wnd) {
        this.setWindowHandle(wnd);
    }

    public Wnd getWindowHandle() {
        if (this._windowHandle == null) {
            throw new IllegalStateException();
        }
        return this._windowHandle;
    }

    public void setWindowHandle(Wnd windowHandle) {
        if (windowHandle == null) {
            throw new IllegalArgumentException();
        }
        this._windowHandle = windowHandle;
    }

    public boolean isTransparent() {
        return this._transparent;
    }

    public void setTransparent(boolean transparent) {
        if (this._transparent == transparent) {
            return;
        }
        this._transparent = transparent;
        Wnd windowHandle = this.getWindowHandle();
        long oldWindowStyle = this.getWindowExStyle();
        if (transparent) {
            long newWindowStyle = oldWindowStyle | 0x80000L;
            this.setWindowExStyle(newWindowStyle);
            this.getWindowHandle().setLayeredWindowAttributes(0, this._transparency, 2);
        } else {
            long newWindowStyle = oldWindowStyle & 0xFFFFFFFFFFF7FFFFL;
            this.setWindowExStyle(newWindowStyle);
            Handle NULL = new Handle();
            windowHandle.redraw(NULL, NULL, 1157);
        }
    }

    public byte getTransparency() {
        return this._transparency;
    }

    public void setTransparency(byte transparency) {
        if (this._transparency == transparency) {
            return;
        }
        this._transparency = transparency;
        if (!this.isTransparent()) {
            this.setTransparent(true);
        }
        this.getWindowHandle().setLayeredWindowAttributes(0, transparency, 2);
    }

    public boolean isPalleteWindow() {
        return this._palleteWindow;
    }

    public void setPalleteWindow(boolean palleteWindow) {
        if (this._palleteWindow == palleteWindow) {
            return;
        }
        this._palleteWindow = palleteWindow;
        long oldWindowStyle = this.getWindowExStyle();
        long newWindowStyle = this._palleteWindow ? oldWindowStyle | 0x188L : oldWindowStyle & 0xFFFFFFFFFFFFFE77L;
        this.setWindowExStyle(newWindowStyle);
        Handle NULL = new Handle();
        this.getWindowHandle().redraw(NULL, NULL, 1025);
    }

    public boolean isTopmost() {
        return this._topmost;
    }

    public void setTopmost(boolean topmost) {
        if (this._topmost == topmost) {
            return;
        }
        this._topmost = topmost;
        int zOrder = -2;
        if (this._topmost) {
            zOrder = -1;
        }
        Wnd.setWindowPos(this.getWindowHandle(), new Wnd(zOrder), 0L, 0L, 0L, 0L, 3L);
    }

    public void setWindowExStyle(long flags) {
        Wnd windowHandle = this.getWindowHandle();
        windowHandle.setWindowLong(-20, flags);
        Wnd.setWindowPos(windowHandle, windowHandle, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowExStyle() {
        Wnd windowHandle = this.getWindowHandle();
        return windowHandle.getWindowLong(-20);
    }

    public void setWindowStyle(long flags) {
        Wnd windowHandle = this.getWindowHandle();
        windowHandle.setWindowLong(-16, flags);
        Wnd.setWindowPos(windowHandle, windowHandle, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowStyle() {
        Wnd windowHandle = this.getWindowHandle();
        return windowHandle.getWindowLong(-16);
    }

    public boolean isRounded() {
        return this._rounded;
    }

    public void setRounded(boolean rounded, int ellipseWidth, int ellipseHeight) {
        if (rounded == this._rounded) {
            return;
        }
        this._rounded = rounded;
        Wnd windowHandle = this.getWindowHandle();
        Region region = null;
        if (rounded) {
            Rect windowRect = new Rect();
            Wnd.getWindowRect(windowHandle, windowRect);
            windowRect.moveTo(0L, 0L);
            region = Region.createRoundRectRegion((int)windowRect.getLeft(), (int)windowRect.getTop(), (int)windowRect.getRight(), (int)windowRect.getBottom(), ellipseWidth, ellipseHeight);
        }
        Wnd.setWindowRgn(windowHandle, region, true);
    }

    public void setRounded(boolean rounded) {
        this.setRounded(rounded, 30, 30);
    }

    public void setWindowIcon(Icon icon) {
        Wnd windowHandle = this.getWindowHandle();
        windowHandle.sendMessage(128, icon.getType(), (int)icon.getValue());
    }

    public void setVisible(boolean visible) {
        long windowStyle = this.getWindowStyle();
        windowStyle = !visible ? (windowStyle &= 0xFFFFFFFFEFFFFFFFL) : (windowStyle |= 0x10000000L);
        this.setWindowStyle(windowStyle);
    }

    public void setCaptionVisible(boolean value) {
        if (this._captionVisible == value) {
            return;
        }
        this._captionVisible = value;
        long oldWindowStyle = this.getWindowStyle();
        long newWindowStyle = value ? oldWindowStyle | 0xC00000L : oldWindowStyle & 0xFFFFFFFFFF3FFFFFL;
        this.setWindowStyle(newWindowStyle);
        Handle NULL = new Handle();
        this.getWindowHandle().redraw(NULL, NULL, 6);
    }

    public boolean isCaptionVisible() {
        return this._captionVisible;
    }

    public void setBorderVisible(boolean value) {
        if (this._borderVisible == value) {
            return;
        }
        this._borderVisible = value;
        long oldWindowStyle = this.getWindowStyle();
        long newWindowStyle = value ? oldWindowStyle | 0x800000L : oldWindowStyle & 0xFFFFFFFFFFFBFFFFL;
        this.setWindowStyle(newWindowStyle);
    }

    public boolean isBorderVisible() {
        return this._borderVisible;
    }

    public Region setRegion(Region region) {
        Wnd windowHandle = this.getWindowHandle();
        Region prevRegion = Wnd.getWindowRgn(windowHandle);
        Wnd.setWindowRgn(windowHandle, region, true);
        return prevRegion;
    }

    static {
        OPAQUE = 255;
        TRANSPARENT = 0;
        DEFAULT_ELLIPSE_HEIGHT = 30;
        DEFAULT_ELLIPSE_WIDTH = 30;
    }
}

