/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Callback;
import com.jniwrapper.Char;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.WideChar;
import com.jniwrapper.ZeroTerminatedString;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.VersionInfo;

class OFNStructure
extends Structure {
    public static final char FILES_DELIMETER = '\t';
    private UInt32 _structureSize = new UInt32();
    private Handle _owner = new Handle();
    private Handle _instance = new Handle();
    private PrimitiveArray _filter;
    private ZeroTerminatedString _customFilter;
    private UInt32 _maxCustFilter = new UInt32();
    private UInt32 _filterIndex = new UInt32();
    private PrimitiveArray _file;
    private UInt32 _maxFile = new UInt32();
    private ZeroTerminatedString _fileTitle;
    private UInt32 _maxFileTitle = new UInt32();
    private ZeroTerminatedString _initialDir;
    private ZeroTerminatedString _title;
    private UInt32 _flags = new UInt32();
    private UInt16 _fileOffset = new UInt16();
    private UInt16 _fileExtension = new UInt16();
    private ZeroTerminatedString _defExt;
    private UInt32 _custData = new UInt32();
    private Callback _hook = null;
    private ZeroTerminatedString _templateName;
    private Pointer _reserved = new Pointer(null, true);
    private UInt32 _reservedFlags = new UInt32();
    private UInt32 _flagsEx = new UInt32();
    private boolean _unicode;
    static final char NATIVE_DELIMETER_SPACE = ' ';
    static final char NATIVE_DELIMETER_NULL = '\u0000';

    public OFNStructure(Callback hook, int maxFile) {
        this._hook = hook;
        this.setMaxFile(maxFile);
        this.initStringParameters();
        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isWin2k() | versionInfo.isWinMe()) {
            this.init(new Parameter[]{this._structureSize, this._owner, this._instance, new Pointer((Parameter)this._filter), new Pointer((Parameter)this._customFilter), this._maxCustFilter, this._filterIndex, new Pointer((Parameter)this._file), this._maxFile, new Pointer((Parameter)this._fileTitle), this._maxFileTitle, new Pointer((Parameter)this._initialDir), new Pointer((Parameter)this._title), this._flags, this._fileOffset, this._fileExtension, new Pointer((Parameter)this._defExt), this._custData, this._hook, new Pointer((Parameter)this._templateName), this._reserved, this._reservedFlags, this._flagsEx});
        } else {
            this.init(new Parameter[]{this._structureSize, this._owner, this._instance, new Pointer((Parameter)this._filter), new Pointer((Parameter)this._customFilter), this._maxCustFilter, this._filterIndex, new Pointer((Parameter)this._file), this._maxFile, new Pointer((Parameter)this._fileTitle), this._maxFileTitle, new Pointer((Parameter)this._initialDir), new Pointer((Parameter)this._title), this._flags, this._fileOffset, this._fileExtension, new Pointer((Parameter)this._defExt), this._custData, this._hook, new Pointer((Parameter)this._templateName)});
        }
        this._structureSize.setValue((long)this.getLength());
    }

    private void initStringParameters() {
        Kernel32 kernel32 = Kernel32.getInstance();
        this._unicode = kernel32.isUnicode();
        if (this._unicode) {
            this._file = new PrimitiveArray((Parameter)new WideChar(), (int)this.getMaxFile() + 2);
            this._filter = new PrimitiveArray((Parameter)new WideChar(), (int)this.getMaxFile() + 2);
        } else {
            this._file = new PrimitiveArray((Parameter)new Char(), (int)this.getMaxFile() + 2);
            this._filter = new PrimitiveArray((Parameter)new Char(), (int)this.getMaxFile() + 2);
        }
        this._customFilter = kernel32.stringParam();
        this._fileTitle = kernel32.stringParam();
        this._initialDir = kernel32.stringParam();
        this._title = kernel32.stringParam();
        this._defExt = kernel32.stringParam();
        this._templateName = kernel32.stringParam();
    }

    public Handle getOwner() {
        return this._owner;
    }

    public void setOwner(Handle owner) {
        this._owner.setValue(owner == null ? 0L : owner.getValue());
    }

    public Handle getInstance() {
        return this._instance;
    }

    public void setInstance(Handle instance) {
        this._instance.setValue(instance == null ? 0L : instance.getValue());
    }

    public void setFilter(StringBuffer filter) {
        int i = 0;
        while (i < filter.length()) {
            char c = filter.charAt(i);
            WideChar character = this._unicode ? new WideChar(c) : new Char(c);
            this._filter.setElement(i, (Parameter)character);
            ++i;
        }
    }

    public String getCustomFilter() {
        return this._customFilter.getValue();
    }

    public void setCustomFilter(String customFilter) {
        this._customFilter.setValue(customFilter);
    }

    public long getMaxCustFilter() {
        return this._maxCustFilter.getValue();
    }

    public void setMaxCustFilter(long maxCustFilter) {
        this._maxCustFilter.setValue(maxCustFilter);
    }

    public long getFilterIndex() {
        return this._filterIndex.getValue();
    }

    public void setFilterIndex(long filterIndex) {
        this._filterIndex.setValue(filterIndex);
    }

    public String getFile() {
        StringBuffer result = new StringBuffer();
        int elementCount = this._file.getElementCount();
        boolean zero = false;
        int i = 0;
        while (i < elementCount) {
            char c;
            char c2 = c = this._unicode ? ((WideChar)this._file.getElement(i)).getValue() : ((Char)this._file.getElement(i)).getValue();
            if (zero && c == '\u0000') break;
            if (c == '\u0000') {
                zero = true;
                result.append('\t');
            } else {
                zero = false;
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public void setFile(String file) {
        if (file.length() > this._file.getLength()) {
            throw new IllegalArgumentException("File name length is greater than allowed");
        }
        int i = 0;
        while (i < file.length()) {
            char c = file.charAt(i);
            WideChar character = this._unicode ? new WideChar(c) : new Char(c);
            this._file.setElement(i, (Parameter)character);
            ++i;
        }
        this._file.setElement(file.length(), (Parameter)(this._unicode ? new WideChar() : new Char()));
    }

    public long getMaxFile() {
        return this._maxFile.getValue();
    }

    public void setMaxFile(long maxFile) {
        this._maxFile.setValue(maxFile);
    }

    public String getFileTitle() {
        return this._fileTitle.getValue();
    }

    public void setFileTitle(String fileTitle) {
        this._fileTitle.setValue(fileTitle);
    }

    public long getMaxFileTitle() {
        return this._maxFileTitle.getValue();
    }

    public void setMaxFileTitle(long maxFileTitle) {
        this._maxFileTitle.setValue(maxFileTitle);
    }

    public String getInitialDir() {
        return this._initialDir.getValue();
    }

    public void setInitialDir(String initialDir) {
        this._initialDir.setValue(initialDir);
    }

    public String getTitle() {
        return this._title.getValue();
    }

    public void setTitle(String title) {
        this._title.setValue(title);
    }

    public long getFlags() {
        return this._flags.getValue();
    }

    public void setFlags(long flags) {
        this._flags.setValue(flags);
    }

    public long getFileOffset() {
        return this._fileOffset.getValue();
    }

    public void setFileOffset(long fileOffset) {
        this._fileOffset.setValue(fileOffset);
    }

    public long getFileExtension() {
        return this._fileExtension.getValue();
    }

    public void setFileExtension(long fileExtension) {
        this._fileExtension.setValue(fileExtension);
    }

    public String getDefExt() {
        return this._defExt.getValue();
    }

    public void setDefExt(String defExt) {
        this._defExt.setValue(defExt);
    }

    public long getCustData() {
        return this._custData.getValue();
    }

    public void setCustData(long custData) {
        this._custData.setValue(custData);
    }

    public Callback getHook() {
        return this._hook;
    }

    public void setHook(Callback hook) {
        this._hook = hook;
    }

    public String getTemplateName() {
        return this._templateName.getValue();
    }

    public void setTemplateName(String templateName) {
        this._templateName.setValue(templateName);
    }

    public long getFlagsEx() {
        return this._flagsEx.getValue();
    }

    public void setFlagsEx(long flagsEx) {
        this._flagsEx.setValue(flagsEx);
    }

    static {
        FILES_DELIMETER = (char)9;
        NATIVE_DELIMETER_SPACE = (char)32;
        NATIVE_DELIMETER_NULL = '\u0000';
    }
}

