/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ZeroTerminatedString;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.VersionInfo;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.shell.ShellFolder;
import com.jniwrapper.win32.ui.WindowTools;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.dialogs.BIStructure;
import com.jniwrapper.win32.ui.dialogs.DialogHelper;
import java.awt.Window;
import java.io.File;

public class SelectFolderDialog {
    static final FunctionName FUNCTION_BROWSE_FOR_FOLDER = new FunctionName("SHBrowseForFolder");
    private ShellFolder _startFolder = ShellFolder.DESKTOP;
    private Window _owner = null;
    private String _title = "";
    private String _folder = "";
    private SelectFolderDialogOptions _flags = new SelectFolderDialogOptions();

    public SelectFolderDialog() {
        this.reset();
    }

    public SelectFolderDialog(String caption) {
        this();
        this.setTitle(caption);
    }

    public SelectFolderDialog(Window owner) {
        this.setOwner(owner);
        this.reset();
    }

    public SelectFolderDialog(Window owner, String caption) {
        this(owner);
        this.setTitle(caption);
    }

    protected void reset() {
        this._flags.clear();
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getFolder() {
        return this._folder;
    }

    public void setFolder(String folder) {
        this._folder = folder;
    }

    public Window getOwner() {
        return this._owner;
    }

    public void setOwner(Window owner) {
        this._owner = owner;
    }

    public SelectFolderDialogOptions getOptions() {
        return this._flags;
    }

    public ShellFolder getStartFolder() {
        return this._startFolder;
    }

    public void setStartFolder(ShellFolder startFolder) {
        this._startFolder = startFolder;
    }

    protected Callback getDialogCallback() {
        return null;
    }

    public boolean execute() {
        boolean result;
        Wnd owner = this._owner != null ? new Wnd(WindowTools.getWindowHandle(this._owner)) : new Wnd();
        int folderID = this._startFolder.getFolderID();
        Handle root = ShellFolder.getFolderIDList(folderID);
        if (root.isNull()) {
            return false;
        }
        BIStructure browseInfoStructure = new BIStructure((Parameter)this.getDialogCallback(), (Pointer.Void)root);
        browseInfoStructure.setOwner(owner);
        browseInfoStructure.setTitle(this.getTitle());
        browseInfoStructure.setFlags(this._flags.getFlags());
        File directory = new File(this._folder);
        if (!directory.exists()) {
            this._folder = "";
        }
        if (this._folder.length() > 0) {
            ZeroTerminatedString dir = Shell32.getInstance().stringParam(this._folder);
            browseInfoStructure.setParam((Parameter)dir);
        }
        Function browseForFolder = Shell32.getInstance().getFunction(FUNCTION_BROWSE_FOR_FOLDER.toString());
        Handle returnValue = new Handle();
        if (this._owner != null) {
            DialogHelper.invokeDialog(this._owner, browseForFolder, (Parameter)returnValue, new Parameter[]{new Pointer((Parameter)browseInfoStructure)});
        } else {
            browseForFolder.invoke((Parameter)returnValue, (Parameter)new Pointer((Parameter)browseInfoStructure));
        }
        if (returnValue.isNull()) {
            return false;
        }
        boolean bl = result = !returnValue.isNull();
        if (result) {
            String selectedFolder = ShellFolder.getPathFromIDList(returnValue);
            this._folder = selectedFolder.length() == 0 && this._flags.contains(4096L) ? "\\\\" + browseInfoStructure.getDisplayName() : selectedFolder;
        }
        return result;
    }

    public static SelectFolderDialog createBrowseForComputersDialog() {
        SelectFolderDialog dialog = new SelectFolderDialog();
        SelectFolderDialogOptions flags = dialog.getOptions();
        flags.clear();
        flags.add(64L);
        flags.add(512L);
        flags.add(4096L);
        dialog.setStartFolder(ShellFolder.NETWORK);
        return dialog;
    }

    public static SelectFolderDialog createBrowseForPrintersDialog() {
        SelectFolderDialog dialog = new SelectFolderDialog();
        SelectFolderDialogOptions flags = dialog.getOptions();
        flags.clear();
        VersionInfo versionInfo = new VersionInfo();
        if (!versionInfo.isWin2k()) {
            flags.add(64L);
        }
        flags.add(8704L);
        dialog.setStartFolder(ShellFolder.NETWORK);
        return dialog;
    }

    public class SelectFolderDialogOptions
    extends FlagSet {
        public static final int RETURNONLYFSDIRS = 1;
        public static final int DONTGOBELOWDOMAIN = 2;
        public static final int STATUSTEXT = 4;
        public static final int RETURNFSANCESTORS = 8;
        public static final int EDITBOX = 16;
        public static final int VALIDATE = 32;
        public static final int NEWDIALOGSTYLE = 64;
        public static final int BROWSEINCLUDEURLS = 128;
        public static final int BROWSEFORCOMPUTER = 4096;
        public static final int BROWSEFORPRINTER = 8192;
        public static final int BROWSEINCLUDEFILES = 16384;
        public static final int SHAREABLE = 32768;
        public static final int NONEWFOLDERBUTTON = 512;

        public SelectFolderDialogOptions() {
            this.reset();
        }

        public void reset() {
            this.clear();
            this.add(67L);
        }

        public boolean isOnlyFilesystem() {
            return this.contains(1L);
        }

        public void setOnlyFileSystem(boolean onlyFileSystem) {
            if (onlyFileSystem) {
                this.add(1L);
            } else {
                this.remove(1L);
            }
        }

        public boolean isNewDialogStyle() {
            return this.contains(64L);
        }

        public void setNewDialogStyle(boolean newDialogStyle) {
            if (newDialogStyle) {
                this.add(64L);
            } else {
                this.remove(64L);
            }
        }

        public boolean isSelectFiles() {
            return this.contains(16384L);
        }

        public void setSelectFiles(boolean selectFiles) {
            if (selectFiles) {
                this.add(16384L);
            } else {
                this.remove(16384L);
            }
        }

        public boolean isShowTextBox() {
            return this.contains(16L);
        }

        public void setShowTextBox(boolean showTextBox) {
            if (showTextBox) {
                this.add(16L);
            } else {
                this.remove(16L);
            }
        }

        public boolean isShowNewFolderButton() {
            return !this.contains(512L);
        }

        public void setShowNewFolderButton(boolean showNewFolderButton) {
            if (showNewFolderButton) {
                this.remove(512L);
            } else {
                this.add(512L);
            }
        }

        public boolean isShowNetworkFolders() {
            return !this.contains(2L);
        }

        public void setShowNetworkFolders(boolean showNetworkFolders) {
            if (showNetworkFolders) {
                this.remove(2L);
            } else {
                this.add(2L);
            }
        }

        public boolean isShowFiles() {
            return this.contains(16384L);
        }

        public void setShowFiles(boolean showFiles) {
            if (showFiles) {
                this.add(16384L);
            } else {
                this.remove(16384L);
            }
        }

        static {
            RETURNONLYFSDIRS = 1;
            DONTGOBELOWDOMAIN = 2;
            STATUSTEXT = 4;
            RETURNFSANCESTORS = 8;
            EDITBOX = 16;
            VALIDATE = 32;
            NEWDIALOGSTYLE = 64;
            BROWSEINCLUDEURLS = 128;
            BROWSEFORCOMPUTER = 4096;
            BROWSEFORPRINTER = 8192;
            BROWSEINCLUDEFILES = 16384;
            SHAREABLE = 32768;
            NONEWFOLDERBUTTON = 512;
        }
    }
}

