/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;
import com.jniwrapper.win32.io.FileSystemWatcher;

import javax.swing.*;
import java.io.File;
import java.text.MessageFormat;


/**
 * Sample for FileSystemWatcher. All watcher messages are put into console until the messagebox is closed
 * First command line parameter is folder to be watched. If it is not specified the current folder will be used.
 *
 * @author Serge Piletsky
 */
public class FileSystemWatcherSample
{
    static final String[] ACTION_NAMES = new String[] {"added", "removed", "modified", "renamed"};
    static final String MESSAGE_TEMPLATE = "File ''{0}'' was {1}";

    public static void main(String[] args)
    {
        DefaultLibraryLoader.getInstance().addPath("Bin");

        String folder = new File("").getAbsolutePath();
        if (args.length > 0)
        {
            File f = new File(args[0]);
            if (f.exists())
                folder = args[0];
        }
        System.out.println("Watched folder = " + folder);
        FileSystemWatcher watcher = new FileSystemWatcher(folder, true);
        watcher.addFileSystemListener(new FileSystemEventListener()
        {
            public void handle(FileSystemEvent event)
            {
                String actionName = ACTION_NAMES[event.getAction()];
                String message = MessageFormat.format(MESSAGE_TEMPLATE, new Object[]{event.getFileInfo(), actionName});
                if (event.getAction() == FileSystemEvent.FILE_RENAMED)
                    message += " from '" + event.getOldFileInfo() + "'";

                System.out.println(message);
            }
        });

        try
        {
            watcher.start();
            System.out.println("Watching stared");
            JOptionPane.showConfirmDialog(null, "Watching in progress. Terminate?", "FileSystemWatcher Sample", JOptionPane.DEFAULT_OPTION);
            watcher.stop();
            System.out.println("Watching stoped");
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
}
