/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.ui.controls.SelectFileField;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

/**
 * @author Serge Piletsky
 */
class OpenSaveFileSample extends LazyPanel implements PropertyChangeListener
{
    private Vector _files;
    private JLabel lblAdvisoryText;
    private JLabel lblFileNameCaption;
    private SelectFileField _selectFileField;
    private JLabel lblSelectedFiles;
    private JLabel lblNote;
    private JList lstSelectedFiles;

    public OpenSaveFileSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        _files = new Vector();
        lblAdvisoryText = new HTMLText("The page demonstrates Standard Open/Save file dialogs invoked using a special 'SelectFile' control.");
        lblFileNameCaption = new JLabel("Select File:");
        _selectFileField = new SelectFileField();
        lblSelectedFiles = new JLabel("Selected Files:");
        lblNote = new HTMLText("<b>NOTE:</b> Multiple files selected in dialog are shown in list above.");
        lstSelectedFiles = new JList(_files);
        _selectFileField.addPropertyChangeListener(SelectFileField.PROPERTY_FILE, this);

        JScrollPane files = new JScrollPane(lstSelectedFiles);
        files.setPreferredSize(new Dimension(10, 100));

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        add(lblFileNameCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(_selectFileField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(lblSelectedFiles, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(files, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.5
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 10, 0, 10), 0, 0));

        add(lblNote, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 0, 0), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));


        _selectFileField.getDialog().getOptions().setMultiselectionAllowed(true);
        _selectFileField.getDialog().setFilter("All Files (*.*)|*.*|Pictures|*.bmp;*.gif;*.jpeg");

        super.initialize();
    }

    public void propertyChange(PropertyChangeEvent evt)
    {
        _files.clear();
        _files.addAll(_selectFileField.getDialog().getFiles());
        lstSelectedFiles.updateUI();
    }
}
