/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.SystemColor;
import com.jniwrapper.win32.ui.AWTWindowDecorator;
import com.jniwrapper.win32.ui.DesktopWindow;
import com.jniwrapper.win32.ui.Wnd;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * @author Serge Piletsky
 */
public class WinPackSet extends JFrame
{
    private JTree _menuTree;

    public WinPackSet() throws HeadlessException
    {
        super("WinPack Demo");

        final Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());

        final JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        final HeaderPanel headerPanel = new HeaderPanel();
        Dimension headerSize = new Dimension(390, 30);
        headerPanel.setPreferredSize(headerSize);
        headerPanel.setMinimumSize(headerSize);
        headerPanel.setVisible(false);
        contentPanel.add(headerPanel, BorderLayout.NORTH, 0);

        final JSplitPane splitter = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true);
        splitter.setBorder(null);
        splitter.setDividerSize(2);
        splitter.setDividerLocation(200);

        _menuTree = new JTree();
        _menuTree.setVisible(false);
        _menuTree.setEditable(false);
        BasicTreeUI basicTreeUI = ((BasicTreeUI)_menuTree.getUI());
        basicTreeUI.setCollapsedIcon(new ImageIcon(this.getClass().getResource("res/Closed.gif")));
        basicTreeUI.setExpandedIcon(new ImageIcon(this.getClass().getResource("res/Opened.gif")));
        _menuTree.setCellRenderer(new TreeCellRenderer());

        _menuTree.addTreeSelectionListener(new TreeSelectionListener()
        {
            public void valueChanged(TreeSelectionEvent e)
            {
                TreePath path = e.getPath();
                Component component = null;
                try
                {
                    component = contentPanel.getComponent(1);
                }
                catch (Exception ex)
                {
                }
                if (component instanceof LazyPanel)
                {
                    LazyPanel panel = (LazyPanel) component;
                    panel.deactivate();
                }
                if (component != null)
                {
                    contentPanel.remove(component);
                }

                DefaultMutableTreeNode pathComponent = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                Object userObject = pathComponent.getUserObject();
                String title = pathComponent.toString();
                if (userObject instanceof JPanel)
                {
                    JPanel panel = (JPanel)userObject;
                    contentPanel.add(panel, BorderLayout.CENTER, 1);
                    if (userObject instanceof LazyPanel)
                    {
                        headerPanel.setVisible(true);
                        LazyPanel lazyPanel = (LazyPanel) userObject;
                        try
                        {
                            lazyPanel.activate();
                        }
                        catch(Exception ex)
                        {
                            ex.printStackTrace();
                        }
                    }
                    else
                    {
                        headerPanel.setVisible(false);
                    }
                }
                headerPanel.setTitle(title);
                contentPanel.updateUI();
            }
        });
        JScrollPane menuPanel = new JScrollPane(_menuTree);

        splitter.add(menuPanel, JSplitPane.LEFT);
        splitter.add(contentPanel, JSplitPane.RIGHT);

        contentPane.add(splitter, BorderLayout.CENTER);

        addWindowListener(new WindowAdapter()
        {
            public void windowOpened(WindowEvent e)
            {
                _menuTree.setModel(new MenuTreeModel(WinPackSet.this));
                for (int i = 0; i < _menuTree.getRowCount(); i++)
                {
                    _menuTree.expandRow(i);
                }
                _menuTree.setSelectionRow(0);
                _menuTree.setVisible(true);
                _menuTree.putClientProperty("JTree.lineStyle", "None");


                AWTWindowDecorator decorator = new AWTWindowDecorator(WinPackSet.this);
                Icon smallIcon = new Icon();
                smallIcon.loadFromFile("jniwrapper.ico");
                Icon bigIcon = new Icon(Icon.ICON_BIG);
                bigIcon.loadFromFile("jniwrapper.ico");
                decorator.setWindowIcon(smallIcon);
                decorator.setWindowIcon(bigIcon);
            }
        });
    }

    private static void setupLF()
    {
        UIDefaults defaults = UIManager.getDefaults();
        Font tahoma = new Font("Tahoma", 0, 11);

        Color btnFaceFolor = SystemColor.BTNFACE.getColor();
        Color highlight = SystemColor.HIGHLIGHT.getColor();
        Color highlightText = SystemColor.HIGHLIGHTTEXT.getColor();
        Color scrollBar = SystemColor.SCROLLBAR.getColor();

        defaults.put("Button.font", tahoma);
        defaults.put("Button.background", btnFaceFolor);
        defaults.put("ToggleButton.font", tahoma);
        defaults.put("RadioButton.font", tahoma);
        defaults.put("CheckBox.font", tahoma);
        defaults.put("CheckBox.background", btnFaceFolor);
        defaults.put("Slider.font", tahoma);
        defaults.put("Slider.background", btnFaceFolor);
        defaults.put("Slider.foreground", scrollBar);
        defaults.put("ComboBox.font", tahoma);
        defaults.put("Label.font", tahoma);
        defaults.put("Label.foreground", Color.black);
        defaults.put("List.font", tahoma);
        defaults.put("List.selectionBackground", highlight);
        defaults.put("List.selectionForeground", highlightText);
        defaults.put("Panel.font", tahoma);
        defaults.put("Panel.background", btnFaceFolor);
        defaults.put("ScrollPane.font", tahoma);
        defaults.put("ScrollBar.background", scrollBar);
        defaults.put("ScrollBar.foreground", btnFaceFolor);
        defaults.put("ScrollBar.thumb", btnFaceFolor);
        defaults.put("ScrollBar.thumbHighlight", btnFaceFolor);
        defaults.put("Viewport.font", tahoma);
        defaults.put("Viewport.background", Color.white);
        defaults.put("Table.font", tahoma);
        defaults.put("Table.selectionBackground", highlight);
        defaults.put("Table.selectionForeground", highlightText);
        defaults.put("TableHeader.font", tahoma);
        defaults.put("TableHeader.background", btnFaceFolor);
        defaults.put("TextField.font", tahoma);
        defaults.put("TextField.selectionBackground", highlight);
        defaults.put("TextField.selectionForeground", highlightText);
        defaults.put("Tree.font", tahoma);
        defaults.put("Tree.selectionBackground", highlight);
        defaults.put("Tree.selectionForeground", highlightText);
        defaults.put("Table.focusCellHighlightBorder", new EmptyBorder(1, 1, 1, 1));
        defaults.put("SplitPaneDivider.border", new EmptyBorder(0, 0, 0, 0));
    }

    private static void centerWindow(Window window)
    {
        DesktopWindow desktop = DesktopWindow.getInstance();
        Rect desktopRect = new Rect();
        Wnd.getWindowRect(desktop, desktopRect);
        int width = window.getWidth();
        int height = window.getHeight();
        int x = (int)(desktopRect.getRight() - width) / 2;
        int y = (int)(desktopRect.getBottom() - height) / 2;
        window.setLocation(x, y);
    }

    protected void processWindowEvent(WindowEvent e)
    {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING)
        {
            System.exit(0);
        }
    }

    public static void main(String[] args)
    {
        DefaultLibraryLoader.getInstance().addPath("bin");

        setupLF();
        WinPackSet window = new WinPackSet();
        window.setSize(600, 400);
        window.setBackground(SystemColor.BTNFACE.getColor());
        centerWindow(window);
        window.setVisible(true);
    }
}
